/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.protocol;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.process.protocol.ProtocolLogger;
import org.jboss.as.process.protocol.ProtocolMessages;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static int readChar(InputStream input) throws IOException {
        int a = input.read();
        if (a < 0) {
            return -1;
        }
        if (a == 0) {
            return -1;
        }
        if (a < 128) {
            return (char)a;
        }
        if (a < 192) {
            throw ProtocolMessages.MESSAGES.invalidByte();
        }
        if (a < 224) {
            int b = input.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0xC0) != 128) {
                throw ProtocolMessages.MESSAGES.invalidByte((char)a, a);
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = input.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0xC0) != 128) {
                throw ProtocolMessages.MESSAGES.invalidByte();
            }
            int c = input.read();
            if (c == -1) {
                throw new EOFException();
            }
            if ((c & 0xC0) != 128) {
                throw ProtocolMessages.MESSAGES.invalidByte();
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw ProtocolMessages.MESSAGES.invalidByte();
    }

    public static void readToEol(InputStream input) throws IOException {
        while (true) {
            switch (input.read()) {
                case -1: {
                    return;
                }
                case 10: {
                    return;
                }
            }
        }
    }

    public static byte[] readBytesWithLength(InputStream in) throws IOException {
        int expectedLength = StreamUtils.readInt(in);
        byte[] bytes = new byte[expectedLength];
        StreamUtils.readFully(in, bytes, 0, expectedLength);
        return bytes;
    }

    public static boolean readBoolean(InputStream input) throws IOException {
        return StreamUtils.readUnsignedByte(input) != 0;
    }

    public static int readUnsignedShort(InputStream input) throws IOException {
        int ch2;
        int ch1 = input.read();
        if ((ch1 | (ch2 = input.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        StreamUtils.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw ProtocolMessages.MESSAGES.readBytes(n);
        }
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] bytes = new byte[8];
        StreamUtils.readFully(in, bytes, 0, 8);
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    public static void writeString(OutputStream output, Object o) throws IOException {
        StreamUtils.writeString(output, o.toString());
    }

    public static void writeString(OutputStream output, String s) throws IOException {
        int length = s.length();
        int strIdx = 0;
        while (strIdx < length) {
            StreamUtils.writeChar(output, s.charAt(strIdx++));
        }
    }

    public static void writeChar(OutputStream output, char c) throws IOException {
        if (c >= ' ' && c <= '\u007f') {
            output.write((byte)c);
        } else if (c <= '\u07ff') {
            output.write((byte)(0xC0 | 0x1F & c >> 6));
            output.write((byte)(0x80 | 0x3F & c));
        } else {
            output.write((byte)(0xE0 | 0xF & c >> 12));
            output.write((byte)(0x80 | 0x3F & c >> 6));
            output.write((byte)(0x80 | 0x3F & c));
        }
    }

    public static void writeShort(OutputStream out, int value) throws IOException {
        out.write(value >>> 8);
        out.write(value);
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((byte)(v >>> 56) & 0xFF);
        out.write((byte)(v >>> 48) & 0xFF);
        out.write((byte)(v >>> 40) & 0xFF);
        out.write((byte)(v >>> 32) & 0xFF);
        out.write((byte)(v >>> 24) & 0xFF);
        out.write((byte)(v >>> 16) & 0xFF);
        out.write((byte)(v >>> 8) & 0xFF);
        out.write((byte)(v >>> 0) & 0xFF);
    }

    public static void writeBoolean(OutputStream os, boolean b) throws IOException {
        os.write(b ? 1 : 0);
    }

    public static byte readByte(InputStream stream) throws IOException {
        int b = stream.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public static int readUnsignedByte(InputStream stream) throws IOException {
        int b = stream.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int cnt;
        byte[] bytes = new byte[8192];
        while ((cnt = in.read(bytes)) != -1) {
            out.write(bytes, 0, cnt);
        }
    }

    public static String readUTFZBytes(InputStream input) throws IOException {
        StringBuilder builder = new StringBuilder();
        int c;
        while ((c = StreamUtils.readUTFChar(input)) != -1) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    private static int readUTFChar(InputStream input) throws IOException {
        int a = input.read();
        if (a < 0) {
            throw new EOFException();
        }
        if (a == 0) {
            return -1;
        }
        if (a < 128) {
            return (char)a;
        }
        if (a < 192) {
            throw ProtocolMessages.MESSAGES.invalidByte();
        }
        if (a < 224) {
            int b = input.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0xC0) != 128) {
                throw ProtocolMessages.MESSAGES.invalidByte();
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = input.read();
            if (b == -1) {
                throw new EOFException();
            }
            if ((b & 0xC0) != 128) {
                throw ProtocolMessages.MESSAGES.invalidByte();
            }
            int c = input.read();
            if (c == -1) {
                throw new EOFException();
            }
            if ((c & 0xC0) != 128) {
                throw ProtocolMessages.MESSAGES.invalidByte();
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw ProtocolMessages.MESSAGES.invalidByte();
    }

    public static void writeUTFZBytes(OutputStream outputStream, String string) throws IOException {
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            StreamUtils.writeChar(outputStream, string.charAt(i));
        }
        outputStream.write(0);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    public static void safeClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable t) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseResource(t, socket);
            }
        }
    }

    public static void safeClose(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseServerSocket(e, serverSocket);
            }
        }
    }

    public static void safeFinish(Marshaller marshaller) {
        if (marshaller != null) {
            try {
                marshaller.finish();
            }
            catch (IOException e) {
                ProtocolLogger.ROOT_LOGGER.failedToFinishMarshaller(e, marshaller);
            }
        }
    }

    public static void safeFinish(Unmarshaller unmarshaller) {
        if (unmarshaller != null) {
            try {
                unmarshaller.finish();
            }
            catch (IOException e) {
                ProtocolLogger.ROOT_LOGGER.failedToFinishUnmarshaller(e, unmarshaller);
            }
        }
    }

    public static void safeClose(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Throwable t) {
                ProtocolLogger.ROOT_LOGGER.failedToCloseResource(t, writer);
            }
        }
    }
}

