/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDataReader
implements DataReader<Node> {
    private static final Logger LOG = LogUtils.getL7dLogger(NodeDataReader.class);

    public Object read(MessagePartInfo part, Node input) {
        return this.read(input);
    }

    public Object read(QName name, Node input, Class type) {
        if (SAXSource.class.isAssignableFrom(type)) {
            XMLStreamReader reader = StaxUtils.createXMLStreamReader((Element)((Element)input));
            return new StaxSource(reader);
        }
        if (StreamSource.class.isAssignableFrom(type)) {
            try {
                CachedOutputStream out = new CachedOutputStream();
                DOMUtils.writeXml((Node)input, (OutputStream)out);
                InputStream is = out.getInputStream();
                out.close();
                return new StreamSource(is);
            }
            catch (IOException e) {
                throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e);
            }
            catch (TransformerException e) {
                throw new Fault("COULD_NOT_READ_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
            }
        }
        return this.read(input);
    }

    public Object read(Node n) {
        return new DOMSource(n);
    }

    public void setSchema(Schema s) {
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String prop, Object value) {
    }
}

