/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.TagHandlerPool;

public class PerThreadTagHandlerPool
extends TagHandlerPool {
    private int maxSize;
    private Vector<PerThreadData> perThreadDataVector = new Vector();
    private ThreadLocal<PerThreadData> perThread;

    @Override
    protected void init(ServletConfig config) {
        this.instanceManager = InstanceManagerFactory.getInstanceManager(config);
        this.maxSize = Constants.MAX_POOL_SIZE;
        String maxSizeS = PerThreadTagHandlerPool.getOption(config, "tagpoolMaxSize", null);
        if (maxSizeS != null) {
            this.maxSize = Integer.parseInt(maxSizeS);
            if (this.maxSize < 0) {
                this.maxSize = Constants.MAX_POOL_SIZE;
            }
        }
        this.perThread = new ThreadLocal<PerThreadData>(){

            @Override
            protected PerThreadData initialValue() {
                PerThreadData ptd = new PerThreadData();
                ptd.handlers = new Tag[PerThreadTagHandlerPool.this.maxSize];
                ptd.current = -1;
                PerThreadTagHandlerPool.this.perThreadDataVector.addElement(ptd);
                return ptd;
            }
        };
    }

    @Override
    public Tag get(Class handlerClass) throws JspException {
        PerThreadData ptd = this.perThread.get();
        if (ptd.current >= 0) {
            return ptd.handlers[ptd.current--];
        }
        try {
            if (Constants.USE_INSTANCE_MANAGER_FOR_TAGS) {
                return (Tag)this.instanceManager.newInstance(handlerClass);
            }
            Tag instance = (Tag)handlerClass.newInstance();
            if (Constants.INJECT_TAGS) {
                this.instanceManager.newInstance(instance);
            }
            return instance;
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reuse(Tag handler) {
        PerThreadData ptd = this.perThread.get();
        if (ptd.current < ptd.handlers.length - 1) {
            ptd.handlers[++ptd.current] = handler;
        } else {
            handler.release();
        }
    }

    @Override
    public void release() {
        Enumeration<PerThreadData> enumeration = this.perThreadDataVector.elements();
        while (enumeration.hasMoreElements()) {
            PerThreadData ptd = enumeration.nextElement();
            if (ptd.handlers != null) {
                for (int i = ptd.current; i >= 0; --i) {
                    if (ptd.handlers[i] == null) continue;
                    try {
                        ptd.handlers[i].release();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!Constants.INJECT_TAGS && !Constants.USE_INSTANCE_MANAGER_FOR_TAGS) continue;
                    try {
                        this.instanceManager.destroyInstance(ptd.handlers[i]);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            ptd.handlers = null;
            ptd.current = -1;
        }
        this.perThreadDataVector.clear();
    }

    private static class PerThreadData {
        Tag[] handlers;
        int current;

        private PerThreadData() {
        }
    }
}

