/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.service;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.jboss.as.configadmin.parser.ConfigAdminState;
import org.jboss.as.configadmin.service.ConfigAdminListener;
import org.jboss.as.configadmin.service.ConfigAdminService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ConfigAdminServiceImpl
implements ConfigAdminService {
    private final InjectedValue<ConfigAdminState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<ModelController> injectedModelController = new InjectedValue();
    private final Set<ConfigAdminListener> listeners = new CopyOnWriteArraySet<ConfigAdminListener>();
    private final Executor executor = Executors.newSingleThreadExecutor();
    private ModelControllerClient controllerClient;

    private ConfigAdminServiceImpl() {
    }

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        ConfigAdminServiceImpl service = new ConfigAdminServiceImpl();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ConfigAdminState.SERVICE_NAME, ConfigAdminState.class, service.injectedSubsystemState);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedModelController);
        builder.addListener(listeners);
        return builder.install();
    }

    @Override
    public Set<String> getConfigurations() {
        return ((ConfigAdminState)this.injectedSubsystemState.getValue()).getConfigurations();
    }

    @Override
    public boolean hasConfiguration(String pid) {
        return ((ConfigAdminState)this.injectedSubsystemState.getValue()).hasConfiguration(pid);
    }

    @Override
    public Dictionary<String, String> getConfiguration(String pid) {
        return ((ConfigAdminState)this.injectedSubsystemState.getValue()).getConfiguration(pid);
    }

    @Override
    public Dictionary<String, String> putConfiguration(String pid, Dictionary<String, String> newConfig) {
        ModelNode address = this.getSubsystemAddress();
        address.add(new ModelNode().set("configuration", pid));
        Dictionary<String, String> oldConfig = this.getConfiguration(pid);
        if (oldConfig != null) {
            ModelNode op = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            try {
                this.controllerClient.execute(op);
            }
            catch (IOException ex) {
                ConfigAdminLogger.ROOT_LOGGER.cannotRemoveConfiguration(ex, pid);
            }
        }
        ModelNode entries = new ModelNode();
        Enumeration<String> keys = newConfig.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            entries.get(key).set(newConfig.get(key));
        }
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("entries").set(entries);
        try {
            ModelNode node = this.controllerClient.execute(op);
            ModelNode outcome = node.get("outcome");
            if ("success".equals(outcome.asString())) {
                this.executor.execute(new ConfigurationModifiedService(pid, newConfig));
            } else {
                ConfigAdminLogger.ROOT_LOGGER.cannotAddConfiguration(pid, node);
            }
        }
        catch (IOException ex) {
            ConfigAdminLogger.ROOT_LOGGER.cannotAddConfiguration(ex, pid);
        }
        return oldConfig;
    }

    @Override
    public Dictionary<String, String> removeConfiguration(String pid) {
        Dictionary<String, String> oldConfig = this.getConfiguration(pid);
        if (oldConfig != null) {
            ModelNode address = this.getSubsystemAddress();
            address.add(new ModelNode().set("configuration", pid));
            ModelNode op = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            try {
                ModelNode node = this.controllerClient.execute(op);
                ModelNode outcome = node.get("outcome");
                if ("success".equals(outcome.asString())) {
                    this.executor.execute(new ConfigurationModifiedService(pid, oldConfig));
                } else {
                    ConfigAdminLogger.ROOT_LOGGER.cannotRemoveConfiguration(pid, node);
                }
            }
            catch (IOException ex) {
                ConfigAdminLogger.ROOT_LOGGER.cannotRemoveConfiguration(ex, pid);
            }
        }
        return oldConfig;
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        ConfigAdminLogger.ROOT_LOGGER.debugf("Starting: %s in mode %s", controller.getName(), controller.getMode());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.controllerClient = ((ModelController)this.injectedModelController.getValue()).createClient((Executor)executor);
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        ConfigAdminLogger.ROOT_LOGGER.debugf("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public ConfigAdminService getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public void addListener(ConfigAdminListener listener) {
        ConfigAdminLogger.ROOT_LOGGER.debugf("Add listener: %s", listener);
        this.listeners.add(listener);
        Set<String> pids = listener.getPIDs();
        if (pids != null) {
            for (String pid : pids) {
                Dictionary<String, String> props = this.getConfiguration(pid);
                listener.configurationModified(pid, props);
            }
        }
    }

    @Override
    public void removeListener(ConfigAdminListener listener) {
        ConfigAdminLogger.ROOT_LOGGER.debugf("Remove listener: %s", listener);
        this.listeners.remove(listener);
    }

    private ModelNode getSubsystemAddress() {
        ModelNode address = new ModelNode();
        address.add(new ModelNode().set("subsystem", "configadmin"));
        return address;
    }

    class ConfigurationModifiedService
    implements Runnable {
        private final String pid;
        private final Dictionary<String, String> props;

        private ConfigurationModifiedService(String pid, Dictionary<String, String> props) {
            this.pid = pid;
            this.props = props;
        }

        @Override
        public void run() {
            ConfigAdminLogger.ROOT_LOGGER.debugf("Updating configuration: %s", this.pid);
            HashSet snapshot = new HashSet(ConfigAdminServiceImpl.this.listeners);
            for (ConfigAdminListener aux : snapshot) {
                Set<String> pids = aux.getPIDs();
                if (pids != null && !pids.contains(this.pid)) continue;
                try {
                    aux.configurationModified(this.pid, this.props);
                }
                catch (Exception ex) {
                    ConfigAdminLogger.ROOT_LOGGER.configurationListenerError(ex, aux);
                }
            }
        }
    }
}

