/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.console;

import java.io.UnsupportedEncodingException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.handlers.FlushingHandlerService;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.handlers.console.Target;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ConsoleHandlerService
implements FlushingHandlerService {
    private FormatterSpec formatterSpec;
    private Level level;
    private Target target;
    private boolean autoflush;
    private String encoding;
    private Filter filter;
    private ConsoleHandler value;

    public synchronized void start(StartContext context) throws StartException {
        ConsoleHandler handler;
        this.value = handler = new ConsoleHandler();
        this.formatterSpec.apply((Handler)handler);
        ConsoleHandlerService.setTarget(handler, this.target);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
        if (this.filter != null) {
            handler.setFilter(this.filter);
        }
        handler.setAutoFlush(this.autoflush);
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
    }

    private static void setTarget(ConsoleHandler handler, Target target) {
        if (handler == null || target == null) {
            return;
        }
        switch (target) {
            case SYSTEM_ERR: {
                handler.setTarget(ConsoleHandler.Target.SYSTEM_ERR);
                break;
            }
            case SYSTEM_OUT: {
                handler.setTarget(ConsoleHandler.Target.SYSTEM_OUT);
            }
        }
    }

    public synchronized void stop(StopContext context) {
        ConsoleHandler handler = this.value;
        handler.close();
        this.value = null;
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    @Override
    public synchronized void setLevel(Level level) {
        this.level = level;
        ConsoleHandler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized FormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    @Override
    public synchronized void setFormatterSpec(FormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        ConsoleHandler handler = this.value;
        if (handler != null) {
            formatterSpec.apply((Handler)handler);
        }
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
        ConsoleHandler handler = this.value;
        if (handler != null) {
            handler.setFilter(filter);
        }
    }

    public synchronized Target getTarget() {
        return this.target;
    }

    public synchronized void setTarget(Target target) {
        this.target = target;
        ConsoleHandlerService.setTarget(this.value, target);
    }

    public synchronized boolean isAutoflush() {
        return this.autoflush;
    }

    @Override
    public synchronized void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
        ConsoleHandler handler = this.value;
        if (handler != null) {
            handler.setAutoFlush(autoflush);
        }
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    @Override
    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        ConsoleHandler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
        this.encoding = encoding;
    }
}

