/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.MessageListener;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQSession;

public class JMSMessageListenerWrapper
implements MessageHandler {
    private static final Logger log = Logger.getLogger(JMSMessageListenerWrapper.class);
    private final HornetQSession session;
    private final MessageListener listener;
    private final ClientConsumer consumer;
    private final boolean transactedOrClientAck;

    protected JMSMessageListenerWrapper(HornetQSession session, ClientConsumer consumer, MessageListener listener, int ackMode) {
        this.session = session;
        this.consumer = consumer;
        this.listener = listener;
        this.transactedOrClientAck = ackMode == 0 || ackMode == 2 || session.isXA();
    }

    public void onMessage(ClientMessage message) {
        block13: {
            HornetQMessage msg = HornetQMessage.createMessage(message, this.session.getCoreSession());
            try {
                msg.doBeforeReceive();
            }
            catch (Exception e) {
                log.error("Failed to prepare message for receipt", e);
                return;
            }
            if (this.transactedOrClientAck) {
                try {
                    message.acknowledge();
                }
                catch (HornetQException e) {
                    log.error("Failed to process message", e);
                }
            }
            try {
                this.listener.onMessage(msg);
            }
            catch (RuntimeException e) {
                log.warn("Unhandled exception thrown from onMessage", e);
                if (this.transactedOrClientAck) break block13;
                try {
                    this.session.getCoreSession().rollback(true);
                    this.session.setRecoverCalled(true);
                }
                catch (Exception e2) {
                    log.error("Failed to recover session", e2);
                }
            }
        }
        if (!this.session.isRecoverCalled()) {
            try {
                if (!this.consumer.isClosed() && !this.transactedOrClientAck) {
                    message.acknowledge();
                }
            }
            catch (HornetQException e) {
                log.error("Failed to process message", e);
            }
        }
        this.session.setRecoverCalled(false);
    }
}

