/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionAcknowledgeMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;
    private boolean requiresResponse;

    public SessionAcknowledgeMessage(long consumerID, long messageID, boolean requiresResponse) {
        super((byte)41);
        this.consumerID = consumerID;
        this.messageID = messageID;
        this.requiresResponse = requiresResponse;
    }

    public SessionAcknowledgeMessage() {
        super((byte)41);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
        buffer.writeBoolean(this.requiresResponse);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
        this.requiresResponse = buffer.readBoolean();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionAcknowledgeMessage)) {
            return false;
        }
        SessionAcknowledgeMessage r = (SessionAcknowledgeMessage)other;
        return super.equals(other) && this.consumerID == r.consumerID && this.messageID == r.messageID && this.requiresResponse == r.requiresResponse;
    }
}

