/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.factories;

import java.net.URL;
import javax.security.auth.login.Configuration;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.StandaloneConfiguration;
import org.jboss.security.mapping.MappingManager;
import org.picketbox.factories.SecurityActions;
import org.picketbox.plugins.PicketBoxSecurityManagement;

public class SecurityFactory {
    private static ISecurityManagement securityManagement = new PicketBoxSecurityManagement();
    private static Configuration parentConfiguration = null;
    private static StandaloneConfiguration standaloneConfiguration;

    public static AuthenticationManager getAuthenticationManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getAuthenticationManager(securityDomain);
    }

    public static AuthorizationManager getAuthorizationManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getAuthorizationManager(securityDomain);
    }

    public static AuditManager getAuditManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getAuditManager(securityDomain);
    }

    public static MappingManager getMappingManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getMappingManager(securityDomain);
    }

    public static ISecurityManagement getSecurityManagement() {
        return securityManagement;
    }

    public static void setSecurityManagement(ISecurityManagement iSecurityManagement) {
        securityManagement = iSecurityManagement;
    }

    public static void prepare() {
        if (!(Configuration.getConfiguration() instanceof ApplicationPolicyRegistration)) {
            standaloneConfiguration.setParentConfig(parentConfiguration);
            Configuration.setConfiguration(standaloneConfiguration);
        }
        SecurityFactory.setLog4JLogger();
    }

    public static SecurityContext establishSecurityContext(String securityDomainName) {
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityContextFactory.createSecurityContext(securityDomainName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SecurityActions.setSecurityContext(securityContext);
        return securityContext;
    }

    public static void setLog4JLogger() {
        String loggerPluginClass = SecurityActions.getSystemProperty("org.jboss.logging.Logger.pluginClass", "");
        if (loggerPluginClass.length() < 1) {
            SecurityActions.setSystemProperty("org.jboss.logging.Logger.pluginClass", "org.jboss.logging.log4j.Log4jLoggerPlugin");
        }
    }

    public static void setJDKLogger() {
        String loggerPluginClass = SecurityActions.getSystemProperty("org.jboss.logging.Logger.pluginClass", "");
        if (loggerPluginClass.length() < 1) {
            SecurityActions.setSystemProperty("org.jboss.logging.Logger.pluginClass", "org.jboss.logging.jdk.JDK14LoggerPlugin");
            SecurityActions.setSystemProperty("java.util.logging.config.file=logging.properties", "logging.properties");
        }
    }

    public static void release() {
        Configuration config = Configuration.getConfiguration();
        if (config == standaloneConfiguration) {
            Configuration.setConfiguration(parentConfiguration);
        }
    }

    private static void validate() {
        assert (securityManagement != null);
    }

    static {
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            if (tcl == null) {
                throw new IllegalStateException("PB00015: Null Value:TCCL has not been set");
            }
            URL configLocation = tcl.getResource("auth.conf");
            String prop = "java.security.auth.login.config";
            if (SecurityActions.getSystemProperty(prop, null) == null) {
                if (configLocation == null) {
                    throw new RuntimeException("PB00015: Null Value:Neither system property *java.security.auth.login.config* available or auth.conf present");
                }
                SecurityActions.setSystemProperty(prop, configLocation.toExternalForm());
            }
            parentConfiguration = Configuration.getConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException("PB00019: Processing Failed:Unable to init SecurityFactory:", e);
        }
        standaloneConfiguration = StandaloneConfiguration.getInstance();
    }
}

