/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego.encoding;

public class NegTokenEncoder {
    private static int bitsRequired(int x) {
        return (int)(Math.log(x) / Math.log(2.0)) + 1;
    }

    public static byte[] createTypeLength(byte type, int length) {
        byte[] token;
        int bitsRequired = NegTokenEncoder.bitsRequired(length);
        if (bitsRequired <= 7) {
            token = new byte[2];
            token[1] = (byte)length;
        } else {
            int bytesRequired = bitsRequired / 8;
            if (bitsRequired % 8 != 0) {
                ++bytesRequired;
            }
            token = new byte[bytesRequired + 2];
            token[1] = (byte)(bytesRequired | 0x80);
            int lengthLeft = length;
            for (int i = 0; i < bytesRequired; ++i) {
                int pos = bytesRequired - i - 1;
                if (pos == 0) {
                    token[i + 2] = (byte)lengthLeft;
                    continue;
                }
                int pow = pos * 8;
                int multiplier = (int)Math.pow(2.0, pow);
                int byteValue = lengthLeft / multiplier;
                token[i + 2] = (byte)byteValue;
                lengthLeft -= byteValue * multiplier;
            }
        }
        token[0] = type;
        return token;
    }
}

