/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.File;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class PathContentServitor
extends AbstractService<VirtualFile> {
    private final String unresolvedPath;
    private final InjectedValue<String> relativePathValue = new InjectedValue();

    static ServiceController<VirtualFile> addService(ServiceTarget serviceTarget, ServiceName serviceName, String path, ServiceName relativeToServiceName, ServiceVerificationHandler verificationHandler) {
        PathContentServitor service = new PathContentServitor(path);
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        if (relativeToServiceName != null) {
            builder.addDependency(relativeToServiceName, String.class, service.relativePathValue);
        }
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private PathContentServitor(String relativePath) {
        this.unresolvedPath = relativePath;
    }

    public VirtualFile getValue() throws IllegalStateException, IllegalArgumentException {
        return VFS.getChild((String)this.resolvePath());
    }

    private String resolvePath() {
        String base = (String)this.relativePathValue.getOptionalValue();
        if (base != null) {
            base = base.endsWith(File.separator) ? base.substring(0, base.length() - 1) : base;
            return base + File.separatorChar + this.unresolvedPath;
        }
        return this.unresolvedPath;
    }
}

