package org.ovirt.engine.ui.webadmin.section.main.view.popup.cluster;

import java.util.ArrayList;

import org.ovirt.engine.core.common.queries.ConfigurationValues;
import org.ovirt.engine.ui.common.view.popup.AbstractModelBoundPopupView;
import org.ovirt.engine.ui.common.widget.dialog.SimpleDialogPanel;
import org.ovirt.engine.ui.common.widget.editor.EntityModelCellTable;
import org.ovirt.engine.ui.common.widget.editor.EntityModelCellTable.SelectionMode;
import org.ovirt.engine.ui.common.widget.table.column.CheckboxColumn;
import org.ovirt.engine.ui.common.widget.table.column.TextColumnWithTooltip;
import org.ovirt.engine.ui.common.widget.table.header.CheckboxHeader;
import org.ovirt.engine.ui.uicommonweb.dataprovider.AsyncDataProvider;
import org.ovirt.engine.ui.uicommonweb.models.EntityModel;
import org.ovirt.engine.ui.uicommonweb.models.ListModel;
import org.ovirt.engine.ui.uicommonweb.models.clusters.ClusterNetworkManageModel;
import org.ovirt.engine.ui.uicommonweb.models.clusters.ClusterNetworkModel;
import org.ovirt.engine.ui.webadmin.ApplicationConstants;
import org.ovirt.engine.ui.webadmin.ApplicationResources;
import org.ovirt.engine.ui.webadmin.ApplicationTemplates;
import org.ovirt.engine.ui.webadmin.section.main.presenter.popup.cluster.ClusterManageNetworkPopupPresenterWidget;

import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.inject.Inject;

public class ClusterManageNetworkPopupView extends AbstractModelBoundPopupView<ClusterNetworkManageModel> implements ClusterManageNetworkPopupPresenterWidget.ViewDef {

    interface ViewUiBinder extends UiBinder<SimpleDialogPanel, ClusterManageNetworkPopupView> {
        ViewUiBinder uiBinder = GWT.create(ViewUiBinder.class);
    }

    @UiField(provided = true)
    EntityModelCellTable<ClusterNetworkManageModel> networks;

    private final ApplicationConstants constants;
    private final ApplicationTemplates templates;

    @Inject
    public ClusterManageNetworkPopupView(EventBus eventBus,
            ApplicationResources resources, ApplicationConstants constants, ApplicationTemplates templates) {
        super(eventBus, resources);
        this.constants = constants;
        this.templates = templates;
        this.networks = new EntityModelCellTable<ClusterNetworkManageModel>(SelectionMode.NONE, true);
        initWidget(ViewUiBinder.uiBinder.createAndBindUi(this));
    }

    @SuppressWarnings("unchecked")
    Iterable<EntityModel> getNetworksTableItems() {
        ListModel tableModel = networks.asEditor().flush();
        return tableModel != null ? tableModel.getItems() : new ArrayList<EntityModel>();
    }

    void refreshNetworksTable() {
        networks.asEditor().edit(networks.asEditor().flush());
    }

    void initEntityModelCellTable(final ApplicationConstants constants, final ApplicationTemplates templates) {
        networks.enableColumnResizing();
        boolean multipleSelectionAllowed = networks.asEditor().flush().isMultiCluster();

        CheckboxHeader assignAllHeader = new CheckboxHeader(templates.textForCheckBoxHeader(constants.assignAll())) {
            @Override
            protected void selectionChanged(Boolean value) {
                for (EntityModel model : getNetworksTableItems()) {
                    ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                    if (canEditAssign(clusterNetworkManageModel)) {
                        changeIsAttached(clusterNetworkManageModel, value);
                    }
                }
                refreshNetworksTable();
            }

            @Override
            public Boolean getValue() {
                for (EntityModel model : getNetworksTableItems()) {
                    ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                    if (canEditAssign(clusterNetworkManageModel)) {
                        if (!clusterNetworkManageModel.isAttached()) {
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean isEnabled() {
                for (EntityModel model : getNetworksTableItems()) {
                    ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                    if (clusterNetworkManageModel.getIsChangable()) {
                        return true;
                    }
                }
                return false;
            }
        };

        networks.addColumn(new TextColumnWithTooltip<EntityModel>() {
            @Override
            public String getValue(EntityModel model) {
                return ((ClusterNetworkModel) model).getDisplayedName();
            }
        }, constants.nameNetwork(), "85px"); //$NON-NLS-1$

        networks.addColumn(new CheckboxColumn<EntityModel>(new FieldUpdater<EntityModel, Boolean>() {
            @Override
            public void update(int index, EntityModel model, Boolean value) {
                ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                changeIsAttached(clusterNetworkManageModel, value);
                refreshNetworksTable();
            }
        }) {
            @Override
            public Boolean getValue(EntityModel model) {
                return ((ClusterNetworkModel) model).isAttached();
            }

            @Override
            protected boolean canEdit(EntityModel model) {
                return ClusterManageNetworkPopupView.this.canEditAssign(model);
            }

            @Override
            public void render(Context context, EntityModel object, SafeHtmlBuilder sb) {
                super.render(context, object, sb);
                sb.append(templates.textForCheckBox(constants.assign()));
            }

        }, assignAllHeader, "90px"); //$NON-NLS-1$

        CheckboxHeader requiredAllHeader = new CheckboxHeader(
                templates.textForCheckBoxHeader(constants.requiredAll())) {
            @Override
            protected void selectionChanged(Boolean value) {
                for (EntityModel model : getNetworksTableItems()) {
                    ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                    if (canEditRequired(clusterNetworkManageModel)) {
                        clusterNetworkManageModel.setRequired(value);
                    }
                    refreshNetworksTable();
                }
            }

            @Override
            public Boolean getValue() {
                for (EntityModel model : getNetworksTableItems()) {
                    ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                    if (canEditRequired(clusterNetworkManageModel)) {
                        if (!clusterNetworkManageModel.isRequired()) {
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean isEnabled() {
                for (EntityModel model : getNetworksTableItems()) {
                    ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;
                    if (clusterNetworkManageModel.getIsChangable()) {
                        return true;
                    }
                }
                return false;
            }
        };

        networks.addColumn(new CheckboxColumn<EntityModel>(new FieldUpdater<EntityModel, Boolean>() {
            @Override
            public void update(int index, EntityModel model, Boolean value) {
                ((ClusterNetworkModel) model).setRequired(value);
                refreshNetworksTable();
            }
        }) {
            @Override
            public Boolean getValue(EntityModel model) {
                return ((ClusterNetworkModel) model).isRequired();
            }

            @Override
            protected boolean canEdit(EntityModel model) {
                return canEditRequired(model);
            }

            @Override
            public void render(Context context, EntityModel object, SafeHtmlBuilder sb) {
                super.render(context, object, sb);
                sb.append(templates.textForCheckBox(constants.required()));
            }
        }, requiredAllHeader, "110px"); //$NON-NLS-1$

        networks.addColumn(new CheckboxColumn<EntityModel>() {
            @Override
            public Boolean getValue(EntityModel model) {
                return ((ClusterNetworkModel) model).isVmNetwork();
            }

            @Override
            protected boolean canEdit(EntityModel model) {
                return false;
            }

        }, constants.vmNetwork(), "80px"); //$NON-NLS-1$

        networks.addColumn(new CheckboxColumn<EntityModel>(multipleSelectionAllowed,
                new FieldUpdater<EntityModel, Boolean>() {
            @Override
            public void update(int index, EntityModel model, Boolean value) {
                ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;

                networks.asEditor().flush().setDisplayNetwork(clusterNetworkManageModel, value);
                refreshNetworksTable();
            }
        }) {
            @Override
            public Boolean getValue(EntityModel model) {
                return ((ClusterNetworkModel) model).isDisplayNetwork();
            }

            @Override
            protected boolean canEdit(EntityModel model) {
                ClusterNetworkModel clusterNetworkModel = (ClusterNetworkModel) model;
                return clusterNetworkModel.isAttached() && !clusterNetworkModel.isExternal();
            }
        }, constants.displayNetwork(), "100px"); //$NON-NLS-1$

        networks.addColumn(new CheckboxColumn<EntityModel>(multipleSelectionAllowed,
                new FieldUpdater<EntityModel, Boolean>() {
            @Override
            public void update(int index, EntityModel model, Boolean value) {
                ClusterNetworkModel clusterNetworkManageModel = (ClusterNetworkModel) model;

                networks.asEditor().flush().setMigrationNetwork(clusterNetworkManageModel, value);
                refreshNetworksTable();
            }
        }) {
            @Override
            public Boolean getValue(EntityModel model) {
                return ((ClusterNetworkModel) model).isMigrationNetwork();
            }

            @Override
            protected boolean canEdit(EntityModel model) {
                ClusterNetworkModel clusterNetworkModel = ((ClusterNetworkModel) model);
                Boolean migrationNetworkEnabled =
                        (Boolean) AsyncDataProvider.getConfigValuePreConverted(ConfigurationValues.MigrationNetworkEnabled,
                         clusterNetworkModel.getCluster().getcompatibility_version().toString());
                return migrationNetworkEnabled && clusterNetworkModel.isAttached() && !clusterNetworkModel.isExternal();
            }
        }, constants.migrationNetwork(), "105px"); //$NON-NLS-1$
    }

    @Override
    public void edit(ClusterNetworkManageModel model) {
        networks.asEditor().edit(model);
        initEntityModelCellTable(constants, templates);
    }

    @Override
    public ClusterNetworkManageModel flush() {
        return networks.asEditor().flush();
    }

    private void changeIsAttached(ClusterNetworkModel clusterNetworkManageModel, Boolean value) {
        clusterNetworkManageModel.setAttached(value);
        if (!value && clusterNetworkManageModel.isDisplayNetwork()) {
            clusterNetworkManageModel.setDisplayNetwork(false);
        }
        if (!value && clusterNetworkManageModel.isRequired()) {
            clusterNetworkManageModel.setRequired(false);
        }
    }

    private boolean canEditAssign(EntityModel model) {
        return !((ClusterNetworkModel) model).isManagement();
    }

    private boolean canEditRequired(EntityModel model) {
        ClusterNetworkModel clusterNetworkModel = (ClusterNetworkModel) model;
        return clusterNetworkModel.isAttached() && !clusterNetworkModel.isManagement()
                && !clusterNetworkModel.isExternal();
    }

}
