/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1FeatureSpinlocks;
import kubevirt.io.V1FeatureState;
import kubevirt.io.V1FeatureVendorID;

/**
 * Hyperv specific features.
 */
@ApiModel(description = "Hyperv specific features.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1FeatureHyperv {
  @SerializedName("evmcs")
  private V1FeatureState evmcs = null;

  @SerializedName("frequencies")
  private V1FeatureState frequencies = null;

  @SerializedName("ipi")
  private V1FeatureState ipi = null;

  @SerializedName("reenlightenment")
  private V1FeatureState reenlightenment = null;

  @SerializedName("relaxed")
  private V1FeatureState relaxed = null;

  @SerializedName("reset")
  private V1FeatureState reset = null;

  @SerializedName("runtime")
  private V1FeatureState runtime = null;

  @SerializedName("spinlocks")
  private V1FeatureSpinlocks spinlocks = null;

  @SerializedName("synic")
  private V1FeatureState synic = null;

  @SerializedName("synictimer")
  private V1FeatureState synictimer = null;

  @SerializedName("tlbflush")
  private V1FeatureState tlbflush = null;

  @SerializedName("vapic")
  private V1FeatureState vapic = null;

  @SerializedName("vendorid")
  private V1FeatureVendorID vendorid = null;

  @SerializedName("vpindex")
  private V1FeatureState vpindex = null;

  public V1FeatureHyperv evmcs(V1FeatureState evmcs) {
    this.evmcs = evmcs;
    return this;
  }

   /**
   * EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic. Defaults to the machine type setting. +optional
   * @return evmcs
  **/
  @ApiModelProperty(value = "EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic. Defaults to the machine type setting. +optional")
  public V1FeatureState getEvmcs() {
    return evmcs;
  }

  public void setEvmcs(V1FeatureState evmcs) {
    this.evmcs = evmcs;
  }

  public V1FeatureHyperv frequencies(V1FeatureState frequencies) {
    this.frequencies = frequencies;
    return this;
  }

   /**
   * Frequencies improves the TSC clock source handling for Hyper-V on KVM. Defaults to the machine type setting. +optional
   * @return frequencies
  **/
  @ApiModelProperty(value = "Frequencies improves the TSC clock source handling for Hyper-V on KVM. Defaults to the machine type setting. +optional")
  public V1FeatureState getFrequencies() {
    return frequencies;
  }

  public void setFrequencies(V1FeatureState frequencies) {
    this.frequencies = frequencies;
  }

  public V1FeatureHyperv ipi(V1FeatureState ipi) {
    this.ipi = ipi;
    return this;
  }

   /**
   * IPI improves performances in overcommited environments. Requires vpindex. Defaults to the machine type setting. +optional
   * @return ipi
  **/
  @ApiModelProperty(value = "IPI improves performances in overcommited environments. Requires vpindex. Defaults to the machine type setting. +optional")
  public V1FeatureState getIpi() {
    return ipi;
  }

  public void setIpi(V1FeatureState ipi) {
    this.ipi = ipi;
  }

  public V1FeatureHyperv reenlightenment(V1FeatureState reenlightenment) {
    this.reenlightenment = reenlightenment;
    return this;
  }

   /**
   * Reenlightenment enables the notifications on TSC frequency changes. Defaults to the machine type setting. +optional
   * @return reenlightenment
  **/
  @ApiModelProperty(value = "Reenlightenment enables the notifications on TSC frequency changes. Defaults to the machine type setting. +optional")
  public V1FeatureState getReenlightenment() {
    return reenlightenment;
  }

  public void setReenlightenment(V1FeatureState reenlightenment) {
    this.reenlightenment = reenlightenment;
  }

  public V1FeatureHyperv relaxed(V1FeatureState relaxed) {
    this.relaxed = relaxed;
    return this;
  }

   /**
   * Relaxed instructs the guest OS to disable watchdog timeouts. Defaults to the machine type setting. +optional
   * @return relaxed
  **/
  @ApiModelProperty(value = "Relaxed instructs the guest OS to disable watchdog timeouts. Defaults to the machine type setting. +optional")
  public V1FeatureState getRelaxed() {
    return relaxed;
  }

  public void setRelaxed(V1FeatureState relaxed) {
    this.relaxed = relaxed;
  }

  public V1FeatureHyperv reset(V1FeatureState reset) {
    this.reset = reset;
    return this;
  }

   /**
   * Reset enables Hyperv reboot/reset for the vmi. Requires synic. Defaults to the machine type setting. +optional
   * @return reset
  **/
  @ApiModelProperty(value = "Reset enables Hyperv reboot/reset for the vmi. Requires synic. Defaults to the machine type setting. +optional")
  public V1FeatureState getReset() {
    return reset;
  }

  public void setReset(V1FeatureState reset) {
    this.reset = reset;
  }

  public V1FeatureHyperv runtime(V1FeatureState runtime) {
    this.runtime = runtime;
    return this;
  }

   /**
   * Runtime improves the time accounting to improve scheduling in the guest. Defaults to the machine type setting. +optional
   * @return runtime
  **/
  @ApiModelProperty(value = "Runtime improves the time accounting to improve scheduling in the guest. Defaults to the machine type setting. +optional")
  public V1FeatureState getRuntime() {
    return runtime;
  }

  public void setRuntime(V1FeatureState runtime) {
    this.runtime = runtime;
  }

  public V1FeatureHyperv spinlocks(V1FeatureSpinlocks spinlocks) {
    this.spinlocks = spinlocks;
    return this;
  }

   /**
   * Spinlocks allows to configure the spinlock retry attempts. +optional
   * @return spinlocks
  **/
  @ApiModelProperty(value = "Spinlocks allows to configure the spinlock retry attempts. +optional")
  public V1FeatureSpinlocks getSpinlocks() {
    return spinlocks;
  }

  public void setSpinlocks(V1FeatureSpinlocks spinlocks) {
    this.spinlocks = spinlocks;
  }

  public V1FeatureHyperv synic(V1FeatureState synic) {
    this.synic = synic;
    return this;
  }

   /**
   * SyNIC enables the Synthetic Interrupt Controller. Defaults to the machine type setting. +optional
   * @return synic
  **/
  @ApiModelProperty(value = "SyNIC enables the Synthetic Interrupt Controller. Defaults to the machine type setting. +optional")
  public V1FeatureState getSynic() {
    return synic;
  }

  public void setSynic(V1FeatureState synic) {
    this.synic = synic;
  }

  public V1FeatureHyperv synictimer(V1FeatureState synictimer) {
    this.synictimer = synictimer;
    return this;
  }

   /**
   * SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load. Defaults to the machine type setting. +optional
   * @return synictimer
  **/
  @ApiModelProperty(value = "SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load. Defaults to the machine type setting. +optional")
  public V1FeatureState getSynictimer() {
    return synictimer;
  }

  public void setSynictimer(V1FeatureState synictimer) {
    this.synictimer = synictimer;
  }

  public V1FeatureHyperv tlbflush(V1FeatureState tlbflush) {
    this.tlbflush = tlbflush;
    return this;
  }

   /**
   * TLBFlush improves performances in overcommited environments. Requires vpindex. Defaults to the machine type setting. +optional
   * @return tlbflush
  **/
  @ApiModelProperty(value = "TLBFlush improves performances in overcommited environments. Requires vpindex. Defaults to the machine type setting. +optional")
  public V1FeatureState getTlbflush() {
    return tlbflush;
  }

  public void setTlbflush(V1FeatureState tlbflush) {
    this.tlbflush = tlbflush;
  }

  public V1FeatureHyperv vapic(V1FeatureState vapic) {
    this.vapic = vapic;
    return this;
  }

   /**
   * VAPIC improves the paravirtualized handling of interrupts. Defaults to the machine type setting. +optional
   * @return vapic
  **/
  @ApiModelProperty(value = "VAPIC improves the paravirtualized handling of interrupts. Defaults to the machine type setting. +optional")
  public V1FeatureState getVapic() {
    return vapic;
  }

  public void setVapic(V1FeatureState vapic) {
    this.vapic = vapic;
  }

  public V1FeatureHyperv vendorid(V1FeatureVendorID vendorid) {
    this.vendorid = vendorid;
    return this;
  }

   /**
   * VendorID allows setting the hypervisor vendor id. Defaults to the machine type setting. +optional
   * @return vendorid
  **/
  @ApiModelProperty(value = "VendorID allows setting the hypervisor vendor id. Defaults to the machine type setting. +optional")
  public V1FeatureVendorID getVendorid() {
    return vendorid;
  }

  public void setVendorid(V1FeatureVendorID vendorid) {
    this.vendorid = vendorid;
  }

  public V1FeatureHyperv vpindex(V1FeatureState vpindex) {
    this.vpindex = vpindex;
    return this;
  }

   /**
   * VPIndex enables the Virtual Processor Index to help windows identifying virtual processors. Defaults to the machine type setting. +optional
   * @return vpindex
  **/
  @ApiModelProperty(value = "VPIndex enables the Virtual Processor Index to help windows identifying virtual processors. Defaults to the machine type setting. +optional")
  public V1FeatureState getVpindex() {
    return vpindex;
  }

  public void setVpindex(V1FeatureState vpindex) {
    this.vpindex = vpindex;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1FeatureHyperv v1FeatureHyperv = (V1FeatureHyperv) o;
    return Objects.equals(this.evmcs, v1FeatureHyperv.evmcs) &&
        Objects.equals(this.frequencies, v1FeatureHyperv.frequencies) &&
        Objects.equals(this.ipi, v1FeatureHyperv.ipi) &&
        Objects.equals(this.reenlightenment, v1FeatureHyperv.reenlightenment) &&
        Objects.equals(this.relaxed, v1FeatureHyperv.relaxed) &&
        Objects.equals(this.reset, v1FeatureHyperv.reset) &&
        Objects.equals(this.runtime, v1FeatureHyperv.runtime) &&
        Objects.equals(this.spinlocks, v1FeatureHyperv.spinlocks) &&
        Objects.equals(this.synic, v1FeatureHyperv.synic) &&
        Objects.equals(this.synictimer, v1FeatureHyperv.synictimer) &&
        Objects.equals(this.tlbflush, v1FeatureHyperv.tlbflush) &&
        Objects.equals(this.vapic, v1FeatureHyperv.vapic) &&
        Objects.equals(this.vendorid, v1FeatureHyperv.vendorid) &&
        Objects.equals(this.vpindex, v1FeatureHyperv.vpindex);
  }

  @Override
  public int hashCode() {
    return Objects.hash(evmcs, frequencies, ipi, reenlightenment, relaxed, reset, runtime, spinlocks, synic, synictimer, tlbflush, vapic, vendorid, vpindex);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1FeatureHyperv {\n");
    
    sb.append("    evmcs: ").append(toIndentedString(evmcs)).append("\n");
    sb.append("    frequencies: ").append(toIndentedString(frequencies)).append("\n");
    sb.append("    ipi: ").append(toIndentedString(ipi)).append("\n");
    sb.append("    reenlightenment: ").append(toIndentedString(reenlightenment)).append("\n");
    sb.append("    relaxed: ").append(toIndentedString(relaxed)).append("\n");
    sb.append("    reset: ").append(toIndentedString(reset)).append("\n");
    sb.append("    runtime: ").append(toIndentedString(runtime)).append("\n");
    sb.append("    spinlocks: ").append(toIndentedString(spinlocks)).append("\n");
    sb.append("    synic: ").append(toIndentedString(synic)).append("\n");
    sb.append("    synictimer: ").append(toIndentedString(synictimer)).append("\n");
    sb.append("    tlbflush: ").append(toIndentedString(tlbflush)).append("\n");
    sb.append("    vapic: ").append(toIndentedString(vapic)).append("\n");
    sb.append("    vendorid: ").append(toIndentedString(vendorid)).append("\n");
    sb.append("    vpindex: ").append(toIndentedString(vpindex)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

