package org.ovirt.engine.core.bll;

import static org.mockito.Mockito.atLeastOnce;
import static org.mockito.Mockito.verify;

import org.junit.Test;
import org.ovirt.engine.core.common.interfaces.SearchType;
import org.ovirt.engine.core.common.queries.SearchParameters;

public class DirectoryGroupSearchQueryTest extends DirectorySearchQueryTestBase {
    // The name of the group to search:
    private static final String NAME = "wizards";

    /**
     * The objective of this test is to verify that the LDAP filter generated by the {@link SearchQuery} class is
     * correct, the success or failure and the result of the command aren't relevant.
     */
    @Test
    public void testFilterGeneration() {
        // Run the query:
        SearchParameters parameters = new SearchParameters("AdGroup: allnames=" + NAME, SearchType.DirectoryGroup);
        SearchQuery query = new SearchQuery(parameters);
        query.setInternalExecution(true);
        query.execute();

        // Check that the directory was used to perform the expected LDAP query:
        String expectedFilter =
            "(&($LDAP_GROUP_CATEGORY) (|" +
                "($CN=" + NAME + ")" +
            "))";
        verify(directoryMock, atLeastOnce()).queryGroups(expectedFilter);
    }
}
