#
# otopi -- plugable installer
# Copyright (C) 2012-2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.1.2
%global		package_maven_version 1.1.0

%if 0%{?rhel:1}
%global		maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy
%endif

# rhel does not support complex boolean statements
%if 0%{?fedora:1}
%if %{fedora} >= 19
%global		fedora_19_maven	1
%endif
%endif

Summary:	oVirt Task Oriented Pluggable Installer/Implementation (%{name})
Name:		otopi
Version:	1.1.2
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/releases/3.3/src/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch

Requires:	python
BuildRequires:	gettext
BuildRequires:	python2-devel
BuildRequires:	java-devel

%if 0%{?fedora:1}
BuildRequires:	apache-commons-logging
BuildRequires:	junit
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit4

%if 0%{?fedora_19_maven:1}
BuildRequires:	maven-local
%else
BuildRequires:	maven
BuildRequires:	jpackage-utils
%endif

%else
BuildRequires:	jakarta-commons-logging
BuildRequires:	junit4
%endif

%description
Standalone plugin based installation framework to be used to setup
system components. The plugin nature provides simplicity to
add new installation functionality without the complexity of the state
and transaction management.

%package java
Summary:	%{name} java support
Requires:	%{name} = %{version}-%{release}
Requires:	java
%if 0%{?fedora:1}
Requires:	apache-commons-logging

%if 0%{?fedora:1}
%if !0%{?fedora_19_maven:1}
Requires:	jpackage-utils
%endif
%endif

%else
Requires:	jakarta-commons-logging
%endif
%description java
java libraries.

%if 0%{?fedora:1}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%if !0%{?fedora_19_maven:1}
Requires:	jpackage-utils
%endif

%description javadoc
This package contains the API documentation for %{name}.
%endif

%package devel
Summary:	%{name} development components
Requires:	%{name}-java = %{version}-%{release}
%description devel
Development environment for %{name}.

%if 0%{?rhel:1}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if 0%{?fedora:1}
%global conf --disable-java-sdk-compile
%else
%global conf COMMONS_LOGGING_JAR=$(build-classpath commons-logging) JUNIT_JAR=$(build-classpath junit4)
%endif
%configure \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	--with-local-version="%{name}-%{version}-%{release}" \
	%{?conf}
make %{?_smp_mflags}

%if 0%{?fedora:1}

cd src/java
%if 0%{?fedora_19_maven:1}
%mvn_build
%else
mvn-rpmbuild install javadoc:aggregate
%endif
cd ../..
%endif

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if 0%{?fedora:1}

%if 0%{?fedora_19_maven:1}
cd src/java
%mvn_install
cd ../..
%else
install -d -m 755 "%{buildroot}%{_javadir}/%{name}"
install -d -m 755 "%{buildroot}%{_mavenpomdir}"
install -pm 644 src/java/target/%{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s "%{name}-%{package_maven_version}.jar" "%{buildroot}%{_javadir}/%{name}/%{name}.jar"
install -pm 644 "src/java/pom.xml" "%{buildroot}%{_mavenpomdir}/JPP.%{name}-%{name}.pom"
%add_maven_depmap "JPP.%{name}-%{name}.pom" "%{name}/%{name}.jar"
mkdir -p "%{buildroot}%{_javadocdir}/%{name}"
cp -rp src/java/target/apidocs/*  "%{buildroot}%{_javadocdir}/%{name}"
%endif

%else

install -d "%{buildroot}%{_javadir}/%{name}"
install target/%{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s %{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}/%{name}.jar

%endif

%if 0%{?rhel:1}
install -d "%{buildroot}%{maven2brewrepodir}"
cp "%{buildroot}%{_javadir}/%{name}/%{name}.jar" "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.jar"
cp src/java/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.pom"
%endif

install -d -m 755 "%{buildroot}%{_sysconfdir}/%{name}.conf.d"

%if 0%{?fedora:1}
%if !0%{?fedora_19_maven:1}
%post java
%update_maven_depmap
%postun java
%update_maven_depmap
%endif
%endif

%files
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/plugins
%dir %{_sysconfdir}/%{name}.conf.d
%doc AUTHORS
%doc COPYING
%doc README
%doc README.API
%doc README.dialog
%doc README.environment
%exclude %{python_sitelib}/%{name}/codegen/
%{_datadir}/%{name}/plugins/%{name}/
%{_sbindir}/%{name}
%{python_sitelib}/%{name}/

%if 0%{?fedora_19_maven:1}
%files java -f src/java/.mfiles
%else
%files java
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/%{name}*.jar
%if 0%{?fedora:1}
%{_mavenpomdir}/JPP.%{name}-%{name}.pom
%{_mavendepmapfragdir}/%{name}
%endif
%endif

%if 0%{?fedora:1}

%if 0%{?fedora_19_maven:1}
%files javadoc -f src/java/.mfiles-javadoc
%else
%files javadoc
%dir %{_javadocdir}/%{name}
%{_javadocdir}/%{name}
%endif

%endif

%files devel
%{_datadir}/%{name}/%{name}-bundle
%{python_sitelib}/%{name}/codegen/

%if 0%{?rhel:1}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Mon Oct 7 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.2-1
- Release.

* Sat Sep 7 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.1-1
- Release.

* Mon Aug 26 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.0-1
- Release.

* Thu Feb 14 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-1
- Release.

* Sat Oct 13 2012 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-0.1_beta
- Initial add.
