# Settings
%global product_name Reports package for oVirt Virtualization Management
%global product_description oVirt virtualization reports
%global install_poms 1

%global reports_name ovirt-engine-reports
%global reports_java %{_javadir}/%{reports_name}
%global engine_group ovirt
%global engine_user ovirt

%global make_common_opts \\\
        -j1 \\\
        PACKAGE_NAME=%{name} \\\
        RPM_VERSION=%{version} \\\
        RPM_RELEASE=%{release} \\\
        OVIRT_REPORTS_NAME=%{reports_name} \\\
        PREFIX=%{_prefix} \\\
        SYSCONF_DIR=%{_sysconfdir} \\\
        BIN_DIR=%{_bindir} \\\
        DATAROOT_DIR=%{_datadir} \\\
        PYTHON=%{__python} \\\
        PYTHON_DIR=%{python_sitelib} \\\
        JAVA_DIR=%{_javadir} \\\
        MAVENPOM_DIR=%{_mavenpomdir} \\\
        PKG_JAVA_DIR=%{reports_java} \\\
        %{?BUILD_FLAGS:BUILD_FLAGS="%{BUILD_FLAGS}"} \\\
        %{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name: ovirt-engine-reports
Version: 3.3.5
Release: 1%{?release_suffix}%{dist}
License: AGPLv3
Summary: %{product_name}
Group: Virtualization/Management
URL: http://www.ovirt.org
BuildArch: noarch
Source: http://resources.ovirt.org/pub/ovirt-3.3-snapshot/src/ovirt-engine-reports-3.3.5.tar.gz
BuildRequires: maven
BuildRequires: jpackage-utils
BuildRequires: java-1.7.0-openjdk-devel
BuildRequires: make
BuildRequires: log4j
Requires: python
Requires: java-1.7.0-openjdk
Requires: jpackage-utils
Requires: ovirt-engine >= 3.3.0
Requires: ovirt-engine-dbscripts >= 3.3.0
Requires: ovirt-engine-dwh >= 3.3.0
Requires: jasperreports-server = 5.5.0-1
Requires: m2crypto

# We need some packages installed in order to workaround
# bug 862355:
Requires: liberation-mono-fonts

%description
The %{product_description} package provides a suite of
pre-configured reports and dashboards that enable you to
monitor the system. The reports module is based on
JasperReports and JasperServer, and can also be used to create
ad-hoc reports.

%prep

%setup -c -q

%build

make %{make_common_opts}

%install
rm -fr "%{buildroot}"

# Use the makefile to do the normal installation, after that we
# will need to replace jar files with links to their actual
# locations:
make %{make_common_opts} install DESTDIR=%{buildroot}

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{reports_name}"
    ln -s -f %{_bindir}/%{reports_name}-setup %{buildroot}%{_bindir}/%{name}-setup
    ln -s "%{reports_name}" "%{buildroot}%{reports_java}/../%{name}"
%endif

# Register poms
%if !%{install_poms}
rm -fr "%{buildroot}%{_mavenpomdir}"
%else
for pom in %{buildroot}%{_mavenpomdir}/*.pom
do
  pomdir=`dirname "${pom}"`
  pom=`basename "${pom}"`
  jpppom="JPP.${pom}"
  mv "${pomdir}/${pom}" "${pomdir}/${jpppom}"
  artifact_id=`echo "${pom}" | sed -e 's/^%{name}-//' -e 's/\.pom//'`
  if [ -f "%{buildroot}%{reports_java}/${artifact_id}.jar" ]
  then
    %add_maven_depmap "${jpppom}" "%{name}/${artifact_id}.jar"
  else
    %add_maven_depmap "${jpppom}"
  fi
done
%endif

%post
%update_maven_depmap

%postun
%update_maven_depmap
if [ "$1" -eq 0 ]; then
    if [ -d /usr/share/ovirt-engine/%{name}.war ]; then
        rm -rf /usr/share/ovirt-engine/%{name}.war
        rm -rf /var/lib/ovirt-engine/deployments/%{name}.war*
    fi
    if [ -f /etc/ovirt-engine/jrs-deployment.version ]; then
        rm -rf /etc/ovirt-engine/jrs-deployment.version
    fi
    if [ -f /usr/share/ovirt-engine/engine.ear/webadmin.war/webadmin/Reports.xml ]; then
        rm -rf /usr/share/ovirt-engine/engine.ear/webadmin.war/webadmin/Reports.xml
    fi
fi

%files
%dir %attr(-, %{engine_user}, %{engine_group}) %{_sysconfdir}/%{reports_name}/ovirt-engine-reports.conf.d

%{_sysconfdir}/ovirt-engine/engine.conf.d/50-ovirt-engine-reports.conf
%{_sysconfdir}/ovirt-engine/ovirt-engine-reports
%{_sysconfdir}/httpd/conf.d/z-ovirt-engine-reports-proxy.conf
%{reports_java}
%{_datadir}/%{reports_name}
%if "%{name}" != "%{reports_name}"
%{_javadir}/%{name}
%endif
%if %{install_poms}
%{_mavendepmapfragdir}/%{name}
%{_mavenpomdir}/JPP.%{name}-*
%endif

%{_bindir}/%{reports_name}-setup
%if "%{name}" != "%{reports_name}"
%{_bindir}/%{name}-setup
%endif

%changelog
* Wed Apr 9 2014 Yaniv Dary <ydary@redhat.com> - 3.3.5
Fixed issue:
- less strict parsing of pg_hba.conf (#1085374)

* Tue Mar 11 2014 Yaniv Dary <ydary@redhat.com> - 3.3.5
Fixed issue:
1074909 - setup error on a system installed in Brazilian Portuguese

* Mon Mar 10 2014 Yaniv Dary <ydary@redhat.com> - 3.3.5
Fixes issues:
1059268 - BR18 - the numbers of OSs are incorrect
1064827 - ssl2jkstrust.py does not get root ca from chain in some cases
1072405 - ovirt-engine-reports-setup does not handle escape characters in the 10-setup-database.conf ENGINE_DB_PASSWORD
1072466 - Upgrading reports from 3.2 to 3.3 without Apache running fails and prevents any future setup from succeeding

* Tue Feb 25 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.3.4-1
- 3.3.4-1

* Sun Nov 4 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
- Update

* Wed Feb 15 2012 Yaniv Dary <ydary@redhat.com> - 3.0.2
- Initial Commit
