// ============================================================================
//
// Copyright (c) 2006-2013, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.configurationsync_3_3;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: ConfigurationSync Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 5.3.0.r101800
 * @status 
 */
public class ConfigurationSync implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "3.3";
	private final String jobName = "ConfigurationSync";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";
	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	public boolean isExportedAsOSGI = false;

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private java.lang.Exception exception = null;

	public java.lang.Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends java.lang.Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private java.lang.Exception e = null;
		private String currentComponent = null;

		private TalendException(java.lang.Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public java.lang.Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						e.getMessage());
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					ConfigurationSync.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(ConfigurationSync.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (java.lang.SecurityException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalArgumentException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalAccessException e) {
					this.e.printStackTrace();
				} catch (java.lang.reflect.InvocationTargetException e) {
					this.e.printStackTrace();
				} catch (TalendException e) {
					// do nothing
				}

			} else {

				((java.util.Map) threadLocal.get()).put("status", "failure");

			}
		}
	}

	public void tJDBCInput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_15_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_15", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_14_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_14", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_14_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_18_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_18", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_15_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_15", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_15_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_20_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_20", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_16_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_16", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_16_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_33_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_33", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_33_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_23_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_23", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_33_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_23_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_33_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_34_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_34", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_34_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_22_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_22", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_34_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_24_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_34_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_22_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_22", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_17_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_17", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_17_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_24_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_24", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_18_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_18", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_18_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_26_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_26", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_19_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_19", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_19_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_28_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_28", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_28_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_20_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_20", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_28_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_20_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_28_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_61_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_61", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_61_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_33_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_33", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_61_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_35_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_35", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_61_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_62_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_62", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_62_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_34_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_34", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_62_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_36_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_36", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_62_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_30_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_30", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_30_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_21_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_21", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_30_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_21_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_30_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_53_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_53", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_53_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_31_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_31", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_53_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_31_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_31", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_53_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_56_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_56", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_56_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_32_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_32", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_56_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_32_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_32", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_56_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_45_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_45", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_45_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_26_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_26", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_45_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_26_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_26", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_45_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_48_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_48", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_48_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_27_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_27", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_48_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_27_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_27", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_48_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_46_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_46", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCSP_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCSP_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_28_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_28", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_28_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_28", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_50_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_50", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_50_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_29_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_29", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_50_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_29_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_29", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_50_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRow_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCRow_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRow_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_52_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_52", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_30_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_30", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_30_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_30", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_33_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_33", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_39_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_39", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_39_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_40_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_40", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_40_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_41_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_41", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_41_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_43_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_43", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_43_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_42_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_42", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_42_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_44_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_44", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_44_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_14_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_14", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_17_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_17", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_17_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_19_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_19", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_19_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_21_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_21", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_23_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_23", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_23_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_25_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_25", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_25_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_27_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_27", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_27_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_29_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_29", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_29_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_35_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_35", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_35_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_32_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_32", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_32_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_58_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_58", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_58_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_47_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_47", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_47_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_59_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_59", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_59_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_49_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_49", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_49_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_55_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_55", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_55_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_63_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_63", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_63_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_64_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_64", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_64_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_54_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_54", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_54_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_65_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_65", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_65_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_66_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_66", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_66_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tPrejob_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row35_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row35", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_39_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row36_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row36", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_40_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row37_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row37", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_41_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row38_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row38", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_43_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row39_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row39", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_42_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row40_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row40", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_44_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row15_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row15", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row16_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row16", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_17_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row18_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row18", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_19_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row20_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row20", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row22_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row22", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_23_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row24_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row24", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_25_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row26_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row26", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_27_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row28_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row28", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_29_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row33_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row33", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_35_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row32_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row32", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_32_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row34_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row34", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_58_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row11_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row11", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_47_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row43_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row43", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_59_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row13_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row13", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_49_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row47_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row47", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_55_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row51_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row51", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_63_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row52_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row52", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_64_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row46_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row46", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_54_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row53_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row53", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_65_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row54_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tAdvancedHash_row54", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_66_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_CONSOLE_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_15_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_18_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_20_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_33_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_34_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_22_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_24_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_26_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_7_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_28_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_61_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_62_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_8_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_30_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_53_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_56_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_45_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_48_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_46_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_50_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRow_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_52_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_39_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_40_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_41_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_43_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_42_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_44_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_14_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_17_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_19_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_21_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_23_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_25_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_27_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_29_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_35_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_32_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_58_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_47_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_59_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_49_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_55_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_63_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_64_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_54_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_65_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_66_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public static class datacenter_configurationStruct implements
			routines.system.IPersistableRow<datacenter_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public short storage_type;

		public short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					this.storage_type = dis.readShort();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// short

				dos.writeShort(this.storage_type);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(datacenter_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();
				datacenter_configurationStruct datacenter_configuration = new datacenter_configurationStruct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_2) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_2 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_2 = dataSources_tJDBCOutput_2
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_2 = 10000;
				int batchSizeCounter_tJDBCOutput_2 = 0;

				String insert_tJDBCOutput_2 = "INSERT INTO "
						+ "datacenter_configuration"
						+ " (datacenter_id,datacenter_name,datacenter_description,storage_type,create_date,update_date) VALUES (?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(insert_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tMap_2 begin ] start
				 */

				ok_Hash.put("tMap_2", false);
				start_Hash.put("tMap_2", System.currentTimeMillis());
				currentComponent = "tMap_2";

				int tos_count_tMap_2 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_2__Struct {
				}
				Var__tMap_2__Struct Var__tMap_2 = new Var__tMap_2__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				datacenter_configurationStruct datacenter_configuration_tmp = new datacenter_configurationStruct();
				// ###############################

				/**
				 * [tMap_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());
				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_2) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_2 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_2 = dataSources_tJDBCInput_2.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_2);
				}

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT     datacenter_id,     datacenter_name,     datacenter_description,     storage_type,     create_date,     update_date  FROM dwh_datacenter_configuration_history_view";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);

				java.sql.ResultSet rs_tJDBCInput_2 = stmt_tJDBCInput_2
						.executeQuery(dbquery_tJDBCInput_2);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
						.getMetaData();
				int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
						.getColumnCount();

				String tmpContent_tJDBCInput_2 = null;
				int column_index_tJDBCInput_2 = 1;
				while (rs_tJDBCInput_2.next()) {
					nb_line_tJDBCInput_2++;

					column_index_tJDBCInput_2 = 1;

					if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
						row3.datacenter_id = null;
					} else {

						if (rs_tJDBCInput_2
								.getObject(column_index_tJDBCInput_2) != null) {
							row3.datacenter_id = rs_tJDBCInput_2
									.getObject(column_index_tJDBCInput_2);
						} else {
							row3.datacenter_id = null;
						}

						if (rs_tJDBCInput_2.wasNull()) {
							row3.datacenter_id = null;
						}
					}
					column_index_tJDBCInput_2 = 2;

					if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
						row3.datacenter_name = null;
					} else {

						tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
								.getString(column_index_tJDBCInput_2);
						if (tmpContent_tJDBCInput_2 != null) {
							row3.datacenter_name = tmpContent_tJDBCInput_2;
						} else {
							row3.datacenter_name = null;
						}

						if (rs_tJDBCInput_2.wasNull()) {
							row3.datacenter_name = null;
						}
					}
					column_index_tJDBCInput_2 = 3;

					if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
						row3.datacenter_description = null;
					} else {

						tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
								.getString(column_index_tJDBCInput_2);
						if (tmpContent_tJDBCInput_2 != null) {
							row3.datacenter_description = tmpContent_tJDBCInput_2;
						} else {
							row3.datacenter_description = null;
						}

						if (rs_tJDBCInput_2.wasNull()) {
							row3.datacenter_description = null;
						}
					}
					column_index_tJDBCInput_2 = 4;

					if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
						row3.storage_type = null;
					} else {

						if (rs_tJDBCInput_2
								.getObject(column_index_tJDBCInput_2) != null) {
							row3.storage_type = rs_tJDBCInput_2
									.getShort(column_index_tJDBCInput_2);
						} else {
							row3.storage_type = null;
						}

						if (rs_tJDBCInput_2.wasNull()) {
							row3.storage_type = null;
						}
					}
					column_index_tJDBCInput_2 = 5;

					if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
						row3.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_2 = null;
						try {
							date_tJDBCInput_2 = rs_tJDBCInput_2
									.getTimestamp(column_index_tJDBCInput_2);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_2 = rs_tJDBCInput_2
									.getDate(column_index_tJDBCInput_2);
						}
						row3.create_date = date_tJDBCInput_2;

						if (rs_tJDBCInput_2.wasNull()) {
							row3.create_date = null;
						}
					}
					column_index_tJDBCInput_2 = 6;

					if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
						row3.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_2 = null;
						try {
							date_tJDBCInput_2 = rs_tJDBCInput_2
									.getTimestamp(column_index_tJDBCInput_2);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_2 = rs_tJDBCInput_2
									.getDate(column_index_tJDBCInput_2);
						}
						row3.update_date = date_tJDBCInput_2;

						if (rs_tJDBCInput_2.wasNull()) {
							row3.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_2 begin ] stop
					 */
					/**
					 * [tJDBCInput_2 main ] start
					 */

					currentComponent = "tJDBCInput_2";

					tos_count_tJDBCInput_2++;

					/**
					 * [tJDBCInput_2 main ] stop
					 */

					/**
					 * [tMap_2 main ] start
					 */

					currentComponent = "tMap_2";

					boolean hasCasePrimitiveKeyWithNull_tMap_2 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_2 = false;
					boolean mainRowRejected_tMap_2 = false;

					if (

					(

					row3.update_date == null ? TalendDate.compareDate(
							row3.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row3.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row3'
						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_2__Struct Var = Var__tMap_2;// ###############################
							// ###############################
							// # Output tables

							datacenter_configuration = null;

							// # Output table : 'datacenter_configuration'
							datacenter_configuration_tmp.datacenter_id = row3.datacenter_id;
							datacenter_configuration_tmp.datacenter_name = StringHandling
									.TRIM(row3.datacenter_name);
							datacenter_configuration_tmp.datacenter_description = StringHandling
									.TRIM(row3.datacenter_description);
							datacenter_configuration_tmp.storage_type = row3.storage_type;
							datacenter_configuration_tmp.create_date = row3.create_date;
							datacenter_configuration_tmp.update_date = row3.update_date;
							datacenter_configuration = datacenter_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_2 = false;

						tos_count_tMap_2++;

						/**
						 * [tMap_2 main ] stop
						 */
						// Start of branch "datacenter_configuration"
						if (datacenter_configuration != null) {

							/**
							 * [tJDBCOutput_2 main ] start
							 */

							currentComponent = "tJDBCOutput_2";

							whetherReject_tJDBCOutput_2 = false;
							if (datacenter_configuration.datacenter_id == null) {
								pstmt_tJDBCOutput_2.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_2.setObject(1,
										datacenter_configuration.datacenter_id);
							}

							if (datacenter_configuration.datacenter_name == null) {
								pstmt_tJDBCOutput_2.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_2
										.setString(
												2,
												datacenter_configuration.datacenter_name);
							}

							if (datacenter_configuration.datacenter_description == null) {
								pstmt_tJDBCOutput_2.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_2
										.setString(
												3,
												datacenter_configuration.datacenter_description);
							}

							pstmt_tJDBCOutput_2.setShort(4,
									datacenter_configuration.storage_type);

							if (datacenter_configuration.create_date != null) {
								pstmt_tJDBCOutput_2
										.setTimestamp(
												5,
												new java.sql.Timestamp(
														datacenter_configuration.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_2.setNull(5,
										java.sql.Types.DATE);
							}

							if (datacenter_configuration.update_date != null) {
								pstmt_tJDBCOutput_2
										.setTimestamp(
												6,
												new java.sql.Timestamp(
														datacenter_configuration.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_2.setNull(6,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_2 = insertedCount_tJDBCOutput_2
										+ pstmt_tJDBCOutput_2.executeUpdate();
								nb_line_tJDBCOutput_2++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_2 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_2++;

							/**
							 * [tJDBCOutput_2 main ] stop
							 */

						} // End of branch "datacenter_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row3'

					/**
					 * [tJDBCInput_2 end ] start
					 */

					currentComponent = "tJDBCInput_2";

				}
				rs_tJDBCInput_2.close();
				stmt_tJDBCInput_2.close();

				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tMap_2 end ] start
				 */

				currentComponent = "tMap_2";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_2", true);
				end_Hash.put("tMap_2", System.currentTimeMillis());

				/**
				 * [tMap_2 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_15Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class delete_datacentersStruct implements
			routines.system.IPersistableRow<delete_datacentersStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public short storage_type;

		public short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					this.storage_type = dis.readShort();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// short

				dos.writeShort(this.storage_type);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_datacentersStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row14Struct implements
			routines.system.IPersistableRow<row14Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row14Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_15Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_15Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_15Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_15Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_14Process(globalMap);

				row14Struct row14 = new row14Struct();
				delete_datacentersStruct delete_datacenters = new delete_datacentersStruct();

				/**
				 * [tJDBCOutput_14 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_14", false);
				start_Hash.put("tJDBCOutput_14", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_14";

				int tos_count_tJDBCOutput_14 = 0;

				int nb_line_tJDBCOutput_14 = 0;
				int nb_line_update_tJDBCOutput_14 = 0;
				int nb_line_inserted_tJDBCOutput_14 = 0;
				int nb_line_deleted_tJDBCOutput_14 = 0;
				int nb_line_rejected_tJDBCOutput_14 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_14 = 0;

				int deletedCount_tJDBCOutput_14 = 0;
				int updatedCount_tJDBCOutput_14 = 0;
				int insertedCount_tJDBCOutput_14 = 0;
				int rejectedCount_tJDBCOutput_14 = 0;

				boolean whetherReject_tJDBCOutput_14 = false;

				java.sql.Connection connection_tJDBCOutput_14 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_14) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_14 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_14 = dataSources_tJDBCOutput_14.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_14 = 10000;
				int batchSizeCounter_tJDBCOutput_14 = 0;

				String insert_tJDBCOutput_14 = "INSERT INTO "
						+ "datacenter_configuration"
						+ " (datacenter_id,datacenter_name,datacenter_description,storage_type,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_14 = connection_tJDBCOutput_14
						.prepareStatement(insert_tJDBCOutput_14);

				/**
				 * [tJDBCOutput_14 begin ] stop
				 */

				/**
				 * [tMap_14 begin ] start
				 */

				ok_Hash.put("tMap_14", false);
				start_Hash.put("tMap_14", System.currentTimeMillis());
				currentComponent = "tMap_14";

				int tos_count_tMap_14 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row15Struct> tHash_Lookup_row15 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row15Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row15Struct>) globalMap
						.get("tHash_Lookup_row15"));

				row15Struct row15HashKey = new row15Struct();
				row15Struct row15Default = new row15Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_14__Struct {
				}
				Var__tMap_14__Struct Var__tMap_14 = new Var__tMap_14__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_datacentersStruct delete_datacenters_tmp = new delete_datacentersStruct();
				// ###############################

				/**
				 * [tMap_14 begin ] stop
				 */

				/**
				 * [tJDBCInput_15 begin ] start
				 */

				ok_Hash.put("tJDBCInput_15", false);
				start_Hash.put("tJDBCInput_15", System.currentTimeMillis());
				currentComponent = "tJDBCInput_15";

				int tos_count_tJDBCInput_15 = 0;

				int nb_line_tJDBCInput_15 = 0;
				java.sql.Connection conn_tJDBCInput_15 = null;
				conn_tJDBCInput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_15) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_15 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_15 = dataSources_tJDBCInput_15.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_15);
				}

				java.sql.Statement stmt_tJDBCInput_15 = conn_tJDBCInput_15
						.createStatement();

				String dbquery_tJDBCInput_15 = "SELECT history_id,   		datacenter_id,   		upper(cast(datacenter_id as char(36))) as datacenter_join_id,  		datacenter_name,   		datacenter_description,          	storage_type,   		create_date,   		update_date  FROM  v3_3_latest_configuration_datacenters";

				globalMap.put("tJDBCInput_15_QUERY", dbquery_tJDBCInput_15);

				java.sql.ResultSet rs_tJDBCInput_15 = stmt_tJDBCInput_15
						.executeQuery(dbquery_tJDBCInput_15);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_15 = rs_tJDBCInput_15
						.getMetaData();
				int colQtyInRs_tJDBCInput_15 = rsmd_tJDBCInput_15
						.getColumnCount();

				String tmpContent_tJDBCInput_15 = null;
				int column_index_tJDBCInput_15 = 1;
				while (rs_tJDBCInput_15.next()) {
					nb_line_tJDBCInput_15++;

					column_index_tJDBCInput_15 = 1;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.history_id = null;
					} else {

						if (rs_tJDBCInput_15
								.getObject(column_index_tJDBCInput_15) != null) {
							row14.history_id = rs_tJDBCInput_15
									.getInt(column_index_tJDBCInput_15);
						} else {
							row14.history_id = null;
						}

						if (rs_tJDBCInput_15.wasNull()) {
							row14.history_id = null;
						}
					}
					column_index_tJDBCInput_15 = 2;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.datacenter_id = null;
					} else {

						if (rs_tJDBCInput_15
								.getObject(column_index_tJDBCInput_15) != null) {
							row14.datacenter_id = rs_tJDBCInput_15
									.getObject(column_index_tJDBCInput_15);
						} else {
							row14.datacenter_id = null;
						}

						if (rs_tJDBCInput_15.wasNull()) {
							row14.datacenter_id = null;
						}
					}
					column_index_tJDBCInput_15 = 3;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.datacenter_join_id = null;
					} else {

						tmpContent_tJDBCInput_15 = rs_tJDBCInput_15
								.getString(column_index_tJDBCInput_15);
						if (tmpContent_tJDBCInput_15 != null) {
							row14.datacenter_join_id = tmpContent_tJDBCInput_15;
						} else {
							row14.datacenter_join_id = null;
						}

						if (rs_tJDBCInput_15.wasNull()) {
							row14.datacenter_join_id = null;
						}
					}
					column_index_tJDBCInput_15 = 4;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.datacenter_name = null;
					} else {

						tmpContent_tJDBCInput_15 = rs_tJDBCInput_15
								.getString(column_index_tJDBCInput_15);
						if (tmpContent_tJDBCInput_15 != null) {
							row14.datacenter_name = tmpContent_tJDBCInput_15;
						} else {
							row14.datacenter_name = null;
						}

						if (rs_tJDBCInput_15.wasNull()) {
							row14.datacenter_name = null;
						}
					}
					column_index_tJDBCInput_15 = 5;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.datacenter_description = null;
					} else {

						tmpContent_tJDBCInput_15 = rs_tJDBCInput_15
								.getString(column_index_tJDBCInput_15);
						if (tmpContent_tJDBCInput_15 != null) {
							row14.datacenter_description = tmpContent_tJDBCInput_15;
						} else {
							row14.datacenter_description = null;
						}

						if (rs_tJDBCInput_15.wasNull()) {
							row14.datacenter_description = null;
						}
					}
					column_index_tJDBCInput_15 = 6;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.storage_type = null;
					} else {

						if (rs_tJDBCInput_15
								.getObject(column_index_tJDBCInput_15) != null) {
							row14.storage_type = rs_tJDBCInput_15
									.getShort(column_index_tJDBCInput_15);
						} else {
							row14.storage_type = null;
						}

						if (rs_tJDBCInput_15.wasNull()) {
							row14.storage_type = null;
						}
					}
					column_index_tJDBCInput_15 = 7;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_15 = null;
						try {
							date_tJDBCInput_15 = rs_tJDBCInput_15
									.getTimestamp(column_index_tJDBCInput_15);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_15 = rs_tJDBCInput_15
									.getDate(column_index_tJDBCInput_15);
						}
						row14.create_date = date_tJDBCInput_15;

						if (rs_tJDBCInput_15.wasNull()) {
							row14.create_date = null;
						}
					}
					column_index_tJDBCInput_15 = 8;

					if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
						row14.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_15 = null;
						try {
							date_tJDBCInput_15 = rs_tJDBCInput_15
									.getTimestamp(column_index_tJDBCInput_15);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_15 = rs_tJDBCInput_15
									.getDate(column_index_tJDBCInput_15);
						}
						row14.update_date = date_tJDBCInput_15;

						if (rs_tJDBCInput_15.wasNull()) {
							row14.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_15 begin ] stop
					 */
					/**
					 * [tJDBCInput_15 main ] start
					 */

					currentComponent = "tJDBCInput_15";

					tos_count_tJDBCInput_15++;

					/**
					 * [tJDBCInput_15 main ] stop
					 */

					/**
					 * [tMap_14 main ] start
					 */

					currentComponent = "tMap_14";

					boolean hasCasePrimitiveKeyWithNull_tMap_14 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_14 = false;
					boolean mainRowRejected_tMap_14 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row15"
					// /////////////////////////////////////////////

					boolean forceLooprow15 = false;

					row15Struct row15ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_14) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_14 = false;

						row15HashKey.datacenter_join_id = row14.datacenter_join_id;

						row15HashKey.hashCodeDirty = true;

						tHash_Lookup_row15.lookup(row15HashKey);

						if (!tHash_Lookup_row15.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_14 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row15 != null
							&& tHash_Lookup_row15.getCount(row15HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row15' and it contains more one result from keys :  row15.datacenter_join_id = '"
						// + row15HashKey.datacenter_join_id + "'");
					} // G 071

					row15Struct row15 = null;

					row15Struct fromLookup_row15 = null;
					row15 = row15Default;

					if (tHash_Lookup_row15 != null
							&& tHash_Lookup_row15.hasNext()) { // G 099

						fromLookup_row15 = tHash_Lookup_row15.next();

					} // G 099

					if (fromLookup_row15 != null) {
						row15 = fromLookup_row15;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_14__Struct Var = Var__tMap_14;// ###############################
						// ###############################
						// # Output tables

						delete_datacenters = null;

						if (!rejectedInnerJoin_tMap_14) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_datacenters'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_14) {
							delete_datacenters_tmp.datacenter_id = row14.datacenter_id;
							delete_datacenters_tmp.datacenter_name = row14.datacenter_name;
							delete_datacenters_tmp.datacenter_description = row14.datacenter_description;
							delete_datacenters_tmp.storage_type = row14.storage_type;
							delete_datacenters_tmp.create_date = row14.create_date;
							delete_datacenters_tmp.update_date = context.runTime;
							delete_datacenters_tmp.delete_date = context.runTime;
							delete_datacenters = delete_datacenters_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_14 = false;

					tos_count_tMap_14++;

					/**
					 * [tMap_14 main ] stop
					 */
					// Start of branch "delete_datacenters"
					if (delete_datacenters != null) {

						/**
						 * [tJDBCOutput_14 main ] start
						 */

						currentComponent = "tJDBCOutput_14";

						whetherReject_tJDBCOutput_14 = false;
						if (delete_datacenters.datacenter_id == null) {
							pstmt_tJDBCOutput_14.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_14.setObject(1,
									delete_datacenters.datacenter_id);
						}

						if (delete_datacenters.datacenter_name == null) {
							pstmt_tJDBCOutput_14.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_14.setString(2,
									delete_datacenters.datacenter_name);
						}

						if (delete_datacenters.datacenter_description == null) {
							pstmt_tJDBCOutput_14.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_14.setString(3,
									delete_datacenters.datacenter_description);
						}

						pstmt_tJDBCOutput_14.setShort(4,
								delete_datacenters.storage_type);

						if (delete_datacenters.create_date != null) {
							pstmt_tJDBCOutput_14.setTimestamp(
									5,
									new java.sql.Timestamp(
											delete_datacenters.create_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_14
									.setNull(5, java.sql.Types.DATE);
						}

						if (delete_datacenters.update_date != null) {
							pstmt_tJDBCOutput_14.setTimestamp(
									6,
									new java.sql.Timestamp(
											delete_datacenters.update_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_14
									.setNull(6, java.sql.Types.DATE);
						}

						if (delete_datacenters.delete_date != null) {
							pstmt_tJDBCOutput_14.setTimestamp(
									7,
									new java.sql.Timestamp(
											delete_datacenters.delete_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_14
									.setNull(7, java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_14 = insertedCount_tJDBCOutput_14
									+ pstmt_tJDBCOutput_14.executeUpdate();
							nb_line_tJDBCOutput_14++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_14 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_14++;

						/**
						 * [tJDBCOutput_14 main ] stop
						 */

					} // End of branch "delete_datacenters"

					/**
					 * [tJDBCInput_15 end ] start
					 */

					currentComponent = "tJDBCInput_15";

				}
				rs_tJDBCInput_15.close();
				stmt_tJDBCInput_15.close();

				globalMap.put("tJDBCInput_15_NB_LINE", nb_line_tJDBCInput_15);

				ok_Hash.put("tJDBCInput_15", true);
				end_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				/**
				 * [tJDBCInput_15 end ] stop
				 */

				/**
				 * [tMap_14 end ] start
				 */

				currentComponent = "tMap_14";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row15 != null) {
					tHash_Lookup_row15.endGet();
				}
				globalMap.remove("tHash_Lookup_row15");

				// ###############################

				ok_Hash.put("tMap_14", true);
				end_Hash.put("tMap_14", System.currentTimeMillis());

				/**
				 * [tMap_14 end ] stop
				 */

				/**
				 * [tJDBCOutput_14 end ] start
				 */

				currentComponent = "tJDBCOutput_14";

				if (pstmt_tJDBCOutput_14 != null) {

					pstmt_tJDBCOutput_14.close();

				}

				nb_line_deleted_tJDBCOutput_14 = nb_line_deleted_tJDBCOutput_14
						+ deletedCount_tJDBCOutput_14;
				nb_line_update_tJDBCOutput_14 = nb_line_update_tJDBCOutput_14
						+ updatedCount_tJDBCOutput_14;
				nb_line_inserted_tJDBCOutput_14 = nb_line_inserted_tJDBCOutput_14
						+ insertedCount_tJDBCOutput_14;
				nb_line_rejected_tJDBCOutput_14 = nb_line_rejected_tJDBCOutput_14
						+ rejectedCount_tJDBCOutput_14;

				globalMap.put("tJDBCOutput_14_NB_LINE", nb_line_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_14);

				ok_Hash.put("tJDBCOutput_14", true);
				end_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_14 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_15:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_1Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_14"
			globalMap.remove("tHash_Lookup_row15");

		}

		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 1);
	}

	public static class cluster_configurationStruct implements
			routines.system.IPersistableRow<cluster_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(cluster_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_1Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_39Process(globalMap);

				row1Struct row1 = new row1Struct();
				cluster_configurationStruct cluster_configuration = new cluster_configurationStruct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_1) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_1 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_1 = dataSources_tJDBCOutput_1
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_1 = 10000;
				int batchSizeCounter_tJDBCOutput_1 = 0;

				String insert_tJDBCOutput_1 = "INSERT INTO "
						+ "cluster_configuration"
						+ " (cluster_id,cluster_name,cluster_description,datacenter_id,cpu_name,compatibility_version,datacenter_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(insert_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tMap_1 begin ] start
				 */

				ok_Hash.put("tMap_1", false);
				start_Hash.put("tMap_1", System.currentTimeMillis());
				currentComponent = "tMap_1";

				int tos_count_tMap_1 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row35Struct> tHash_Lookup_row35 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row35Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row35Struct>) globalMap
						.get("tHash_Lookup_row35"));

				row35Struct row35HashKey = new row35Struct();
				row35Struct row35Default = new row35Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_1__Struct {
				}
				Var__tMap_1__Struct Var__tMap_1 = new Var__tMap_1__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				cluster_configurationStruct cluster_configuration_tmp = new cluster_configurationStruct();
				// ###############################

				/**
				 * [tMap_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());
				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_1) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_1 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_1 = dataSources_tJDBCInput_1.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_1);
				}

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "SELECT     cluster_id,     cluster_name,     cluster_description,     datacenter_id,     upper(cast(datacenter_id as char(36))) as datacenter_join_id,    cpu_name,     compatibility_version,     create_date,     update_date  FROM dwh_cluster_configuration_history_view";

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);

				java.sql.ResultSet rs_tJDBCInput_1 = stmt_tJDBCInput_1
						.executeQuery(dbquery_tJDBCInput_1);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
						.getMetaData();
				int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
						.getColumnCount();

				String tmpContent_tJDBCInput_1 = null;
				int column_index_tJDBCInput_1 = 1;
				while (rs_tJDBCInput_1.next()) {
					nb_line_tJDBCInput_1++;

					column_index_tJDBCInput_1 = 1;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.cluster_id = null;
					} else {

						if (rs_tJDBCInput_1
								.getObject(column_index_tJDBCInput_1) != null) {
							row1.cluster_id = rs_tJDBCInput_1
									.getObject(column_index_tJDBCInput_1);
						} else {
							row1.cluster_id = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.cluster_id = null;
						}
					}
					column_index_tJDBCInput_1 = 2;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.cluster_name = null;
					} else {

						tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
								.getString(column_index_tJDBCInput_1);
						if (tmpContent_tJDBCInput_1 != null) {
							row1.cluster_name = tmpContent_tJDBCInput_1;
						} else {
							row1.cluster_name = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.cluster_name = null;
						}
					}
					column_index_tJDBCInput_1 = 3;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.cluster_description = null;
					} else {

						tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
								.getString(column_index_tJDBCInput_1);
						if (tmpContent_tJDBCInput_1 != null) {
							row1.cluster_description = tmpContent_tJDBCInput_1;
						} else {
							row1.cluster_description = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.cluster_description = null;
						}
					}
					column_index_tJDBCInput_1 = 4;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.datacenter_id = null;
					} else {

						if (rs_tJDBCInput_1
								.getObject(column_index_tJDBCInput_1) != null) {
							row1.datacenter_id = rs_tJDBCInput_1
									.getObject(column_index_tJDBCInput_1);
						} else {
							row1.datacenter_id = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.datacenter_id = null;
						}
					}
					column_index_tJDBCInput_1 = 5;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.datacenter_join_id = null;
					} else {

						tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
								.getString(column_index_tJDBCInput_1);
						if (tmpContent_tJDBCInput_1 != null) {
							row1.datacenter_join_id = tmpContent_tJDBCInput_1;
						} else {
							row1.datacenter_join_id = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.datacenter_join_id = null;
						}
					}
					column_index_tJDBCInput_1 = 6;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.cpu_name = null;
					} else {

						tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
								.getString(column_index_tJDBCInput_1);
						if (tmpContent_tJDBCInput_1 != null) {
							row1.cpu_name = tmpContent_tJDBCInput_1;
						} else {
							row1.cpu_name = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.cpu_name = null;
						}
					}
					column_index_tJDBCInput_1 = 7;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.compatibility_version = null;
					} else {

						tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
								.getString(column_index_tJDBCInput_1);
						if (tmpContent_tJDBCInput_1 != null) {
							row1.compatibility_version = tmpContent_tJDBCInput_1;
						} else {
							row1.compatibility_version = null;
						}

						if (rs_tJDBCInput_1.wasNull()) {
							row1.compatibility_version = null;
						}
					}
					column_index_tJDBCInput_1 = 8;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_1 = null;
						try {
							date_tJDBCInput_1 = rs_tJDBCInput_1
									.getTimestamp(column_index_tJDBCInput_1);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_1 = rs_tJDBCInput_1
									.getDate(column_index_tJDBCInput_1);
						}
						row1.create_date = date_tJDBCInput_1;

						if (rs_tJDBCInput_1.wasNull()) {
							row1.create_date = null;
						}
					}
					column_index_tJDBCInput_1 = 9;

					if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
						row1.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_1 = null;
						try {
							date_tJDBCInput_1 = rs_tJDBCInput_1
									.getTimestamp(column_index_tJDBCInput_1);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_1 = rs_tJDBCInput_1
									.getDate(column_index_tJDBCInput_1);
						}
						row1.update_date = date_tJDBCInput_1;

						if (rs_tJDBCInput_1.wasNull()) {
							row1.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_1 begin ] stop
					 */
					/**
					 * [tJDBCInput_1 main ] start
					 */

					currentComponent = "tJDBCInput_1";

					tos_count_tJDBCInput_1++;

					/**
					 * [tJDBCInput_1 main ] stop
					 */

					/**
					 * [tMap_1 main ] start
					 */

					currentComponent = "tMap_1";

					boolean hasCasePrimitiveKeyWithNull_tMap_1 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_1 = false;
					boolean mainRowRejected_tMap_1 = false;

					if (

					(

					row1.update_date == null ? TalendDate.compareDate(
							row1.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row1.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row1'

						// /////////////////////////////////////////////
						// Starting Lookup Table "row35"
						// /////////////////////////////////////////////

						boolean forceLooprow35 = false;

						row35Struct row35ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_1) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_1 = false;

							row35HashKey.datacenter_join_id = row1.datacenter_join_id;

							row35HashKey.hashCodeDirty = true;

							tHash_Lookup_row35.lookup(row35HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row35 != null
								&& tHash_Lookup_row35.getCount(row35HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row35' and it contains more one result from keys :  row35.datacenter_join_id = '"
							// + row35HashKey.datacenter_join_id + "'");
						} // G 071

						row35Struct row35 = null;

						row35Struct fromLookup_row35 = null;
						row35 = row35Default;

						if (tHash_Lookup_row35 != null
								&& tHash_Lookup_row35.hasNext()) { // G 099

							fromLookup_row35 = tHash_Lookup_row35.next();

						} // G 099

						if (fromLookup_row35 != null) {
							row35 = fromLookup_row35;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_1__Struct Var = Var__tMap_1;// ###############################
							// ###############################
							// # Output tables

							cluster_configuration = null;

							// # Output table : 'cluster_configuration'
							cluster_configuration_tmp.cluster_id = row1.cluster_id;
							cluster_configuration_tmp.cluster_name = StringHandling
									.TRIM(row1.cluster_name);
							cluster_configuration_tmp.cluster_description = StringHandling
									.TRIM(row1.cluster_description);
							cluster_configuration_tmp.datacenter_id = row1.datacenter_id;
							cluster_configuration_tmp.cpu_name = StringHandling
									.TRIM(row1.cpu_name);
							cluster_configuration_tmp.compatibility_version = StringHandling
									.TRIM(row1.compatibility_version);
							cluster_configuration_tmp.datacenter_configuration_version = row35.history_id;
							cluster_configuration_tmp.create_date = row1.create_date;
							cluster_configuration_tmp.update_date = row1.update_date;
							cluster_configuration_tmp.delete_date = null;
							cluster_configuration = cluster_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_1 = false;

						tos_count_tMap_1++;

						/**
						 * [tMap_1 main ] stop
						 */
						// Start of branch "cluster_configuration"
						if (cluster_configuration != null) {

							/**
							 * [tJDBCOutput_1 main ] start
							 */

							currentComponent = "tJDBCOutput_1";

							whetherReject_tJDBCOutput_1 = false;
							if (cluster_configuration.cluster_id == null) {
								pstmt_tJDBCOutput_1.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_1.setObject(1,
										cluster_configuration.cluster_id);
							}

							if (cluster_configuration.cluster_name == null) {
								pstmt_tJDBCOutput_1.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(2,
										cluster_configuration.cluster_name);
							}

							if (cluster_configuration.cluster_description == null) {
								pstmt_tJDBCOutput_1.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1
										.setString(
												3,
												cluster_configuration.cluster_description);
							}

							if (cluster_configuration.datacenter_id == null) {
								pstmt_tJDBCOutput_1.setNull(4,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_1.setObject(4,
										cluster_configuration.datacenter_id);
							}

							if (cluster_configuration.cpu_name == null) {
								pstmt_tJDBCOutput_1.setNull(5,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(5,
										cluster_configuration.cpu_name);
							}

							if (cluster_configuration.compatibility_version == null) {
								pstmt_tJDBCOutput_1.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1
										.setString(
												6,
												cluster_configuration.compatibility_version);
							}

							if (cluster_configuration.datacenter_configuration_version == null) {
								pstmt_tJDBCOutput_1.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1
										.setInt(7,
												cluster_configuration.datacenter_configuration_version);
							}

							if (cluster_configuration.create_date != null) {
								pstmt_tJDBCOutput_1
										.setTimestamp(
												8,
												new java.sql.Timestamp(
														cluster_configuration.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_1.setNull(8,
										java.sql.Types.DATE);
							}

							if (cluster_configuration.update_date != null) {
								pstmt_tJDBCOutput_1
										.setTimestamp(
												9,
												new java.sql.Timestamp(
														cluster_configuration.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_1.setNull(9,
										java.sql.Types.DATE);
							}

							if (cluster_configuration.delete_date != null) {
								pstmt_tJDBCOutput_1
										.setTimestamp(
												10,
												new java.sql.Timestamp(
														cluster_configuration.delete_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_1.setNull(10,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_1 = insertedCount_tJDBCOutput_1
										+ pstmt_tJDBCOutput_1.executeUpdate();
								nb_line_tJDBCOutput_1++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_1 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_1++;

							/**
							 * [tJDBCOutput_1 main ] stop
							 */

						} // End of branch "cluster_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row1'

					/**
					 * [tJDBCInput_1 end ] start
					 */

					currentComponent = "tJDBCInput_1";

				}
				rs_tJDBCInput_1.close();
				stmt_tJDBCInput_1.close();

				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tMap_1 end ] start
				 */

				currentComponent = "tMap_1";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row35 != null) {
					tHash_Lookup_row35.endGet();
				}
				globalMap.remove("tHash_Lookup_row35");

				// ###############################

				ok_Hash.put("tMap_1", true);
				end_Hash.put("tMap_1", System.currentTimeMillis());

				/**
				 * [tMap_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_18Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_1"
			globalMap.remove("tHash_Lookup_row35");

		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public static class delete_clusterStruct implements
			routines.system.IPersistableRow<delete_clusterStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_clusterStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row17Struct implements
			routines.system.IPersistableRow<row17Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row17Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_18Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_18Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_18Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_18Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_17Process(globalMap);

				row17Struct row17 = new row17Struct();
				delete_clusterStruct delete_cluster = new delete_clusterStruct();

				/**
				 * [tJDBCOutput_15 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_15", false);
				start_Hash.put("tJDBCOutput_15", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_15";

				int tos_count_tJDBCOutput_15 = 0;

				int nb_line_tJDBCOutput_15 = 0;
				int nb_line_update_tJDBCOutput_15 = 0;
				int nb_line_inserted_tJDBCOutput_15 = 0;
				int nb_line_deleted_tJDBCOutput_15 = 0;
				int nb_line_rejected_tJDBCOutput_15 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_15 = 0;

				int deletedCount_tJDBCOutput_15 = 0;
				int updatedCount_tJDBCOutput_15 = 0;
				int insertedCount_tJDBCOutput_15 = 0;
				int rejectedCount_tJDBCOutput_15 = 0;

				boolean whetherReject_tJDBCOutput_15 = false;

				java.sql.Connection connection_tJDBCOutput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_15) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_15 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_15 = dataSources_tJDBCOutput_15.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_15 = 10000;
				int batchSizeCounter_tJDBCOutput_15 = 0;

				String insert_tJDBCOutput_15 = "INSERT INTO "
						+ "cluster_configuration"
						+ " (cluster_id,cluster_name,cluster_description,datacenter_id,cpu_name,compatibility_version,datacenter_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_15 = connection_tJDBCOutput_15
						.prepareStatement(insert_tJDBCOutput_15);

				/**
				 * [tJDBCOutput_15 begin ] stop
				 */

				/**
				 * [tMap_15 begin ] start
				 */

				ok_Hash.put("tMap_15", false);
				start_Hash.put("tMap_15", System.currentTimeMillis());
				currentComponent = "tMap_15";

				int tos_count_tMap_15 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row16Struct> tHash_Lookup_row16 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row16Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row16Struct>) globalMap
						.get("tHash_Lookup_row16"));

				row16Struct row16HashKey = new row16Struct();
				row16Struct row16Default = new row16Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_15__Struct {
				}
				Var__tMap_15__Struct Var__tMap_15 = new Var__tMap_15__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_clusterStruct delete_cluster_tmp = new delete_clusterStruct();
				// ###############################

				/**
				 * [tMap_15 begin ] stop
				 */

				/**
				 * [tJDBCInput_18 begin ] start
				 */

				ok_Hash.put("tJDBCInput_18", false);
				start_Hash.put("tJDBCInput_18", System.currentTimeMillis());
				currentComponent = "tJDBCInput_18";

				int tos_count_tJDBCInput_18 = 0;

				int nb_line_tJDBCInput_18 = 0;
				java.sql.Connection conn_tJDBCInput_18 = null;
				conn_tJDBCInput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_18) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_18 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_18 = dataSources_tJDBCInput_18.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_18);
				}

				java.sql.Statement stmt_tJDBCInput_18 = conn_tJDBCInput_18
						.createStatement();

				String dbquery_tJDBCInput_18 = "SELECT history_id,    		cluster_id,     		upper(cast(cluster_id as char(36))) as cluster_join_id,   		cluster_name,    		cluster_description,    		datacenter_id,    		cpu_name,    		compatibility_version,    		datacenter_configuration_version,    		create_date,    		update_date FROM v3_3_latest_configuration_clusters";

				globalMap.put("tJDBCInput_18_QUERY", dbquery_tJDBCInput_18);

				java.sql.ResultSet rs_tJDBCInput_18 = stmt_tJDBCInput_18
						.executeQuery(dbquery_tJDBCInput_18);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_18 = rs_tJDBCInput_18
						.getMetaData();
				int colQtyInRs_tJDBCInput_18 = rsmd_tJDBCInput_18
						.getColumnCount();

				String tmpContent_tJDBCInput_18 = null;
				int column_index_tJDBCInput_18 = 1;
				while (rs_tJDBCInput_18.next()) {
					nb_line_tJDBCInput_18++;

					column_index_tJDBCInput_18 = 1;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.history_id = null;
					} else {

						if (rs_tJDBCInput_18
								.getObject(column_index_tJDBCInput_18) != null) {
							row17.history_id = rs_tJDBCInput_18
									.getInt(column_index_tJDBCInput_18);
						} else {
							row17.history_id = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.history_id = null;
						}
					}
					column_index_tJDBCInput_18 = 2;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.cluster_id = null;
					} else {

						if (rs_tJDBCInput_18
								.getObject(column_index_tJDBCInput_18) != null) {
							row17.cluster_id = rs_tJDBCInput_18
									.getObject(column_index_tJDBCInput_18);
						} else {
							row17.cluster_id = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.cluster_id = null;
						}
					}
					column_index_tJDBCInput_18 = 3;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.cluster_join_id = null;
					} else {

						tmpContent_tJDBCInput_18 = rs_tJDBCInput_18
								.getString(column_index_tJDBCInput_18);
						if (tmpContent_tJDBCInput_18 != null) {
							row17.cluster_join_id = tmpContent_tJDBCInput_18;
						} else {
							row17.cluster_join_id = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.cluster_join_id = null;
						}
					}
					column_index_tJDBCInput_18 = 4;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.cluster_name = null;
					} else {

						tmpContent_tJDBCInput_18 = rs_tJDBCInput_18
								.getString(column_index_tJDBCInput_18);
						if (tmpContent_tJDBCInput_18 != null) {
							row17.cluster_name = tmpContent_tJDBCInput_18;
						} else {
							row17.cluster_name = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.cluster_name = null;
						}
					}
					column_index_tJDBCInput_18 = 5;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.cluster_description = null;
					} else {

						tmpContent_tJDBCInput_18 = rs_tJDBCInput_18
								.getString(column_index_tJDBCInput_18);
						if (tmpContent_tJDBCInput_18 != null) {
							row17.cluster_description = tmpContent_tJDBCInput_18;
						} else {
							row17.cluster_description = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.cluster_description = null;
						}
					}
					column_index_tJDBCInput_18 = 6;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.datacenter_id = null;
					} else {

						if (rs_tJDBCInput_18
								.getObject(column_index_tJDBCInput_18) != null) {
							row17.datacenter_id = rs_tJDBCInput_18
									.getObject(column_index_tJDBCInput_18);
						} else {
							row17.datacenter_id = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.datacenter_id = null;
						}
					}
					column_index_tJDBCInput_18 = 7;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.cpu_name = null;
					} else {

						tmpContent_tJDBCInput_18 = rs_tJDBCInput_18
								.getString(column_index_tJDBCInput_18);
						if (tmpContent_tJDBCInput_18 != null) {
							row17.cpu_name = tmpContent_tJDBCInput_18;
						} else {
							row17.cpu_name = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.cpu_name = null;
						}
					}
					column_index_tJDBCInput_18 = 8;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.compatibility_version = null;
					} else {

						tmpContent_tJDBCInput_18 = rs_tJDBCInput_18
								.getString(column_index_tJDBCInput_18);
						if (tmpContent_tJDBCInput_18 != null) {
							row17.compatibility_version = tmpContent_tJDBCInput_18;
						} else {
							row17.compatibility_version = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.compatibility_version = null;
						}
					}
					column_index_tJDBCInput_18 = 9;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.datacenter_configuration_version = null;
					} else {

						if (rs_tJDBCInput_18
								.getObject(column_index_tJDBCInput_18) != null) {
							row17.datacenter_configuration_version = rs_tJDBCInput_18
									.getInt(column_index_tJDBCInput_18);
						} else {
							row17.datacenter_configuration_version = null;
						}

						if (rs_tJDBCInput_18.wasNull()) {
							row17.datacenter_configuration_version = null;
						}
					}
					column_index_tJDBCInput_18 = 10;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_18 = null;
						try {
							date_tJDBCInput_18 = rs_tJDBCInput_18
									.getTimestamp(column_index_tJDBCInput_18);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_18 = rs_tJDBCInput_18
									.getDate(column_index_tJDBCInput_18);
						}
						row17.create_date = date_tJDBCInput_18;

						if (rs_tJDBCInput_18.wasNull()) {
							row17.create_date = null;
						}
					}
					column_index_tJDBCInput_18 = 11;

					if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
						row17.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_18 = null;
						try {
							date_tJDBCInput_18 = rs_tJDBCInput_18
									.getTimestamp(column_index_tJDBCInput_18);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_18 = rs_tJDBCInput_18
									.getDate(column_index_tJDBCInput_18);
						}
						row17.update_date = date_tJDBCInput_18;

						if (rs_tJDBCInput_18.wasNull()) {
							row17.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_18 begin ] stop
					 */
					/**
					 * [tJDBCInput_18 main ] start
					 */

					currentComponent = "tJDBCInput_18";

					tos_count_tJDBCInput_18++;

					/**
					 * [tJDBCInput_18 main ] stop
					 */

					/**
					 * [tMap_15 main ] start
					 */

					currentComponent = "tMap_15";

					boolean hasCasePrimitiveKeyWithNull_tMap_15 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_15 = false;
					boolean mainRowRejected_tMap_15 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row16"
					// /////////////////////////////////////////////

					boolean forceLooprow16 = false;

					row16Struct row16ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_15) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_15 = false;

						row16HashKey.cluster_join_id = row17.cluster_join_id;

						row16HashKey.hashCodeDirty = true;

						tHash_Lookup_row16.lookup(row16HashKey);

						if (!tHash_Lookup_row16.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_15 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row16 != null
							&& tHash_Lookup_row16.getCount(row16HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row16' and it contains more one result from keys :  row16.cluster_join_id = '"
						// + row16HashKey.cluster_join_id + "'");
					} // G 071

					row16Struct row16 = null;

					row16Struct fromLookup_row16 = null;
					row16 = row16Default;

					if (tHash_Lookup_row16 != null
							&& tHash_Lookup_row16.hasNext()) { // G 099

						fromLookup_row16 = tHash_Lookup_row16.next();

					} // G 099

					if (fromLookup_row16 != null) {
						row16 = fromLookup_row16;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_15__Struct Var = Var__tMap_15;// ###############################
						// ###############################
						// # Output tables

						delete_cluster = null;

						if (!rejectedInnerJoin_tMap_15) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_cluster'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_15) {
							delete_cluster_tmp.cluster_id = row17.cluster_id;
							delete_cluster_tmp.cluster_name = row17.cluster_name;
							delete_cluster_tmp.cluster_description = row17.cluster_description;
							delete_cluster_tmp.datacenter_id = row17.datacenter_id;
							delete_cluster_tmp.cpu_name = row17.cpu_name;
							delete_cluster_tmp.compatibility_version = row17.compatibility_version;
							delete_cluster_tmp.datacenter_configuration_version = row17.datacenter_configuration_version;
							delete_cluster_tmp.create_date = row17.create_date;
							delete_cluster_tmp.update_date = context.runTime;
							delete_cluster_tmp.delete_date = context.runTime;
							delete_cluster = delete_cluster_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_15 = false;

					tos_count_tMap_15++;

					/**
					 * [tMap_15 main ] stop
					 */
					// Start of branch "delete_cluster"
					if (delete_cluster != null) {

						/**
						 * [tJDBCOutput_15 main ] start
						 */

						currentComponent = "tJDBCOutput_15";

						whetherReject_tJDBCOutput_15 = false;
						if (delete_cluster.cluster_id == null) {
							pstmt_tJDBCOutput_15.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_15.setObject(1,
									delete_cluster.cluster_id);
						}

						if (delete_cluster.cluster_name == null) {
							pstmt_tJDBCOutput_15.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_15.setString(2,
									delete_cluster.cluster_name);
						}

						if (delete_cluster.cluster_description == null) {
							pstmt_tJDBCOutput_15.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_15.setString(3,
									delete_cluster.cluster_description);
						}

						if (delete_cluster.datacenter_id == null) {
							pstmt_tJDBCOutput_15.setNull(4,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_15.setObject(4,
									delete_cluster.datacenter_id);
						}

						if (delete_cluster.cpu_name == null) {
							pstmt_tJDBCOutput_15.setNull(5,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_15.setString(5,
									delete_cluster.cpu_name);
						}

						if (delete_cluster.compatibility_version == null) {
							pstmt_tJDBCOutput_15.setNull(6,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_15.setString(6,
									delete_cluster.compatibility_version);
						}

						if (delete_cluster.datacenter_configuration_version == null) {
							pstmt_tJDBCOutput_15.setNull(7,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_15
									.setInt(7,
											delete_cluster.datacenter_configuration_version);
						}

						if (delete_cluster.create_date != null) {
							pstmt_tJDBCOutput_15.setTimestamp(
									8,
									new java.sql.Timestamp(
											delete_cluster.create_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_15
									.setNull(8, java.sql.Types.DATE);
						}

						if (delete_cluster.update_date != null) {
							pstmt_tJDBCOutput_15.setTimestamp(
									9,
									new java.sql.Timestamp(
											delete_cluster.update_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_15
									.setNull(9, java.sql.Types.DATE);
						}

						if (delete_cluster.delete_date != null) {
							pstmt_tJDBCOutput_15.setTimestamp(
									10,
									new java.sql.Timestamp(
											delete_cluster.delete_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_15.setNull(10,
									java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_15 = insertedCount_tJDBCOutput_15
									+ pstmt_tJDBCOutput_15.executeUpdate();
							nb_line_tJDBCOutput_15++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_15 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_15++;

						/**
						 * [tJDBCOutput_15 main ] stop
						 */

					} // End of branch "delete_cluster"

					/**
					 * [tJDBCInput_18 end ] start
					 */

					currentComponent = "tJDBCInput_18";

				}
				rs_tJDBCInput_18.close();
				stmt_tJDBCInput_18.close();

				globalMap.put("tJDBCInput_18_NB_LINE", nb_line_tJDBCInput_18);

				ok_Hash.put("tJDBCInput_18", true);
				end_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				/**
				 * [tJDBCInput_18 end ] stop
				 */

				/**
				 * [tMap_15 end ] start
				 */

				currentComponent = "tMap_15";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row16 != null) {
					tHash_Lookup_row16.endGet();
				}
				globalMap.remove("tHash_Lookup_row16");

				// ###############################

				ok_Hash.put("tMap_15", true);
				end_Hash.put("tMap_15", System.currentTimeMillis());

				/**
				 * [tMap_15 end ] stop
				 */

				/**
				 * [tJDBCOutput_15 end ] start
				 */

				currentComponent = "tJDBCOutput_15";

				if (pstmt_tJDBCOutput_15 != null) {

					pstmt_tJDBCOutput_15.close();

				}

				nb_line_deleted_tJDBCOutput_15 = nb_line_deleted_tJDBCOutput_15
						+ deletedCount_tJDBCOutput_15;
				nb_line_update_tJDBCOutput_15 = nb_line_update_tJDBCOutput_15
						+ updatedCount_tJDBCOutput_15;
				nb_line_inserted_tJDBCOutput_15 = nb_line_inserted_tJDBCOutput_15
						+ insertedCount_tJDBCOutput_15;
				nb_line_rejected_tJDBCOutput_15 = nb_line_rejected_tJDBCOutput_15
						+ rejectedCount_tJDBCOutput_15;

				globalMap.put("tJDBCOutput_15_NB_LINE", nb_line_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_15);

				ok_Hash.put("tJDBCOutput_15", true);
				end_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_15 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_18:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_3Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_15"
			globalMap.remove("tHash_Lookup_row16");

		}

		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 1);
	}

	public static class storage_configurationStruct implements
			routines.system.IPersistableRow<storage_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public short storage_domain_type;

		public short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public short storage_type;

		public short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_name = readString(dis);

					this.storage_domain_type = dis.readShort();

					this.storage_type = dis.readShort();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_name, dos);

				// short

				dos.writeShort(this.storage_domain_type);

				// short

				dos.writeShort(this.storage_type);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(storage_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row5Struct implements
			routines.system.IPersistableRow<row5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public Short storage_domain_type;

		public Short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_type = null;
					} else {
						this.storage_domain_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_name, dos);

				// Short

				if (this.storage_domain_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_type);
				}

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row5Struct row5 = new row5Struct();
				storage_configurationStruct storage_configuration = new storage_configurationStruct();

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_3) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_3 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_3 = dataSources_tJDBCOutput_3
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_3 = 10000;
				int batchSizeCounter_tJDBCOutput_3 = 0;

				String insert_tJDBCOutput_3 = "INSERT INTO "
						+ "storage_domain_configuration"
						+ " (storage_domain_id,storage_domain_name,storage_domain_type,storage_type,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(insert_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());
				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				storage_configurationStruct storage_configuration_tmp = new storage_configurationStruct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());
				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_3) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_3 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_3 = dataSources_tJDBCInput_3.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_3);
				}

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT    storage_domain_id,    storage_domain_name,    storage_domain_type,    storage_type,    create_date,    update_date FROM dwh_storage_domain_configuration_history_view";

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);

				java.sql.ResultSet rs_tJDBCInput_3 = stmt_tJDBCInput_3
						.executeQuery(dbquery_tJDBCInput_3);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
						.getMetaData();
				int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
						.getColumnCount();

				String tmpContent_tJDBCInput_3 = null;
				int column_index_tJDBCInput_3 = 1;
				while (rs_tJDBCInput_3.next()) {
					nb_line_tJDBCInput_3++;

					column_index_tJDBCInput_3 = 1;

					if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
						row5.storage_domain_id = null;
					} else {

						if (rs_tJDBCInput_3
								.getObject(column_index_tJDBCInput_3) != null) {
							row5.storage_domain_id = rs_tJDBCInput_3
									.getObject(column_index_tJDBCInput_3);
						} else {
							row5.storage_domain_id = null;
						}

						if (rs_tJDBCInput_3.wasNull()) {
							row5.storage_domain_id = null;
						}
					}
					column_index_tJDBCInput_3 = 2;

					if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
						row5.storage_domain_name = null;
					} else {

						tmpContent_tJDBCInput_3 = rs_tJDBCInput_3
								.getString(column_index_tJDBCInput_3);
						if (tmpContent_tJDBCInput_3 != null) {
							row5.storage_domain_name = tmpContent_tJDBCInput_3;
						} else {
							row5.storage_domain_name = null;
						}

						if (rs_tJDBCInput_3.wasNull()) {
							row5.storage_domain_name = null;
						}
					}
					column_index_tJDBCInput_3 = 3;

					if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
						row5.storage_domain_type = null;
					} else {

						if (rs_tJDBCInput_3
								.getObject(column_index_tJDBCInput_3) != null) {
							row5.storage_domain_type = rs_tJDBCInput_3
									.getShort(column_index_tJDBCInput_3);
						} else {
							row5.storage_domain_type = null;
						}

						if (rs_tJDBCInput_3.wasNull()) {
							row5.storage_domain_type = null;
						}
					}
					column_index_tJDBCInput_3 = 4;

					if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
						row5.storage_type = null;
					} else {

						if (rs_tJDBCInput_3
								.getObject(column_index_tJDBCInput_3) != null) {
							row5.storage_type = rs_tJDBCInput_3
									.getShort(column_index_tJDBCInput_3);
						} else {
							row5.storage_type = null;
						}

						if (rs_tJDBCInput_3.wasNull()) {
							row5.storage_type = null;
						}
					}
					column_index_tJDBCInput_3 = 5;

					if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
						row5.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_3 = null;
						try {
							date_tJDBCInput_3 = rs_tJDBCInput_3
									.getTimestamp(column_index_tJDBCInput_3);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_3 = rs_tJDBCInput_3
									.getDate(column_index_tJDBCInput_3);
						}
						row5.create_date = date_tJDBCInput_3;

						if (rs_tJDBCInput_3.wasNull()) {
							row5.create_date = null;
						}
					}
					column_index_tJDBCInput_3 = 6;

					if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
						row5.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_3 = null;
						try {
							date_tJDBCInput_3 = rs_tJDBCInput_3
									.getTimestamp(column_index_tJDBCInput_3);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_3 = rs_tJDBCInput_3
									.getDate(column_index_tJDBCInput_3);
						}
						row5.update_date = date_tJDBCInput_3;

						if (rs_tJDBCInput_3.wasNull()) {
							row5.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_3 begin ] stop
					 */
					/**
					 * [tJDBCInput_3 main ] start
					 */

					currentComponent = "tJDBCInput_3";

					tos_count_tJDBCInput_3++;

					/**
					 * [tJDBCInput_3 main ] stop
					 */

					/**
					 * [tMap_3 main ] start
					 */

					currentComponent = "tMap_3";

					boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_3 = false;
					boolean mainRowRejected_tMap_3 = false;

					if (

					(

					row5.update_date == null ? TalendDate.compareDate(
							row5.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row5.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row5'
						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
							// ###############################
							// # Output tables

							storage_configuration = null;

							// # Output table : 'storage_configuration'
							storage_configuration_tmp.storage_domain_id = row5.storage_domain_id;
							storage_configuration_tmp.storage_domain_name = StringHandling
									.TRIM(row5.storage_domain_name);
							storage_configuration_tmp.storage_domain_type = row5.storage_domain_type;
							storage_configuration_tmp.storage_type = row5.storage_type;
							storage_configuration_tmp.create_date = row5.create_date;
							storage_configuration_tmp.update_date = row5.update_date;
							storage_configuration_tmp.delete_date = null;
							storage_configuration = storage_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_3 = false;

						tos_count_tMap_3++;

						/**
						 * [tMap_3 main ] stop
						 */
						// Start of branch "storage_configuration"
						if (storage_configuration != null) {

							/**
							 * [tJDBCOutput_3 main ] start
							 */

							currentComponent = "tJDBCOutput_3";

							whetherReject_tJDBCOutput_3 = false;
							if (storage_configuration.storage_domain_id == null) {
								pstmt_tJDBCOutput_3.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_3
										.setObject(
												1,
												storage_configuration.storage_domain_id);
							}

							if (storage_configuration.storage_domain_name == null) {
								pstmt_tJDBCOutput_3.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_3
										.setString(
												2,
												storage_configuration.storage_domain_name);
							}

							pstmt_tJDBCOutput_3.setShort(3,
									storage_configuration.storage_domain_type);

							pstmt_tJDBCOutput_3.setShort(4,
									storage_configuration.storage_type);

							if (storage_configuration.create_date != null) {
								pstmt_tJDBCOutput_3
										.setTimestamp(
												5,
												new java.sql.Timestamp(
														storage_configuration.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_3.setNull(5,
										java.sql.Types.DATE);
							}

							if (storage_configuration.update_date != null) {
								pstmt_tJDBCOutput_3
										.setTimestamp(
												6,
												new java.sql.Timestamp(
														storage_configuration.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_3.setNull(6,
										java.sql.Types.DATE);
							}

							if (storage_configuration.delete_date != null) {
								pstmt_tJDBCOutput_3
										.setTimestamp(
												7,
												new java.sql.Timestamp(
														storage_configuration.delete_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_3.setNull(7,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_3 = insertedCount_tJDBCOutput_3
										+ pstmt_tJDBCOutput_3.executeUpdate();
								nb_line_tJDBCOutput_3++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_3 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_3++;

							/**
							 * [tJDBCOutput_3 main ] stop
							 */

						} // End of branch "storage_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row5'

					/**
					 * [tJDBCInput_3 end ] start
					 */

					currentComponent = "tJDBCInput_3";

				}
				rs_tJDBCInput_3.close();
				stmt_tJDBCInput_3.close();

				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_3:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_20Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class delete_storageStruct implements
			routines.system.IPersistableRow<delete_storageStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public short storage_domain_type;

		public short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public short storage_type;

		public short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_name = readString(dis);

					this.storage_domain_type = dis.readShort();

					this.storage_type = dis.readShort();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_name, dos);

				// short

				dos.writeShort(this.storage_domain_type);

				// short

				dos.writeShort(this.storage_type);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_storageStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row19Struct implements
			routines.system.IPersistableRow<row19Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public Short storage_domain_type;

		public Short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_domain_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_type = null;
					} else {
						this.storage_domain_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// String

				writeString(this.storage_domain_name, dos);

				// Short

				if (this.storage_domain_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_type);
				}

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row19Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_20Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_20Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public Short storage_domain_type;

		public Short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_domain_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_type = null;
					} else {
						this.storage_domain_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// String

				writeString(this.storage_domain_name, dos);

				// Short

				if (this.storage_domain_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_type);
				}

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_20Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_20Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_19Process(globalMap);

				row19Struct row19 = new row19Struct();
				delete_storageStruct delete_storage = new delete_storageStruct();

				/**
				 * [tJDBCOutput_16 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_16", false);
				start_Hash.put("tJDBCOutput_16", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_16";

				int tos_count_tJDBCOutput_16 = 0;

				int nb_line_tJDBCOutput_16 = 0;
				int nb_line_update_tJDBCOutput_16 = 0;
				int nb_line_inserted_tJDBCOutput_16 = 0;
				int nb_line_deleted_tJDBCOutput_16 = 0;
				int nb_line_rejected_tJDBCOutput_16 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_16 = 0;

				int deletedCount_tJDBCOutput_16 = 0;
				int updatedCount_tJDBCOutput_16 = 0;
				int insertedCount_tJDBCOutput_16 = 0;
				int rejectedCount_tJDBCOutput_16 = 0;

				boolean whetherReject_tJDBCOutput_16 = false;

				java.sql.Connection connection_tJDBCOutput_16 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_16) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_16 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_16 = dataSources_tJDBCOutput_16.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_16 = 10000;
				int batchSizeCounter_tJDBCOutput_16 = 0;

				String insert_tJDBCOutput_16 = "INSERT INTO "
						+ "storage_domain_configuration"
						+ " (storage_domain_id,storage_domain_name,storage_domain_type,storage_type,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_16 = connection_tJDBCOutput_16
						.prepareStatement(insert_tJDBCOutput_16);

				/**
				 * [tJDBCOutput_16 begin ] stop
				 */

				/**
				 * [tMap_16 begin ] start
				 */

				ok_Hash.put("tMap_16", false);
				start_Hash.put("tMap_16", System.currentTimeMillis());
				currentComponent = "tMap_16";

				int tos_count_tMap_16 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row18Struct> tHash_Lookup_row18 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row18Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row18Struct>) globalMap
						.get("tHash_Lookup_row18"));

				row18Struct row18HashKey = new row18Struct();
				row18Struct row18Default = new row18Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_16__Struct {
				}
				Var__tMap_16__Struct Var__tMap_16 = new Var__tMap_16__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_storageStruct delete_storage_tmp = new delete_storageStruct();
				// ###############################

				/**
				 * [tMap_16 begin ] stop
				 */

				/**
				 * [tJDBCInput_20 begin ] start
				 */

				ok_Hash.put("tJDBCInput_20", false);
				start_Hash.put("tJDBCInput_20", System.currentTimeMillis());
				currentComponent = "tJDBCInput_20";

				int tos_count_tJDBCInput_20 = 0;

				int nb_line_tJDBCInput_20 = 0;
				java.sql.Connection conn_tJDBCInput_20 = null;
				conn_tJDBCInput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_20) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_20 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_20 = dataSources_tJDBCInput_20.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_20);
				}

				java.sql.Statement stmt_tJDBCInput_20 = conn_tJDBCInput_20
						.createStatement();

				String dbquery_tJDBCInput_20 = "SELECT history_id,    		storage_domain_id,   		upper(cast(storage_domain_id as char(36))) as storage_domain_join_id,  		storage_domain_name,   		storage_domain_type,    		storage_type,    		create_date,    		update_date FROM v3_3_latest_configuration_storage_domains";

				globalMap.put("tJDBCInput_20_QUERY", dbquery_tJDBCInput_20);

				java.sql.ResultSet rs_tJDBCInput_20 = stmt_tJDBCInput_20
						.executeQuery(dbquery_tJDBCInput_20);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_20 = rs_tJDBCInput_20
						.getMetaData();
				int colQtyInRs_tJDBCInput_20 = rsmd_tJDBCInput_20
						.getColumnCount();

				String tmpContent_tJDBCInput_20 = null;
				int column_index_tJDBCInput_20 = 1;
				while (rs_tJDBCInput_20.next()) {
					nb_line_tJDBCInput_20++;

					column_index_tJDBCInput_20 = 1;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.history_id = null;
					} else {

						if (rs_tJDBCInput_20
								.getObject(column_index_tJDBCInput_20) != null) {
							row19.history_id = rs_tJDBCInput_20
									.getInt(column_index_tJDBCInput_20);
						} else {
							row19.history_id = null;
						}

						if (rs_tJDBCInput_20.wasNull()) {
							row19.history_id = null;
						}
					}
					column_index_tJDBCInput_20 = 2;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.storage_domain_id = null;
					} else {

						if (rs_tJDBCInput_20
								.getObject(column_index_tJDBCInput_20) != null) {
							row19.storage_domain_id = rs_tJDBCInput_20
									.getObject(column_index_tJDBCInput_20);
						} else {
							row19.storage_domain_id = null;
						}

						if (rs_tJDBCInput_20.wasNull()) {
							row19.storage_domain_id = null;
						}
					}
					column_index_tJDBCInput_20 = 3;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.storage_domain_join_id = null;
					} else {

						tmpContent_tJDBCInput_20 = rs_tJDBCInput_20
								.getString(column_index_tJDBCInput_20);
						if (tmpContent_tJDBCInput_20 != null) {
							row19.storage_domain_join_id = tmpContent_tJDBCInput_20;
						} else {
							row19.storage_domain_join_id = null;
						}

						if (rs_tJDBCInput_20.wasNull()) {
							row19.storage_domain_join_id = null;
						}
					}
					column_index_tJDBCInput_20 = 4;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.storage_domain_name = null;
					} else {

						tmpContent_tJDBCInput_20 = rs_tJDBCInput_20
								.getString(column_index_tJDBCInput_20);
						if (tmpContent_tJDBCInput_20 != null) {
							row19.storage_domain_name = tmpContent_tJDBCInput_20;
						} else {
							row19.storage_domain_name = null;
						}

						if (rs_tJDBCInput_20.wasNull()) {
							row19.storage_domain_name = null;
						}
					}
					column_index_tJDBCInput_20 = 5;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.storage_domain_type = null;
					} else {

						if (rs_tJDBCInput_20
								.getObject(column_index_tJDBCInput_20) != null) {
							row19.storage_domain_type = rs_tJDBCInput_20
									.getShort(column_index_tJDBCInput_20);
						} else {
							row19.storage_domain_type = null;
						}

						if (rs_tJDBCInput_20.wasNull()) {
							row19.storage_domain_type = null;
						}
					}
					column_index_tJDBCInput_20 = 6;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.storage_type = null;
					} else {

						if (rs_tJDBCInput_20
								.getObject(column_index_tJDBCInput_20) != null) {
							row19.storage_type = rs_tJDBCInput_20
									.getShort(column_index_tJDBCInput_20);
						} else {
							row19.storage_type = null;
						}

						if (rs_tJDBCInput_20.wasNull()) {
							row19.storage_type = null;
						}
					}
					column_index_tJDBCInput_20 = 7;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_20 = null;
						try {
							date_tJDBCInput_20 = rs_tJDBCInput_20
									.getTimestamp(column_index_tJDBCInput_20);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_20 = rs_tJDBCInput_20
									.getDate(column_index_tJDBCInput_20);
						}
						row19.create_date = date_tJDBCInput_20;

						if (rs_tJDBCInput_20.wasNull()) {
							row19.create_date = null;
						}
					}
					column_index_tJDBCInput_20 = 8;

					if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
						row19.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_20 = null;
						try {
							date_tJDBCInput_20 = rs_tJDBCInput_20
									.getTimestamp(column_index_tJDBCInput_20);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_20 = rs_tJDBCInput_20
									.getDate(column_index_tJDBCInput_20);
						}
						row19.update_date = date_tJDBCInput_20;

						if (rs_tJDBCInput_20.wasNull()) {
							row19.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_20 begin ] stop
					 */
					/**
					 * [tJDBCInput_20 main ] start
					 */

					currentComponent = "tJDBCInput_20";

					tos_count_tJDBCInput_20++;

					/**
					 * [tJDBCInput_20 main ] stop
					 */

					/**
					 * [tMap_16 main ] start
					 */

					currentComponent = "tMap_16";

					boolean hasCasePrimitiveKeyWithNull_tMap_16 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_16 = false;
					boolean mainRowRejected_tMap_16 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row18"
					// /////////////////////////////////////////////

					boolean forceLooprow18 = false;

					row18Struct row18ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_16) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_16 = false;

						row18HashKey.storage_domain_join_id = row19.storage_domain_join_id;

						row18HashKey.hashCodeDirty = true;

						tHash_Lookup_row18.lookup(row18HashKey);

						if (!tHash_Lookup_row18.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_16 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row18 != null
							&& tHash_Lookup_row18.getCount(row18HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row18' and it contains more one result from keys :  row18.storage_domain_join_id = '"
						// + row18HashKey.storage_domain_join_id + "'");
					} // G 071

					row18Struct row18 = null;

					row18Struct fromLookup_row18 = null;
					row18 = row18Default;

					if (tHash_Lookup_row18 != null
							&& tHash_Lookup_row18.hasNext()) { // G 099

						fromLookup_row18 = tHash_Lookup_row18.next();

					} // G 099

					if (fromLookup_row18 != null) {
						row18 = fromLookup_row18;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_16__Struct Var = Var__tMap_16;// ###############################
						// ###############################
						// # Output tables

						delete_storage = null;

						if (!rejectedInnerJoin_tMap_16) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_storage'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_16) {
							delete_storage_tmp.storage_domain_id = row19.storage_domain_id;
							delete_storage_tmp.storage_domain_name = row19.storage_domain_name;
							delete_storage_tmp.storage_domain_type = row19.storage_domain_type;
							delete_storage_tmp.storage_type = row19.storage_type;
							delete_storage_tmp.create_date = row19.create_date;
							delete_storage_tmp.update_date = context.runTime;
							delete_storage_tmp.delete_date = context.runTime;
							delete_storage = delete_storage_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_16 = false;

					tos_count_tMap_16++;

					/**
					 * [tMap_16 main ] stop
					 */
					// Start of branch "delete_storage"
					if (delete_storage != null) {

						/**
						 * [tJDBCOutput_16 main ] start
						 */

						currentComponent = "tJDBCOutput_16";

						whetherReject_tJDBCOutput_16 = false;
						if (delete_storage.storage_domain_id == null) {
							pstmt_tJDBCOutput_16.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_16.setObject(1,
									delete_storage.storage_domain_id);
						}

						if (delete_storage.storage_domain_name == null) {
							pstmt_tJDBCOutput_16.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_16.setString(2,
									delete_storage.storage_domain_name);
						}

						pstmt_tJDBCOutput_16.setShort(3,
								delete_storage.storage_domain_type);

						pstmt_tJDBCOutput_16.setShort(4,
								delete_storage.storage_type);

						if (delete_storage.create_date != null) {
							pstmt_tJDBCOutput_16.setTimestamp(
									5,
									new java.sql.Timestamp(
											delete_storage.create_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_16
									.setNull(5, java.sql.Types.DATE);
						}

						if (delete_storage.update_date != null) {
							pstmt_tJDBCOutput_16.setTimestamp(
									6,
									new java.sql.Timestamp(
											delete_storage.update_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_16
									.setNull(6, java.sql.Types.DATE);
						}

						if (delete_storage.delete_date != null) {
							pstmt_tJDBCOutput_16.setTimestamp(
									7,
									new java.sql.Timestamp(
											delete_storage.delete_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_16
									.setNull(7, java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_16 = insertedCount_tJDBCOutput_16
									+ pstmt_tJDBCOutput_16.executeUpdate();
							nb_line_tJDBCOutput_16++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_16 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_16++;

						/**
						 * [tJDBCOutput_16 main ] stop
						 */

					} // End of branch "delete_storage"

					/**
					 * [tJDBCInput_20 end ] start
					 */

					currentComponent = "tJDBCInput_20";

				}
				rs_tJDBCInput_20.close();
				stmt_tJDBCInput_20.close();

				globalMap.put("tJDBCInput_20_NB_LINE", nb_line_tJDBCInput_20);

				ok_Hash.put("tJDBCInput_20", true);
				end_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				/**
				 * [tJDBCInput_20 end ] stop
				 */

				/**
				 * [tMap_16 end ] start
				 */

				currentComponent = "tMap_16";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row18 != null) {
					tHash_Lookup_row18.endGet();
				}
				globalMap.remove("tHash_Lookup_row18");

				// ###############################

				ok_Hash.put("tMap_16", true);
				end_Hash.put("tMap_16", System.currentTimeMillis());

				/**
				 * [tMap_16 end ] stop
				 */

				/**
				 * [tJDBCOutput_16 end ] start
				 */

				currentComponent = "tJDBCOutput_16";

				if (pstmt_tJDBCOutput_16 != null) {

					pstmt_tJDBCOutput_16.close();

				}

				nb_line_deleted_tJDBCOutput_16 = nb_line_deleted_tJDBCOutput_16
						+ deletedCount_tJDBCOutput_16;
				nb_line_update_tJDBCOutput_16 = nb_line_update_tJDBCOutput_16
						+ updatedCount_tJDBCOutput_16;
				nb_line_inserted_tJDBCOutput_16 = nb_line_inserted_tJDBCOutput_16
						+ insertedCount_tJDBCOutput_16;
				nb_line_rejected_tJDBCOutput_16 = nb_line_rejected_tJDBCOutput_16
						+ rejectedCount_tJDBCOutput_16;

				globalMap.put("tJDBCOutput_16_NB_LINE", nb_line_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_16);

				ok_Hash.put("tJDBCOutput_16", true);
				end_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_16 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_20:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_33Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_16"
			globalMap.remove("tHash_Lookup_row18");

		}

		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 1);
	}

	public static class insert_new_dc_storage_connectionStruct
			implements
			routines.system.IPersistableRow<insert_new_dc_storage_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		public java.util.Date detach_date;

		public java.util.Date getDetach_date() {
			return this.detach_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_domain_id == null) ? 0
								: this.storage_domain_id.hashCode());

				result = prime
						* result
						+ ((this.datacenter_id == null) ? 0
								: this.datacenter_id.hashCode());

				result = prime
						* result
						+ ((this.attach_date == null) ? 0 : this.attach_date
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final insert_new_dc_storage_connectionStruct other = (insert_new_dc_storage_connectionStruct) obj;

			if (this.storage_domain_id == null) {
				if (other.storage_domain_id != null)
					return false;
			} else if (!this.storage_domain_id.equals(other.storage_domain_id))
				return false;

			if (this.datacenter_id == null) {
				if (other.datacenter_id != null)
					return false;
			} else if (!this.datacenter_id.equals(other.datacenter_id))
				return false;

			if (this.attach_date == null) {
				if (other.attach_date != null)
					return false;
			} else if (!this.attach_date.equals(other.attach_date))
				return false;

			return true;
		}

		public void copyDataTo(insert_new_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;
			other.detach_date = this.detach_date;

		}

		public void copyKeysDataTo(insert_new_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;

		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.datacenter_id = (Object) dis.readObject();

					this.attach_date = readDate(dis);

					this.detach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// Object

				dos.writeObject(this.datacenter_id);

				// java.util.Date

				writeDate(this.attach_date, dos);

				// java.util.Date

				writeDate(this.detach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append(",detach_date=" + String.valueOf(detach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(insert_new_dc_storage_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_domain_id,
					other.storage_domain_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.datacenter_id,
					other.datacenter_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.attach_date,
					other.attach_date);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row31Struct implements
			routines.system.IPersistableRow<row31Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_id;

		public Object getStorage_id() {
			return this.storage_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object storage_pool_id;

		public Object getStorage_pool_id() {
			return this.storage_pool_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_pool_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.storage_pool_id);

				// String

				writeString(this.datacenter_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_id=" + String.valueOf(storage_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_pool_id=" + String.valueOf(storage_pool_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row31Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_33Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_33Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object storage_id;

		public Object getStorage_id() {
			return this.storage_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object storage_pool_id;

		public Object getStorage_pool_id() {
			return this.storage_pool_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_id == null) ? 0 : this.storage_id
								.hashCode());

				result = prime
						* result
						+ ((this.storage_pool_id == null) ? 0
								: this.storage_pool_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final after_tJDBCInput_33Struct other = (after_tJDBCInput_33Struct) obj;

			if (this.storage_id == null) {
				if (other.storage_id != null)
					return false;
			} else if (!this.storage_id.equals(other.storage_id))
				return false;

			if (this.storage_pool_id == null) {
				if (other.storage_pool_id != null)
					return false;
			} else if (!this.storage_pool_id.equals(other.storage_pool_id))
				return false;

			return true;
		}

		public void copyDataTo(after_tJDBCInput_33Struct other) {

			other.storage_id = this.storage_id;
			other.storage_domain_join_id = this.storage_domain_join_id;
			other.storage_pool_id = this.storage_pool_id;
			other.datacenter_join_id = this.datacenter_join_id;

		}

		public void copyKeysDataTo(after_tJDBCInput_33Struct other) {

			other.storage_id = this.storage_id;
			other.storage_pool_id = this.storage_pool_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_pool_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.storage_pool_id);

				// String

				writeString(this.datacenter_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_id=" + String.valueOf(storage_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_pool_id=" + String.valueOf(storage_pool_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_33Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_id,
					other.storage_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.storage_pool_id,
					other.storage_pool_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_33Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_33_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_35Process(globalMap);

				row31Struct row31 = new row31Struct();
				insert_new_dc_storage_connectionStruct insert_new_dc_storage_connection = new insert_new_dc_storage_connectionStruct();

				/**
				 * [tJDBCOutput_23 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_23", false);
				start_Hash.put("tJDBCOutput_23", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_23";

				int tos_count_tJDBCOutput_23 = 0;

				int nb_line_tJDBCOutput_23 = 0;
				int nb_line_update_tJDBCOutput_23 = 0;
				int nb_line_inserted_tJDBCOutput_23 = 0;
				int nb_line_deleted_tJDBCOutput_23 = 0;
				int nb_line_rejected_tJDBCOutput_23 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_23 = 0;

				int deletedCount_tJDBCOutput_23 = 0;
				int updatedCount_tJDBCOutput_23 = 0;
				int insertedCount_tJDBCOutput_23 = 0;
				int rejectedCount_tJDBCOutput_23 = 0;

				boolean whetherReject_tJDBCOutput_23 = false;

				java.sql.Connection connection_tJDBCOutput_23 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_23) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_23 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_23 = dataSources_tJDBCOutput_23.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_23 = 10000;
				int batchSizeCounter_tJDBCOutput_23 = 0;

				String insert_tJDBCOutput_23 = "INSERT INTO "
						+ "datacenter_storage_domain_map"
						+ " (storage_domain_id,datacenter_id,attach_date,detach_date) VALUES (?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_23 = connection_tJDBCOutput_23
						.prepareStatement(insert_tJDBCOutput_23);

				/**
				 * [tJDBCOutput_23 begin ] stop
				 */

				/**
				 * [tMap_23 begin ] start
				 */

				ok_Hash.put("tMap_23", false);
				start_Hash.put("tMap_23", System.currentTimeMillis());
				currentComponent = "tMap_23";

				int tos_count_tMap_23 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row33Struct> tHash_Lookup_row33 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row33Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row33Struct>) globalMap
						.get("tHash_Lookup_row33"));

				row33Struct row33HashKey = new row33Struct();
				row33Struct row33Default = new row33Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_23__Struct {
				}
				Var__tMap_23__Struct Var__tMap_23 = new Var__tMap_23__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				insert_new_dc_storage_connectionStruct insert_new_dc_storage_connection_tmp = new insert_new_dc_storage_connectionStruct();
				// ###############################

				/**
				 * [tMap_23 begin ] stop
				 */

				/**
				 * [tJDBCInput_33 begin ] start
				 */

				ok_Hash.put("tJDBCInput_33", false);
				start_Hash.put("tJDBCInput_33", System.currentTimeMillis());
				currentComponent = "tJDBCInput_33";

				int tos_count_tJDBCInput_33 = 0;

				int nb_line_tJDBCInput_33 = 0;
				java.sql.Connection conn_tJDBCInput_33 = null;
				conn_tJDBCInput_33 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_33) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_33 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_33 = dataSources_tJDBCInput_33.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_33);
				}

				java.sql.Statement stmt_tJDBCInput_33 = conn_tJDBCInput_33
						.createStatement();

				String dbquery_tJDBCInput_33 = "SELECT storage_id,  		upper(cast(storage_id as char(36))) as storage_domain_join_id,  		storage_pool_id,  		upper(cast(storage_pool_id as char(36))) as datacenter_join_id  FROM  storage_pool_iso_map";

				globalMap.put("tJDBCInput_33_QUERY", dbquery_tJDBCInput_33);

				java.sql.ResultSet rs_tJDBCInput_33 = stmt_tJDBCInput_33
						.executeQuery(dbquery_tJDBCInput_33);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_33 = rs_tJDBCInput_33
						.getMetaData();
				int colQtyInRs_tJDBCInput_33 = rsmd_tJDBCInput_33
						.getColumnCount();

				String tmpContent_tJDBCInput_33 = null;
				int column_index_tJDBCInput_33 = 1;
				while (rs_tJDBCInput_33.next()) {
					nb_line_tJDBCInput_33++;

					column_index_tJDBCInput_33 = 1;

					if (colQtyInRs_tJDBCInput_33 < column_index_tJDBCInput_33) {
						row31.storage_id = null;
					} else {

						if (rs_tJDBCInput_33
								.getObject(column_index_tJDBCInput_33) != null) {
							row31.storage_id = rs_tJDBCInput_33
									.getObject(column_index_tJDBCInput_33);
						} else {
							throw new RuntimeException(
									"Null value in non-Nullable column");
						}

					}
					column_index_tJDBCInput_33 = 2;

					if (colQtyInRs_tJDBCInput_33 < column_index_tJDBCInput_33) {
						row31.storage_domain_join_id = null;
					} else {

						tmpContent_tJDBCInput_33 = rs_tJDBCInput_33
								.getString(column_index_tJDBCInput_33);
						if (tmpContent_tJDBCInput_33 != null) {
							row31.storage_domain_join_id = tmpContent_tJDBCInput_33;
						} else {
							row31.storage_domain_join_id = null;
						}

					}
					column_index_tJDBCInput_33 = 3;

					if (colQtyInRs_tJDBCInput_33 < column_index_tJDBCInput_33) {
						row31.storage_pool_id = null;
					} else {

						if (rs_tJDBCInput_33
								.getObject(column_index_tJDBCInput_33) != null) {
							row31.storage_pool_id = rs_tJDBCInput_33
									.getObject(column_index_tJDBCInput_33);
						} else {
							throw new RuntimeException(
									"Null value in non-Nullable column");
						}

					}
					column_index_tJDBCInput_33 = 4;

					if (colQtyInRs_tJDBCInput_33 < column_index_tJDBCInput_33) {
						row31.datacenter_join_id = null;
					} else {

						tmpContent_tJDBCInput_33 = rs_tJDBCInput_33
								.getString(column_index_tJDBCInput_33);
						if (tmpContent_tJDBCInput_33 != null) {
							row31.datacenter_join_id = tmpContent_tJDBCInput_33;
						} else {
							row31.datacenter_join_id = null;
						}

					}

					/**
					 * [tJDBCInput_33 begin ] stop
					 */
					/**
					 * [tJDBCInput_33 main ] start
					 */

					currentComponent = "tJDBCInput_33";

					tos_count_tJDBCInput_33++;

					/**
					 * [tJDBCInput_33 main ] stop
					 */

					/**
					 * [tMap_23 main ] start
					 */

					currentComponent = "tMap_23";

					boolean hasCasePrimitiveKeyWithNull_tMap_23 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_23 = false;
					boolean mainRowRejected_tMap_23 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row33"
					// /////////////////////////////////////////////

					boolean forceLooprow33 = false;

					row33Struct row33ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_23) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_23 = false;

						row33HashKey.storage_domain_join_id = row31.storage_domain_join_id;

						row33HashKey.datacenter_join_id = row31.datacenter_join_id;

						row33HashKey.hashCodeDirty = true;

						tHash_Lookup_row33.lookup(row33HashKey);

						if (!tHash_Lookup_row33.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_23 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row33 != null
							&& tHash_Lookup_row33.getCount(row33HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row33' and it contains more one result from keys :  row33.storage_domain_join_id = '"
						// + row33HashKey.storage_domain_join_id +
						// "', row33.datacenter_join_id = '" +
						// row33HashKey.datacenter_join_id + "'");
					} // G 071

					row33Struct row33 = null;

					row33Struct fromLookup_row33 = null;
					row33 = row33Default;

					if (tHash_Lookup_row33 != null
							&& tHash_Lookup_row33.hasNext()) { // G 099

						fromLookup_row33 = tHash_Lookup_row33.next();

					} // G 099

					if (fromLookup_row33 != null) {
						row33 = fromLookup_row33;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_23__Struct Var = Var__tMap_23;// ###############################
						// ###############################
						// # Output tables

						insert_new_dc_storage_connection = null;

						if (!rejectedInnerJoin_tMap_23) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table :
						// 'insert_new_dc_storage_connection'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_23) {
							insert_new_dc_storage_connection_tmp.storage_domain_id = row31.storage_id;
							insert_new_dc_storage_connection_tmp.datacenter_id = row31.storage_pool_id;
							insert_new_dc_storage_connection_tmp.attach_date = context.runTime;
							insert_new_dc_storage_connection_tmp.detach_date = null;
							insert_new_dc_storage_connection = insert_new_dc_storage_connection_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_23 = false;

					tos_count_tMap_23++;

					/**
					 * [tMap_23 main ] stop
					 */
					// Start of branch "insert_new_dc_storage_connection"
					if (insert_new_dc_storage_connection != null) {

						/**
						 * [tJDBCOutput_23 main ] start
						 */

						currentComponent = "tJDBCOutput_23";

						whetherReject_tJDBCOutput_23 = false;
						if (insert_new_dc_storage_connection.storage_domain_id == null) {
							pstmt_tJDBCOutput_23.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_23
									.setObject(
											1,
											insert_new_dc_storage_connection.storage_domain_id);
						}

						if (insert_new_dc_storage_connection.datacenter_id == null) {
							pstmt_tJDBCOutput_23.setNull(2,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_23
									.setObject(
											2,
											insert_new_dc_storage_connection.datacenter_id);
						}

						if (insert_new_dc_storage_connection.attach_date != null) {
							pstmt_tJDBCOutput_23
									.setTimestamp(
											3,
											new java.sql.Timestamp(
													insert_new_dc_storage_connection.attach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_23
									.setNull(3, java.sql.Types.DATE);
						}

						if (insert_new_dc_storage_connection.detach_date != null) {
							pstmt_tJDBCOutput_23
									.setTimestamp(
											4,
											new java.sql.Timestamp(
													insert_new_dc_storage_connection.detach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_23
									.setNull(4, java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_23 = insertedCount_tJDBCOutput_23
									+ pstmt_tJDBCOutput_23.executeUpdate();
							nb_line_tJDBCOutput_23++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_23 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_23++;

						/**
						 * [tJDBCOutput_23 main ] stop
						 */

					} // End of branch "insert_new_dc_storage_connection"

					/**
					 * [tJDBCInput_33 end ] start
					 */

					currentComponent = "tJDBCInput_33";

				}
				rs_tJDBCInput_33.close();
				stmt_tJDBCInput_33.close();

				globalMap.put("tJDBCInput_33_NB_LINE", nb_line_tJDBCInput_33);

				ok_Hash.put("tJDBCInput_33", true);
				end_Hash.put("tJDBCInput_33", System.currentTimeMillis());

				/**
				 * [tJDBCInput_33 end ] stop
				 */

				/**
				 * [tMap_23 end ] start
				 */

				currentComponent = "tMap_23";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row33 != null) {
					tHash_Lookup_row33.endGet();
				}
				globalMap.remove("tHash_Lookup_row33");

				// ###############################

				ok_Hash.put("tMap_23", true);
				end_Hash.put("tMap_23", System.currentTimeMillis());

				/**
				 * [tMap_23 end ] stop
				 */

				/**
				 * [tJDBCOutput_23 end ] start
				 */

				currentComponent = "tJDBCOutput_23";

				if (pstmt_tJDBCOutput_23 != null) {

					pstmt_tJDBCOutput_23.close();

				}

				nb_line_deleted_tJDBCOutput_23 = nb_line_deleted_tJDBCOutput_23
						+ deletedCount_tJDBCOutput_23;
				nb_line_update_tJDBCOutput_23 = nb_line_update_tJDBCOutput_23
						+ updatedCount_tJDBCOutput_23;
				nb_line_inserted_tJDBCOutput_23 = nb_line_inserted_tJDBCOutput_23
						+ insertedCount_tJDBCOutput_23;
				nb_line_rejected_tJDBCOutput_23 = nb_line_rejected_tJDBCOutput_23
						+ rejectedCount_tJDBCOutput_23;

				globalMap.put("tJDBCOutput_23_NB_LINE", nb_line_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_23);

				ok_Hash.put("tJDBCOutput_23", true);
				end_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_23 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_33:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_34Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_23"
			globalMap.remove("tHash_Lookup_row33");

		}

		globalMap.put("tJDBCInput_33_SUBPROCESS_STATE", 1);
	}

	public static class delete_dc_storage_connectionStruct implements
			routines.system.IPersistableRow<delete_dc_storage_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		public java.util.Date detach_date;

		public java.util.Date getDetach_date() {
			return this.detach_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_domain_id == null) ? 0
								: this.storage_domain_id.hashCode());

				result = prime
						* result
						+ ((this.datacenter_id == null) ? 0
								: this.datacenter_id.hashCode());

				result = prime
						* result
						+ ((this.attach_date == null) ? 0 : this.attach_date
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final delete_dc_storage_connectionStruct other = (delete_dc_storage_connectionStruct) obj;

			if (this.storage_domain_id == null) {
				if (other.storage_domain_id != null)
					return false;
			} else if (!this.storage_domain_id.equals(other.storage_domain_id))
				return false;

			if (this.datacenter_id == null) {
				if (other.datacenter_id != null)
					return false;
			} else if (!this.datacenter_id.equals(other.datacenter_id))
				return false;

			if (this.attach_date == null) {
				if (other.attach_date != null)
					return false;
			} else if (!this.attach_date.equals(other.attach_date))
				return false;

			return true;
		}

		public void copyDataTo(delete_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;
			other.detach_date = this.detach_date;

		}

		public void copyKeysDataTo(delete_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;

		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.datacenter_id = (Object) dis.readObject();

					this.attach_date = readDate(dis);

					this.detach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// Object

				dos.writeObject(this.datacenter_id);

				// java.util.Date

				writeDate(this.attach_date, dos);

				// java.util.Date

				writeDate(this.detach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append(",detach_date=" + String.valueOf(detach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_dc_storage_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_domain_id,
					other.storage_domain_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.datacenter_id,
					other.datacenter_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.attach_date,
					other.attach_date);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row30Struct implements
			routines.system.IPersistableRow<row30Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.attach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// java.util.Date

				writeDate(this.attach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row30Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_34Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_34Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.attach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// java.util.Date

				writeDate(this.attach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_34Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_34Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_34_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_32Process(globalMap);

				row30Struct row30 = new row30Struct();
				delete_dc_storage_connectionStruct delete_dc_storage_connection = new delete_dc_storage_connectionStruct();

				/**
				 * [tJDBCOutput_24 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_24", false);
				start_Hash.put("tJDBCOutput_24", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_24";

				int tos_count_tJDBCOutput_24 = 0;

				int updateKeyCount_tJDBCOutput_24 = 3;
				if (updateKeyCount_tJDBCOutput_24 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_24 = 0;
				int nb_line_update_tJDBCOutput_24 = 0;
				int nb_line_inserted_tJDBCOutput_24 = 0;
				int nb_line_deleted_tJDBCOutput_24 = 0;
				int nb_line_rejected_tJDBCOutput_24 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_24 = 0;

				int deletedCount_tJDBCOutput_24 = 0;
				int updatedCount_tJDBCOutput_24 = 0;
				int insertedCount_tJDBCOutput_24 = 0;
				int rejectedCount_tJDBCOutput_24 = 0;

				boolean whetherReject_tJDBCOutput_24 = false;

				java.sql.Connection connection_tJDBCOutput_24 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_24) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_24 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_24 = dataSources_tJDBCOutput_24.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_24 = 10000;
				int batchSizeCounter_tJDBCOutput_24 = 0;

				String update_tJDBCOutput_24 = "UPDATE "
						+ "datacenter_storage_domain_map"
						+ " SET detach_date = ? WHERE storage_domain_id = ? AND datacenter_id = ? AND attach_date = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_24 = connection_tJDBCOutput_24
						.prepareStatement(update_tJDBCOutput_24);

				/**
				 * [tJDBCOutput_24 begin ] stop
				 */

				/**
				 * [tMap_22 begin ] start
				 */

				ok_Hash.put("tMap_22", false);
				start_Hash.put("tMap_22", System.currentTimeMillis());
				currentComponent = "tMap_22";

				int tos_count_tMap_22 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row32Struct> tHash_Lookup_row32 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row32Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row32Struct>) globalMap
						.get("tHash_Lookup_row32"));

				row32Struct row32HashKey = new row32Struct();
				row32Struct row32Default = new row32Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_22__Struct {
				}
				Var__tMap_22__Struct Var__tMap_22 = new Var__tMap_22__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_dc_storage_connectionStruct delete_dc_storage_connection_tmp = new delete_dc_storage_connectionStruct();
				// ###############################

				/**
				 * [tMap_22 begin ] stop
				 */

				/**
				 * [tJDBCInput_34 begin ] start
				 */

				ok_Hash.put("tJDBCInput_34", false);
				start_Hash.put("tJDBCInput_34", System.currentTimeMillis());
				currentComponent = "tJDBCInput_34";

				int tos_count_tJDBCInput_34 = 0;

				int nb_line_tJDBCInput_34 = 0;
				java.sql.Connection conn_tJDBCInput_34 = null;
				conn_tJDBCInput_34 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_34) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_34 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_34 = dataSources_tJDBCInput_34.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_34);
				}

				java.sql.Statement stmt_tJDBCInput_34 = conn_tJDBCInput_34
						.createStatement();

				String dbquery_tJDBCInput_34 = "SELECT storage_domain_id,   		upper(cast(storage_domain_id as char(36))) as storage_domain_join_id,  		datacenter_id,   		upper(cast(datacenter_id as char(36))) as datacenter_join_id, 		attach_date FROM  v3_3_latest_map_datacenters_storage_domains";

				globalMap.put("tJDBCInput_34_QUERY", dbquery_tJDBCInput_34);

				java.sql.ResultSet rs_tJDBCInput_34 = stmt_tJDBCInput_34
						.executeQuery(dbquery_tJDBCInput_34);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_34 = rs_tJDBCInput_34
						.getMetaData();
				int colQtyInRs_tJDBCInput_34 = rsmd_tJDBCInput_34
						.getColumnCount();

				String tmpContent_tJDBCInput_34 = null;
				int column_index_tJDBCInput_34 = 1;
				while (rs_tJDBCInput_34.next()) {
					nb_line_tJDBCInput_34++;

					column_index_tJDBCInput_34 = 1;

					if (colQtyInRs_tJDBCInput_34 < column_index_tJDBCInput_34) {
						row30.storage_domain_id = null;
					} else {

						if (rs_tJDBCInput_34
								.getObject(column_index_tJDBCInput_34) != null) {
							row30.storage_domain_id = rs_tJDBCInput_34
									.getObject(column_index_tJDBCInput_34);
						} else {
							row30.storage_domain_id = null;
						}

						if (rs_tJDBCInput_34.wasNull()) {
							row30.storage_domain_id = null;
						}
					}
					column_index_tJDBCInput_34 = 2;

					if (colQtyInRs_tJDBCInput_34 < column_index_tJDBCInput_34) {
						row30.storage_domain_join_id = null;
					} else {

						tmpContent_tJDBCInput_34 = rs_tJDBCInput_34
								.getString(column_index_tJDBCInput_34);
						if (tmpContent_tJDBCInput_34 != null) {
							row30.storage_domain_join_id = tmpContent_tJDBCInput_34;
						} else {
							row30.storage_domain_join_id = null;
						}

						if (rs_tJDBCInput_34.wasNull()) {
							row30.storage_domain_join_id = null;
						}
					}
					column_index_tJDBCInput_34 = 3;

					if (colQtyInRs_tJDBCInput_34 < column_index_tJDBCInput_34) {
						row30.datacenter_id = null;
					} else {

						if (rs_tJDBCInput_34
								.getObject(column_index_tJDBCInput_34) != null) {
							row30.datacenter_id = rs_tJDBCInput_34
									.getObject(column_index_tJDBCInput_34);
						} else {
							row30.datacenter_id = null;
						}

						if (rs_tJDBCInput_34.wasNull()) {
							row30.datacenter_id = null;
						}
					}
					column_index_tJDBCInput_34 = 4;

					if (colQtyInRs_tJDBCInput_34 < column_index_tJDBCInput_34) {
						row30.datacenter_join_id = null;
					} else {

						tmpContent_tJDBCInput_34 = rs_tJDBCInput_34
								.getString(column_index_tJDBCInput_34);
						if (tmpContent_tJDBCInput_34 != null) {
							row30.datacenter_join_id = tmpContent_tJDBCInput_34;
						} else {
							row30.datacenter_join_id = null;
						}

						if (rs_tJDBCInput_34.wasNull()) {
							row30.datacenter_join_id = null;
						}
					}
					column_index_tJDBCInput_34 = 5;

					if (colQtyInRs_tJDBCInput_34 < column_index_tJDBCInput_34) {
						row30.attach_date = null;
					} else {

						java.util.Date date_tJDBCInput_34 = null;
						try {
							date_tJDBCInput_34 = rs_tJDBCInput_34
									.getTimestamp(column_index_tJDBCInput_34);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_34 = rs_tJDBCInput_34
									.getDate(column_index_tJDBCInput_34);
						}
						row30.attach_date = date_tJDBCInput_34;

						if (rs_tJDBCInput_34.wasNull()) {
							row30.attach_date = null;
						}
					}

					/**
					 * [tJDBCInput_34 begin ] stop
					 */
					/**
					 * [tJDBCInput_34 main ] start
					 */

					currentComponent = "tJDBCInput_34";

					tos_count_tJDBCInput_34++;

					/**
					 * [tJDBCInput_34 main ] stop
					 */

					/**
					 * [tMap_22 main ] start
					 */

					currentComponent = "tMap_22";

					boolean hasCasePrimitiveKeyWithNull_tMap_22 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_22 = false;
					boolean mainRowRejected_tMap_22 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row32"
					// /////////////////////////////////////////////

					boolean forceLooprow32 = false;

					row32Struct row32ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_22) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_22 = false;

						row32HashKey.storage_domain_join_id = row30.storage_domain_join_id;

						row32HashKey.datacenter_join_id = row30.datacenter_join_id;

						row32HashKey.hashCodeDirty = true;

						tHash_Lookup_row32.lookup(row32HashKey);

						if (!tHash_Lookup_row32.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_22 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row32 != null
							&& tHash_Lookup_row32.getCount(row32HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row32' and it contains more one result from keys :  row32.storage_domain_join_id = '"
						// + row32HashKey.storage_domain_join_id +
						// "', row32.datacenter_join_id = '" +
						// row32HashKey.datacenter_join_id + "'");
					} // G 071

					row32Struct row32 = null;

					row32Struct fromLookup_row32 = null;
					row32 = row32Default;

					if (tHash_Lookup_row32 != null
							&& tHash_Lookup_row32.hasNext()) { // G 099

						fromLookup_row32 = tHash_Lookup_row32.next();

					} // G 099

					if (fromLookup_row32 != null) {
						row32 = fromLookup_row32;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_22__Struct Var = Var__tMap_22;// ###############################
						// ###############################
						// # Output tables

						delete_dc_storage_connection = null;

						if (!rejectedInnerJoin_tMap_22) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table :
						// 'delete_dc_storage_connection'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_22) {
							delete_dc_storage_connection_tmp.storage_domain_id = row30.storage_domain_id;
							delete_dc_storage_connection_tmp.datacenter_id = row30.datacenter_id;
							delete_dc_storage_connection_tmp.attach_date = row30.attach_date;
							delete_dc_storage_connection_tmp.detach_date = context.runTime;
							delete_dc_storage_connection = delete_dc_storage_connection_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_22 = false;

					tos_count_tMap_22++;

					/**
					 * [tMap_22 main ] stop
					 */
					// Start of branch "delete_dc_storage_connection"
					if (delete_dc_storage_connection != null) {

						/**
						 * [tJDBCOutput_24 main ] start
						 */

						currentComponent = "tJDBCOutput_24";

						whetherReject_tJDBCOutput_24 = false;
						if (delete_dc_storage_connection.detach_date != null) {
							pstmt_tJDBCOutput_24
									.setTimestamp(
											1,
											new java.sql.Timestamp(
													delete_dc_storage_connection.detach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_24
									.setNull(1, java.sql.Types.DATE);
						}

						if (delete_dc_storage_connection.storage_domain_id == null) {
							pstmt_tJDBCOutput_24.setNull(2,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_24
									.setObject(
											2,
											delete_dc_storage_connection.storage_domain_id);
						}

						if (delete_dc_storage_connection.datacenter_id == null) {
							pstmt_tJDBCOutput_24.setNull(3,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_24.setObject(3,
									delete_dc_storage_connection.datacenter_id);
						}

						if (delete_dc_storage_connection.attach_date != null) {
							pstmt_tJDBCOutput_24
									.setTimestamp(
											4,
											new java.sql.Timestamp(
													delete_dc_storage_connection.attach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_24
									.setNull(4, java.sql.Types.DATE);
						}

						try {
							updatedCount_tJDBCOutput_24 = updatedCount_tJDBCOutput_24
									+ pstmt_tJDBCOutput_24.executeUpdate();
							nb_line_tJDBCOutput_24++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_24 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_24++;

						/**
						 * [tJDBCOutput_24 main ] stop
						 */

					} // End of branch "delete_dc_storage_connection"

					/**
					 * [tJDBCInput_34 end ] start
					 */

					currentComponent = "tJDBCInput_34";

				}
				rs_tJDBCInput_34.close();
				stmt_tJDBCInput_34.close();

				globalMap.put("tJDBCInput_34_NB_LINE", nb_line_tJDBCInput_34);

				ok_Hash.put("tJDBCInput_34", true);
				end_Hash.put("tJDBCInput_34", System.currentTimeMillis());

				/**
				 * [tJDBCInput_34 end ] stop
				 */

				/**
				 * [tMap_22 end ] start
				 */

				currentComponent = "tMap_22";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row32 != null) {
					tHash_Lookup_row32.endGet();
				}
				globalMap.remove("tHash_Lookup_row32");

				// ###############################

				ok_Hash.put("tMap_22", true);
				end_Hash.put("tMap_22", System.currentTimeMillis());

				/**
				 * [tMap_22 end ] stop
				 */

				/**
				 * [tJDBCOutput_24 end ] start
				 */

				currentComponent = "tJDBCOutput_24";

				if (pstmt_tJDBCOutput_24 != null) {

					pstmt_tJDBCOutput_24.close();

				}

				nb_line_deleted_tJDBCOutput_24 = nb_line_deleted_tJDBCOutput_24
						+ deletedCount_tJDBCOutput_24;
				nb_line_update_tJDBCOutput_24 = nb_line_update_tJDBCOutput_24
						+ updatedCount_tJDBCOutput_24;
				nb_line_inserted_tJDBCOutput_24 = nb_line_inserted_tJDBCOutput_24
						+ insertedCount_tJDBCOutput_24;
				nb_line_rejected_tJDBCOutput_24 = nb_line_rejected_tJDBCOutput_24
						+ rejectedCount_tJDBCOutput_24;

				globalMap.put("tJDBCOutput_24_NB_LINE", nb_line_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_24);

				ok_Hash.put("tJDBCOutput_24", true);
				end_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_24 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_34:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_4Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_22"
			globalMap.remove("tHash_Lookup_row32");

		}

		globalMap.put("tJDBCInput_34_SUBPROCESS_STATE", 1);
	}

	public static class host_configurationStruct implements
			routines.system.IPersistableRow<host_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public short host_type;

		public short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String pm_ip_address;

		public String getPm_ip_address() {
			return this.pm_ip_address;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public int vdsm_port;

		public int getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.host_type = dis.readShort();

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.pm_ip_address = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = dis.readInt();

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// short

				dos.writeShort(this.host_type);

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.pm_ip_address, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// int

				dos.writeInt(this.vdsm_port);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",pm_ip_address=" + pm_ip_address);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(host_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row7Struct implements
			routines.system.IPersistableRow<row7Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String pm_ip_address;

		public String getPm_ip_address() {
			return this.pm_ip_address;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.pm_ip_address = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.pm_ip_address, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",pm_ip_address=" + pm_ip_address);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row7Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_4Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String pm_ip_address;

		public String getPm_ip_address() {
			return this.pm_ip_address;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.pm_ip_address = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.pm_ip_address, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",pm_ip_address=" + pm_ip_address);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_40Process(globalMap);

				row7Struct row7 = new row7Struct();
				host_configurationStruct host_configuration = new host_configurationStruct();

				/**
				 * [tJDBCOutput_4 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_4", false);
				start_Hash.put("tJDBCOutput_4", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_4";

				int tos_count_tJDBCOutput_4 = 0;

				int nb_line_tJDBCOutput_4 = 0;
				int nb_line_update_tJDBCOutput_4 = 0;
				int nb_line_inserted_tJDBCOutput_4 = 0;
				int nb_line_deleted_tJDBCOutput_4 = 0;
				int nb_line_rejected_tJDBCOutput_4 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_4 = 0;

				int deletedCount_tJDBCOutput_4 = 0;
				int updatedCount_tJDBCOutput_4 = 0;
				int insertedCount_tJDBCOutput_4 = 0;
				int rejectedCount_tJDBCOutput_4 = 0;

				boolean whetherReject_tJDBCOutput_4 = false;

				java.sql.Connection connection_tJDBCOutput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_4) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_4 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_4 = dataSources_tJDBCOutput_4
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_4 = 10000;
				int batchSizeCounter_tJDBCOutput_4 = 0;

				String insert_tJDBCOutput_4 = "INSERT INTO "
						+ "host_configuration"
						+ " (host_id,host_unique_id,host_name,cluster_id,host_type,fqdn_or_ip,memory_size_mb,swap_size_mb,cpu_model,number_of_cores,number_of_sockets,cpu_speed_mh,host_os,pm_ip_address,kernel_version,kvm_version,vdsm_version,vdsm_port,cluster_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_4 = connection_tJDBCOutput_4
						.prepareStatement(insert_tJDBCOutput_4);

				/**
				 * [tJDBCOutput_4 begin ] stop
				 */

				/**
				 * [tMap_4 begin ] start
				 */

				ok_Hash.put("tMap_4", false);
				start_Hash.put("tMap_4", System.currentTimeMillis());
				currentComponent = "tMap_4";

				int tos_count_tMap_4 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row36Struct> tHash_Lookup_row36 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row36Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row36Struct>) globalMap
						.get("tHash_Lookup_row36"));

				row36Struct row36HashKey = new row36Struct();
				row36Struct row36Default = new row36Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_4__Struct {
				}
				Var__tMap_4__Struct Var__tMap_4 = new Var__tMap_4__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				host_configurationStruct host_configuration_tmp = new host_configurationStruct();
				// ###############################

				/**
				 * [tMap_4 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());
				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_4) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_4 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_4 = dataSources_tJDBCInput_4.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_4);
				}

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT     host_id,     host_unique_id,     host_name,     cluster_id,    upper(cast(cluster_id as char(36))) as cluster_join_id,      host_type,     fqdn_or_ip,     memory_size_mb,     swap_size_mb,     cpu_model,    number_of_cores,    number_of_sockets,   cpu_speed_mh,    host_os,     pm_ip_address,     kernel_version,     kvm_version,     vdsm_version,     vdsm_port,     create_date,     update_date  FROM dwh_host_configuration_history_view";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);

				java.sql.ResultSet rs_tJDBCInput_4 = stmt_tJDBCInput_4
						.executeQuery(dbquery_tJDBCInput_4);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
						.getMetaData();
				int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
						.getColumnCount();

				String tmpContent_tJDBCInput_4 = null;
				int column_index_tJDBCInput_4 = 1;
				while (rs_tJDBCInput_4.next()) {
					nb_line_tJDBCInput_4++;

					column_index_tJDBCInput_4 = 1;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.host_id = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.host_id = rs_tJDBCInput_4
									.getObject(column_index_tJDBCInput_4);
						} else {
							row7.host_id = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.host_id = null;
						}
					}
					column_index_tJDBCInput_4 = 2;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.host_unique_id = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.host_unique_id = tmpContent_tJDBCInput_4;
						} else {
							row7.host_unique_id = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.host_unique_id = null;
						}
					}
					column_index_tJDBCInput_4 = 3;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.host_name = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.host_name = tmpContent_tJDBCInput_4;
						} else {
							row7.host_name = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.host_name = null;
						}
					}
					column_index_tJDBCInput_4 = 4;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.cluster_id = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.cluster_id = rs_tJDBCInput_4
									.getObject(column_index_tJDBCInput_4);
						} else {
							row7.cluster_id = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.cluster_id = null;
						}
					}
					column_index_tJDBCInput_4 = 5;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.cluster_join_id = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.cluster_join_id = tmpContent_tJDBCInput_4;
						} else {
							row7.cluster_join_id = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.cluster_join_id = null;
						}
					}
					column_index_tJDBCInput_4 = 6;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.host_type = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.host_type = rs_tJDBCInput_4
									.getShort(column_index_tJDBCInput_4);
						} else {
							row7.host_type = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.host_type = null;
						}
					}
					column_index_tJDBCInput_4 = 7;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.fqdn_or_ip = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.fqdn_or_ip = tmpContent_tJDBCInput_4;
						} else {
							row7.fqdn_or_ip = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.fqdn_or_ip = null;
						}
					}
					column_index_tJDBCInput_4 = 8;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.memory_size_mb = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.memory_size_mb = rs_tJDBCInput_4
									.getInt(column_index_tJDBCInput_4);
						} else {
							row7.memory_size_mb = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.memory_size_mb = null;
						}
					}
					column_index_tJDBCInput_4 = 9;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.swap_size_mb = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.swap_size_mb = rs_tJDBCInput_4
									.getInt(column_index_tJDBCInput_4);
						} else {
							row7.swap_size_mb = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.swap_size_mb = null;
						}
					}
					column_index_tJDBCInput_4 = 10;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.cpu_model = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.cpu_model = tmpContent_tJDBCInput_4;
						} else {
							row7.cpu_model = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.cpu_model = null;
						}
					}
					column_index_tJDBCInput_4 = 11;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.number_of_cores = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.number_of_cores = rs_tJDBCInput_4
									.getShort(column_index_tJDBCInput_4);
						} else {
							row7.number_of_cores = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.number_of_cores = null;
						}
					}
					column_index_tJDBCInput_4 = 12;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.number_of_sockets = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.number_of_sockets = rs_tJDBCInput_4
									.getShort(column_index_tJDBCInput_4);
						} else {
							row7.number_of_sockets = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.number_of_sockets = null;
						}
					}
					column_index_tJDBCInput_4 = 13;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.cpu_speed_mh = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.cpu_speed_mh = rs_tJDBCInput_4
									.getDouble(column_index_tJDBCInput_4);
						} else {
							row7.cpu_speed_mh = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.cpu_speed_mh = null;
						}
					}
					column_index_tJDBCInput_4 = 14;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.host_os = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.host_os = tmpContent_tJDBCInput_4;
						} else {
							row7.host_os = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.host_os = null;
						}
					}
					column_index_tJDBCInput_4 = 15;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.pm_ip_address = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.pm_ip_address = tmpContent_tJDBCInput_4;
						} else {
							row7.pm_ip_address = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.pm_ip_address = null;
						}
					}
					column_index_tJDBCInput_4 = 16;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.kernel_version = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.kernel_version = tmpContent_tJDBCInput_4;
						} else {
							row7.kernel_version = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.kernel_version = null;
						}
					}
					column_index_tJDBCInput_4 = 17;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.kvm_version = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.kvm_version = tmpContent_tJDBCInput_4;
						} else {
							row7.kvm_version = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.kvm_version = null;
						}
					}
					column_index_tJDBCInput_4 = 18;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.vdsm_version = null;
					} else {

						tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
								.getString(column_index_tJDBCInput_4);
						if (tmpContent_tJDBCInput_4 != null) {
							row7.vdsm_version = tmpContent_tJDBCInput_4;
						} else {
							row7.vdsm_version = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.vdsm_version = null;
						}
					}
					column_index_tJDBCInput_4 = 19;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.vdsm_port = null;
					} else {

						if (rs_tJDBCInput_4
								.getObject(column_index_tJDBCInput_4) != null) {
							row7.vdsm_port = rs_tJDBCInput_4
									.getInt(column_index_tJDBCInput_4);
						} else {
							row7.vdsm_port = null;
						}

						if (rs_tJDBCInput_4.wasNull()) {
							row7.vdsm_port = null;
						}
					}
					column_index_tJDBCInput_4 = 20;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_4 = null;
						try {
							date_tJDBCInput_4 = rs_tJDBCInput_4
									.getTimestamp(column_index_tJDBCInput_4);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_4 = rs_tJDBCInput_4
									.getDate(column_index_tJDBCInput_4);
						}
						row7.create_date = date_tJDBCInput_4;

						if (rs_tJDBCInput_4.wasNull()) {
							row7.create_date = null;
						}
					}
					column_index_tJDBCInput_4 = 21;

					if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
						row7.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_4 = null;
						try {
							date_tJDBCInput_4 = rs_tJDBCInput_4
									.getTimestamp(column_index_tJDBCInput_4);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_4 = rs_tJDBCInput_4
									.getDate(column_index_tJDBCInput_4);
						}
						row7.update_date = date_tJDBCInput_4;

						if (rs_tJDBCInput_4.wasNull()) {
							row7.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_4 begin ] stop
					 */
					/**
					 * [tJDBCInput_4 main ] start
					 */

					currentComponent = "tJDBCInput_4";

					tos_count_tJDBCInput_4++;

					/**
					 * [tJDBCInput_4 main ] stop
					 */

					/**
					 * [tMap_4 main ] start
					 */

					currentComponent = "tMap_4";

					boolean hasCasePrimitiveKeyWithNull_tMap_4 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_4 = false;
					boolean mainRowRejected_tMap_4 = false;

					if (

					(

					row7.update_date == null ? TalendDate.compareDate(
							row7.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row7.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row7'

						// /////////////////////////////////////////////
						// Starting Lookup Table "row36"
						// /////////////////////////////////////////////

						boolean forceLooprow36 = false;

						row36Struct row36ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_4) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_4 = false;

							row36HashKey.cluster_join_id = row7.cluster_join_id;

							row36HashKey.hashCodeDirty = true;

							tHash_Lookup_row36.lookup(row36HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row36 != null
								&& tHash_Lookup_row36.getCount(row36HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row36' and it contains more one result from keys :  row36.cluster_join_id = '"
							// + row36HashKey.cluster_join_id + "'");
						} // G 071

						row36Struct row36 = null;

						row36Struct fromLookup_row36 = null;
						row36 = row36Default;

						if (tHash_Lookup_row36 != null
								&& tHash_Lookup_row36.hasNext()) { // G 099

							fromLookup_row36 = tHash_Lookup_row36.next();

						} // G 099

						if (fromLookup_row36 != null) {
							row36 = fromLookup_row36;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_4__Struct Var = Var__tMap_4;// ###############################
							// ###############################
							// # Output tables

							host_configuration = null;

							// # Output table : 'host_configuration'
							host_configuration_tmp.host_id = row7.host_id;
							host_configuration_tmp.host_unique_id = StringHandling
									.TRIM(row7.host_unique_id);
							host_configuration_tmp.host_name = StringHandling
									.TRIM(row7.host_name);
							host_configuration_tmp.cluster_id = row7.cluster_id;
							host_configuration_tmp.host_type = row7.host_type;
							host_configuration_tmp.fqdn_or_ip = StringHandling
									.TRIM(row7.fqdn_or_ip);
							host_configuration_tmp.memory_size_mb = row7.memory_size_mb;
							host_configuration_tmp.swap_size_mb = row7.swap_size_mb;
							host_configuration_tmp.cpu_model = StringHandling
									.TRIM(row7.cpu_model);
							host_configuration_tmp.number_of_cores = row7.number_of_cores;
							host_configuration_tmp.number_of_sockets = row7.number_of_sockets;
							host_configuration_tmp.cpu_speed_mh = row7.cpu_speed_mh;
							host_configuration_tmp.host_os = StringHandling
									.TRIM(row7.host_os);
							host_configuration_tmp.pm_ip_address = StringHandling
									.TRIM(row7.pm_ip_address);
							host_configuration_tmp.kernel_version = StringHandling
									.TRIM(row7.kernel_version);
							host_configuration_tmp.kvm_version = StringHandling
									.TRIM(row7.kvm_version);
							host_configuration_tmp.vdsm_version = StringHandling
									.TRIM(row7.vdsm_version);
							host_configuration_tmp.vdsm_port = row7.vdsm_port;
							host_configuration_tmp.cluster_configuration_version = row36.history_id;
							host_configuration_tmp.create_date = row7.create_date;
							host_configuration_tmp.update_date = row7.update_date;
							host_configuration_tmp.delete_date = null;
							host_configuration = host_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_4 = false;

						tos_count_tMap_4++;

						/**
						 * [tMap_4 main ] stop
						 */
						// Start of branch "host_configuration"
						if (host_configuration != null) {

							/**
							 * [tJDBCOutput_4 main ] start
							 */

							currentComponent = "tJDBCOutput_4";

							whetherReject_tJDBCOutput_4 = false;
							if (host_configuration.host_id == null) {
								pstmt_tJDBCOutput_4.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_4.setObject(1,
										host_configuration.host_id);
							}

							if (host_configuration.host_unique_id == null) {
								pstmt_tJDBCOutput_4.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(2,
										host_configuration.host_unique_id);
							}

							if (host_configuration.host_name == null) {
								pstmt_tJDBCOutput_4.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(3,
										host_configuration.host_name);
							}

							if (host_configuration.cluster_id == null) {
								pstmt_tJDBCOutput_4.setNull(4,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_4.setObject(4,
										host_configuration.cluster_id);
							}

							pstmt_tJDBCOutput_4.setShort(5,
									host_configuration.host_type);

							if (host_configuration.fqdn_or_ip == null) {
								pstmt_tJDBCOutput_4.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(6,
										host_configuration.fqdn_or_ip);
							}

							if (host_configuration.memory_size_mb == null) {
								pstmt_tJDBCOutput_4.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4.setInt(7,
										host_configuration.memory_size_mb);
							}

							if (host_configuration.swap_size_mb == null) {
								pstmt_tJDBCOutput_4.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4.setInt(8,
										host_configuration.swap_size_mb);
							}

							if (host_configuration.cpu_model == null) {
								pstmt_tJDBCOutput_4.setNull(9,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(9,
										host_configuration.cpu_model);
							}

							if (host_configuration.number_of_cores == null) {
								pstmt_tJDBCOutput_4.setNull(10,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4.setShort(10,
										host_configuration.number_of_cores);
							}

							if (host_configuration.number_of_sockets == null) {
								pstmt_tJDBCOutput_4.setNull(11,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4.setShort(11,
										host_configuration.number_of_sockets);
							}

							if (host_configuration.cpu_speed_mh == null) {
								pstmt_tJDBCOutput_4.setNull(12,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_4.setDouble(12,
										host_configuration.cpu_speed_mh);
							}

							if (host_configuration.host_os == null) {
								pstmt_tJDBCOutput_4.setNull(13,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(13,
										host_configuration.host_os);
							}

							if (host_configuration.pm_ip_address == null) {
								pstmt_tJDBCOutput_4.setNull(14,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(14,
										host_configuration.pm_ip_address);
							}

							if (host_configuration.kernel_version == null) {
								pstmt_tJDBCOutput_4.setNull(15,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(15,
										host_configuration.kernel_version);
							}

							if (host_configuration.kvm_version == null) {
								pstmt_tJDBCOutput_4.setNull(16,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(16,
										host_configuration.kvm_version);
							}

							if (host_configuration.vdsm_version == null) {
								pstmt_tJDBCOutput_4.setNull(17,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_4.setString(17,
										host_configuration.vdsm_version);
							}

							pstmt_tJDBCOutput_4.setInt(18,
									host_configuration.vdsm_port);

							if (host_configuration.cluster_configuration_version == null) {
								pstmt_tJDBCOutput_4.setNull(19,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_4
										.setInt(19,
												host_configuration.cluster_configuration_version);
							}

							if (host_configuration.create_date != null) {
								pstmt_tJDBCOutput_4.setTimestamp(
										20,
										new java.sql.Timestamp(
												host_configuration.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_4.setNull(20,
										java.sql.Types.DATE);
							}

							if (host_configuration.update_date != null) {
								pstmt_tJDBCOutput_4.setTimestamp(
										21,
										new java.sql.Timestamp(
												host_configuration.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_4.setNull(21,
										java.sql.Types.DATE);
							}

							if (host_configuration.delete_date != null) {
								pstmt_tJDBCOutput_4.setTimestamp(
										22,
										new java.sql.Timestamp(
												host_configuration.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_4.setNull(22,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_4 = insertedCount_tJDBCOutput_4
										+ pstmt_tJDBCOutput_4.executeUpdate();
								nb_line_tJDBCOutput_4++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_4 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_4++;

							/**
							 * [tJDBCOutput_4 main ] stop
							 */

						} // End of branch "host_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row7'

					/**
					 * [tJDBCInput_4 end ] start
					 */

					currentComponent = "tJDBCInput_4";

				}
				rs_tJDBCInput_4.close();
				stmt_tJDBCInput_4.close();

				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tMap_4 end ] start
				 */

				currentComponent = "tMap_4";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row36 != null) {
					tHash_Lookup_row36.endGet();
				}
				globalMap.remove("tHash_Lookup_row36");

				// ###############################

				ok_Hash.put("tMap_4", true);
				end_Hash.put("tMap_4", System.currentTimeMillis());

				/**
				 * [tMap_4 end ] stop
				 */

				/**
				 * [tJDBCOutput_4 end ] start
				 */

				currentComponent = "tJDBCOutput_4";

				if (pstmt_tJDBCOutput_4 != null) {

					pstmt_tJDBCOutput_4.close();

				}

				nb_line_deleted_tJDBCOutput_4 = nb_line_deleted_tJDBCOutput_4
						+ deletedCount_tJDBCOutput_4;
				nb_line_update_tJDBCOutput_4 = nb_line_update_tJDBCOutput_4
						+ updatedCount_tJDBCOutput_4;
				nb_line_inserted_tJDBCOutput_4 = nb_line_inserted_tJDBCOutput_4
						+ insertedCount_tJDBCOutput_4;
				nb_line_rejected_tJDBCOutput_4 = nb_line_rejected_tJDBCOutput_4
						+ rejectedCount_tJDBCOutput_4;

				globalMap.put("tJDBCOutput_4_NB_LINE", nb_line_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_4);

				ok_Hash.put("tJDBCOutput_4", true);
				end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_4 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_4:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_22Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_4"
			globalMap.remove("tHash_Lookup_row36");

		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class delete_hostsStruct implements
			routines.system.IPersistableRow<delete_hostsStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public short host_type;

		public short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String pm_ip_address;

		public String getPm_ip_address() {
			return this.pm_ip_address;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public int vdsm_port;

		public int getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.host_type = dis.readShort();

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.pm_ip_address = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = dis.readInt();

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// short

				dos.writeShort(this.host_type);

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.pm_ip_address, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// int

				dos.writeInt(this.vdsm_port);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",pm_ip_address=" + pm_ip_address);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_hostsStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row21Struct implements
			routines.system.IPersistableRow<row21Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String pm_ip_address;

		public String getPm_ip_address() {
			return this.pm_ip_address;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.pm_ip_address = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.pm_ip_address, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",pm_ip_address=" + pm_ip_address);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row21Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_22Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_22Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String pm_ip_address;

		public String getPm_ip_address() {
			return this.pm_ip_address;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.pm_ip_address = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.pm_ip_address, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",pm_ip_address=" + pm_ip_address);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_22Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_22Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_21Process(globalMap);

				row21Struct row21 = new row21Struct();
				delete_hostsStruct delete_hosts = new delete_hostsStruct();

				/**
				 * [tJDBCOutput_17 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_17", false);
				start_Hash.put("tJDBCOutput_17", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_17";

				int tos_count_tJDBCOutput_17 = 0;

				int nb_line_tJDBCOutput_17 = 0;
				int nb_line_update_tJDBCOutput_17 = 0;
				int nb_line_inserted_tJDBCOutput_17 = 0;
				int nb_line_deleted_tJDBCOutput_17 = 0;
				int nb_line_rejected_tJDBCOutput_17 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_17 = 0;

				int deletedCount_tJDBCOutput_17 = 0;
				int updatedCount_tJDBCOutput_17 = 0;
				int insertedCount_tJDBCOutput_17 = 0;
				int rejectedCount_tJDBCOutput_17 = 0;

				boolean whetherReject_tJDBCOutput_17 = false;

				java.sql.Connection connection_tJDBCOutput_17 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_17) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_17 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_17 = dataSources_tJDBCOutput_17.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_17 = 10000;
				int batchSizeCounter_tJDBCOutput_17 = 0;

				String insert_tJDBCOutput_17 = "INSERT INTO "
						+ "host_configuration"
						+ " (host_id,host_unique_id,host_name,cluster_id,host_type,fqdn_or_ip,memory_size_mb,swap_size_mb,cpu_model,number_of_cores,number_of_sockets,cpu_speed_mh,host_os,pm_ip_address,kernel_version,kvm_version,vdsm_version,vdsm_port,cluster_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_17 = connection_tJDBCOutput_17
						.prepareStatement(insert_tJDBCOutput_17);

				/**
				 * [tJDBCOutput_17 begin ] stop
				 */

				/**
				 * [tMap_17 begin ] start
				 */

				ok_Hash.put("tMap_17", false);
				start_Hash.put("tMap_17", System.currentTimeMillis());
				currentComponent = "tMap_17";

				int tos_count_tMap_17 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row20Struct> tHash_Lookup_row20 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row20Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row20Struct>) globalMap
						.get("tHash_Lookup_row20"));

				row20Struct row20HashKey = new row20Struct();
				row20Struct row20Default = new row20Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_17__Struct {
				}
				Var__tMap_17__Struct Var__tMap_17 = new Var__tMap_17__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_hostsStruct delete_hosts_tmp = new delete_hostsStruct();
				// ###############################

				/**
				 * [tMap_17 begin ] stop
				 */

				/**
				 * [tJDBCInput_22 begin ] start
				 */

				ok_Hash.put("tJDBCInput_22", false);
				start_Hash.put("tJDBCInput_22", System.currentTimeMillis());
				currentComponent = "tJDBCInput_22";

				int tos_count_tJDBCInput_22 = 0;

				int nb_line_tJDBCInput_22 = 0;
				java.sql.Connection conn_tJDBCInput_22 = null;
				conn_tJDBCInput_22 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_22) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_22 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_22 = dataSources_tJDBCInput_22.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_22);
				}

				java.sql.Statement stmt_tJDBCInput_22 = conn_tJDBCInput_22
						.createStatement();

				String dbquery_tJDBCInput_22 = "SELECT history_id,   		host_id,   		upper(cast(host_id as char(36))) as host_join_id,  		host_unique_id,   		host_name,   		cluster_id,   		host_type,   		fqdn_or_ip,   		memory_size_mb,   		swap_size_mb,  		cpu_model,   		number_of_cores,          number_of_sockets,         cpu_speed_mh,  		host_os,   		pm_ip_address,  		kernel_version,   		kvm_version,   		vdsm_version,   		vdsm_port,   		cluster_configuration_version,   		create_date,   		update_date  FROM v3_3_latest_configuration_hosts";

				globalMap.put("tJDBCInput_22_QUERY", dbquery_tJDBCInput_22);

				java.sql.ResultSet rs_tJDBCInput_22 = stmt_tJDBCInput_22
						.executeQuery(dbquery_tJDBCInput_22);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_22 = rs_tJDBCInput_22
						.getMetaData();
				int colQtyInRs_tJDBCInput_22 = rsmd_tJDBCInput_22
						.getColumnCount();

				String tmpContent_tJDBCInput_22 = null;
				int column_index_tJDBCInput_22 = 1;
				while (rs_tJDBCInput_22.next()) {
					nb_line_tJDBCInput_22++;

					column_index_tJDBCInput_22 = 1;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.history_id = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.history_id = rs_tJDBCInput_22
									.getInt(column_index_tJDBCInput_22);
						} else {
							row21.history_id = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.history_id = null;
						}
					}
					column_index_tJDBCInput_22 = 2;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.host_id = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.host_id = rs_tJDBCInput_22
									.getObject(column_index_tJDBCInput_22);
						} else {
							row21.host_id = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.host_id = null;
						}
					}
					column_index_tJDBCInput_22 = 3;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.host_join_id = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.host_join_id = tmpContent_tJDBCInput_22;
						} else {
							row21.host_join_id = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.host_join_id = null;
						}
					}
					column_index_tJDBCInput_22 = 4;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.host_unique_id = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.host_unique_id = tmpContent_tJDBCInput_22;
						} else {
							row21.host_unique_id = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.host_unique_id = null;
						}
					}
					column_index_tJDBCInput_22 = 5;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.host_name = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.host_name = tmpContent_tJDBCInput_22;
						} else {
							row21.host_name = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.host_name = null;
						}
					}
					column_index_tJDBCInput_22 = 6;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.cluster_id = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.cluster_id = rs_tJDBCInput_22
									.getObject(column_index_tJDBCInput_22);
						} else {
							row21.cluster_id = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.cluster_id = null;
						}
					}
					column_index_tJDBCInput_22 = 7;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.host_type = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.host_type = rs_tJDBCInput_22
									.getShort(column_index_tJDBCInput_22);
						} else {
							row21.host_type = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.host_type = null;
						}
					}
					column_index_tJDBCInput_22 = 8;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.fqdn_or_ip = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.fqdn_or_ip = tmpContent_tJDBCInput_22;
						} else {
							row21.fqdn_or_ip = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.fqdn_or_ip = null;
						}
					}
					column_index_tJDBCInput_22 = 9;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.memory_size_mb = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.memory_size_mb = rs_tJDBCInput_22
									.getInt(column_index_tJDBCInput_22);
						} else {
							row21.memory_size_mb = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.memory_size_mb = null;
						}
					}
					column_index_tJDBCInput_22 = 10;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.swap_size_mb = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.swap_size_mb = rs_tJDBCInput_22
									.getInt(column_index_tJDBCInput_22);
						} else {
							row21.swap_size_mb = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.swap_size_mb = null;
						}
					}
					column_index_tJDBCInput_22 = 11;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.cpu_model = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.cpu_model = tmpContent_tJDBCInput_22;
						} else {
							row21.cpu_model = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.cpu_model = null;
						}
					}
					column_index_tJDBCInput_22 = 12;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.number_of_cores = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.number_of_cores = rs_tJDBCInput_22
									.getShort(column_index_tJDBCInput_22);
						} else {
							row21.number_of_cores = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.number_of_cores = null;
						}
					}
					column_index_tJDBCInput_22 = 13;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.number_of_sockets = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.number_of_sockets = rs_tJDBCInput_22
									.getShort(column_index_tJDBCInput_22);
						} else {
							row21.number_of_sockets = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.number_of_sockets = null;
						}
					}
					column_index_tJDBCInput_22 = 14;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.cpu_speed_mh = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.cpu_speed_mh = rs_tJDBCInput_22
									.getDouble(column_index_tJDBCInput_22);
						} else {
							row21.cpu_speed_mh = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.cpu_speed_mh = null;
						}
					}
					column_index_tJDBCInput_22 = 15;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.host_os = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.host_os = tmpContent_tJDBCInput_22;
						} else {
							row21.host_os = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.host_os = null;
						}
					}
					column_index_tJDBCInput_22 = 16;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.pm_ip_address = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.pm_ip_address = tmpContent_tJDBCInput_22;
						} else {
							row21.pm_ip_address = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.pm_ip_address = null;
						}
					}
					column_index_tJDBCInput_22 = 17;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.kernel_version = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.kernel_version = tmpContent_tJDBCInput_22;
						} else {
							row21.kernel_version = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.kernel_version = null;
						}
					}
					column_index_tJDBCInput_22 = 18;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.kvm_version = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.kvm_version = tmpContent_tJDBCInput_22;
						} else {
							row21.kvm_version = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.kvm_version = null;
						}
					}
					column_index_tJDBCInput_22 = 19;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.vdsm_version = null;
					} else {

						tmpContent_tJDBCInput_22 = rs_tJDBCInput_22
								.getString(column_index_tJDBCInput_22);
						if (tmpContent_tJDBCInput_22 != null) {
							row21.vdsm_version = tmpContent_tJDBCInput_22;
						} else {
							row21.vdsm_version = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.vdsm_version = null;
						}
					}
					column_index_tJDBCInput_22 = 20;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.vdsm_port = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.vdsm_port = rs_tJDBCInput_22
									.getInt(column_index_tJDBCInput_22);
						} else {
							row21.vdsm_port = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.vdsm_port = null;
						}
					}
					column_index_tJDBCInput_22 = 21;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.cluster_configuration_version = null;
					} else {

						if (rs_tJDBCInput_22
								.getObject(column_index_tJDBCInput_22) != null) {
							row21.cluster_configuration_version = rs_tJDBCInput_22
									.getInt(column_index_tJDBCInput_22);
						} else {
							row21.cluster_configuration_version = null;
						}

						if (rs_tJDBCInput_22.wasNull()) {
							row21.cluster_configuration_version = null;
						}
					}
					column_index_tJDBCInput_22 = 22;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_22 = null;
						try {
							date_tJDBCInput_22 = rs_tJDBCInput_22
									.getTimestamp(column_index_tJDBCInput_22);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_22 = rs_tJDBCInput_22
									.getDate(column_index_tJDBCInput_22);
						}
						row21.create_date = date_tJDBCInput_22;

						if (rs_tJDBCInput_22.wasNull()) {
							row21.create_date = null;
						}
					}
					column_index_tJDBCInput_22 = 23;

					if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
						row21.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_22 = null;
						try {
							date_tJDBCInput_22 = rs_tJDBCInput_22
									.getTimestamp(column_index_tJDBCInput_22);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_22 = rs_tJDBCInput_22
									.getDate(column_index_tJDBCInput_22);
						}
						row21.update_date = date_tJDBCInput_22;

						if (rs_tJDBCInput_22.wasNull()) {
							row21.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_22 begin ] stop
					 */
					/**
					 * [tJDBCInput_22 main ] start
					 */

					currentComponent = "tJDBCInput_22";

					tos_count_tJDBCInput_22++;

					/**
					 * [tJDBCInput_22 main ] stop
					 */

					/**
					 * [tMap_17 main ] start
					 */

					currentComponent = "tMap_17";

					boolean hasCasePrimitiveKeyWithNull_tMap_17 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_17 = false;
					boolean mainRowRejected_tMap_17 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row20"
					// /////////////////////////////////////////////

					boolean forceLooprow20 = false;

					row20Struct row20ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_17) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_17 = false;

						row20HashKey.host_join_id = row21.host_join_id;

						row20HashKey.hashCodeDirty = true;

						tHash_Lookup_row20.lookup(row20HashKey);

						if (!tHash_Lookup_row20.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_17 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row20 != null
							&& tHash_Lookup_row20.getCount(row20HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row20' and it contains more one result from keys :  row20.host_join_id = '"
						// + row20HashKey.host_join_id + "'");
					} // G 071

					row20Struct row20 = null;

					row20Struct fromLookup_row20 = null;
					row20 = row20Default;

					if (tHash_Lookup_row20 != null
							&& tHash_Lookup_row20.hasNext()) { // G 099

						fromLookup_row20 = tHash_Lookup_row20.next();

					} // G 099

					if (fromLookup_row20 != null) {
						row20 = fromLookup_row20;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_17__Struct Var = Var__tMap_17;// ###############################
						// ###############################
						// # Output tables

						delete_hosts = null;

						if (!rejectedInnerJoin_tMap_17) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_hosts'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_17) {
							delete_hosts_tmp.host_id = row21.host_id;
							delete_hosts_tmp.host_unique_id = row21.host_unique_id;
							delete_hosts_tmp.host_name = row21.host_name;
							delete_hosts_tmp.cluster_id = row21.cluster_id;
							delete_hosts_tmp.host_type = row21.host_type;
							delete_hosts_tmp.fqdn_or_ip = row21.fqdn_or_ip;
							delete_hosts_tmp.memory_size_mb = row21.memory_size_mb;
							delete_hosts_tmp.swap_size_mb = row21.swap_size_mb;
							delete_hosts_tmp.cpu_model = row21.cpu_model;
							delete_hosts_tmp.number_of_cores = row21.number_of_cores;
							delete_hosts_tmp.number_of_sockets = row21.number_of_sockets;
							delete_hosts_tmp.cpu_speed_mh = row21.cpu_speed_mh;
							delete_hosts_tmp.host_os = row21.host_os;
							delete_hosts_tmp.pm_ip_address = row21.pm_ip_address;
							delete_hosts_tmp.kernel_version = row21.kernel_version;
							delete_hosts_tmp.kvm_version = row21.kvm_version;
							delete_hosts_tmp.vdsm_version = row21.vdsm_version;
							delete_hosts_tmp.vdsm_port = row21.vdsm_port;
							delete_hosts_tmp.cluster_configuration_version = row21.cluster_configuration_version;
							delete_hosts_tmp.create_date = row21.create_date;
							delete_hosts_tmp.update_date = context.runTime;
							delete_hosts_tmp.delete_date = context.runTime;
							delete_hosts = delete_hosts_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_17 = false;

					tos_count_tMap_17++;

					/**
					 * [tMap_17 main ] stop
					 */
					// Start of branch "delete_hosts"
					if (delete_hosts != null) {

						/**
						 * [tJDBCOutput_17 main ] start
						 */

						currentComponent = "tJDBCOutput_17";

						whetherReject_tJDBCOutput_17 = false;
						if (delete_hosts.host_id == null) {
							pstmt_tJDBCOutput_17.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_17.setObject(1,
									delete_hosts.host_id);
						}

						if (delete_hosts.host_unique_id == null) {
							pstmt_tJDBCOutput_17.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(2,
									delete_hosts.host_unique_id);
						}

						if (delete_hosts.host_name == null) {
							pstmt_tJDBCOutput_17.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(3,
									delete_hosts.host_name);
						}

						if (delete_hosts.cluster_id == null) {
							pstmt_tJDBCOutput_17.setNull(4,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_17.setObject(4,
									delete_hosts.cluster_id);
						}

						pstmt_tJDBCOutput_17
								.setShort(5, delete_hosts.host_type);

						if (delete_hosts.fqdn_or_ip == null) {
							pstmt_tJDBCOutput_17.setNull(6,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(6,
									delete_hosts.fqdn_or_ip);
						}

						if (delete_hosts.memory_size_mb == null) {
							pstmt_tJDBCOutput_17.setNull(7,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_17.setInt(7,
									delete_hosts.memory_size_mb);
						}

						if (delete_hosts.swap_size_mb == null) {
							pstmt_tJDBCOutput_17.setNull(8,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_17.setInt(8,
									delete_hosts.swap_size_mb);
						}

						if (delete_hosts.cpu_model == null) {
							pstmt_tJDBCOutput_17.setNull(9,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(9,
									delete_hosts.cpu_model);
						}

						if (delete_hosts.number_of_cores == null) {
							pstmt_tJDBCOutput_17.setNull(10,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_17.setShort(10,
									delete_hosts.number_of_cores);
						}

						if (delete_hosts.number_of_sockets == null) {
							pstmt_tJDBCOutput_17.setNull(11,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_17.setShort(11,
									delete_hosts.number_of_sockets);
						}

						if (delete_hosts.cpu_speed_mh == null) {
							pstmt_tJDBCOutput_17.setNull(12,
									java.sql.Types.DOUBLE);
						} else {
							pstmt_tJDBCOutput_17.setDouble(12,
									delete_hosts.cpu_speed_mh);
						}

						if (delete_hosts.host_os == null) {
							pstmt_tJDBCOutput_17.setNull(13,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(13,
									delete_hosts.host_os);
						}

						if (delete_hosts.pm_ip_address == null) {
							pstmt_tJDBCOutput_17.setNull(14,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(14,
									delete_hosts.pm_ip_address);
						}

						if (delete_hosts.kernel_version == null) {
							pstmt_tJDBCOutput_17.setNull(15,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(15,
									delete_hosts.kernel_version);
						}

						if (delete_hosts.kvm_version == null) {
							pstmt_tJDBCOutput_17.setNull(16,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(16,
									delete_hosts.kvm_version);
						}

						if (delete_hosts.vdsm_version == null) {
							pstmt_tJDBCOutput_17.setNull(17,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_17.setString(17,
									delete_hosts.vdsm_version);
						}

						pstmt_tJDBCOutput_17.setInt(18, delete_hosts.vdsm_port);

						if (delete_hosts.cluster_configuration_version == null) {
							pstmt_tJDBCOutput_17.setNull(19,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_17.setInt(19,
									delete_hosts.cluster_configuration_version);
						}

						if (delete_hosts.create_date != null) {
							pstmt_tJDBCOutput_17
									.setTimestamp(20, new java.sql.Timestamp(
											delete_hosts.create_date.getTime()));
						} else {
							pstmt_tJDBCOutput_17.setNull(20,
									java.sql.Types.DATE);
						}

						if (delete_hosts.update_date != null) {
							pstmt_tJDBCOutput_17
									.setTimestamp(21, new java.sql.Timestamp(
											delete_hosts.update_date.getTime()));
						} else {
							pstmt_tJDBCOutput_17.setNull(21,
									java.sql.Types.DATE);
						}

						if (delete_hosts.delete_date != null) {
							pstmt_tJDBCOutput_17
									.setTimestamp(22, new java.sql.Timestamp(
											delete_hosts.delete_date.getTime()));
						} else {
							pstmt_tJDBCOutput_17.setNull(22,
									java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_17 = insertedCount_tJDBCOutput_17
									+ pstmt_tJDBCOutput_17.executeUpdate();
							nb_line_tJDBCOutput_17++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_17 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_17++;

						/**
						 * [tJDBCOutput_17 main ] stop
						 */

					} // End of branch "delete_hosts"

					/**
					 * [tJDBCInput_22 end ] start
					 */

					currentComponent = "tJDBCInput_22";

				}
				rs_tJDBCInput_22.close();
				stmt_tJDBCInput_22.close();

				globalMap.put("tJDBCInput_22_NB_LINE", nb_line_tJDBCInput_22);

				ok_Hash.put("tJDBCInput_22", true);
				end_Hash.put("tJDBCInput_22", System.currentTimeMillis());

				/**
				 * [tJDBCInput_22 end ] stop
				 */

				/**
				 * [tMap_17 end ] start
				 */

				currentComponent = "tMap_17";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row20 != null) {
					tHash_Lookup_row20.endGet();
				}
				globalMap.remove("tHash_Lookup_row20");

				// ###############################

				ok_Hash.put("tMap_17", true);
				end_Hash.put("tMap_17", System.currentTimeMillis());

				/**
				 * [tMap_17 end ] stop
				 */

				/**
				 * [tJDBCOutput_17 end ] start
				 */

				currentComponent = "tJDBCOutput_17";

				if (pstmt_tJDBCOutput_17 != null) {

					pstmt_tJDBCOutput_17.close();

				}

				nb_line_deleted_tJDBCOutput_17 = nb_line_deleted_tJDBCOutput_17
						+ deletedCount_tJDBCOutput_17;
				nb_line_update_tJDBCOutput_17 = nb_line_update_tJDBCOutput_17
						+ updatedCount_tJDBCOutput_17;
				nb_line_inserted_tJDBCOutput_17 = nb_line_inserted_tJDBCOutput_17
						+ insertedCount_tJDBCOutput_17;
				nb_line_rejected_tJDBCOutput_17 = nb_line_rejected_tJDBCOutput_17
						+ rejectedCount_tJDBCOutput_17;

				globalMap.put("tJDBCOutput_17_NB_LINE", nb_line_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_17);

				ok_Hash.put("tJDBCOutput_17", true);
				end_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_17 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_22:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_5Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_17"
			globalMap.remove("tHash_Lookup_row20");

		}

		globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", 1);
	}

	public static class hinterface_configurationStruct implements
			routines.system.IPersistableRow<hinterface_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(hinterface_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_5Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_41Process(globalMap);

				row2Struct row2 = new row2Struct();
				hinterface_configurationStruct hinterface_configuration = new hinterface_configurationStruct();

				/**
				 * [tJDBCOutput_5 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_5", false);
				start_Hash.put("tJDBCOutput_5", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_5";

				int tos_count_tJDBCOutput_5 = 0;

				int nb_line_tJDBCOutput_5 = 0;
				int nb_line_update_tJDBCOutput_5 = 0;
				int nb_line_inserted_tJDBCOutput_5 = 0;
				int nb_line_deleted_tJDBCOutput_5 = 0;
				int nb_line_rejected_tJDBCOutput_5 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_5 = 0;

				int deletedCount_tJDBCOutput_5 = 0;
				int updatedCount_tJDBCOutput_5 = 0;
				int insertedCount_tJDBCOutput_5 = 0;
				int rejectedCount_tJDBCOutput_5 = 0;

				boolean whetherReject_tJDBCOutput_5 = false;

				java.sql.Connection connection_tJDBCOutput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_5) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_5 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_5 = dataSources_tJDBCOutput_5
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_5 = 10000;
				int batchSizeCounter_tJDBCOutput_5 = 0;

				String insert_tJDBCOutput_5 = "INSERT INTO "
						+ "host_interface_configuration"
						+ " (host_interface_id,host_interface_name,host_id,host_interface_type,host_interface_speed_bps,mac_address,network_name,ip_address,gateway,bond,bond_name,vlan_id,host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(insert_tJDBCOutput_5);

				/**
				 * [tJDBCOutput_5 begin ] stop
				 */

				/**
				 * [tMap_5 begin ] start
				 */

				ok_Hash.put("tMap_5", false);
				start_Hash.put("tMap_5", System.currentTimeMillis());
				currentComponent = "tMap_5";

				int tos_count_tMap_5 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row37Struct> tHash_Lookup_row37 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row37Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row37Struct>) globalMap
						.get("tHash_Lookup_row37"));

				row37Struct row37HashKey = new row37Struct();
				row37Struct row37Default = new row37Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_5__Struct {
				}
				Var__tMap_5__Struct Var__tMap_5 = new Var__tMap_5__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				hinterface_configurationStruct hinterface_configuration_tmp = new hinterface_configurationStruct();
				// ###############################

				/**
				 * [tMap_5 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());
				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_5) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_5 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_5 = dataSources_tJDBCInput_5.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_5);
				}

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT     host_interface_id,     host_interface_name,     host_id,     upper(cast(host_id as char(36))) as host_join_id,    host_interface_type,     host_interface_speed_bps,     mac_address,     network_name,     ip_address,     gateway,     bond,     bond_name,     vlan_id,     create_date,     update_date  FROM dwh_host_interface_configuration_history_view";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);

				java.sql.ResultSet rs_tJDBCInput_5 = stmt_tJDBCInput_5
						.executeQuery(dbquery_tJDBCInput_5);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
						.getMetaData();
				int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
						.getColumnCount();

				String tmpContent_tJDBCInput_5 = null;
				int column_index_tJDBCInput_5 = 1;
				while (rs_tJDBCInput_5.next()) {
					nb_line_tJDBCInput_5++;

					column_index_tJDBCInput_5 = 1;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.host_interface_id = null;
					} else {

						if (rs_tJDBCInput_5
								.getObject(column_index_tJDBCInput_5) != null) {
							row2.host_interface_id = rs_tJDBCInput_5
									.getObject(column_index_tJDBCInput_5);
						} else {
							row2.host_interface_id = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.host_interface_id = null;
						}
					}
					column_index_tJDBCInput_5 = 2;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.host_interface_name = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.host_interface_name = tmpContent_tJDBCInput_5;
						} else {
							row2.host_interface_name = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.host_interface_name = null;
						}
					}
					column_index_tJDBCInput_5 = 3;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.host_id = null;
					} else {

						if (rs_tJDBCInput_5
								.getObject(column_index_tJDBCInput_5) != null) {
							row2.host_id = rs_tJDBCInput_5
									.getObject(column_index_tJDBCInput_5);
						} else {
							row2.host_id = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.host_id = null;
						}
					}
					column_index_tJDBCInput_5 = 4;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.host_join_id = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.host_join_id = tmpContent_tJDBCInput_5;
						} else {
							row2.host_join_id = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.host_join_id = null;
						}
					}
					column_index_tJDBCInput_5 = 5;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.host_interface_type = null;
					} else {

						if (rs_tJDBCInput_5
								.getObject(column_index_tJDBCInput_5) != null) {
							row2.host_interface_type = rs_tJDBCInput_5
									.getShort(column_index_tJDBCInput_5);
						} else {
							row2.host_interface_type = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.host_interface_type = null;
						}
					}
					column_index_tJDBCInput_5 = 6;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.host_interface_speed_bps = null;
					} else {

						if (rs_tJDBCInput_5
								.getObject(column_index_tJDBCInput_5) != null) {
							row2.host_interface_speed_bps = rs_tJDBCInput_5
									.getInt(column_index_tJDBCInput_5);
						} else {
							row2.host_interface_speed_bps = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.host_interface_speed_bps = null;
						}
					}
					column_index_tJDBCInput_5 = 7;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.mac_address = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.mac_address = tmpContent_tJDBCInput_5;
						} else {
							row2.mac_address = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.mac_address = null;
						}
					}
					column_index_tJDBCInput_5 = 8;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.network_name = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.network_name = tmpContent_tJDBCInput_5;
						} else {
							row2.network_name = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.network_name = null;
						}
					}
					column_index_tJDBCInput_5 = 9;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.ip_address = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.ip_address = tmpContent_tJDBCInput_5;
						} else {
							row2.ip_address = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.ip_address = null;
						}
					}
					column_index_tJDBCInput_5 = 10;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.gateway = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.gateway = tmpContent_tJDBCInput_5;
						} else {
							row2.gateway = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.gateway = null;
						}
					}
					column_index_tJDBCInput_5 = 11;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.bond = null;
					} else {

						if (rs_tJDBCInput_5
								.getObject(column_index_tJDBCInput_5) != null) {
							row2.bond = rs_tJDBCInput_5
									.getBoolean(column_index_tJDBCInput_5);
						} else {
							row2.bond = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.bond = null;
						}
					}
					column_index_tJDBCInput_5 = 12;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.bond_name = null;
					} else {

						tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
								.getString(column_index_tJDBCInput_5);
						if (tmpContent_tJDBCInput_5 != null) {
							row2.bond_name = tmpContent_tJDBCInput_5;
						} else {
							row2.bond_name = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.bond_name = null;
						}
					}
					column_index_tJDBCInput_5 = 13;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.vlan_id = null;
					} else {

						if (rs_tJDBCInput_5
								.getObject(column_index_tJDBCInput_5) != null) {
							row2.vlan_id = rs_tJDBCInput_5
									.getInt(column_index_tJDBCInput_5);
						} else {
							row2.vlan_id = null;
						}

						if (rs_tJDBCInput_5.wasNull()) {
							row2.vlan_id = null;
						}
					}
					column_index_tJDBCInput_5 = 14;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_5 = null;
						try {
							date_tJDBCInput_5 = rs_tJDBCInput_5
									.getTimestamp(column_index_tJDBCInput_5);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_5 = rs_tJDBCInput_5
									.getDate(column_index_tJDBCInput_5);
						}
						row2.create_date = date_tJDBCInput_5;

						if (rs_tJDBCInput_5.wasNull()) {
							row2.create_date = null;
						}
					}
					column_index_tJDBCInput_5 = 15;

					if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
						row2.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_5 = null;
						try {
							date_tJDBCInput_5 = rs_tJDBCInput_5
									.getTimestamp(column_index_tJDBCInput_5);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_5 = rs_tJDBCInput_5
									.getDate(column_index_tJDBCInput_5);
						}
						row2.update_date = date_tJDBCInput_5;

						if (rs_tJDBCInput_5.wasNull()) {
							row2.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_5 begin ] stop
					 */
					/**
					 * [tJDBCInput_5 main ] start
					 */

					currentComponent = "tJDBCInput_5";

					tos_count_tJDBCInput_5++;

					/**
					 * [tJDBCInput_5 main ] stop
					 */

					/**
					 * [tMap_5 main ] start
					 */

					currentComponent = "tMap_5";

					boolean hasCasePrimitiveKeyWithNull_tMap_5 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_5 = false;
					boolean mainRowRejected_tMap_5 = false;

					if (

					(

					row2.update_date == null ? TalendDate.compareDate(
							row2.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row2.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row2'

						// /////////////////////////////////////////////
						// Starting Lookup Table "row37"
						// /////////////////////////////////////////////

						boolean forceLooprow37 = false;

						row37Struct row37ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_5) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_5 = false;

							row37HashKey.host_join_id = row2.host_join_id;

							row37HashKey.hashCodeDirty = true;

							tHash_Lookup_row37.lookup(row37HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row37 != null
								&& tHash_Lookup_row37.getCount(row37HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row37' and it contains more one result from keys :  row37.host_join_id = '"
							// + row37HashKey.host_join_id + "'");
						} // G 071

						row37Struct row37 = null;

						row37Struct fromLookup_row37 = null;
						row37 = row37Default;

						if (tHash_Lookup_row37 != null
								&& tHash_Lookup_row37.hasNext()) { // G 099

							fromLookup_row37 = tHash_Lookup_row37.next();

						} // G 099

						if (fromLookup_row37 != null) {
							row37 = fromLookup_row37;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_5__Struct Var = Var__tMap_5;// ###############################
							// ###############################
							// # Output tables

							hinterface_configuration = null;

							// # Output table : 'hinterface_configuration'
							hinterface_configuration_tmp.host_interface_id = row2.host_interface_id;
							hinterface_configuration_tmp.host_interface_name = StringHandling
									.TRIM(row2.host_interface_name);
							hinterface_configuration_tmp.host_id = row2.host_id;
							hinterface_configuration_tmp.host_interface_type = row2.host_interface_type;
							hinterface_configuration_tmp.host_interface_speed_bps = row2.host_interface_speed_bps;
							hinterface_configuration_tmp.mac_address = StringHandling
									.TRIM(row2.mac_address);
							hinterface_configuration_tmp.network_name = StringHandling
									.TRIM(row2.network_name);
							hinterface_configuration_tmp.ip_address = StringHandling
									.TRIM(row2.ip_address);
							hinterface_configuration_tmp.gateway = StringHandling
									.TRIM(row2.gateway);
							hinterface_configuration_tmp.bond = row2.bond;
							hinterface_configuration_tmp.bond_name = StringHandling
									.TRIM(row2.bond_name);
							hinterface_configuration_tmp.vlan_id = row2.vlan_id;
							hinterface_configuration_tmp.host_configuration_version = row37.history_id;
							hinterface_configuration_tmp.create_date = row2.create_date;
							hinterface_configuration_tmp.update_date = row2.update_date;
							hinterface_configuration_tmp.delete_date = null;
							hinterface_configuration = hinterface_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_5 = false;

						tos_count_tMap_5++;

						/**
						 * [tMap_5 main ] stop
						 */
						// Start of branch "hinterface_configuration"
						if (hinterface_configuration != null) {

							/**
							 * [tJDBCOutput_5 main ] start
							 */

							currentComponent = "tJDBCOutput_5";

							whetherReject_tJDBCOutput_5 = false;
							if (hinterface_configuration.host_interface_id == null) {
								pstmt_tJDBCOutput_5.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_5
										.setObject(
												1,
												hinterface_configuration.host_interface_id);
							}

							if (hinterface_configuration.host_interface_name == null) {
								pstmt_tJDBCOutput_5.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_5
										.setString(
												2,
												hinterface_configuration.host_interface_name);
							}

							if (hinterface_configuration.host_id == null) {
								pstmt_tJDBCOutput_5.setNull(3,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_5.setObject(3,
										hinterface_configuration.host_id);
							}

							if (hinterface_configuration.host_interface_type == null) {
								pstmt_tJDBCOutput_5.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_5
										.setShort(
												4,
												hinterface_configuration.host_interface_type);
							}

							if (hinterface_configuration.host_interface_speed_bps == null) {
								pstmt_tJDBCOutput_5.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_5
										.setInt(5,
												hinterface_configuration.host_interface_speed_bps);
							}

							if (hinterface_configuration.mac_address == null) {
								pstmt_tJDBCOutput_5.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_5.setString(6,
										hinterface_configuration.mac_address);
							}

							if (hinterface_configuration.network_name == null) {
								pstmt_tJDBCOutput_5.setNull(7,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_5.setString(7,
										hinterface_configuration.network_name);
							}

							if (hinterface_configuration.ip_address == null) {
								pstmt_tJDBCOutput_5.setNull(8,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_5.setString(8,
										hinterface_configuration.ip_address);
							}

							if (hinterface_configuration.gateway == null) {
								pstmt_tJDBCOutput_5.setNull(9,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_5.setString(9,
										hinterface_configuration.gateway);
							}

							if (hinterface_configuration.bond == null) {
								pstmt_tJDBCOutput_5.setNull(10,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_5.setBoolean(10,
										hinterface_configuration.bond);
							}

							if (hinterface_configuration.bond_name == null) {
								pstmt_tJDBCOutput_5.setNull(11,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_5.setString(11,
										hinterface_configuration.bond_name);
							}

							if (hinterface_configuration.vlan_id == null) {
								pstmt_tJDBCOutput_5.setNull(12,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_5.setInt(12,
										hinterface_configuration.vlan_id);
							}

							if (hinterface_configuration.host_configuration_version == null) {
								pstmt_tJDBCOutput_5.setNull(13,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_5
										.setInt(13,
												hinterface_configuration.host_configuration_version);
							}

							if (hinterface_configuration.create_date != null) {
								pstmt_tJDBCOutput_5
										.setTimestamp(
												14,
												new java.sql.Timestamp(
														hinterface_configuration.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_5.setNull(14,
										java.sql.Types.DATE);
							}

							if (hinterface_configuration.update_date != null) {
								pstmt_tJDBCOutput_5
										.setTimestamp(
												15,
												new java.sql.Timestamp(
														hinterface_configuration.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_5.setNull(15,
										java.sql.Types.DATE);
							}

							if (hinterface_configuration.delete_date != null) {
								pstmt_tJDBCOutput_5
										.setTimestamp(
												16,
												new java.sql.Timestamp(
														hinterface_configuration.delete_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_5.setNull(16,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_5 = insertedCount_tJDBCOutput_5
										+ pstmt_tJDBCOutput_5.executeUpdate();
								nb_line_tJDBCOutput_5++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_5 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_5++;

							/**
							 * [tJDBCOutput_5 main ] stop
							 */

						} // End of branch "hinterface_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row2'

					/**
					 * [tJDBCInput_5 end ] start
					 */

					currentComponent = "tJDBCInput_5";

				}
				rs_tJDBCInput_5.close();
				stmt_tJDBCInput_5.close();

				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tMap_5 end ] start
				 */

				currentComponent = "tMap_5";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row37 != null) {
					tHash_Lookup_row37.endGet();
				}
				globalMap.remove("tHash_Lookup_row37");

				// ###############################

				ok_Hash.put("tMap_5", true);
				end_Hash.put("tMap_5", System.currentTimeMillis());

				/**
				 * [tMap_5 end ] stop
				 */

				/**
				 * [tJDBCOutput_5 end ] start
				 */

				currentComponent = "tJDBCOutput_5";

				if (pstmt_tJDBCOutput_5 != null) {

					pstmt_tJDBCOutput_5.close();

				}

				nb_line_deleted_tJDBCOutput_5 = nb_line_deleted_tJDBCOutput_5
						+ deletedCount_tJDBCOutput_5;
				nb_line_update_tJDBCOutput_5 = nb_line_update_tJDBCOutput_5
						+ updatedCount_tJDBCOutput_5;
				nb_line_inserted_tJDBCOutput_5 = nb_line_inserted_tJDBCOutput_5
						+ insertedCount_tJDBCOutput_5;
				nb_line_rejected_tJDBCOutput_5 = nb_line_rejected_tJDBCOutput_5
						+ rejectedCount_tJDBCOutput_5;

				globalMap.put("tJDBCOutput_5_NB_LINE", nb_line_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_5);

				ok_Hash.put("tJDBCOutput_5", true);
				end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_5 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_5:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_24Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_5"
			globalMap.remove("tHash_Lookup_row37");

		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class delete_hinterfaceStruct implements
			routines.system.IPersistableRow<delete_hinterfaceStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_hinterfaceStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row23Struct implements
			routines.system.IPersistableRow<row23Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_join_id = readString(dis);

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_join_id, dos);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row23Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_24Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_24Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_join_id = readString(dis);

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_join_id, dos);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_24Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_24Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_23Process(globalMap);

				row23Struct row23 = new row23Struct();
				delete_hinterfaceStruct delete_hinterface = new delete_hinterfaceStruct();

				/**
				 * [tJDBCOutput_18 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_18", false);
				start_Hash.put("tJDBCOutput_18", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_18";

				int tos_count_tJDBCOutput_18 = 0;

				int nb_line_tJDBCOutput_18 = 0;
				int nb_line_update_tJDBCOutput_18 = 0;
				int nb_line_inserted_tJDBCOutput_18 = 0;
				int nb_line_deleted_tJDBCOutput_18 = 0;
				int nb_line_rejected_tJDBCOutput_18 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_18 = 0;

				int deletedCount_tJDBCOutput_18 = 0;
				int updatedCount_tJDBCOutput_18 = 0;
				int insertedCount_tJDBCOutput_18 = 0;
				int rejectedCount_tJDBCOutput_18 = 0;

				boolean whetherReject_tJDBCOutput_18 = false;

				java.sql.Connection connection_tJDBCOutput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_18) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_18 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_18 = dataSources_tJDBCOutput_18.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_18 = 10000;
				int batchSizeCounter_tJDBCOutput_18 = 0;

				String insert_tJDBCOutput_18 = "INSERT INTO "
						+ "host_interface_configuration"
						+ " (host_interface_id,host_interface_name,host_id,host_interface_type,host_interface_speed_bps,mac_address,network_name,ip_address,gateway,bond,bond_name,vlan_id,host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_18 = connection_tJDBCOutput_18
						.prepareStatement(insert_tJDBCOutput_18);

				/**
				 * [tJDBCOutput_18 begin ] stop
				 */

				/**
				 * [tMap_18 begin ] start
				 */

				ok_Hash.put("tMap_18", false);
				start_Hash.put("tMap_18", System.currentTimeMillis());
				currentComponent = "tMap_18";

				int tos_count_tMap_18 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row22Struct> tHash_Lookup_row22 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row22Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row22Struct>) globalMap
						.get("tHash_Lookup_row22"));

				row22Struct row22HashKey = new row22Struct();
				row22Struct row22Default = new row22Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_18__Struct {
				}
				Var__tMap_18__Struct Var__tMap_18 = new Var__tMap_18__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_hinterfaceStruct delete_hinterface_tmp = new delete_hinterfaceStruct();
				// ###############################

				/**
				 * [tMap_18 begin ] stop
				 */

				/**
				 * [tJDBCInput_24 begin ] start
				 */

				ok_Hash.put("tJDBCInput_24", false);
				start_Hash.put("tJDBCInput_24", System.currentTimeMillis());
				currentComponent = "tJDBCInput_24";

				int tos_count_tJDBCInput_24 = 0;

				int nb_line_tJDBCInput_24 = 0;
				java.sql.Connection conn_tJDBCInput_24 = null;
				conn_tJDBCInput_24 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_24) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_24 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_24 = dataSources_tJDBCInput_24.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_24);
				}

				java.sql.Statement stmt_tJDBCInput_24 = conn_tJDBCInput_24
						.createStatement();

				String dbquery_tJDBCInput_24 = "SELECT     history_id,     host_interface_id,     upper(cast(host_interface_id as char(36))) as host_interface_join_id,    host_interface_name,     host_id,     host_interface_type,     host_interface_speed_bps,     mac_address,     network_name,     ip_address,     gateway,     bond,     bond_name,     vlan_id,     host_configuration_version,     create_date,     update_date  FROM v3_3_latest_configuration_hosts_interfaces";

				globalMap.put("tJDBCInput_24_QUERY", dbquery_tJDBCInput_24);

				java.sql.ResultSet rs_tJDBCInput_24 = stmt_tJDBCInput_24
						.executeQuery(dbquery_tJDBCInput_24);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_24 = rs_tJDBCInput_24
						.getMetaData();
				int colQtyInRs_tJDBCInput_24 = rsmd_tJDBCInput_24
						.getColumnCount();

				String tmpContent_tJDBCInput_24 = null;
				int column_index_tJDBCInput_24 = 1;
				while (rs_tJDBCInput_24.next()) {
					nb_line_tJDBCInput_24++;

					column_index_tJDBCInput_24 = 1;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.history_id = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.history_id = rs_tJDBCInput_24
									.getInt(column_index_tJDBCInput_24);
						} else {
							row23.history_id = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.history_id = null;
						}
					}
					column_index_tJDBCInput_24 = 2;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_interface_id = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.host_interface_id = rs_tJDBCInput_24
									.getObject(column_index_tJDBCInput_24);
						} else {
							row23.host_interface_id = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_interface_id = null;
						}
					}
					column_index_tJDBCInput_24 = 3;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_interface_join_id = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.host_interface_join_id = tmpContent_tJDBCInput_24;
						} else {
							row23.host_interface_join_id = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_interface_join_id = null;
						}
					}
					column_index_tJDBCInput_24 = 4;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_interface_name = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.host_interface_name = tmpContent_tJDBCInput_24;
						} else {
							row23.host_interface_name = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_interface_name = null;
						}
					}
					column_index_tJDBCInput_24 = 5;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_id = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.host_id = rs_tJDBCInput_24
									.getObject(column_index_tJDBCInput_24);
						} else {
							row23.host_id = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_id = null;
						}
					}
					column_index_tJDBCInput_24 = 6;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_interface_type = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.host_interface_type = rs_tJDBCInput_24
									.getShort(column_index_tJDBCInput_24);
						} else {
							row23.host_interface_type = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_interface_type = null;
						}
					}
					column_index_tJDBCInput_24 = 7;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_interface_speed_bps = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.host_interface_speed_bps = rs_tJDBCInput_24
									.getInt(column_index_tJDBCInput_24);
						} else {
							row23.host_interface_speed_bps = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_interface_speed_bps = null;
						}
					}
					column_index_tJDBCInput_24 = 8;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.mac_address = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.mac_address = tmpContent_tJDBCInput_24;
						} else {
							row23.mac_address = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.mac_address = null;
						}
					}
					column_index_tJDBCInput_24 = 9;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.network_name = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.network_name = tmpContent_tJDBCInput_24;
						} else {
							row23.network_name = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.network_name = null;
						}
					}
					column_index_tJDBCInput_24 = 10;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.ip_address = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.ip_address = tmpContent_tJDBCInput_24;
						} else {
							row23.ip_address = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.ip_address = null;
						}
					}
					column_index_tJDBCInput_24 = 11;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.gateway = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.gateway = tmpContent_tJDBCInput_24;
						} else {
							row23.gateway = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.gateway = null;
						}
					}
					column_index_tJDBCInput_24 = 12;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.bond = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.bond = rs_tJDBCInput_24
									.getBoolean(column_index_tJDBCInput_24);
						} else {
							row23.bond = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.bond = null;
						}
					}
					column_index_tJDBCInput_24 = 13;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.bond_name = null;
					} else {

						tmpContent_tJDBCInput_24 = rs_tJDBCInput_24
								.getString(column_index_tJDBCInput_24);
						if (tmpContent_tJDBCInput_24 != null) {
							row23.bond_name = tmpContent_tJDBCInput_24;
						} else {
							row23.bond_name = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.bond_name = null;
						}
					}
					column_index_tJDBCInput_24 = 14;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.vlan_id = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.vlan_id = rs_tJDBCInput_24
									.getInt(column_index_tJDBCInput_24);
						} else {
							row23.vlan_id = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.vlan_id = null;
						}
					}
					column_index_tJDBCInput_24 = 15;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.host_configuration_version = null;
					} else {

						if (rs_tJDBCInput_24
								.getObject(column_index_tJDBCInput_24) != null) {
							row23.host_configuration_version = rs_tJDBCInput_24
									.getInt(column_index_tJDBCInput_24);
						} else {
							row23.host_configuration_version = null;
						}

						if (rs_tJDBCInput_24.wasNull()) {
							row23.host_configuration_version = null;
						}
					}
					column_index_tJDBCInput_24 = 16;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_24 = null;
						try {
							date_tJDBCInput_24 = rs_tJDBCInput_24
									.getTimestamp(column_index_tJDBCInput_24);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_24 = rs_tJDBCInput_24
									.getDate(column_index_tJDBCInput_24);
						}
						row23.create_date = date_tJDBCInput_24;

						if (rs_tJDBCInput_24.wasNull()) {
							row23.create_date = null;
						}
					}
					column_index_tJDBCInput_24 = 17;

					if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
						row23.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_24 = null;
						try {
							date_tJDBCInput_24 = rs_tJDBCInput_24
									.getTimestamp(column_index_tJDBCInput_24);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_24 = rs_tJDBCInput_24
									.getDate(column_index_tJDBCInput_24);
						}
						row23.update_date = date_tJDBCInput_24;

						if (rs_tJDBCInput_24.wasNull()) {
							row23.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_24 begin ] stop
					 */
					/**
					 * [tJDBCInput_24 main ] start
					 */

					currentComponent = "tJDBCInput_24";

					tos_count_tJDBCInput_24++;

					/**
					 * [tJDBCInput_24 main ] stop
					 */

					/**
					 * [tMap_18 main ] start
					 */

					currentComponent = "tMap_18";

					boolean hasCasePrimitiveKeyWithNull_tMap_18 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_18 = false;
					boolean mainRowRejected_tMap_18 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row22"
					// /////////////////////////////////////////////

					boolean forceLooprow22 = false;

					row22Struct row22ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_18) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_18 = false;

						row22HashKey.host_interface_join_id = row23.host_interface_join_id;

						row22HashKey.hashCodeDirty = true;

						tHash_Lookup_row22.lookup(row22HashKey);

						if (!tHash_Lookup_row22.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_18 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row22 != null
							&& tHash_Lookup_row22.getCount(row22HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row22' and it contains more one result from keys :  row22.host_interface_join_id = '"
						// + row22HashKey.host_interface_join_id + "'");
					} // G 071

					row22Struct row22 = null;

					row22Struct fromLookup_row22 = null;
					row22 = row22Default;

					if (tHash_Lookup_row22 != null
							&& tHash_Lookup_row22.hasNext()) { // G 099

						fromLookup_row22 = tHash_Lookup_row22.next();

					} // G 099

					if (fromLookup_row22 != null) {
						row22 = fromLookup_row22;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_18__Struct Var = Var__tMap_18;// ###############################
						// ###############################
						// # Output tables

						delete_hinterface = null;

						if (!rejectedInnerJoin_tMap_18) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_hinterface'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_18) {
							delete_hinterface_tmp.host_interface_id = row23.host_interface_id;
							delete_hinterface_tmp.host_interface_name = row23.host_interface_name;
							delete_hinterface_tmp.host_id = row23.host_id;
							delete_hinterface_tmp.host_interface_type = row23.host_interface_type;
							delete_hinterface_tmp.host_interface_speed_bps = row23.host_interface_speed_bps;
							delete_hinterface_tmp.mac_address = row23.mac_address;
							delete_hinterface_tmp.network_name = row23.network_name;
							delete_hinterface_tmp.ip_address = row23.ip_address;
							delete_hinterface_tmp.gateway = row23.gateway;
							delete_hinterface_tmp.bond = row23.bond;
							delete_hinterface_tmp.bond_name = row23.bond_name;
							delete_hinterface_tmp.vlan_id = row23.vlan_id;
							delete_hinterface_tmp.host_configuration_version = row23.host_configuration_version;
							delete_hinterface_tmp.create_date = row23.create_date;
							delete_hinterface_tmp.update_date = context.runTime;
							delete_hinterface_tmp.delete_date = context.runTime;
							delete_hinterface = delete_hinterface_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_18 = false;

					tos_count_tMap_18++;

					/**
					 * [tMap_18 main ] stop
					 */
					// Start of branch "delete_hinterface"
					if (delete_hinterface != null) {

						/**
						 * [tJDBCOutput_18 main ] start
						 */

						currentComponent = "tJDBCOutput_18";

						whetherReject_tJDBCOutput_18 = false;
						if (delete_hinterface.host_interface_id == null) {
							pstmt_tJDBCOutput_18.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_18.setObject(1,
									delete_hinterface.host_interface_id);
						}

						if (delete_hinterface.host_interface_name == null) {
							pstmt_tJDBCOutput_18.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_18.setString(2,
									delete_hinterface.host_interface_name);
						}

						if (delete_hinterface.host_id == null) {
							pstmt_tJDBCOutput_18.setNull(3,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_18.setObject(3,
									delete_hinterface.host_id);
						}

						if (delete_hinterface.host_interface_type == null) {
							pstmt_tJDBCOutput_18.setNull(4,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_18.setShort(4,
									delete_hinterface.host_interface_type);
						}

						if (delete_hinterface.host_interface_speed_bps == null) {
							pstmt_tJDBCOutput_18.setNull(5,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_18.setInt(5,
									delete_hinterface.host_interface_speed_bps);
						}

						if (delete_hinterface.mac_address == null) {
							pstmt_tJDBCOutput_18.setNull(6,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_18.setString(6,
									delete_hinterface.mac_address);
						}

						if (delete_hinterface.network_name == null) {
							pstmt_tJDBCOutput_18.setNull(7,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_18.setString(7,
									delete_hinterface.network_name);
						}

						if (delete_hinterface.ip_address == null) {
							pstmt_tJDBCOutput_18.setNull(8,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_18.setString(8,
									delete_hinterface.ip_address);
						}

						if (delete_hinterface.gateway == null) {
							pstmt_tJDBCOutput_18.setNull(9,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_18.setString(9,
									delete_hinterface.gateway);
						}

						if (delete_hinterface.bond == null) {
							pstmt_tJDBCOutput_18.setNull(10,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_18.setBoolean(10,
									delete_hinterface.bond);
						}

						if (delete_hinterface.bond_name == null) {
							pstmt_tJDBCOutput_18.setNull(11,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_18.setString(11,
									delete_hinterface.bond_name);
						}

						if (delete_hinterface.vlan_id == null) {
							pstmt_tJDBCOutput_18.setNull(12,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_18.setInt(12,
									delete_hinterface.vlan_id);
						}

						if (delete_hinterface.host_configuration_version == null) {
							pstmt_tJDBCOutput_18.setNull(13,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_18
									.setInt(13,
											delete_hinterface.host_configuration_version);
						}

						if (delete_hinterface.create_date != null) {
							pstmt_tJDBCOutput_18.setTimestamp(
									14,
									new java.sql.Timestamp(
											delete_hinterface.create_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_18.setNull(14,
									java.sql.Types.DATE);
						}

						if (delete_hinterface.update_date != null) {
							pstmt_tJDBCOutput_18.setTimestamp(
									15,
									new java.sql.Timestamp(
											delete_hinterface.update_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_18.setNull(15,
									java.sql.Types.DATE);
						}

						if (delete_hinterface.delete_date != null) {
							pstmt_tJDBCOutput_18.setTimestamp(
									16,
									new java.sql.Timestamp(
											delete_hinterface.delete_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_18.setNull(16,
									java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_18 = insertedCount_tJDBCOutput_18
									+ pstmt_tJDBCOutput_18.executeUpdate();
							nb_line_tJDBCOutput_18++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_18 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_18++;

						/**
						 * [tJDBCOutput_18 main ] stop
						 */

					} // End of branch "delete_hinterface"

					/**
					 * [tJDBCInput_24 end ] start
					 */

					currentComponent = "tJDBCInput_24";

				}
				rs_tJDBCInput_24.close();
				stmt_tJDBCInput_24.close();

				globalMap.put("tJDBCInput_24_NB_LINE", nb_line_tJDBCInput_24);

				ok_Hash.put("tJDBCInput_24", true);
				end_Hash.put("tJDBCInput_24", System.currentTimeMillis());

				/**
				 * [tJDBCInput_24 end ] stop
				 */

				/**
				 * [tMap_18 end ] start
				 */

				currentComponent = "tMap_18";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row22 != null) {
					tHash_Lookup_row22.endGet();
				}
				globalMap.remove("tHash_Lookup_row22");

				// ###############################

				ok_Hash.put("tMap_18", true);
				end_Hash.put("tMap_18", System.currentTimeMillis());

				/**
				 * [tMap_18 end ] stop
				 */

				/**
				 * [tJDBCOutput_18 end ] start
				 */

				currentComponent = "tJDBCOutput_18";

				if (pstmt_tJDBCOutput_18 != null) {

					pstmt_tJDBCOutput_18.close();

				}

				nb_line_deleted_tJDBCOutput_18 = nb_line_deleted_tJDBCOutput_18
						+ deletedCount_tJDBCOutput_18;
				nb_line_update_tJDBCOutput_18 = nb_line_update_tJDBCOutput_18
						+ updatedCount_tJDBCOutput_18;
				nb_line_inserted_tJDBCOutput_18 = nb_line_inserted_tJDBCOutput_18
						+ insertedCount_tJDBCOutput_18;
				nb_line_rejected_tJDBCOutput_18 = nb_line_rejected_tJDBCOutput_18
						+ rejectedCount_tJDBCOutput_18;

				globalMap.put("tJDBCOutput_18_NB_LINE", nb_line_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_18);

				ok_Hash.put("tJDBCOutput_18", true);
				end_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_18 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_24:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_6Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_18"
			globalMap.remove("tHash_Lookup_row22");

		}

		globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", 1);
	}

	public static class vm_configurationStruct implements
			routines.system.IPersistableRow<vm_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public short operating_system;

		public short getOperating_system() {
			return this.operating_system;
		}

		public String ad_domain;

		public String getAd_domain() {
			return this.ad_domain;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					this.operating_system = dis.readShort();

					this.ad_domain = readString(dis);

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// short

				dos.writeShort(this.operating_system);

				// String

				writeString(this.ad_domain, dos);

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",ad_domain=" + ad_domain);
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public String ad_domain;

		public String getAd_domain() {
			return this.ad_domain;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public String default_host_join_id;

		public String getDefault_host_join_id() {
			return this.default_host_join_id;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.ad_domain = readString(dis);

					this.default_host = (Object) dis.readObject();

					this.default_host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// String

				writeString(this.ad_domain, dos);

				// Object

				dos.writeObject(this.default_host);

				// String

				writeString(this.default_host_join_id, dos);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",ad_domain=" + ad_domain);
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",default_host_join_id=" + default_host_join_id);
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_6Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public String ad_domain;

		public String getAd_domain() {
			return this.ad_domain;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public String default_host_join_id;

		public String getDefault_host_join_id() {
			return this.default_host_join_id;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.ad_domain = readString(dis);

					this.default_host = (Object) dis.readObject();

					this.default_host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// String

				writeString(this.ad_domain, dos);

				// Object

				dos.writeObject(this.default_host);

				// String

				writeString(this.default_host_join_id, dos);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",ad_domain=" + ad_domain);
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",default_host_join_id=" + default_host_join_id);
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_6Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_43Process(globalMap);
				tJDBCInput_42Process(globalMap);

				row4Struct row4 = new row4Struct();
				vm_configurationStruct vm_configuration = new vm_configurationStruct();

				/**
				 * [tJDBCOutput_6 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_6", false);
				start_Hash.put("tJDBCOutput_6", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_6";

				int tos_count_tJDBCOutput_6 = 0;

				int nb_line_tJDBCOutput_6 = 0;
				int nb_line_update_tJDBCOutput_6 = 0;
				int nb_line_inserted_tJDBCOutput_6 = 0;
				int nb_line_deleted_tJDBCOutput_6 = 0;
				int nb_line_rejected_tJDBCOutput_6 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_6 = 0;

				int deletedCount_tJDBCOutput_6 = 0;
				int updatedCount_tJDBCOutput_6 = 0;
				int insertedCount_tJDBCOutput_6 = 0;
				int rejectedCount_tJDBCOutput_6 = 0;

				boolean whetherReject_tJDBCOutput_6 = false;

				java.sql.Connection connection_tJDBCOutput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_6) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_6 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_6 = dataSources_tJDBCOutput_6
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_6 = 10000;
				int batchSizeCounter_tJDBCOutput_6 = 0;

				String insert_tJDBCOutput_6 = "INSERT INTO "
						+ "vm_configuration"
						+ " (vm_id,vm_name,vm_description,vm_type,cluster_id,template_id,template_name,cpu_per_socket,number_of_sockets,memory_size_mb,operating_system,ad_domain,default_host,high_availability,initialized,stateless,fail_back,usb_policy,time_zone,vm_pool_id,vm_pool_name,cluster_configuration_version,default_host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(insert_tJDBCOutput_6);

				/**
				 * [tJDBCOutput_6 begin ] stop
				 */

				/**
				 * [tMap_6 begin ] start
				 */

				ok_Hash.put("tMap_6", false);
				start_Hash.put("tMap_6", System.currentTimeMillis());
				currentComponent = "tMap_6";

				int tos_count_tMap_6 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row38Struct> tHash_Lookup_row38 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row38Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row38Struct>) globalMap
						.get("tHash_Lookup_row38"));

				row38Struct row38HashKey = new row38Struct();
				row38Struct row38Default = new row38Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row39Struct> tHash_Lookup_row39 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row39Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row39Struct>) globalMap
						.get("tHash_Lookup_row39"));

				row39Struct row39HashKey = new row39Struct();
				row39Struct row39Default = new row39Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_6__Struct {
				}
				Var__tMap_6__Struct Var__tMap_6 = new Var__tMap_6__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_configurationStruct vm_configuration_tmp = new vm_configurationStruct();
				// ###############################

				/**
				 * [tMap_6 begin ] stop
				 */

				/**
				 * [tJDBCInput_6 begin ] start
				 */

				ok_Hash.put("tJDBCInput_6", false);
				start_Hash.put("tJDBCInput_6", System.currentTimeMillis());
				currentComponent = "tJDBCInput_6";

				int tos_count_tJDBCInput_6 = 0;

				int nb_line_tJDBCInput_6 = 0;
				java.sql.Connection conn_tJDBCInput_6 = null;
				conn_tJDBCInput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_6) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_6 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_6 = dataSources_tJDBCInput_6.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_6);
				}

				java.sql.Statement stmt_tJDBCInput_6 = conn_tJDBCInput_6
						.createStatement();

				String dbquery_tJDBCInput_6 = "SELECT     vm_id,     vm_name,     vm_description,     vm_type,     cluster_id,    upper(cast(cluster_id as char(36))) as cluster_join_id,      template_id,     template_name,     cpu_per_socket,     number_of_sockets,     memory_size_mb,     operating_system,     ad_domain,     default_host,    upper(cast(default_host as char(36))) as default_host_join_id,      high_availability,     initialized,     stateless,     fail_back,      usb_policy,     time_zone,    vm_pool_id,   vm_pool_name,    create_date,     update_date  FROM dwh_vm_configuration_history_view";

				globalMap.put("tJDBCInput_6_QUERY", dbquery_tJDBCInput_6);

				java.sql.ResultSet rs_tJDBCInput_6 = stmt_tJDBCInput_6
						.executeQuery(dbquery_tJDBCInput_6);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_6 = rs_tJDBCInput_6
						.getMetaData();
				int colQtyInRs_tJDBCInput_6 = rsmd_tJDBCInput_6
						.getColumnCount();

				String tmpContent_tJDBCInput_6 = null;
				int column_index_tJDBCInput_6 = 1;
				while (rs_tJDBCInput_6.next()) {
					nb_line_tJDBCInput_6++;

					column_index_tJDBCInput_6 = 1;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.vm_id = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.vm_id = rs_tJDBCInput_6
									.getObject(column_index_tJDBCInput_6);
						} else {
							row4.vm_id = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.vm_id = null;
						}
					}
					column_index_tJDBCInput_6 = 2;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.vm_name = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.vm_name = tmpContent_tJDBCInput_6;
						} else {
							row4.vm_name = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.vm_name = null;
						}
					}
					column_index_tJDBCInput_6 = 3;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.vm_description = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.vm_description = tmpContent_tJDBCInput_6;
						} else {
							row4.vm_description = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.vm_description = null;
						}
					}
					column_index_tJDBCInput_6 = 4;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.vm_type = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.vm_type = rs_tJDBCInput_6
									.getShort(column_index_tJDBCInput_6);
						} else {
							row4.vm_type = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.vm_type = null;
						}
					}
					column_index_tJDBCInput_6 = 5;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.cluster_id = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.cluster_id = rs_tJDBCInput_6
									.getObject(column_index_tJDBCInput_6);
						} else {
							row4.cluster_id = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.cluster_id = null;
						}
					}
					column_index_tJDBCInput_6 = 6;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.cluster_join_id = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.cluster_join_id = tmpContent_tJDBCInput_6;
						} else {
							row4.cluster_join_id = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.cluster_join_id = null;
						}
					}
					column_index_tJDBCInput_6 = 7;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.template_id = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.template_id = rs_tJDBCInput_6
									.getObject(column_index_tJDBCInput_6);
						} else {
							row4.template_id = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.template_id = null;
						}
					}
					column_index_tJDBCInput_6 = 8;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.template_name = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.template_name = tmpContent_tJDBCInput_6;
						} else {
							row4.template_name = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.template_name = null;
						}
					}
					column_index_tJDBCInput_6 = 9;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.cpu_per_socket = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.cpu_per_socket = rs_tJDBCInput_6
									.getShort(column_index_tJDBCInput_6);
						} else {
							row4.cpu_per_socket = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.cpu_per_socket = null;
						}
					}
					column_index_tJDBCInput_6 = 10;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.number_of_sockets = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.number_of_sockets = rs_tJDBCInput_6
									.getShort(column_index_tJDBCInput_6);
						} else {
							row4.number_of_sockets = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.number_of_sockets = null;
						}
					}
					column_index_tJDBCInput_6 = 11;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.memory_size_mb = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.memory_size_mb = rs_tJDBCInput_6
									.getInt(column_index_tJDBCInput_6);
						} else {
							row4.memory_size_mb = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.memory_size_mb = null;
						}
					}
					column_index_tJDBCInput_6 = 12;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.operating_system = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.operating_system = rs_tJDBCInput_6
									.getShort(column_index_tJDBCInput_6);
						} else {
							row4.operating_system = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.operating_system = null;
						}
					}
					column_index_tJDBCInput_6 = 13;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.ad_domain = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.ad_domain = tmpContent_tJDBCInput_6;
						} else {
							row4.ad_domain = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.ad_domain = null;
						}
					}
					column_index_tJDBCInput_6 = 14;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.default_host = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.default_host = rs_tJDBCInput_6
									.getObject(column_index_tJDBCInput_6);
						} else {
							row4.default_host = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.default_host = null;
						}
					}
					column_index_tJDBCInput_6 = 15;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.default_host_join_id = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.default_host_join_id = tmpContent_tJDBCInput_6;
						} else {
							row4.default_host_join_id = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.default_host_join_id = null;
						}
					}
					column_index_tJDBCInput_6 = 16;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.high_availability = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.high_availability = rs_tJDBCInput_6
									.getBoolean(column_index_tJDBCInput_6);
						} else {
							row4.high_availability = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.high_availability = null;
						}
					}
					column_index_tJDBCInput_6 = 17;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.initialized = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.initialized = rs_tJDBCInput_6
									.getBoolean(column_index_tJDBCInput_6);
						} else {
							row4.initialized = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.initialized = null;
						}
					}
					column_index_tJDBCInput_6 = 18;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.stateless = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.stateless = rs_tJDBCInput_6
									.getBoolean(column_index_tJDBCInput_6);
						} else {
							row4.stateless = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.stateless = null;
						}
					}
					column_index_tJDBCInput_6 = 19;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.fail_back = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.fail_back = rs_tJDBCInput_6
									.getBoolean(column_index_tJDBCInput_6);
						} else {
							row4.fail_back = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.fail_back = null;
						}
					}
					column_index_tJDBCInput_6 = 20;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.usb_policy = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.usb_policy = rs_tJDBCInput_6
									.getShort(column_index_tJDBCInput_6);
						} else {
							row4.usb_policy = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.usb_policy = null;
						}
					}
					column_index_tJDBCInput_6 = 21;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.time_zone = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.time_zone = tmpContent_tJDBCInput_6;
						} else {
							row4.time_zone = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.time_zone = null;
						}
					}
					column_index_tJDBCInput_6 = 22;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.vm_pool_id = null;
					} else {

						if (rs_tJDBCInput_6
								.getObject(column_index_tJDBCInput_6) != null) {
							row4.vm_pool_id = rs_tJDBCInput_6
									.getObject(column_index_tJDBCInput_6);
						} else {
							row4.vm_pool_id = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.vm_pool_id = null;
						}
					}
					column_index_tJDBCInput_6 = 23;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.vm_pool_name = null;
					} else {

						tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
								.getString(column_index_tJDBCInput_6);
						if (tmpContent_tJDBCInput_6 != null) {
							row4.vm_pool_name = tmpContent_tJDBCInput_6;
						} else {
							row4.vm_pool_name = null;
						}

						if (rs_tJDBCInput_6.wasNull()) {
							row4.vm_pool_name = null;
						}
					}
					column_index_tJDBCInput_6 = 24;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_6 = null;
						try {
							date_tJDBCInput_6 = rs_tJDBCInput_6
									.getTimestamp(column_index_tJDBCInput_6);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_6 = rs_tJDBCInput_6
									.getDate(column_index_tJDBCInput_6);
						}
						row4.create_date = date_tJDBCInput_6;

						if (rs_tJDBCInput_6.wasNull()) {
							row4.create_date = null;
						}
					}
					column_index_tJDBCInput_6 = 25;

					if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
						row4.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_6 = null;
						try {
							date_tJDBCInput_6 = rs_tJDBCInput_6
									.getTimestamp(column_index_tJDBCInput_6);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_6 = rs_tJDBCInput_6
									.getDate(column_index_tJDBCInput_6);
						}
						row4.update_date = date_tJDBCInput_6;

						if (rs_tJDBCInput_6.wasNull()) {
							row4.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_6 begin ] stop
					 */
					/**
					 * [tJDBCInput_6 main ] start
					 */

					currentComponent = "tJDBCInput_6";

					tos_count_tJDBCInput_6++;

					/**
					 * [tJDBCInput_6 main ] stop
					 */

					/**
					 * [tMap_6 main ] start
					 */

					currentComponent = "tMap_6";

					boolean hasCasePrimitiveKeyWithNull_tMap_6 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_6 = false;
					boolean mainRowRejected_tMap_6 = false;

					if (

					(

					row4.update_date == null ? TalendDate.compareDate(
							row4.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row4.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row4'

						// /////////////////////////////////////////////
						// Starting Lookup Table "row38"
						// /////////////////////////////////////////////

						boolean forceLooprow38 = false;

						row38Struct row38ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_6) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_6 = false;

							row38HashKey.host_join_id = row4.default_host_join_id;

							row38HashKey.hashCodeDirty = true;

							tHash_Lookup_row38.lookup(row38HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row38 != null
								&& tHash_Lookup_row38.getCount(row38HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row38' and it contains more one result from keys :  row38.host_join_id = '"
							// + row38HashKey.host_join_id + "'");
						} // G 071

						row38Struct row38 = null;

						row38Struct fromLookup_row38 = null;
						row38 = row38Default;

						if (tHash_Lookup_row38 != null
								&& tHash_Lookup_row38.hasNext()) { // G 099

							fromLookup_row38 = tHash_Lookup_row38.next();

						} // G 099

						if (fromLookup_row38 != null) {
							row38 = fromLookup_row38;
						}

						// /////////////////////////////////////////////
						// Starting Lookup Table "row39"
						// /////////////////////////////////////////////

						boolean forceLooprow39 = false;

						row39Struct row39ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_6) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_6 = false;

							row39HashKey.cluster_join_id = row4.cluster_join_id;

							row39HashKey.hashCodeDirty = true;

							tHash_Lookup_row39.lookup(row39HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row39 != null
								&& tHash_Lookup_row39.getCount(row39HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row39' and it contains more one result from keys :  row39.cluster_join_id = '"
							// + row39HashKey.cluster_join_id + "'");
						} // G 071

						row39Struct row39 = null;

						row39Struct fromLookup_row39 = null;
						row39 = row39Default;

						if (tHash_Lookup_row39 != null
								&& tHash_Lookup_row39.hasNext()) { // G 099

							fromLookup_row39 = tHash_Lookup_row39.next();

						} // G 099

						if (fromLookup_row39 != null) {
							row39 = fromLookup_row39;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_6__Struct Var = Var__tMap_6;// ###############################
							// ###############################
							// # Output tables

							vm_configuration = null;

							// # Output table : 'vm_configuration'
							vm_configuration_tmp.vm_id = row4.vm_id;
							vm_configuration_tmp.vm_name = StringHandling
									.TRIM(row4.vm_name);
							vm_configuration_tmp.vm_description = StringHandling
									.TRIM(row4.vm_description);
							vm_configuration_tmp.vm_type = row4.vm_type;
							vm_configuration_tmp.cluster_id = row4.cluster_id;
							vm_configuration_tmp.template_id = row4.template_id;
							vm_configuration_tmp.template_name = StringHandling
									.TRIM(row4.template_name);
							vm_configuration_tmp.cpu_per_socket = row4.cpu_per_socket;
							vm_configuration_tmp.number_of_sockets = row4.number_of_sockets;
							vm_configuration_tmp.memory_size_mb = row4.memory_size_mb;
							vm_configuration_tmp.operating_system = row4.operating_system;
							vm_configuration_tmp.ad_domain = StringHandling
									.TRIM(row4.ad_domain);
							vm_configuration_tmp.default_host = row4.default_host;
							vm_configuration_tmp.high_availability = row4.high_availability;
							vm_configuration_tmp.initialized = row4.initialized;
							vm_configuration_tmp.stateless = row4.stateless;
							vm_configuration_tmp.fail_back = row4.fail_back;
							vm_configuration_tmp.usb_policy = row4.usb_policy;
							vm_configuration_tmp.time_zone = StringHandling
									.TRIM(row4.time_zone);
							vm_configuration_tmp.vm_pool_id = row4.vm_pool_id;
							vm_configuration_tmp.vm_pool_name = row4.vm_pool_name;
							vm_configuration_tmp.cluster_configuration_version = row39.history_id;
							vm_configuration_tmp.default_host_configuration_version = row38.history_id;
							vm_configuration_tmp.create_date = row4.create_date;
							vm_configuration_tmp.update_date = row4.update_date;
							vm_configuration_tmp.delete_date = null;
							vm_configuration = vm_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_6 = false;

						tos_count_tMap_6++;

						/**
						 * [tMap_6 main ] stop
						 */
						// Start of branch "vm_configuration"
						if (vm_configuration != null) {

							/**
							 * [tJDBCOutput_6 main ] start
							 */

							currentComponent = "tJDBCOutput_6";

							whetherReject_tJDBCOutput_6 = false;
							if (vm_configuration.vm_id == null) {
								pstmt_tJDBCOutput_6.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_6.setObject(1,
										vm_configuration.vm_id);
							}

							if (vm_configuration.vm_name == null) {
								pstmt_tJDBCOutput_6.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_6.setString(2,
										vm_configuration.vm_name);
							}

							if (vm_configuration.vm_description == null) {
								pstmt_tJDBCOutput_6.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_6.setString(3,
										vm_configuration.vm_description);
							}

							if (vm_configuration.vm_type == null) {
								pstmt_tJDBCOutput_6.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6.setShort(4,
										vm_configuration.vm_type);
							}

							if (vm_configuration.cluster_id == null) {
								pstmt_tJDBCOutput_6.setNull(5,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_6.setObject(5,
										vm_configuration.cluster_id);
							}

							if (vm_configuration.template_id == null) {
								pstmt_tJDBCOutput_6.setNull(6,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_6.setObject(6,
										vm_configuration.template_id);
							}

							if (vm_configuration.template_name == null) {
								pstmt_tJDBCOutput_6.setNull(7,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_6.setString(7,
										vm_configuration.template_name);
							}

							if (vm_configuration.cpu_per_socket == null) {
								pstmt_tJDBCOutput_6.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6.setShort(8,
										vm_configuration.cpu_per_socket);
							}

							if (vm_configuration.number_of_sockets == null) {
								pstmt_tJDBCOutput_6.setNull(9,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6.setShort(9,
										vm_configuration.number_of_sockets);
							}

							if (vm_configuration.memory_size_mb == null) {
								pstmt_tJDBCOutput_6.setNull(10,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6.setInt(10,
										vm_configuration.memory_size_mb);
							}

							pstmt_tJDBCOutput_6.setShort(11,
									vm_configuration.operating_system);

							if (vm_configuration.ad_domain == null) {
								pstmt_tJDBCOutput_6.setNull(12,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_6.setString(12,
										vm_configuration.ad_domain);
							}

							if (vm_configuration.default_host == null) {
								pstmt_tJDBCOutput_6.setNull(13,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_6.setObject(13,
										vm_configuration.default_host);
							}

							if (vm_configuration.high_availability == null) {
								pstmt_tJDBCOutput_6.setNull(14,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_6.setBoolean(14,
										vm_configuration.high_availability);
							}

							if (vm_configuration.initialized == null) {
								pstmt_tJDBCOutput_6.setNull(15,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_6.setBoolean(15,
										vm_configuration.initialized);
							}

							if (vm_configuration.stateless == null) {
								pstmt_tJDBCOutput_6.setNull(16,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_6.setBoolean(16,
										vm_configuration.stateless);
							}

							if (vm_configuration.fail_back == null) {
								pstmt_tJDBCOutput_6.setNull(17,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_6.setBoolean(17,
										vm_configuration.fail_back);
							}

							if (vm_configuration.usb_policy == null) {
								pstmt_tJDBCOutput_6.setNull(18,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6.setShort(18,
										vm_configuration.usb_policy);
							}

							if (vm_configuration.time_zone == null) {
								pstmt_tJDBCOutput_6.setNull(19,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_6.setString(19,
										vm_configuration.time_zone);
							}

							if (vm_configuration.vm_pool_id == null) {
								pstmt_tJDBCOutput_6.setNull(20,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_6.setObject(20,
										vm_configuration.vm_pool_id);
							}

							if (vm_configuration.vm_pool_name == null) {
								pstmt_tJDBCOutput_6.setNull(21,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_6.setString(21,
										vm_configuration.vm_pool_name);
							}

							if (vm_configuration.cluster_configuration_version == null) {
								pstmt_tJDBCOutput_6.setNull(22,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6
										.setInt(22,
												vm_configuration.cluster_configuration_version);
							}

							if (vm_configuration.default_host_configuration_version == null) {
								pstmt_tJDBCOutput_6.setNull(23,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_6
										.setInt(23,
												vm_configuration.default_host_configuration_version);
							}

							if (vm_configuration.create_date != null) {
								pstmt_tJDBCOutput_6.setTimestamp(
										24,
										new java.sql.Timestamp(
												vm_configuration.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_6.setNull(24,
										java.sql.Types.DATE);
							}

							if (vm_configuration.update_date != null) {
								pstmt_tJDBCOutput_6.setTimestamp(
										25,
										new java.sql.Timestamp(
												vm_configuration.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_6.setNull(25,
										java.sql.Types.DATE);
							}

							if (vm_configuration.delete_date != null) {
								pstmt_tJDBCOutput_6.setTimestamp(
										26,
										new java.sql.Timestamp(
												vm_configuration.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_6.setNull(26,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_6 = insertedCount_tJDBCOutput_6
										+ pstmt_tJDBCOutput_6.executeUpdate();
								nb_line_tJDBCOutput_6++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_6 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_6++;

							/**
							 * [tJDBCOutput_6 main ] stop
							 */

						} // End of branch "vm_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row4'

					/**
					 * [tJDBCInput_6 end ] start
					 */

					currentComponent = "tJDBCInput_6";

				}
				rs_tJDBCInput_6.close();
				stmt_tJDBCInput_6.close();

				globalMap.put("tJDBCInput_6_NB_LINE", nb_line_tJDBCInput_6);

				ok_Hash.put("tJDBCInput_6", true);
				end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				/**
				 * [tJDBCInput_6 end ] stop
				 */

				/**
				 * [tMap_6 end ] start
				 */

				currentComponent = "tMap_6";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row38 != null) {
					tHash_Lookup_row38.endGet();
				}
				globalMap.remove("tHash_Lookup_row38");

				if (tHash_Lookup_row39 != null) {
					tHash_Lookup_row39.endGet();
				}
				globalMap.remove("tHash_Lookup_row39");

				// ###############################

				ok_Hash.put("tMap_6", true);
				end_Hash.put("tMap_6", System.currentTimeMillis());

				/**
				 * [tMap_6 end ] stop
				 */

				/**
				 * [tJDBCOutput_6 end ] start
				 */

				currentComponent = "tJDBCOutput_6";

				if (pstmt_tJDBCOutput_6 != null) {

					pstmt_tJDBCOutput_6.close();

				}

				nb_line_deleted_tJDBCOutput_6 = nb_line_deleted_tJDBCOutput_6
						+ deletedCount_tJDBCOutput_6;
				nb_line_update_tJDBCOutput_6 = nb_line_update_tJDBCOutput_6
						+ updatedCount_tJDBCOutput_6;
				nb_line_inserted_tJDBCOutput_6 = nb_line_inserted_tJDBCOutput_6
						+ insertedCount_tJDBCOutput_6;
				nb_line_rejected_tJDBCOutput_6 = nb_line_rejected_tJDBCOutput_6
						+ rejectedCount_tJDBCOutput_6;

				globalMap.put("tJDBCOutput_6_NB_LINE", nb_line_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_6);

				ok_Hash.put("tJDBCOutput_6", true);
				end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_6 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_6:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_26Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_6"
			globalMap.remove("tHash_Lookup_row38");

			// free memory for "tMap_6"
			globalMap.remove("tHash_Lookup_row39");

		}

		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 1);
	}

	public static class delete_vmsStruct implements
			routines.system.IPersistableRow<delete_vmsStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public short operating_system;

		public short getOperating_system() {
			return this.operating_system;
		}

		public String ad_domain;

		public String getAd_domain() {
			return this.ad_domain;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					this.operating_system = dis.readShort();

					this.ad_domain = readString(dis);

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// short

				dos.writeShort(this.operating_system);

				// String

				writeString(this.ad_domain, dos);

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",ad_domain=" + ad_domain);
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vmsStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row25Struct implements
			routines.system.IPersistableRow<row25Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public String ad_domain;

		public String getAd_domain() {
			return this.ad_domain;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.ad_domain = readString(dis);

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// String

				writeString(this.ad_domain, dos);

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",ad_domain=" + ad_domain);
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row25Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_26Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_26Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public String ad_domain;

		public String getAd_domain() {
			return this.ad_domain;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.ad_domain = readString(dis);

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// String

				writeString(this.ad_domain, dos);

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",ad_domain=" + ad_domain);
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_26Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_26Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_25Process(globalMap);

				row25Struct row25 = new row25Struct();
				delete_vmsStruct delete_vms = new delete_vmsStruct();

				/**
				 * [tJDBCOutput_19 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_19", false);
				start_Hash.put("tJDBCOutput_19", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_19";

				int tos_count_tJDBCOutput_19 = 0;

				int nb_line_tJDBCOutput_19 = 0;
				int nb_line_update_tJDBCOutput_19 = 0;
				int nb_line_inserted_tJDBCOutput_19 = 0;
				int nb_line_deleted_tJDBCOutput_19 = 0;
				int nb_line_rejected_tJDBCOutput_19 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_19 = 0;

				int deletedCount_tJDBCOutput_19 = 0;
				int updatedCount_tJDBCOutput_19 = 0;
				int insertedCount_tJDBCOutput_19 = 0;
				int rejectedCount_tJDBCOutput_19 = 0;

				boolean whetherReject_tJDBCOutput_19 = false;

				java.sql.Connection connection_tJDBCOutput_19 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_19) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_19 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_19 = dataSources_tJDBCOutput_19.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_19 = 10000;
				int batchSizeCounter_tJDBCOutput_19 = 0;

				String insert_tJDBCOutput_19 = "INSERT INTO "
						+ "vm_configuration"
						+ " (vm_id,vm_name,vm_description,vm_type,cluster_id,template_id,template_name,cpu_per_socket,number_of_sockets,memory_size_mb,operating_system,ad_domain,default_host,high_availability,initialized,stateless,fail_back,usb_policy,time_zone,cluster_configuration_version,default_host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_19 = connection_tJDBCOutput_19
						.prepareStatement(insert_tJDBCOutput_19);

				/**
				 * [tJDBCOutput_19 begin ] stop
				 */

				/**
				 * [tMap_19 begin ] start
				 */

				ok_Hash.put("tMap_19", false);
				start_Hash.put("tMap_19", System.currentTimeMillis());
				currentComponent = "tMap_19";

				int tos_count_tMap_19 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row24Struct> tHash_Lookup_row24 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row24Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row24Struct>) globalMap
						.get("tHash_Lookup_row24"));

				row24Struct row24HashKey = new row24Struct();
				row24Struct row24Default = new row24Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_19__Struct {
				}
				Var__tMap_19__Struct Var__tMap_19 = new Var__tMap_19__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_vmsStruct delete_vms_tmp = new delete_vmsStruct();
				// ###############################

				/**
				 * [tMap_19 begin ] stop
				 */

				/**
				 * [tJDBCInput_26 begin ] start
				 */

				ok_Hash.put("tJDBCInput_26", false);
				start_Hash.put("tJDBCInput_26", System.currentTimeMillis());
				currentComponent = "tJDBCInput_26";

				int tos_count_tJDBCInput_26 = 0;

				int nb_line_tJDBCInput_26 = 0;
				java.sql.Connection conn_tJDBCInput_26 = null;
				conn_tJDBCInput_26 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_26) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_26 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_26 = dataSources_tJDBCInput_26.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_26);
				}

				java.sql.Statement stmt_tJDBCInput_26 = conn_tJDBCInput_26
						.createStatement();

				String dbquery_tJDBCInput_26 = "SELECT history_id,   		vm_id,   		upper(cast(vm_id as char(36))) as vm_join_id,  		vm_name,   		vm_description,   		vm_type,   		cluster_id,   		template_id,   		template_name,   		cpu_per_socket,   		number_of_sockets,   		memory_size_mb,   		operating_system,   		ad_domain,   		default_host,   		high_availability,   		initialized,   		stateless,   		fail_back,   		usb_policy,   		time_zone,   		cluster_configuration_version,   		default_host_configuration_version,   		create_date,   		update_date  FROM v3_3_latest_configuration_vms";

				globalMap.put("tJDBCInput_26_QUERY", dbquery_tJDBCInput_26);

				java.sql.ResultSet rs_tJDBCInput_26 = stmt_tJDBCInput_26
						.executeQuery(dbquery_tJDBCInput_26);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_26 = rs_tJDBCInput_26
						.getMetaData();
				int colQtyInRs_tJDBCInput_26 = rsmd_tJDBCInput_26
						.getColumnCount();

				String tmpContent_tJDBCInput_26 = null;
				int column_index_tJDBCInput_26 = 1;
				while (rs_tJDBCInput_26.next()) {
					nb_line_tJDBCInput_26++;

					column_index_tJDBCInput_26 = 1;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.history_id = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.history_id = rs_tJDBCInput_26
									.getInt(column_index_tJDBCInput_26);
						} else {
							row25.history_id = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.history_id = null;
						}
					}
					column_index_tJDBCInput_26 = 2;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.vm_id = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.vm_id = rs_tJDBCInput_26
									.getObject(column_index_tJDBCInput_26);
						} else {
							row25.vm_id = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.vm_id = null;
						}
					}
					column_index_tJDBCInput_26 = 3;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.vm_join_id = null;
					} else {

						tmpContent_tJDBCInput_26 = rs_tJDBCInput_26
								.getString(column_index_tJDBCInput_26);
						if (tmpContent_tJDBCInput_26 != null) {
							row25.vm_join_id = tmpContent_tJDBCInput_26;
						} else {
							row25.vm_join_id = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.vm_join_id = null;
						}
					}
					column_index_tJDBCInput_26 = 4;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.vm_name = null;
					} else {

						tmpContent_tJDBCInput_26 = rs_tJDBCInput_26
								.getString(column_index_tJDBCInput_26);
						if (tmpContent_tJDBCInput_26 != null) {
							row25.vm_name = tmpContent_tJDBCInput_26;
						} else {
							row25.vm_name = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.vm_name = null;
						}
					}
					column_index_tJDBCInput_26 = 5;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.vm_description = null;
					} else {

						tmpContent_tJDBCInput_26 = rs_tJDBCInput_26
								.getString(column_index_tJDBCInput_26);
						if (tmpContent_tJDBCInput_26 != null) {
							row25.vm_description = tmpContent_tJDBCInput_26;
						} else {
							row25.vm_description = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.vm_description = null;
						}
					}
					column_index_tJDBCInput_26 = 6;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.vm_type = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.vm_type = rs_tJDBCInput_26
									.getShort(column_index_tJDBCInput_26);
						} else {
							row25.vm_type = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.vm_type = null;
						}
					}
					column_index_tJDBCInput_26 = 7;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.cluster_id = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.cluster_id = rs_tJDBCInput_26
									.getObject(column_index_tJDBCInput_26);
						} else {
							row25.cluster_id = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.cluster_id = null;
						}
					}
					column_index_tJDBCInput_26 = 8;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.template_id = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.template_id = rs_tJDBCInput_26
									.getObject(column_index_tJDBCInput_26);
						} else {
							row25.template_id = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.template_id = null;
						}
					}
					column_index_tJDBCInput_26 = 9;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.template_name = null;
					} else {

						tmpContent_tJDBCInput_26 = rs_tJDBCInput_26
								.getString(column_index_tJDBCInput_26);
						if (tmpContent_tJDBCInput_26 != null) {
							row25.template_name = tmpContent_tJDBCInput_26;
						} else {
							row25.template_name = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.template_name = null;
						}
					}
					column_index_tJDBCInput_26 = 10;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.cpu_per_socket = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.cpu_per_socket = rs_tJDBCInput_26
									.getShort(column_index_tJDBCInput_26);
						} else {
							row25.cpu_per_socket = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.cpu_per_socket = null;
						}
					}
					column_index_tJDBCInput_26 = 11;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.number_of_sockets = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.number_of_sockets = rs_tJDBCInput_26
									.getShort(column_index_tJDBCInput_26);
						} else {
							row25.number_of_sockets = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.number_of_sockets = null;
						}
					}
					column_index_tJDBCInput_26 = 12;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.memory_size_mb = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.memory_size_mb = rs_tJDBCInput_26
									.getInt(column_index_tJDBCInput_26);
						} else {
							row25.memory_size_mb = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.memory_size_mb = null;
						}
					}
					column_index_tJDBCInput_26 = 13;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.operating_system = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.operating_system = rs_tJDBCInput_26
									.getShort(column_index_tJDBCInput_26);
						} else {
							row25.operating_system = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.operating_system = null;
						}
					}
					column_index_tJDBCInput_26 = 14;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.ad_domain = null;
					} else {

						tmpContent_tJDBCInput_26 = rs_tJDBCInput_26
								.getString(column_index_tJDBCInput_26);
						if (tmpContent_tJDBCInput_26 != null) {
							row25.ad_domain = tmpContent_tJDBCInput_26;
						} else {
							row25.ad_domain = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.ad_domain = null;
						}
					}
					column_index_tJDBCInput_26 = 15;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.default_host = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.default_host = rs_tJDBCInput_26
									.getObject(column_index_tJDBCInput_26);
						} else {
							row25.default_host = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.default_host = null;
						}
					}
					column_index_tJDBCInput_26 = 16;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.high_availability = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.high_availability = rs_tJDBCInput_26
									.getBoolean(column_index_tJDBCInput_26);
						} else {
							row25.high_availability = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.high_availability = null;
						}
					}
					column_index_tJDBCInput_26 = 17;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.initialized = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.initialized = rs_tJDBCInput_26
									.getBoolean(column_index_tJDBCInput_26);
						} else {
							row25.initialized = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.initialized = null;
						}
					}
					column_index_tJDBCInput_26 = 18;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.stateless = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.stateless = rs_tJDBCInput_26
									.getBoolean(column_index_tJDBCInput_26);
						} else {
							row25.stateless = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.stateless = null;
						}
					}
					column_index_tJDBCInput_26 = 19;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.fail_back = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.fail_back = rs_tJDBCInput_26
									.getBoolean(column_index_tJDBCInput_26);
						} else {
							row25.fail_back = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.fail_back = null;
						}
					}
					column_index_tJDBCInput_26 = 20;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.usb_policy = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.usb_policy = rs_tJDBCInput_26
									.getShort(column_index_tJDBCInput_26);
						} else {
							row25.usb_policy = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.usb_policy = null;
						}
					}
					column_index_tJDBCInput_26 = 21;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.time_zone = null;
					} else {

						tmpContent_tJDBCInput_26 = rs_tJDBCInput_26
								.getString(column_index_tJDBCInput_26);
						if (tmpContent_tJDBCInput_26 != null) {
							row25.time_zone = tmpContent_tJDBCInput_26;
						} else {
							row25.time_zone = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.time_zone = null;
						}
					}
					column_index_tJDBCInput_26 = 22;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.cluster_configuration_version = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.cluster_configuration_version = rs_tJDBCInput_26
									.getInt(column_index_tJDBCInput_26);
						} else {
							row25.cluster_configuration_version = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.cluster_configuration_version = null;
						}
					}
					column_index_tJDBCInput_26 = 23;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.default_host_configuration_version = null;
					} else {

						if (rs_tJDBCInput_26
								.getObject(column_index_tJDBCInput_26) != null) {
							row25.default_host_configuration_version = rs_tJDBCInput_26
									.getInt(column_index_tJDBCInput_26);
						} else {
							row25.default_host_configuration_version = null;
						}

						if (rs_tJDBCInput_26.wasNull()) {
							row25.default_host_configuration_version = null;
						}
					}
					column_index_tJDBCInput_26 = 24;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_26 = null;
						try {
							date_tJDBCInput_26 = rs_tJDBCInput_26
									.getTimestamp(column_index_tJDBCInput_26);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_26 = rs_tJDBCInput_26
									.getDate(column_index_tJDBCInput_26);
						}
						row25.create_date = date_tJDBCInput_26;

						if (rs_tJDBCInput_26.wasNull()) {
							row25.create_date = null;
						}
					}
					column_index_tJDBCInput_26 = 25;

					if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
						row25.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_26 = null;
						try {
							date_tJDBCInput_26 = rs_tJDBCInput_26
									.getTimestamp(column_index_tJDBCInput_26);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_26 = rs_tJDBCInput_26
									.getDate(column_index_tJDBCInput_26);
						}
						row25.update_date = date_tJDBCInput_26;

						if (rs_tJDBCInput_26.wasNull()) {
							row25.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_26 begin ] stop
					 */
					/**
					 * [tJDBCInput_26 main ] start
					 */

					currentComponent = "tJDBCInput_26";

					tos_count_tJDBCInput_26++;

					/**
					 * [tJDBCInput_26 main ] stop
					 */

					/**
					 * [tMap_19 main ] start
					 */

					currentComponent = "tMap_19";

					boolean hasCasePrimitiveKeyWithNull_tMap_19 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_19 = false;
					boolean mainRowRejected_tMap_19 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row24"
					// /////////////////////////////////////////////

					boolean forceLooprow24 = false;

					row24Struct row24ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_19) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_19 = false;

						row24HashKey.vm_join_id = row25.vm_join_id;

						row24HashKey.hashCodeDirty = true;

						tHash_Lookup_row24.lookup(row24HashKey);

						if (!tHash_Lookup_row24.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_19 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row24 != null
							&& tHash_Lookup_row24.getCount(row24HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row24' and it contains more one result from keys :  row24.vm_join_id = '"
						// + row24HashKey.vm_join_id + "'");
					} // G 071

					row24Struct row24 = null;

					row24Struct fromLookup_row24 = null;
					row24 = row24Default;

					if (tHash_Lookup_row24 != null
							&& tHash_Lookup_row24.hasNext()) { // G 099

						fromLookup_row24 = tHash_Lookup_row24.next();

					} // G 099

					if (fromLookup_row24 != null) {
						row24 = fromLookup_row24;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_19__Struct Var = Var__tMap_19;// ###############################
						// ###############################
						// # Output tables

						delete_vms = null;

						if (!rejectedInnerJoin_tMap_19) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_vms'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_19) {
							delete_vms_tmp.vm_id = row25.vm_id;
							delete_vms_tmp.vm_name = row25.vm_name;
							delete_vms_tmp.vm_description = row25.vm_description;
							delete_vms_tmp.vm_type = row25.vm_type;
							delete_vms_tmp.cluster_id = row25.cluster_id;
							delete_vms_tmp.template_id = row25.template_id;
							delete_vms_tmp.template_name = row25.template_name;
							delete_vms_tmp.cpu_per_socket = row25.cpu_per_socket;
							delete_vms_tmp.number_of_sockets = row25.number_of_sockets;
							delete_vms_tmp.memory_size_mb = row25.memory_size_mb;
							delete_vms_tmp.operating_system = row25.operating_system;
							delete_vms_tmp.ad_domain = row25.ad_domain;
							delete_vms_tmp.default_host = row25.default_host;
							delete_vms_tmp.high_availability = row25.high_availability;
							delete_vms_tmp.initialized = row25.initialized;
							delete_vms_tmp.stateless = row25.stateless;
							delete_vms_tmp.fail_back = row25.fail_back;
							delete_vms_tmp.usb_policy = row25.usb_policy;
							delete_vms_tmp.time_zone = row25.time_zone;
							delete_vms_tmp.cluster_configuration_version = row25.cluster_configuration_version;
							delete_vms_tmp.default_host_configuration_version = row25.default_host_configuration_version;
							delete_vms_tmp.create_date = row25.create_date;
							delete_vms_tmp.update_date = context.runTime;
							delete_vms_tmp.delete_date = context.runTime;
							delete_vms = delete_vms_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_19 = false;

					tos_count_tMap_19++;

					/**
					 * [tMap_19 main ] stop
					 */
					// Start of branch "delete_vms"
					if (delete_vms != null) {

						/**
						 * [tJDBCOutput_19 main ] start
						 */

						currentComponent = "tJDBCOutput_19";

						whetherReject_tJDBCOutput_19 = false;
						if (delete_vms.vm_id == null) {
							pstmt_tJDBCOutput_19.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_19.setObject(1, delete_vms.vm_id);
						}

						if (delete_vms.vm_name == null) {
							pstmt_tJDBCOutput_19.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_19.setString(2,
									delete_vms.vm_name);
						}

						if (delete_vms.vm_description == null) {
							pstmt_tJDBCOutput_19.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_19.setString(3,
									delete_vms.vm_description);
						}

						if (delete_vms.vm_type == null) {
							pstmt_tJDBCOutput_19.setNull(4,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19
									.setShort(4, delete_vms.vm_type);
						}

						if (delete_vms.cluster_id == null) {
							pstmt_tJDBCOutput_19.setNull(5,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_19.setObject(5,
									delete_vms.cluster_id);
						}

						if (delete_vms.template_id == null) {
							pstmt_tJDBCOutput_19.setNull(6,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_19.setObject(6,
									delete_vms.template_id);
						}

						if (delete_vms.template_name == null) {
							pstmt_tJDBCOutput_19.setNull(7,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_19.setString(7,
									delete_vms.template_name);
						}

						if (delete_vms.cpu_per_socket == null) {
							pstmt_tJDBCOutput_19.setNull(8,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19.setShort(8,
									delete_vms.cpu_per_socket);
						}

						if (delete_vms.number_of_sockets == null) {
							pstmt_tJDBCOutput_19.setNull(9,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19.setShort(9,
									delete_vms.number_of_sockets);
						}

						if (delete_vms.memory_size_mb == null) {
							pstmt_tJDBCOutput_19.setNull(10,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19.setInt(10,
									delete_vms.memory_size_mb);
						}

						pstmt_tJDBCOutput_19.setShort(11,
								delete_vms.operating_system);

						if (delete_vms.ad_domain == null) {
							pstmt_tJDBCOutput_19.setNull(12,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_19.setString(12,
									delete_vms.ad_domain);
						}

						if (delete_vms.default_host == null) {
							pstmt_tJDBCOutput_19.setNull(13,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_19.setObject(13,
									delete_vms.default_host);
						}

						if (delete_vms.high_availability == null) {
							pstmt_tJDBCOutput_19.setNull(14,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_19.setBoolean(14,
									delete_vms.high_availability);
						}

						if (delete_vms.initialized == null) {
							pstmt_tJDBCOutput_19.setNull(15,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_19.setBoolean(15,
									delete_vms.initialized);
						}

						if (delete_vms.stateless == null) {
							pstmt_tJDBCOutput_19.setNull(16,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_19.setBoolean(16,
									delete_vms.stateless);
						}

						if (delete_vms.fail_back == null) {
							pstmt_tJDBCOutput_19.setNull(17,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_19.setBoolean(17,
									delete_vms.fail_back);
						}

						if (delete_vms.usb_policy == null) {
							pstmt_tJDBCOutput_19.setNull(18,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19.setShort(18,
									delete_vms.usb_policy);
						}

						if (delete_vms.time_zone == null) {
							pstmt_tJDBCOutput_19.setNull(19,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_19.setString(19,
									delete_vms.time_zone);
						}

						if (delete_vms.cluster_configuration_version == null) {
							pstmt_tJDBCOutput_19.setNull(20,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19.setInt(20,
									delete_vms.cluster_configuration_version);
						}

						if (delete_vms.default_host_configuration_version == null) {
							pstmt_tJDBCOutput_19.setNull(21,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_19
									.setInt(21,
											delete_vms.default_host_configuration_version);
						}

						if (delete_vms.create_date != null) {
							pstmt_tJDBCOutput_19.setTimestamp(22,
									new java.sql.Timestamp(
											delete_vms.create_date.getTime()));
						} else {
							pstmt_tJDBCOutput_19.setNull(22,
									java.sql.Types.DATE);
						}

						if (delete_vms.update_date != null) {
							pstmt_tJDBCOutput_19.setTimestamp(23,
									new java.sql.Timestamp(
											delete_vms.update_date.getTime()));
						} else {
							pstmt_tJDBCOutput_19.setNull(23,
									java.sql.Types.DATE);
						}

						if (delete_vms.delete_date != null) {
							pstmt_tJDBCOutput_19.setTimestamp(24,
									new java.sql.Timestamp(
											delete_vms.delete_date.getTime()));
						} else {
							pstmt_tJDBCOutput_19.setNull(24,
									java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_19 = insertedCount_tJDBCOutput_19
									+ pstmt_tJDBCOutput_19.executeUpdate();
							nb_line_tJDBCOutput_19++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_19 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_19++;

						/**
						 * [tJDBCOutput_19 main ] stop
						 */

					} // End of branch "delete_vms"

					/**
					 * [tJDBCInput_26 end ] start
					 */

					currentComponent = "tJDBCInput_26";

				}
				rs_tJDBCInput_26.close();
				stmt_tJDBCInput_26.close();

				globalMap.put("tJDBCInput_26_NB_LINE", nb_line_tJDBCInput_26);

				ok_Hash.put("tJDBCInput_26", true);
				end_Hash.put("tJDBCInput_26", System.currentTimeMillis());

				/**
				 * [tJDBCInput_26 end ] stop
				 */

				/**
				 * [tMap_19 end ] start
				 */

				currentComponent = "tMap_19";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row24 != null) {
					tHash_Lookup_row24.endGet();
				}
				globalMap.remove("tHash_Lookup_row24");

				// ###############################

				ok_Hash.put("tMap_19", true);
				end_Hash.put("tMap_19", System.currentTimeMillis());

				/**
				 * [tMap_19 end ] stop
				 */

				/**
				 * [tJDBCOutput_19 end ] start
				 */

				currentComponent = "tJDBCOutput_19";

				if (pstmt_tJDBCOutput_19 != null) {

					pstmt_tJDBCOutput_19.close();

				}

				nb_line_deleted_tJDBCOutput_19 = nb_line_deleted_tJDBCOutput_19
						+ deletedCount_tJDBCOutput_19;
				nb_line_update_tJDBCOutput_19 = nb_line_update_tJDBCOutput_19
						+ updatedCount_tJDBCOutput_19;
				nb_line_inserted_tJDBCOutput_19 = nb_line_inserted_tJDBCOutput_19
						+ insertedCount_tJDBCOutput_19;
				nb_line_rejected_tJDBCOutput_19 = nb_line_rejected_tJDBCOutput_19
						+ rejectedCount_tJDBCOutput_19;

				globalMap.put("tJDBCOutput_19_NB_LINE", nb_line_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_19);

				ok_Hash.put("tJDBCOutput_19", true);
				end_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_19 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_26:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_7Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_19"
			globalMap.remove("tHash_Lookup_row24");

		}

		globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", 1);
	}

	public static class vm_disk_configurationStruct implements
			routines.system.IPersistableRow<vm_disk_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Short vm_disk_interface;

		public Short getVm_disk_interface() {
			return this.vm_disk_interface;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.image_id = (Object) dis.readObject();

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_description = readString(dis);

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_interface = null;
					} else {
						this.vm_disk_interface = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.image_id);

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.vm_disk_description, dos);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Short

				if (this.vm_disk_interface == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_interface);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_name, dos);

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("image_id=" + String.valueOf(image_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",vm_disk_interface=" + String.valueOf(vm_disk_interface));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_disk_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row6Struct implements
			routines.system.IPersistableRow<row6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Short vm_disk_interface;

		public Short getVm_disk_interface() {
			return this.vm_disk_interface;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_name = readString(dis);

					this.vm_disk_description = readString(dis);

					this.image_id = (Object) dis.readObject();

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_interface = null;
					} else {
						this.vm_disk_interface = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_name, dos);

				// String

				writeString(this.vm_disk_description, dos);

				// Object

				dos.writeObject(this.image_id);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Short

				if (this.vm_disk_interface == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_interface);
				}

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",vm_disk_interface=" + String.valueOf(vm_disk_interface));
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row6Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_7Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row6Struct row6 = new row6Struct();
				vm_disk_configurationStruct vm_disk_configuration = new vm_disk_configurationStruct();

				/**
				 * [tJDBCOutput_7 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_7", false);
				start_Hash.put("tJDBCOutput_7", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_7";

				int tos_count_tJDBCOutput_7 = 0;

				int nb_line_tJDBCOutput_7 = 0;
				int nb_line_update_tJDBCOutput_7 = 0;
				int nb_line_inserted_tJDBCOutput_7 = 0;
				int nb_line_deleted_tJDBCOutput_7 = 0;
				int nb_line_rejected_tJDBCOutput_7 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_7 = 0;

				int deletedCount_tJDBCOutput_7 = 0;
				int updatedCount_tJDBCOutput_7 = 0;
				int insertedCount_tJDBCOutput_7 = 0;
				int rejectedCount_tJDBCOutput_7 = 0;

				boolean whetherReject_tJDBCOutput_7 = false;

				java.sql.Connection connection_tJDBCOutput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_7) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_7 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_7 = dataSources_tJDBCOutput_7
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_7 = 10000;
				int batchSizeCounter_tJDBCOutput_7 = 0;

				String insert_tJDBCOutput_7 = "INSERT INTO "
						+ "vm_disk_configuration"
						+ " (image_id,storage_domain_id,vm_disk_description,vm_disk_size_mb,vm_disk_type,vm_disk_format,vm_disk_interface,create_date,update_date,delete_date,vm_disk_id,vm_disk_name,is_shared) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_7 = connection_tJDBCOutput_7
						.prepareStatement(insert_tJDBCOutput_7);

				/**
				 * [tJDBCOutput_7 begin ] stop
				 */

				/**
				 * [tMap_7 begin ] start
				 */

				ok_Hash.put("tMap_7", false);
				start_Hash.put("tMap_7", System.currentTimeMillis());
				currentComponent = "tMap_7";

				int tos_count_tMap_7 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_7__Struct {
				}
				Var__tMap_7__Struct Var__tMap_7 = new Var__tMap_7__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_disk_configurationStruct vm_disk_configuration_tmp = new vm_disk_configurationStruct();
				// ###############################

				/**
				 * [tMap_7 begin ] stop
				 */

				/**
				 * [tJDBCInput_7 begin ] start
				 */

				ok_Hash.put("tJDBCInput_7", false);
				start_Hash.put("tJDBCInput_7", System.currentTimeMillis());
				currentComponent = "tJDBCInput_7";

				int tos_count_tJDBCInput_7 = 0;

				int nb_line_tJDBCInput_7 = 0;
				java.sql.Connection conn_tJDBCInput_7 = null;
				conn_tJDBCInput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_7) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_7 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_7 = dataSources_tJDBCInput_7.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_7);
				}

				java.sql.Statement stmt_tJDBCInput_7 = conn_tJDBCInput_7
						.createStatement();

				String dbquery_tJDBCInput_7 = "SELECT vm_disk_id,         vm_disk_name,         vm_disk_description,         image_id, 		storage_domain_id, 		vm_disk_size_mb, 		vm_disk_type, 		vm_disk_format, 		vm_disk_interface,         is_shared, 		create_date, 		update_date  FROM dwh_vm_disk_configuration_history_view";

				globalMap.put("tJDBCInput_7_QUERY", dbquery_tJDBCInput_7);

				java.sql.ResultSet rs_tJDBCInput_7 = stmt_tJDBCInput_7
						.executeQuery(dbquery_tJDBCInput_7);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_7 = rs_tJDBCInput_7
						.getMetaData();
				int colQtyInRs_tJDBCInput_7 = rsmd_tJDBCInput_7
						.getColumnCount();

				String tmpContent_tJDBCInput_7 = null;
				int column_index_tJDBCInput_7 = 1;
				while (rs_tJDBCInput_7.next()) {
					nb_line_tJDBCInput_7++;

					column_index_tJDBCInput_7 = 1;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_id = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.vm_disk_id = rs_tJDBCInput_7
									.getObject(column_index_tJDBCInput_7);
						} else {
							row6.vm_disk_id = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_id = null;
						}
					}
					column_index_tJDBCInput_7 = 2;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_name = null;
					} else {

						tmpContent_tJDBCInput_7 = rs_tJDBCInput_7
								.getString(column_index_tJDBCInput_7);
						if (tmpContent_tJDBCInput_7 != null) {
							row6.vm_disk_name = tmpContent_tJDBCInput_7;
						} else {
							row6.vm_disk_name = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_name = null;
						}
					}
					column_index_tJDBCInput_7 = 3;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_description = null;
					} else {

						tmpContent_tJDBCInput_7 = rs_tJDBCInput_7
								.getString(column_index_tJDBCInput_7);
						if (tmpContent_tJDBCInput_7 != null) {
							row6.vm_disk_description = tmpContent_tJDBCInput_7;
						} else {
							row6.vm_disk_description = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_description = null;
						}
					}
					column_index_tJDBCInput_7 = 4;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.image_id = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.image_id = rs_tJDBCInput_7
									.getObject(column_index_tJDBCInput_7);
						} else {
							row6.image_id = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.image_id = null;
						}
					}
					column_index_tJDBCInput_7 = 5;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.storage_domain_id = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.storage_domain_id = rs_tJDBCInput_7
									.getObject(column_index_tJDBCInput_7);
						} else {
							row6.storage_domain_id = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.storage_domain_id = null;
						}
					}
					column_index_tJDBCInput_7 = 6;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_size_mb = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.vm_disk_size_mb = rs_tJDBCInput_7
									.getInt(column_index_tJDBCInput_7);
						} else {
							row6.vm_disk_size_mb = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_size_mb = null;
						}
					}
					column_index_tJDBCInput_7 = 7;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_type = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.vm_disk_type = rs_tJDBCInput_7
									.getShort(column_index_tJDBCInput_7);
						} else {
							row6.vm_disk_type = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_type = null;
						}
					}
					column_index_tJDBCInput_7 = 8;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_format = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.vm_disk_format = rs_tJDBCInput_7
									.getShort(column_index_tJDBCInput_7);
						} else {
							row6.vm_disk_format = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_format = null;
						}
					}
					column_index_tJDBCInput_7 = 9;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.vm_disk_interface = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.vm_disk_interface = rs_tJDBCInput_7
									.getShort(column_index_tJDBCInput_7);
						} else {
							row6.vm_disk_interface = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.vm_disk_interface = null;
						}
					}
					column_index_tJDBCInput_7 = 10;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.is_shared = null;
					} else {

						if (rs_tJDBCInput_7
								.getObject(column_index_tJDBCInput_7) != null) {
							row6.is_shared = rs_tJDBCInput_7
									.getBoolean(column_index_tJDBCInput_7);
						} else {
							row6.is_shared = null;
						}

						if (rs_tJDBCInput_7.wasNull()) {
							row6.is_shared = null;
						}
					}
					column_index_tJDBCInput_7 = 11;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_7 = null;
						try {
							date_tJDBCInput_7 = rs_tJDBCInput_7
									.getTimestamp(column_index_tJDBCInput_7);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_7 = rs_tJDBCInput_7
									.getDate(column_index_tJDBCInput_7);
						}
						row6.create_date = date_tJDBCInput_7;

						if (rs_tJDBCInput_7.wasNull()) {
							row6.create_date = null;
						}
					}
					column_index_tJDBCInput_7 = 12;

					if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
						row6.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_7 = null;
						try {
							date_tJDBCInput_7 = rs_tJDBCInput_7
									.getTimestamp(column_index_tJDBCInput_7);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_7 = rs_tJDBCInput_7
									.getDate(column_index_tJDBCInput_7);
						}
						row6.update_date = date_tJDBCInput_7;

						if (rs_tJDBCInput_7.wasNull()) {
							row6.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_7 begin ] stop
					 */
					/**
					 * [tJDBCInput_7 main ] start
					 */

					currentComponent = "tJDBCInput_7";

					tos_count_tJDBCInput_7++;

					/**
					 * [tJDBCInput_7 main ] stop
					 */

					/**
					 * [tMap_7 main ] start
					 */

					currentComponent = "tMap_7";

					boolean hasCasePrimitiveKeyWithNull_tMap_7 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_7 = false;
					boolean mainRowRejected_tMap_7 = false;

					if (

					(

					row6.update_date == null ? TalendDate.compareDate(
							row6.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row6.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row6'
						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_7__Struct Var = Var__tMap_7;// ###############################
							// ###############################
							// # Output tables

							vm_disk_configuration = null;

							// # Output table : 'vm_disk_configuration'
							vm_disk_configuration_tmp.image_id = row6.image_id;
							vm_disk_configuration_tmp.storage_domain_id = row6.storage_domain_id;
							vm_disk_configuration_tmp.vm_disk_description = StringHandling
									.TRIM(row6.vm_disk_description);
							vm_disk_configuration_tmp.vm_disk_size_mb = row6.vm_disk_size_mb;
							vm_disk_configuration_tmp.vm_disk_type = row6.vm_disk_type;
							vm_disk_configuration_tmp.vm_disk_format = row6.vm_disk_format;
							vm_disk_configuration_tmp.vm_disk_interface = row6.vm_disk_interface;
							vm_disk_configuration_tmp.create_date = row6.create_date;
							vm_disk_configuration_tmp.update_date = row6.update_date;
							vm_disk_configuration_tmp.delete_date = null;
							vm_disk_configuration_tmp.vm_disk_id = row6.vm_disk_id;
							vm_disk_configuration_tmp.vm_disk_name = row6.vm_disk_name;
							vm_disk_configuration_tmp.is_shared = row6.is_shared;
							vm_disk_configuration = vm_disk_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_7 = false;

						tos_count_tMap_7++;

						/**
						 * [tMap_7 main ] stop
						 */
						// Start of branch "vm_disk_configuration"
						if (vm_disk_configuration != null) {

							/**
							 * [tJDBCOutput_7 main ] start
							 */

							currentComponent = "tJDBCOutput_7";

							whetherReject_tJDBCOutput_7 = false;
							if (vm_disk_configuration.image_id == null) {
								pstmt_tJDBCOutput_7.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_7.setObject(1,
										vm_disk_configuration.image_id);
							}

							if (vm_disk_configuration.storage_domain_id == null) {
								pstmt_tJDBCOutput_7.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_7
										.setObject(
												2,
												vm_disk_configuration.storage_domain_id);
							}

							if (vm_disk_configuration.vm_disk_description == null) {
								pstmt_tJDBCOutput_7.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_7
										.setString(
												3,
												vm_disk_configuration.vm_disk_description);
							}

							if (vm_disk_configuration.vm_disk_size_mb == null) {
								pstmt_tJDBCOutput_7.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7.setInt(4,
										vm_disk_configuration.vm_disk_size_mb);
							}

							if (vm_disk_configuration.vm_disk_type == null) {
								pstmt_tJDBCOutput_7.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7.setShort(5,
										vm_disk_configuration.vm_disk_type);
							}

							if (vm_disk_configuration.vm_disk_format == null) {
								pstmt_tJDBCOutput_7.setNull(6,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7.setShort(6,
										vm_disk_configuration.vm_disk_format);
							}

							if (vm_disk_configuration.vm_disk_interface == null) {
								pstmt_tJDBCOutput_7.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_7
										.setShort(
												7,
												vm_disk_configuration.vm_disk_interface);
							}

							if (vm_disk_configuration.create_date != null) {
								pstmt_tJDBCOutput_7
										.setTimestamp(
												8,
												new java.sql.Timestamp(
														vm_disk_configuration.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_7.setNull(8,
										java.sql.Types.DATE);
							}

							if (vm_disk_configuration.update_date != null) {
								pstmt_tJDBCOutput_7
										.setTimestamp(
												9,
												new java.sql.Timestamp(
														vm_disk_configuration.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_7.setNull(9,
										java.sql.Types.DATE);
							}

							if (vm_disk_configuration.delete_date != null) {
								pstmt_tJDBCOutput_7
										.setTimestamp(
												10,
												new java.sql.Timestamp(
														vm_disk_configuration.delete_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_7.setNull(10,
										java.sql.Types.DATE);
							}

							if (vm_disk_configuration.vm_disk_id == null) {
								pstmt_tJDBCOutput_7.setNull(11,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_7.setObject(11,
										vm_disk_configuration.vm_disk_id);
							}

							if (vm_disk_configuration.vm_disk_name == null) {
								pstmt_tJDBCOutput_7.setNull(12,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_7.setString(12,
										vm_disk_configuration.vm_disk_name);
							}

							if (vm_disk_configuration.is_shared == null) {
								pstmt_tJDBCOutput_7.setNull(13,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_7.setBoolean(13,
										vm_disk_configuration.is_shared);
							}

							try {
								insertedCount_tJDBCOutput_7 = insertedCount_tJDBCOutput_7
										+ pstmt_tJDBCOutput_7.executeUpdate();
								nb_line_tJDBCOutput_7++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_7 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_7++;

							/**
							 * [tJDBCOutput_7 main ] stop
							 */

						} // End of branch "vm_disk_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row6'

					/**
					 * [tJDBCInput_7 end ] start
					 */

					currentComponent = "tJDBCInput_7";

				}
				rs_tJDBCInput_7.close();
				stmt_tJDBCInput_7.close();

				globalMap.put("tJDBCInput_7_NB_LINE", nb_line_tJDBCInput_7);

				ok_Hash.put("tJDBCInput_7", true);
				end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				/**
				 * [tJDBCInput_7 end ] stop
				 */

				/**
				 * [tMap_7 end ] start
				 */

				currentComponent = "tMap_7";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_7", true);
				end_Hash.put("tMap_7", System.currentTimeMillis());

				/**
				 * [tMap_7 end ] stop
				 */

				/**
				 * [tJDBCOutput_7 end ] start
				 */

				currentComponent = "tJDBCOutput_7";

				if (pstmt_tJDBCOutput_7 != null) {

					pstmt_tJDBCOutput_7.close();

				}

				nb_line_deleted_tJDBCOutput_7 = nb_line_deleted_tJDBCOutput_7
						+ deletedCount_tJDBCOutput_7;
				nb_line_update_tJDBCOutput_7 = nb_line_update_tJDBCOutput_7
						+ updatedCount_tJDBCOutput_7;
				nb_line_inserted_tJDBCOutput_7 = nb_line_inserted_tJDBCOutput_7
						+ insertedCount_tJDBCOutput_7;
				nb_line_rejected_tJDBCOutput_7 = nb_line_rejected_tJDBCOutput_7
						+ rejectedCount_tJDBCOutput_7;

				globalMap.put("tJDBCOutput_7_NB_LINE", nb_line_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_7);

				ok_Hash.put("tJDBCOutput_7", true);
				end_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_7 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_7:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_28Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		}

		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 1);
	}

	public static class delete_disksStruct implements
			routines.system.IPersistableRow<delete_disksStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Short vm_disk_interface;

		public Short getVm_disk_interface() {
			return this.vm_disk_interface;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.image_id = (Object) dis.readObject();

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_description = readString(dis);

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_interface = null;
					} else {
						this.vm_disk_interface = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.image_id);

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.vm_disk_description, dos);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Short

				if (this.vm_disk_interface == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_interface);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_name, dos);

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("image_id=" + String.valueOf(image_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",vm_disk_interface=" + String.valueOf(vm_disk_interface));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_disksStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row27Struct implements
			routines.system.IPersistableRow<row27Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Short vm_disk_interface;

		public Short getVm_disk_interface() {
			return this.vm_disk_interface;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_disk_name = readString(dis);

					this.vm_disk_description = readString(dis);

					this.image_id = (Object) dis.readObject();

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_interface = null;
					} else {
						this.vm_disk_interface = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// String

				writeString(this.vm_disk_name, dos);

				// String

				writeString(this.vm_disk_description, dos);

				// Object

				dos.writeObject(this.image_id);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Short

				if (this.vm_disk_interface == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_interface);
				}

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",vm_disk_interface=" + String.valueOf(vm_disk_interface));
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row27Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_28Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_28Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Object image_id;

		public Object getImage_id() {
			return this.image_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Short vm_disk_interface;

		public Short getVm_disk_interface() {
			return this.vm_disk_interface;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_disk_name = readString(dis);

					this.vm_disk_description = readString(dis);

					this.image_id = (Object) dis.readObject();

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_interface = null;
					} else {
						this.vm_disk_interface = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// String

				writeString(this.vm_disk_name, dos);

				// String

				writeString(this.vm_disk_description, dos);

				// Object

				dos.writeObject(this.image_id);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Short

				if (this.vm_disk_interface == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_interface);
				}

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",image_id=" + String.valueOf(image_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",vm_disk_interface=" + String.valueOf(vm_disk_interface));
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_28Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_28Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_28_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_27Process(globalMap);

				row27Struct row27 = new row27Struct();
				delete_disksStruct delete_disks = new delete_disksStruct();

				/**
				 * [tJDBCOutput_20 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_20", false);
				start_Hash.put("tJDBCOutput_20", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_20";

				int tos_count_tJDBCOutput_20 = 0;

				int nb_line_tJDBCOutput_20 = 0;
				int nb_line_update_tJDBCOutput_20 = 0;
				int nb_line_inserted_tJDBCOutput_20 = 0;
				int nb_line_deleted_tJDBCOutput_20 = 0;
				int nb_line_rejected_tJDBCOutput_20 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_20 = 0;

				int deletedCount_tJDBCOutput_20 = 0;
				int updatedCount_tJDBCOutput_20 = 0;
				int insertedCount_tJDBCOutput_20 = 0;
				int rejectedCount_tJDBCOutput_20 = 0;

				boolean whetherReject_tJDBCOutput_20 = false;

				java.sql.Connection connection_tJDBCOutput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_20) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_20 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_20 = dataSources_tJDBCOutput_20.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_20 = 10000;
				int batchSizeCounter_tJDBCOutput_20 = 0;

				String insert_tJDBCOutput_20 = "INSERT INTO "
						+ "vm_disk_configuration"
						+ " (image_id,storage_domain_id,vm_disk_description,vm_disk_size_mb,vm_disk_type,vm_disk_format,vm_disk_interface,create_date,update_date,delete_date,vm_disk_id,vm_disk_name,is_shared) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_20 = connection_tJDBCOutput_20
						.prepareStatement(insert_tJDBCOutput_20);

				/**
				 * [tJDBCOutput_20 begin ] stop
				 */

				/**
				 * [tMap_20 begin ] start
				 */

				ok_Hash.put("tMap_20", false);
				start_Hash.put("tMap_20", System.currentTimeMillis());
				currentComponent = "tMap_20";

				int tos_count_tMap_20 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row26Struct> tHash_Lookup_row26 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row26Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row26Struct>) globalMap
						.get("tHash_Lookup_row26"));

				row26Struct row26HashKey = new row26Struct();
				row26Struct row26Default = new row26Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_20__Struct {
				}
				Var__tMap_20__Struct Var__tMap_20 = new Var__tMap_20__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_disksStruct delete_disks_tmp = new delete_disksStruct();
				// ###############################

				/**
				 * [tMap_20 begin ] stop
				 */

				/**
				 * [tJDBCInput_28 begin ] start
				 */

				ok_Hash.put("tJDBCInput_28", false);
				start_Hash.put("tJDBCInput_28", System.currentTimeMillis());
				currentComponent = "tJDBCInput_28";

				int tos_count_tJDBCInput_28 = 0;

				int nb_line_tJDBCInput_28 = 0;
				java.sql.Connection conn_tJDBCInput_28 = null;
				conn_tJDBCInput_28 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_28) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_28 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_28 = dataSources_tJDBCInput_28.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_28);
				}

				java.sql.Statement stmt_tJDBCInput_28 = conn_tJDBCInput_28
						.createStatement();

				String dbquery_tJDBCInput_28 = "SELECT	history_id,   		vm_disk_id,   		upper(cast(vm_disk_id as char(36))) as vm_disk_join_id,         vm_disk_name,         vm_disk_description,         image_id,  		storage_domain_id,  		vm_disk_size_mb,  		vm_disk_type,   		vm_disk_format,    		vm_disk_interface,         is_shared,  		create_date,   		update_date  FROM v3_3_latest_configuration_vms_disks";

				globalMap.put("tJDBCInput_28_QUERY", dbquery_tJDBCInput_28);

				java.sql.ResultSet rs_tJDBCInput_28 = stmt_tJDBCInput_28
						.executeQuery(dbquery_tJDBCInput_28);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_28 = rs_tJDBCInput_28
						.getMetaData();
				int colQtyInRs_tJDBCInput_28 = rsmd_tJDBCInput_28
						.getColumnCount();

				String tmpContent_tJDBCInput_28 = null;
				int column_index_tJDBCInput_28 = 1;
				while (rs_tJDBCInput_28.next()) {
					nb_line_tJDBCInput_28++;

					column_index_tJDBCInput_28 = 1;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.history_id = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.history_id = rs_tJDBCInput_28
									.getInt(column_index_tJDBCInput_28);
						} else {
							row27.history_id = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.history_id = null;
						}
					}
					column_index_tJDBCInput_28 = 2;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_id = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.vm_disk_id = rs_tJDBCInput_28
									.getObject(column_index_tJDBCInput_28);
						} else {
							row27.vm_disk_id = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_id = null;
						}
					}
					column_index_tJDBCInput_28 = 3;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_join_id = null;
					} else {

						tmpContent_tJDBCInput_28 = rs_tJDBCInput_28
								.getString(column_index_tJDBCInput_28);
						if (tmpContent_tJDBCInput_28 != null) {
							row27.vm_disk_join_id = tmpContent_tJDBCInput_28;
						} else {
							row27.vm_disk_join_id = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_join_id = null;
						}
					}
					column_index_tJDBCInput_28 = 4;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_name = null;
					} else {

						tmpContent_tJDBCInput_28 = rs_tJDBCInput_28
								.getString(column_index_tJDBCInput_28);
						if (tmpContent_tJDBCInput_28 != null) {
							row27.vm_disk_name = tmpContent_tJDBCInput_28;
						} else {
							row27.vm_disk_name = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_name = null;
						}
					}
					column_index_tJDBCInput_28 = 5;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_description = null;
					} else {

						tmpContent_tJDBCInput_28 = rs_tJDBCInput_28
								.getString(column_index_tJDBCInput_28);
						if (tmpContent_tJDBCInput_28 != null) {
							row27.vm_disk_description = tmpContent_tJDBCInput_28;
						} else {
							row27.vm_disk_description = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_description = null;
						}
					}
					column_index_tJDBCInput_28 = 6;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.image_id = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.image_id = rs_tJDBCInput_28
									.getObject(column_index_tJDBCInput_28);
						} else {
							row27.image_id = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.image_id = null;
						}
					}
					column_index_tJDBCInput_28 = 7;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.storage_domain_id = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.storage_domain_id = rs_tJDBCInput_28
									.getObject(column_index_tJDBCInput_28);
						} else {
							row27.storage_domain_id = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.storage_domain_id = null;
						}
					}
					column_index_tJDBCInput_28 = 8;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_size_mb = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.vm_disk_size_mb = rs_tJDBCInput_28
									.getInt(column_index_tJDBCInput_28);
						} else {
							row27.vm_disk_size_mb = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_size_mb = null;
						}
					}
					column_index_tJDBCInput_28 = 9;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_type = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.vm_disk_type = rs_tJDBCInput_28
									.getShort(column_index_tJDBCInput_28);
						} else {
							row27.vm_disk_type = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_type = null;
						}
					}
					column_index_tJDBCInput_28 = 10;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_format = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.vm_disk_format = rs_tJDBCInput_28
									.getShort(column_index_tJDBCInput_28);
						} else {
							row27.vm_disk_format = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_format = null;
						}
					}
					column_index_tJDBCInput_28 = 11;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.vm_disk_interface = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.vm_disk_interface = rs_tJDBCInput_28
									.getShort(column_index_tJDBCInput_28);
						} else {
							row27.vm_disk_interface = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.vm_disk_interface = null;
						}
					}
					column_index_tJDBCInput_28 = 12;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.is_shared = null;
					} else {

						if (rs_tJDBCInput_28
								.getObject(column_index_tJDBCInput_28) != null) {
							row27.is_shared = rs_tJDBCInput_28
									.getBoolean(column_index_tJDBCInput_28);
						} else {
							row27.is_shared = null;
						}

						if (rs_tJDBCInput_28.wasNull()) {
							row27.is_shared = null;
						}
					}
					column_index_tJDBCInput_28 = 13;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_28 = null;
						try {
							date_tJDBCInput_28 = rs_tJDBCInput_28
									.getTimestamp(column_index_tJDBCInput_28);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_28 = rs_tJDBCInput_28
									.getDate(column_index_tJDBCInput_28);
						}
						row27.create_date = date_tJDBCInput_28;

						if (rs_tJDBCInput_28.wasNull()) {
							row27.create_date = null;
						}
					}
					column_index_tJDBCInput_28 = 14;

					if (colQtyInRs_tJDBCInput_28 < column_index_tJDBCInput_28) {
						row27.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_28 = null;
						try {
							date_tJDBCInput_28 = rs_tJDBCInput_28
									.getTimestamp(column_index_tJDBCInput_28);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_28 = rs_tJDBCInput_28
									.getDate(column_index_tJDBCInput_28);
						}
						row27.update_date = date_tJDBCInput_28;

						if (rs_tJDBCInput_28.wasNull()) {
							row27.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_28 begin ] stop
					 */
					/**
					 * [tJDBCInput_28 main ] start
					 */

					currentComponent = "tJDBCInput_28";

					tos_count_tJDBCInput_28++;

					/**
					 * [tJDBCInput_28 main ] stop
					 */

					/**
					 * [tMap_20 main ] start
					 */

					currentComponent = "tMap_20";

					boolean hasCasePrimitiveKeyWithNull_tMap_20 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_20 = false;
					boolean mainRowRejected_tMap_20 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row26"
					// /////////////////////////////////////////////

					boolean forceLooprow26 = false;

					row26Struct row26ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_20) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_20 = false;

						row26HashKey.vm_disk_join_id = row27.vm_disk_join_id;

						row26HashKey.hashCodeDirty = true;

						tHash_Lookup_row26.lookup(row26HashKey);

						if (!tHash_Lookup_row26.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_20 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row26 != null
							&& tHash_Lookup_row26.getCount(row26HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row26' and it contains more one result from keys :  row26.vm_disk_join_id = '"
						// + row26HashKey.vm_disk_join_id + "'");
					} // G 071

					row26Struct row26 = null;

					row26Struct fromLookup_row26 = null;
					row26 = row26Default;

					if (tHash_Lookup_row26 != null
							&& tHash_Lookup_row26.hasNext()) { // G 099

						fromLookup_row26 = tHash_Lookup_row26.next();

					} // G 099

					if (fromLookup_row26 != null) {
						row26 = fromLookup_row26;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_20__Struct Var = Var__tMap_20;// ###############################
						// ###############################
						// # Output tables

						delete_disks = null;

						if (!rejectedInnerJoin_tMap_20) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_disks'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_20) {
							delete_disks_tmp.image_id = row27.image_id;
							delete_disks_tmp.storage_domain_id = row27.storage_domain_id;
							delete_disks_tmp.vm_disk_description = row27.vm_disk_description;
							delete_disks_tmp.vm_disk_size_mb = row27.vm_disk_size_mb;
							delete_disks_tmp.vm_disk_type = row27.vm_disk_type;
							delete_disks_tmp.vm_disk_format = row27.vm_disk_format;
							delete_disks_tmp.vm_disk_interface = row27.vm_disk_interface;
							delete_disks_tmp.create_date = row27.create_date;
							delete_disks_tmp.update_date = context.runTime;
							delete_disks_tmp.delete_date = context.runTime;
							delete_disks_tmp.vm_disk_id = row27.vm_disk_id;
							delete_disks_tmp.vm_disk_name = row27.vm_disk_name;
							delete_disks_tmp.is_shared = row27.is_shared;
							delete_disks = delete_disks_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_20 = false;

					tos_count_tMap_20++;

					/**
					 * [tMap_20 main ] stop
					 */
					// Start of branch "delete_disks"
					if (delete_disks != null) {

						/**
						 * [tJDBCOutput_20 main ] start
						 */

						currentComponent = "tJDBCOutput_20";

						whetherReject_tJDBCOutput_20 = false;
						if (delete_disks.image_id == null) {
							pstmt_tJDBCOutput_20.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_20.setObject(1,
									delete_disks.image_id);
						}

						if (delete_disks.storage_domain_id == null) {
							pstmt_tJDBCOutput_20.setNull(2,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_20.setObject(2,
									delete_disks.storage_domain_id);
						}

						if (delete_disks.vm_disk_description == null) {
							pstmt_tJDBCOutput_20.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_20.setString(3,
									delete_disks.vm_disk_description);
						}

						if (delete_disks.vm_disk_size_mb == null) {
							pstmt_tJDBCOutput_20.setNull(4,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_20.setInt(4,
									delete_disks.vm_disk_size_mb);
						}

						if (delete_disks.vm_disk_type == null) {
							pstmt_tJDBCOutput_20.setNull(5,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_20.setShort(5,
									delete_disks.vm_disk_type);
						}

						if (delete_disks.vm_disk_format == null) {
							pstmt_tJDBCOutput_20.setNull(6,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_20.setShort(6,
									delete_disks.vm_disk_format);
						}

						if (delete_disks.vm_disk_interface == null) {
							pstmt_tJDBCOutput_20.setNull(7,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_20.setShort(7,
									delete_disks.vm_disk_interface);
						}

						if (delete_disks.create_date != null) {
							pstmt_tJDBCOutput_20
									.setTimestamp(8, new java.sql.Timestamp(
											delete_disks.create_date.getTime()));
						} else {
							pstmt_tJDBCOutput_20
									.setNull(8, java.sql.Types.DATE);
						}

						if (delete_disks.update_date != null) {
							pstmt_tJDBCOutput_20
									.setTimestamp(9, new java.sql.Timestamp(
											delete_disks.update_date.getTime()));
						} else {
							pstmt_tJDBCOutput_20
									.setNull(9, java.sql.Types.DATE);
						}

						if (delete_disks.delete_date != null) {
							pstmt_tJDBCOutput_20
									.setTimestamp(10, new java.sql.Timestamp(
											delete_disks.delete_date.getTime()));
						} else {
							pstmt_tJDBCOutput_20.setNull(10,
									java.sql.Types.DATE);
						}

						if (delete_disks.vm_disk_id == null) {
							pstmt_tJDBCOutput_20.setNull(11,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_20.setObject(11,
									delete_disks.vm_disk_id);
						}

						if (delete_disks.vm_disk_name == null) {
							pstmt_tJDBCOutput_20.setNull(12,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_20.setString(12,
									delete_disks.vm_disk_name);
						}

						if (delete_disks.is_shared == null) {
							pstmt_tJDBCOutput_20.setNull(13,
									java.sql.Types.BOOLEAN);
						} else {
							pstmt_tJDBCOutput_20.setBoolean(13,
									delete_disks.is_shared);
						}

						try {
							insertedCount_tJDBCOutput_20 = insertedCount_tJDBCOutput_20
									+ pstmt_tJDBCOutput_20.executeUpdate();
							nb_line_tJDBCOutput_20++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_20 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_20++;

						/**
						 * [tJDBCOutput_20 main ] stop
						 */

					} // End of branch "delete_disks"

					/**
					 * [tJDBCInput_28 end ] start
					 */

					currentComponent = "tJDBCInput_28";

				}
				rs_tJDBCInput_28.close();
				stmt_tJDBCInput_28.close();

				globalMap.put("tJDBCInput_28_NB_LINE", nb_line_tJDBCInput_28);

				ok_Hash.put("tJDBCInput_28", true);
				end_Hash.put("tJDBCInput_28", System.currentTimeMillis());

				/**
				 * [tJDBCInput_28 end ] stop
				 */

				/**
				 * [tMap_20 end ] start
				 */

				currentComponent = "tMap_20";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row26 != null) {
					tHash_Lookup_row26.endGet();
				}
				globalMap.remove("tHash_Lookup_row26");

				// ###############################

				ok_Hash.put("tMap_20", true);
				end_Hash.put("tMap_20", System.currentTimeMillis());

				/**
				 * [tMap_20 end ] stop
				 */

				/**
				 * [tJDBCOutput_20 end ] start
				 */

				currentComponent = "tJDBCOutput_20";

				if (pstmt_tJDBCOutput_20 != null) {

					pstmt_tJDBCOutput_20.close();

				}

				nb_line_deleted_tJDBCOutput_20 = nb_line_deleted_tJDBCOutput_20
						+ deletedCount_tJDBCOutput_20;
				nb_line_update_tJDBCOutput_20 = nb_line_update_tJDBCOutput_20
						+ updatedCount_tJDBCOutput_20;
				nb_line_inserted_tJDBCOutput_20 = nb_line_inserted_tJDBCOutput_20
						+ insertedCount_tJDBCOutput_20;
				nb_line_rejected_tJDBCOutput_20 = nb_line_rejected_tJDBCOutput_20
						+ rejectedCount_tJDBCOutput_20;

				globalMap.put("tJDBCOutput_20_NB_LINE", nb_line_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_20);

				ok_Hash.put("tJDBCOutput_20", true);
				end_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_20 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_28:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_61Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_20"
			globalMap.remove("tHash_Lookup_row26");

		}

		globalMap.put("tJDBCInput_28_SUBPROCESS_STATE", 1);
	}

	public static class insert_new_vm_disk_connectionStruct
			implements
			routines.system.IPersistableRow<insert_new_vm_disk_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		public java.util.Date detach_date;

		public java.util.Date getDetach_date() {
			return this.detach_date;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_id = (Object) dis.readObject();

					this.attach_date = readDate(dis);

					this.detach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.vm_id);

				// java.util.Date

				writeDate(this.attach_date, dos);

				// java.util.Date

				writeDate(this.detach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append(",detach_date=" + String.valueOf(detach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(insert_new_vm_disk_connectionStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row49Struct implements
			routines.system.IPersistableRow<row49Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row49Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_61Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_61Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_61Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_61Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_61_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_63Process(globalMap);

				row49Struct row49 = new row49Struct();
				insert_new_vm_disk_connectionStruct insert_new_vm_disk_connection = new insert_new_vm_disk_connectionStruct();

				/**
				 * [tJDBCOutput_35 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_35", false);
				start_Hash.put("tJDBCOutput_35", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_35";

				int tos_count_tJDBCOutput_35 = 0;

				int nb_line_tJDBCOutput_35 = 0;
				int nb_line_update_tJDBCOutput_35 = 0;
				int nb_line_inserted_tJDBCOutput_35 = 0;
				int nb_line_deleted_tJDBCOutput_35 = 0;
				int nb_line_rejected_tJDBCOutput_35 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_35 = 0;

				int deletedCount_tJDBCOutput_35 = 0;
				int updatedCount_tJDBCOutput_35 = 0;
				int insertedCount_tJDBCOutput_35 = 0;
				int rejectedCount_tJDBCOutput_35 = 0;

				boolean whetherReject_tJDBCOutput_35 = false;

				java.sql.Connection connection_tJDBCOutput_35 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_35) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_35 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_35 = dataSources_tJDBCOutput_35.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_35 = 10000;
				int batchSizeCounter_tJDBCOutput_35 = 0;

				String insert_tJDBCOutput_35 = "INSERT INTO "
						+ "disks_vm_map"
						+ " (vm_disk_id,vm_id,attach_date,detach_date) VALUES (?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_35 = connection_tJDBCOutput_35
						.prepareStatement(insert_tJDBCOutput_35);

				/**
				 * [tJDBCOutput_35 begin ] stop
				 */

				/**
				 * [tMap_33 begin ] start
				 */

				ok_Hash.put("tMap_33", false);
				start_Hash.put("tMap_33", System.currentTimeMillis());
				currentComponent = "tMap_33";

				int tos_count_tMap_33 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row51Struct> tHash_Lookup_row51 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row51Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row51Struct>) globalMap
						.get("tHash_Lookup_row51"));

				row51Struct row51HashKey = new row51Struct();
				row51Struct row51Default = new row51Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_33__Struct {
				}
				Var__tMap_33__Struct Var__tMap_33 = new Var__tMap_33__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				insert_new_vm_disk_connectionStruct insert_new_vm_disk_connection_tmp = new insert_new_vm_disk_connectionStruct();
				// ###############################

				/**
				 * [tMap_33 begin ] stop
				 */

				/**
				 * [tJDBCInput_61 begin ] start
				 */

				ok_Hash.put("tJDBCInput_61", false);
				start_Hash.put("tJDBCInput_61", System.currentTimeMillis());
				currentComponent = "tJDBCInput_61";

				int tos_count_tJDBCInput_61 = 0;

				int nb_line_tJDBCInput_61 = 0;
				java.sql.Connection conn_tJDBCInput_61 = null;
				conn_tJDBCInput_61 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_61) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_61 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_61 = dataSources_tJDBCInput_61.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_61);
				}

				java.sql.Statement stmt_tJDBCInput_61 = conn_tJDBCInput_61
						.createStatement();

				String dbquery_tJDBCInput_61 = "SELECT    vm_disk_id,    upper(cast(vm_disk_id as char(36))) as vm_disk_join_id,    vm_id,    upper(cast(vm_id as char(36))) as vm_join_id FROM dwh_disk_vm_map_history_view";

				globalMap.put("tJDBCInput_61_QUERY", dbquery_tJDBCInput_61);

				java.sql.ResultSet rs_tJDBCInput_61 = stmt_tJDBCInput_61
						.executeQuery(dbquery_tJDBCInput_61);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_61 = rs_tJDBCInput_61
						.getMetaData();
				int colQtyInRs_tJDBCInput_61 = rsmd_tJDBCInput_61
						.getColumnCount();

				String tmpContent_tJDBCInput_61 = null;
				int column_index_tJDBCInput_61 = 1;
				while (rs_tJDBCInput_61.next()) {
					nb_line_tJDBCInput_61++;

					column_index_tJDBCInput_61 = 1;

					if (colQtyInRs_tJDBCInput_61 < column_index_tJDBCInput_61) {
						row49.vm_disk_id = null;
					} else {

						if (rs_tJDBCInput_61
								.getObject(column_index_tJDBCInput_61) != null) {
							row49.vm_disk_id = rs_tJDBCInput_61
									.getObject(column_index_tJDBCInput_61);
						} else {
							row49.vm_disk_id = null;
						}

						if (rs_tJDBCInput_61.wasNull()) {
							row49.vm_disk_id = null;
						}
					}
					column_index_tJDBCInput_61 = 2;

					if (colQtyInRs_tJDBCInput_61 < column_index_tJDBCInput_61) {
						row49.vm_disk_join_id = null;
					} else {

						tmpContent_tJDBCInput_61 = rs_tJDBCInput_61
								.getString(column_index_tJDBCInput_61);
						if (tmpContent_tJDBCInput_61 != null) {
							row49.vm_disk_join_id = tmpContent_tJDBCInput_61;
						} else {
							row49.vm_disk_join_id = null;
						}

						if (rs_tJDBCInput_61.wasNull()) {
							row49.vm_disk_join_id = null;
						}
					}
					column_index_tJDBCInput_61 = 3;

					if (colQtyInRs_tJDBCInput_61 < column_index_tJDBCInput_61) {
						row49.vm_id = null;
					} else {

						if (rs_tJDBCInput_61
								.getObject(column_index_tJDBCInput_61) != null) {
							row49.vm_id = rs_tJDBCInput_61
									.getObject(column_index_tJDBCInput_61);
						} else {
							row49.vm_id = null;
						}

						if (rs_tJDBCInput_61.wasNull()) {
							row49.vm_id = null;
						}
					}
					column_index_tJDBCInput_61 = 4;

					if (colQtyInRs_tJDBCInput_61 < column_index_tJDBCInput_61) {
						row49.vm_join_id = null;
					} else {

						tmpContent_tJDBCInput_61 = rs_tJDBCInput_61
								.getString(column_index_tJDBCInput_61);
						if (tmpContent_tJDBCInput_61 != null) {
							row49.vm_join_id = tmpContent_tJDBCInput_61;
						} else {
							row49.vm_join_id = null;
						}

						if (rs_tJDBCInput_61.wasNull()) {
							row49.vm_join_id = null;
						}
					}

					/**
					 * [tJDBCInput_61 begin ] stop
					 */
					/**
					 * [tJDBCInput_61 main ] start
					 */

					currentComponent = "tJDBCInput_61";

					tos_count_tJDBCInput_61++;

					/**
					 * [tJDBCInput_61 main ] stop
					 */

					/**
					 * [tMap_33 main ] start
					 */

					currentComponent = "tMap_33";

					boolean hasCasePrimitiveKeyWithNull_tMap_33 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_33 = false;
					boolean mainRowRejected_tMap_33 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row51"
					// /////////////////////////////////////////////

					boolean forceLooprow51 = false;

					row51Struct row51ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_33) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_33 = false;

						row51HashKey.vm_disk_join_id = row49.vm_disk_join_id;

						row51HashKey.vm_join_id = row49.vm_join_id;

						row51HashKey.hashCodeDirty = true;

						tHash_Lookup_row51.lookup(row51HashKey);

						if (!tHash_Lookup_row51.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_33 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row51 != null
							&& tHash_Lookup_row51.getCount(row51HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row51' and it contains more one result from keys :  row51.vm_disk_join_id = '"
						// + row51HashKey.vm_disk_join_id +
						// "', row51.vm_join_id = '" + row51HashKey.vm_join_id +
						// "'");
					} // G 071

					row51Struct row51 = null;

					row51Struct fromLookup_row51 = null;
					row51 = row51Default;

					if (tHash_Lookup_row51 != null
							&& tHash_Lookup_row51.hasNext()) { // G 099

						fromLookup_row51 = tHash_Lookup_row51.next();

					} // G 099

					if (fromLookup_row51 != null) {
						row51 = fromLookup_row51;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_33__Struct Var = Var__tMap_33;// ###############################
						// ###############################
						// # Output tables

						insert_new_vm_disk_connection = null;

						if (!rejectedInnerJoin_tMap_33) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table :
						// 'insert_new_vm_disk_connection'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_33) {
							insert_new_vm_disk_connection_tmp.vm_disk_id = row49.vm_disk_id;
							insert_new_vm_disk_connection_tmp.vm_id = row49.vm_id;
							insert_new_vm_disk_connection_tmp.attach_date = context.runTime;
							insert_new_vm_disk_connection_tmp.detach_date = null;
							insert_new_vm_disk_connection = insert_new_vm_disk_connection_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_33 = false;

					tos_count_tMap_33++;

					/**
					 * [tMap_33 main ] stop
					 */
					// Start of branch "insert_new_vm_disk_connection"
					if (insert_new_vm_disk_connection != null) {

						/**
						 * [tJDBCOutput_35 main ] start
						 */

						currentComponent = "tJDBCOutput_35";

						whetherReject_tJDBCOutput_35 = false;
						if (insert_new_vm_disk_connection.vm_disk_id == null) {
							pstmt_tJDBCOutput_35.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_35.setObject(1,
									insert_new_vm_disk_connection.vm_disk_id);
						}

						if (insert_new_vm_disk_connection.vm_id == null) {
							pstmt_tJDBCOutput_35.setNull(2,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_35.setObject(2,
									insert_new_vm_disk_connection.vm_id);
						}

						if (insert_new_vm_disk_connection.attach_date != null) {
							pstmt_tJDBCOutput_35
									.setTimestamp(
											3,
											new java.sql.Timestamp(
													insert_new_vm_disk_connection.attach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_35
									.setNull(3, java.sql.Types.DATE);
						}

						if (insert_new_vm_disk_connection.detach_date != null) {
							pstmt_tJDBCOutput_35
									.setTimestamp(
											4,
											new java.sql.Timestamp(
													insert_new_vm_disk_connection.detach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_35
									.setNull(4, java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_35 = insertedCount_tJDBCOutput_35
									+ pstmt_tJDBCOutput_35.executeUpdate();
							nb_line_tJDBCOutput_35++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_35 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_35++;

						/**
						 * [tJDBCOutput_35 main ] stop
						 */

					} // End of branch "insert_new_vm_disk_connection"

					/**
					 * [tJDBCInput_61 end ] start
					 */

					currentComponent = "tJDBCInput_61";

				}
				rs_tJDBCInput_61.close();
				stmt_tJDBCInput_61.close();

				globalMap.put("tJDBCInput_61_NB_LINE", nb_line_tJDBCInput_61);

				ok_Hash.put("tJDBCInput_61", true);
				end_Hash.put("tJDBCInput_61", System.currentTimeMillis());

				/**
				 * [tJDBCInput_61 end ] stop
				 */

				/**
				 * [tMap_33 end ] start
				 */

				currentComponent = "tMap_33";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row51 != null) {
					tHash_Lookup_row51.endGet();
				}
				globalMap.remove("tHash_Lookup_row51");

				// ###############################

				ok_Hash.put("tMap_33", true);
				end_Hash.put("tMap_33", System.currentTimeMillis());

				/**
				 * [tMap_33 end ] stop
				 */

				/**
				 * [tJDBCOutput_35 end ] start
				 */

				currentComponent = "tJDBCOutput_35";

				if (pstmt_tJDBCOutput_35 != null) {

					pstmt_tJDBCOutput_35.close();

				}

				nb_line_deleted_tJDBCOutput_35 = nb_line_deleted_tJDBCOutput_35
						+ deletedCount_tJDBCOutput_35;
				nb_line_update_tJDBCOutput_35 = nb_line_update_tJDBCOutput_35
						+ updatedCount_tJDBCOutput_35;
				nb_line_inserted_tJDBCOutput_35 = nb_line_inserted_tJDBCOutput_35
						+ insertedCount_tJDBCOutput_35;
				nb_line_rejected_tJDBCOutput_35 = nb_line_rejected_tJDBCOutput_35
						+ rejectedCount_tJDBCOutput_35;

				globalMap.put("tJDBCOutput_35_NB_LINE", nb_line_tJDBCOutput_35);
				globalMap.put("tJDBCOutput_35_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_35);
				globalMap.put("tJDBCOutput_35_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_35);
				globalMap.put("tJDBCOutput_35_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_35);
				globalMap.put("tJDBCOutput_35_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_35);

				ok_Hash.put("tJDBCOutput_35", true);
				end_Hash.put("tJDBCOutput_35", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_35 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_61:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_62Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_33"
			globalMap.remove("tHash_Lookup_row51");

		}

		globalMap.put("tJDBCInput_61_SUBPROCESS_STATE", 1);
	}

	public static class delete_vm_disk_connectionStruct implements
			routines.system.IPersistableRow<delete_vm_disk_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		public java.util.Date detach_date;

		public java.util.Date getDetach_date() {
			return this.detach_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.vm_disk_id == null) ? 0 : this.vm_disk_id
								.hashCode());

				result = prime * result
						+ ((this.vm_id == null) ? 0 : this.vm_id.hashCode());

				result = prime
						* result
						+ ((this.attach_date == null) ? 0 : this.attach_date
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final delete_vm_disk_connectionStruct other = (delete_vm_disk_connectionStruct) obj;

			if (this.vm_disk_id == null) {
				if (other.vm_disk_id != null)
					return false;
			} else if (!this.vm_disk_id.equals(other.vm_disk_id))
				return false;

			if (this.vm_id == null) {
				if (other.vm_id != null)
					return false;
			} else if (!this.vm_id.equals(other.vm_id))
				return false;

			if (this.attach_date == null) {
				if (other.attach_date != null)
					return false;
			} else if (!this.attach_date.equals(other.attach_date))
				return false;

			return true;
		}

		public void copyDataTo(delete_vm_disk_connectionStruct other) {

			other.vm_disk_id = this.vm_disk_id;
			other.vm_id = this.vm_id;
			other.attach_date = this.attach_date;
			other.detach_date = this.detach_date;

		}

		public void copyKeysDataTo(delete_vm_disk_connectionStruct other) {

			other.vm_disk_id = this.vm_disk_id;
			other.vm_id = this.vm_id;
			other.attach_date = this.attach_date;

		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_id = (Object) dis.readObject();

					this.attach_date = readDate(dis);

					this.detach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// Object

				dos.writeObject(this.vm_id);

				// java.util.Date

				writeDate(this.attach_date, dos);

				// java.util.Date

				writeDate(this.detach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append(",detach_date=" + String.valueOf(detach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vm_disk_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.vm_disk_id,
					other.vm_disk_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.vm_id, other.vm_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.attach_date,
					other.attach_date);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row50Struct implements
			routines.system.IPersistableRow<row50Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.attach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// java.util.Date

				writeDate(this.attach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row50Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_62Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_62Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.attach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// java.util.Date

				writeDate(this.attach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_62Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_62Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_62_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_64Process(globalMap);

				row50Struct row50 = new row50Struct();
				delete_vm_disk_connectionStruct delete_vm_disk_connection = new delete_vm_disk_connectionStruct();

				/**
				 * [tJDBCOutput_36 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_36", false);
				start_Hash.put("tJDBCOutput_36", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_36";

				int tos_count_tJDBCOutput_36 = 0;

				int updateKeyCount_tJDBCOutput_36 = 3;
				if (updateKeyCount_tJDBCOutput_36 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_36 = 0;
				int nb_line_update_tJDBCOutput_36 = 0;
				int nb_line_inserted_tJDBCOutput_36 = 0;
				int nb_line_deleted_tJDBCOutput_36 = 0;
				int nb_line_rejected_tJDBCOutput_36 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_36 = 0;

				int deletedCount_tJDBCOutput_36 = 0;
				int updatedCount_tJDBCOutput_36 = 0;
				int insertedCount_tJDBCOutput_36 = 0;
				int rejectedCount_tJDBCOutput_36 = 0;

				boolean whetherReject_tJDBCOutput_36 = false;

				java.sql.Connection connection_tJDBCOutput_36 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_36) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_36 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_36 = dataSources_tJDBCOutput_36.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_36 = 10000;
				int batchSizeCounter_tJDBCOutput_36 = 0;

				String update_tJDBCOutput_36 = "UPDATE "
						+ "disks_vm_map"
						+ " SET detach_date = ? WHERE vm_disk_id = ? AND vm_id = ? AND attach_date = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_36 = connection_tJDBCOutput_36
						.prepareStatement(update_tJDBCOutput_36);

				/**
				 * [tJDBCOutput_36 begin ] stop
				 */

				/**
				 * [tMap_34 begin ] start
				 */

				ok_Hash.put("tMap_34", false);
				start_Hash.put("tMap_34", System.currentTimeMillis());
				currentComponent = "tMap_34";

				int tos_count_tMap_34 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row52Struct> tHash_Lookup_row52 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row52Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row52Struct>) globalMap
						.get("tHash_Lookup_row52"));

				row52Struct row52HashKey = new row52Struct();
				row52Struct row52Default = new row52Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_34__Struct {
				}
				Var__tMap_34__Struct Var__tMap_34 = new Var__tMap_34__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_vm_disk_connectionStruct delete_vm_disk_connection_tmp = new delete_vm_disk_connectionStruct();
				// ###############################

				/**
				 * [tMap_34 begin ] stop
				 */

				/**
				 * [tJDBCInput_62 begin ] start
				 */

				ok_Hash.put("tJDBCInput_62", false);
				start_Hash.put("tJDBCInput_62", System.currentTimeMillis());
				currentComponent = "tJDBCInput_62";

				int tos_count_tJDBCInput_62 = 0;

				int nb_line_tJDBCInput_62 = 0;
				java.sql.Connection conn_tJDBCInput_62 = null;
				conn_tJDBCInput_62 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_62) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_62 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_62 = dataSources_tJDBCInput_62.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_62);
				}

				java.sql.Statement stmt_tJDBCInput_62 = conn_tJDBCInput_62
						.createStatement();

				String dbquery_tJDBCInput_62 = "SELECT    	history_id,    	vm_disk_id,  	upper(cast(vm_disk_id as char(36))) as vm_disk_join_id,   	vm_id,   	upper(cast(vm_id as char(36))) as vm_join_id,   	attach_date FROM v3_0_latest_disks_vm_map_view";

				globalMap.put("tJDBCInput_62_QUERY", dbquery_tJDBCInput_62);

				java.sql.ResultSet rs_tJDBCInput_62 = stmt_tJDBCInput_62
						.executeQuery(dbquery_tJDBCInput_62);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_62 = rs_tJDBCInput_62
						.getMetaData();
				int colQtyInRs_tJDBCInput_62 = rsmd_tJDBCInput_62
						.getColumnCount();

				String tmpContent_tJDBCInput_62 = null;
				int column_index_tJDBCInput_62 = 1;
				while (rs_tJDBCInput_62.next()) {
					nb_line_tJDBCInput_62++;

					column_index_tJDBCInput_62 = 1;

					if (colQtyInRs_tJDBCInput_62 < column_index_tJDBCInput_62) {
						row50.history_id = null;
					} else {

						if (rs_tJDBCInput_62
								.getObject(column_index_tJDBCInput_62) != null) {
							row50.history_id = rs_tJDBCInput_62
									.getInt(column_index_tJDBCInput_62);
						} else {
							row50.history_id = null;
						}

						if (rs_tJDBCInput_62.wasNull()) {
							row50.history_id = null;
						}
					}
					column_index_tJDBCInput_62 = 2;

					if (colQtyInRs_tJDBCInput_62 < column_index_tJDBCInput_62) {
						row50.vm_disk_id = null;
					} else {

						if (rs_tJDBCInput_62
								.getObject(column_index_tJDBCInput_62) != null) {
							row50.vm_disk_id = rs_tJDBCInput_62
									.getObject(column_index_tJDBCInput_62);
						} else {
							row50.vm_disk_id = null;
						}

						if (rs_tJDBCInput_62.wasNull()) {
							row50.vm_disk_id = null;
						}
					}
					column_index_tJDBCInput_62 = 3;

					if (colQtyInRs_tJDBCInput_62 < column_index_tJDBCInput_62) {
						row50.vm_disk_join_id = null;
					} else {

						tmpContent_tJDBCInput_62 = rs_tJDBCInput_62
								.getString(column_index_tJDBCInput_62);
						if (tmpContent_tJDBCInput_62 != null) {
							row50.vm_disk_join_id = tmpContent_tJDBCInput_62;
						} else {
							row50.vm_disk_join_id = null;
						}

						if (rs_tJDBCInput_62.wasNull()) {
							row50.vm_disk_join_id = null;
						}
					}
					column_index_tJDBCInput_62 = 4;

					if (colQtyInRs_tJDBCInput_62 < column_index_tJDBCInput_62) {
						row50.vm_id = null;
					} else {

						if (rs_tJDBCInput_62
								.getObject(column_index_tJDBCInput_62) != null) {
							row50.vm_id = rs_tJDBCInput_62
									.getObject(column_index_tJDBCInput_62);
						} else {
							row50.vm_id = null;
						}

						if (rs_tJDBCInput_62.wasNull()) {
							row50.vm_id = null;
						}
					}
					column_index_tJDBCInput_62 = 5;

					if (colQtyInRs_tJDBCInput_62 < column_index_tJDBCInput_62) {
						row50.vm_join_id = null;
					} else {

						tmpContent_tJDBCInput_62 = rs_tJDBCInput_62
								.getString(column_index_tJDBCInput_62);
						if (tmpContent_tJDBCInput_62 != null) {
							row50.vm_join_id = tmpContent_tJDBCInput_62;
						} else {
							row50.vm_join_id = null;
						}

						if (rs_tJDBCInput_62.wasNull()) {
							row50.vm_join_id = null;
						}
					}
					column_index_tJDBCInput_62 = 6;

					if (colQtyInRs_tJDBCInput_62 < column_index_tJDBCInput_62) {
						row50.attach_date = null;
					} else {

						java.util.Date date_tJDBCInput_62 = null;
						try {
							date_tJDBCInput_62 = rs_tJDBCInput_62
									.getTimestamp(column_index_tJDBCInput_62);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_62 = rs_tJDBCInput_62
									.getDate(column_index_tJDBCInput_62);
						}
						row50.attach_date = date_tJDBCInput_62;

						if (rs_tJDBCInput_62.wasNull()) {
							row50.attach_date = null;
						}
					}

					/**
					 * [tJDBCInput_62 begin ] stop
					 */
					/**
					 * [tJDBCInput_62 main ] start
					 */

					currentComponent = "tJDBCInput_62";

					tos_count_tJDBCInput_62++;

					/**
					 * [tJDBCInput_62 main ] stop
					 */

					/**
					 * [tMap_34 main ] start
					 */

					currentComponent = "tMap_34";

					boolean hasCasePrimitiveKeyWithNull_tMap_34 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_34 = false;
					boolean mainRowRejected_tMap_34 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row52"
					// /////////////////////////////////////////////

					boolean forceLooprow52 = false;

					row52Struct row52ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_34) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_34 = false;

						row52HashKey.vm_disk_join_id = row50.vm_disk_join_id;

						row52HashKey.vm_join_id = row50.vm_join_id;

						row52HashKey.hashCodeDirty = true;

						tHash_Lookup_row52.lookup(row52HashKey);

						if (!tHash_Lookup_row52.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_34 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row52 != null
							&& tHash_Lookup_row52.getCount(row52HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row52' and it contains more one result from keys :  row52.vm_disk_join_id = '"
						// + row52HashKey.vm_disk_join_id +
						// "', row52.vm_join_id = '" + row52HashKey.vm_join_id +
						// "'");
					} // G 071

					row52Struct row52 = null;

					row52Struct fromLookup_row52 = null;
					row52 = row52Default;

					if (tHash_Lookup_row52 != null
							&& tHash_Lookup_row52.hasNext()) { // G 099

						fromLookup_row52 = tHash_Lookup_row52.next();

					} // G 099

					if (fromLookup_row52 != null) {
						row52 = fromLookup_row52;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_34__Struct Var = Var__tMap_34;// ###############################
						// ###############################
						// # Output tables

						delete_vm_disk_connection = null;

						if (!rejectedInnerJoin_tMap_34) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_vm_disk_connection'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_34) {
							delete_vm_disk_connection_tmp.vm_disk_id = row50.vm_disk_id;
							delete_vm_disk_connection_tmp.vm_id = row50.vm_id;
							delete_vm_disk_connection_tmp.attach_date = row50.attach_date;
							delete_vm_disk_connection_tmp.detach_date = context.runTime;
							delete_vm_disk_connection = delete_vm_disk_connection_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_34 = false;

					tos_count_tMap_34++;

					/**
					 * [tMap_34 main ] stop
					 */
					// Start of branch "delete_vm_disk_connection"
					if (delete_vm_disk_connection != null) {

						/**
						 * [tJDBCOutput_36 main ] start
						 */

						currentComponent = "tJDBCOutput_36";

						whetherReject_tJDBCOutput_36 = false;
						if (delete_vm_disk_connection.detach_date != null) {
							pstmt_tJDBCOutput_36
									.setTimestamp(
											1,
											new java.sql.Timestamp(
													delete_vm_disk_connection.detach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_36
									.setNull(1, java.sql.Types.DATE);
						}

						if (delete_vm_disk_connection.vm_disk_id == null) {
							pstmt_tJDBCOutput_36.setNull(2,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_36.setObject(2,
									delete_vm_disk_connection.vm_disk_id);
						}

						if (delete_vm_disk_connection.vm_id == null) {
							pstmt_tJDBCOutput_36.setNull(3,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_36.setObject(3,
									delete_vm_disk_connection.vm_id);
						}

						if (delete_vm_disk_connection.attach_date != null) {
							pstmt_tJDBCOutput_36
									.setTimestamp(
											4,
											new java.sql.Timestamp(
													delete_vm_disk_connection.attach_date
															.getTime()));
						} else {
							pstmt_tJDBCOutput_36
									.setNull(4, java.sql.Types.DATE);
						}

						try {
							updatedCount_tJDBCOutput_36 = updatedCount_tJDBCOutput_36
									+ pstmt_tJDBCOutput_36.executeUpdate();
							nb_line_tJDBCOutput_36++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_36 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_36++;

						/**
						 * [tJDBCOutput_36 main ] stop
						 */

					} // End of branch "delete_vm_disk_connection"

					/**
					 * [tJDBCInput_62 end ] start
					 */

					currentComponent = "tJDBCInput_62";

				}
				rs_tJDBCInput_62.close();
				stmt_tJDBCInput_62.close();

				globalMap.put("tJDBCInput_62_NB_LINE", nb_line_tJDBCInput_62);

				ok_Hash.put("tJDBCInput_62", true);
				end_Hash.put("tJDBCInput_62", System.currentTimeMillis());

				/**
				 * [tJDBCInput_62 end ] stop
				 */

				/**
				 * [tMap_34 end ] start
				 */

				currentComponent = "tMap_34";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row52 != null) {
					tHash_Lookup_row52.endGet();
				}
				globalMap.remove("tHash_Lookup_row52");

				// ###############################

				ok_Hash.put("tMap_34", true);
				end_Hash.put("tMap_34", System.currentTimeMillis());

				/**
				 * [tMap_34 end ] stop
				 */

				/**
				 * [tJDBCOutput_36 end ] start
				 */

				currentComponent = "tJDBCOutput_36";

				if (pstmt_tJDBCOutput_36 != null) {

					pstmt_tJDBCOutput_36.close();

				}

				nb_line_deleted_tJDBCOutput_36 = nb_line_deleted_tJDBCOutput_36
						+ deletedCount_tJDBCOutput_36;
				nb_line_update_tJDBCOutput_36 = nb_line_update_tJDBCOutput_36
						+ updatedCount_tJDBCOutput_36;
				nb_line_inserted_tJDBCOutput_36 = nb_line_inserted_tJDBCOutput_36
						+ insertedCount_tJDBCOutput_36;
				nb_line_rejected_tJDBCOutput_36 = nb_line_rejected_tJDBCOutput_36
						+ rejectedCount_tJDBCOutput_36;

				globalMap.put("tJDBCOutput_36_NB_LINE", nb_line_tJDBCOutput_36);
				globalMap.put("tJDBCOutput_36_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_36);
				globalMap.put("tJDBCOutput_36_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_36);
				globalMap.put("tJDBCOutput_36_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_36);
				globalMap.put("tJDBCOutput_36_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_36);

				ok_Hash.put("tJDBCOutput_36", true);
				end_Hash.put("tJDBCOutput_36", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_36 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_62:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_8Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_34"
			globalMap.remove("tHash_Lookup_row52");

		}

		globalMap.put("tJDBCInput_62_SUBPROCESS_STATE", 1);
	}

	public static class vm_interface_configurationStruct implements
			routines.system.IPersistableRow<vm_interface_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					this.vm_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Object

				dos.writeObject(this.vm_id);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_interface_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row8Struct implements
			routines.system.IPersistableRow<row8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_8Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_8Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_44Process(globalMap);

				row8Struct row8 = new row8Struct();
				vm_interface_configurationStruct vm_interface_configuration = new vm_interface_configurationStruct();

				/**
				 * [tJDBCOutput_8 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_8", false);
				start_Hash.put("tJDBCOutput_8", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_8";

				int tos_count_tJDBCOutput_8 = 0;

				int nb_line_tJDBCOutput_8 = 0;
				int nb_line_update_tJDBCOutput_8 = 0;
				int nb_line_inserted_tJDBCOutput_8 = 0;
				int nb_line_deleted_tJDBCOutput_8 = 0;
				int nb_line_rejected_tJDBCOutput_8 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_8 = 0;

				int deletedCount_tJDBCOutput_8 = 0;
				int updatedCount_tJDBCOutput_8 = 0;
				int insertedCount_tJDBCOutput_8 = 0;
				int rejectedCount_tJDBCOutput_8 = 0;

				boolean whetherReject_tJDBCOutput_8 = false;

				java.sql.Connection connection_tJDBCOutput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_8) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_8 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_8 = dataSources_tJDBCOutput_8
							.get("").getConnection();
				}

				int batchSize_tJDBCOutput_8 = 10000;
				int batchSizeCounter_tJDBCOutput_8 = 0;

				String insert_tJDBCOutput_8 = "INSERT INTO "
						+ "vm_interface_configuration"
						+ " (vm_interface_id,vm_interface_name,vm_id,vm_interface_type,vm_interface_speed_bps,mac_address,network_name,vm_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_8 = connection_tJDBCOutput_8
						.prepareStatement(insert_tJDBCOutput_8);

				/**
				 * [tJDBCOutput_8 begin ] stop
				 */

				/**
				 * [tMap_8 begin ] start
				 */

				ok_Hash.put("tMap_8", false);
				start_Hash.put("tMap_8", System.currentTimeMillis());
				currentComponent = "tMap_8";

				int tos_count_tMap_8 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row40Struct> tHash_Lookup_row40 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row40Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row40Struct>) globalMap
						.get("tHash_Lookup_row40"));

				row40Struct row40HashKey = new row40Struct();
				row40Struct row40Default = new row40Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_8__Struct {
				}
				Var__tMap_8__Struct Var__tMap_8 = new Var__tMap_8__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_interface_configurationStruct vm_interface_configuration_tmp = new vm_interface_configurationStruct();
				// ###############################

				/**
				 * [tMap_8 begin ] stop
				 */

				/**
				 * [tJDBCInput_8 begin ] start
				 */

				ok_Hash.put("tJDBCInput_8", false);
				start_Hash.put("tJDBCInput_8", System.currentTimeMillis());
				currentComponent = "tJDBCInput_8";

				int tos_count_tJDBCInput_8 = 0;

				int nb_line_tJDBCInput_8 = 0;
				java.sql.Connection conn_tJDBCInput_8 = null;
				conn_tJDBCInput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_8) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_8 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_8 = dataSources_tJDBCInput_8.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_8);
				}

				java.sql.Statement stmt_tJDBCInput_8 = conn_tJDBCInput_8
						.createStatement();

				String dbquery_tJDBCInput_8 = "SELECT     vm_interface_id,     vm_interface_name,     vm_id,     upper(cast(vm_id as char(36))) as vm_join_id,    vm_interface_type,     vm_interface_speed_bps,     mac_address,     network_name,     create_date,     update_date  FROM dwh_vm_interface_configuration_history_view";

				globalMap.put("tJDBCInput_8_QUERY", dbquery_tJDBCInput_8);

				java.sql.ResultSet rs_tJDBCInput_8 = stmt_tJDBCInput_8
						.executeQuery(dbquery_tJDBCInput_8);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_8 = rs_tJDBCInput_8
						.getMetaData();
				int colQtyInRs_tJDBCInput_8 = rsmd_tJDBCInput_8
						.getColumnCount();

				String tmpContent_tJDBCInput_8 = null;
				int column_index_tJDBCInput_8 = 1;
				while (rs_tJDBCInput_8.next()) {
					nb_line_tJDBCInput_8++;

					column_index_tJDBCInput_8 = 1;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.vm_interface_id = null;
					} else {

						if (rs_tJDBCInput_8
								.getObject(column_index_tJDBCInput_8) != null) {
							row8.vm_interface_id = rs_tJDBCInput_8
									.getObject(column_index_tJDBCInput_8);
						} else {
							row8.vm_interface_id = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.vm_interface_id = null;
						}
					}
					column_index_tJDBCInput_8 = 2;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.vm_interface_name = null;
					} else {

						tmpContent_tJDBCInput_8 = rs_tJDBCInput_8
								.getString(column_index_tJDBCInput_8);
						if (tmpContent_tJDBCInput_8 != null) {
							row8.vm_interface_name = tmpContent_tJDBCInput_8;
						} else {
							row8.vm_interface_name = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.vm_interface_name = null;
						}
					}
					column_index_tJDBCInput_8 = 3;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.vm_id = null;
					} else {

						if (rs_tJDBCInput_8
								.getObject(column_index_tJDBCInput_8) != null) {
							row8.vm_id = rs_tJDBCInput_8
									.getObject(column_index_tJDBCInput_8);
						} else {
							row8.vm_id = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.vm_id = null;
						}
					}
					column_index_tJDBCInput_8 = 4;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.vm_join_id = null;
					} else {

						tmpContent_tJDBCInput_8 = rs_tJDBCInput_8
								.getString(column_index_tJDBCInput_8);
						if (tmpContent_tJDBCInput_8 != null) {
							row8.vm_join_id = tmpContent_tJDBCInput_8;
						} else {
							row8.vm_join_id = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.vm_join_id = null;
						}
					}
					column_index_tJDBCInput_8 = 5;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.vm_interface_type = null;
					} else {

						if (rs_tJDBCInput_8
								.getObject(column_index_tJDBCInput_8) != null) {
							row8.vm_interface_type = rs_tJDBCInput_8
									.getShort(column_index_tJDBCInput_8);
						} else {
							row8.vm_interface_type = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.vm_interface_type = null;
						}
					}
					column_index_tJDBCInput_8 = 6;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.vm_interface_speed_bps = null;
					} else {

						if (rs_tJDBCInput_8
								.getObject(column_index_tJDBCInput_8) != null) {
							row8.vm_interface_speed_bps = rs_tJDBCInput_8
									.getInt(column_index_tJDBCInput_8);
						} else {
							row8.vm_interface_speed_bps = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.vm_interface_speed_bps = null;
						}
					}
					column_index_tJDBCInput_8 = 7;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.mac_address = null;
					} else {

						tmpContent_tJDBCInput_8 = rs_tJDBCInput_8
								.getString(column_index_tJDBCInput_8);
						if (tmpContent_tJDBCInput_8 != null) {
							row8.mac_address = tmpContent_tJDBCInput_8;
						} else {
							row8.mac_address = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.mac_address = null;
						}
					}
					column_index_tJDBCInput_8 = 8;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.network_name = null;
					} else {

						tmpContent_tJDBCInput_8 = rs_tJDBCInput_8
								.getString(column_index_tJDBCInput_8);
						if (tmpContent_tJDBCInput_8 != null) {
							row8.network_name = tmpContent_tJDBCInput_8;
						} else {
							row8.network_name = null;
						}

						if (rs_tJDBCInput_8.wasNull()) {
							row8.network_name = null;
						}
					}
					column_index_tJDBCInput_8 = 9;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_8 = null;
						try {
							date_tJDBCInput_8 = rs_tJDBCInput_8
									.getTimestamp(column_index_tJDBCInput_8);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_8 = rs_tJDBCInput_8
									.getDate(column_index_tJDBCInput_8);
						}
						row8.create_date = date_tJDBCInput_8;

						if (rs_tJDBCInput_8.wasNull()) {
							row8.create_date = null;
						}
					}
					column_index_tJDBCInput_8 = 10;

					if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
						row8.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_8 = null;
						try {
							date_tJDBCInput_8 = rs_tJDBCInput_8
									.getTimestamp(column_index_tJDBCInput_8);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_8 = rs_tJDBCInput_8
									.getDate(column_index_tJDBCInput_8);
						}
						row8.update_date = date_tJDBCInput_8;

						if (rs_tJDBCInput_8.wasNull()) {
							row8.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_8 begin ] stop
					 */
					/**
					 * [tJDBCInput_8 main ] start
					 */

					currentComponent = "tJDBCInput_8";

					tos_count_tJDBCInput_8++;

					/**
					 * [tJDBCInput_8 main ] stop
					 */

					/**
					 * [tMap_8 main ] start
					 */

					currentComponent = "tMap_8";

					boolean hasCasePrimitiveKeyWithNull_tMap_8 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_8 = false;
					boolean mainRowRejected_tMap_8 = false;

					if (

					(

					row8.update_date == null ? TalendDate.compareDate(
							row8.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row8.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row8'

						// /////////////////////////////////////////////
						// Starting Lookup Table "row40"
						// /////////////////////////////////////////////

						boolean forceLooprow40 = false;

						row40Struct row40ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_8) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_8 = false;

							row40HashKey.vm_join_id = row8.vm_join_id;

							row40HashKey.hashCodeDirty = true;

							tHash_Lookup_row40.lookup(row40HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row40 != null
								&& tHash_Lookup_row40.getCount(row40HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row40' and it contains more one result from keys :  row40.vm_join_id = '"
							// + row40HashKey.vm_join_id + "'");
						} // G 071

						row40Struct row40 = null;

						row40Struct fromLookup_row40 = null;
						row40 = row40Default;

						if (tHash_Lookup_row40 != null
								&& tHash_Lookup_row40.hasNext()) { // G 099

							fromLookup_row40 = tHash_Lookup_row40.next();

						} // G 099

						if (fromLookup_row40 != null) {
							row40 = fromLookup_row40;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_8__Struct Var = Var__tMap_8;// ###############################
							// ###############################
							// # Output tables

							vm_interface_configuration = null;

							// # Output table : 'vm_interface_configuration'
							vm_interface_configuration_tmp.vm_interface_id = row8.vm_interface_id;
							vm_interface_configuration_tmp.vm_interface_name = StringHandling
									.TRIM(row8.vm_interface_name);
							vm_interface_configuration_tmp.vm_id = row8.vm_id;
							vm_interface_configuration_tmp.vm_interface_type = row8.vm_interface_type;
							vm_interface_configuration_tmp.vm_interface_speed_bps = row8.vm_interface_speed_bps;
							vm_interface_configuration_tmp.mac_address = StringHandling
									.TRIM(row8.mac_address);
							vm_interface_configuration_tmp.network_name = StringHandling
									.TRIM(row8.network_name);
							vm_interface_configuration_tmp.vm_configuration_version = row40.history_id;
							vm_interface_configuration_tmp.create_date = row8.create_date;
							vm_interface_configuration_tmp.update_date = row8.update_date;
							vm_interface_configuration_tmp.delete_date = null;
							vm_interface_configuration = vm_interface_configuration_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_8 = false;

						tos_count_tMap_8++;

						/**
						 * [tMap_8 main ] stop
						 */
						// Start of branch "vm_interface_configuration"
						if (vm_interface_configuration != null) {

							/**
							 * [tJDBCOutput_8 main ] start
							 */

							currentComponent = "tJDBCOutput_8";

							whetherReject_tJDBCOutput_8 = false;
							if (vm_interface_configuration.vm_interface_id == null) {
								pstmt_tJDBCOutput_8.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_8
										.setObject(
												1,
												vm_interface_configuration.vm_interface_id);
							}

							if (vm_interface_configuration.vm_interface_name == null) {
								pstmt_tJDBCOutput_8.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_8
										.setString(
												2,
												vm_interface_configuration.vm_interface_name);
							}

							if (vm_interface_configuration.vm_id == null) {
								pstmt_tJDBCOutput_8.setNull(3,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_8.setObject(3,
										vm_interface_configuration.vm_id);
							}

							if (vm_interface_configuration.vm_interface_type == null) {
								pstmt_tJDBCOutput_8.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_8
										.setShort(
												4,
												vm_interface_configuration.vm_interface_type);
							}

							if (vm_interface_configuration.vm_interface_speed_bps == null) {
								pstmt_tJDBCOutput_8.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_8
										.setInt(5,
												vm_interface_configuration.vm_interface_speed_bps);
							}

							if (vm_interface_configuration.mac_address == null) {
								pstmt_tJDBCOutput_8.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_8.setString(6,
										vm_interface_configuration.mac_address);
							}

							if (vm_interface_configuration.network_name == null) {
								pstmt_tJDBCOutput_8.setNull(7,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_8
										.setString(
												7,
												vm_interface_configuration.network_name);
							}

							if (vm_interface_configuration.vm_configuration_version == null) {
								pstmt_tJDBCOutput_8.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_8
										.setInt(8,
												vm_interface_configuration.vm_configuration_version);
							}

							if (vm_interface_configuration.create_date != null) {
								pstmt_tJDBCOutput_8
										.setTimestamp(
												9,
												new java.sql.Timestamp(
														vm_interface_configuration.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_8.setNull(9,
										java.sql.Types.DATE);
							}

							if (vm_interface_configuration.update_date != null) {
								pstmt_tJDBCOutput_8
										.setTimestamp(
												10,
												new java.sql.Timestamp(
														vm_interface_configuration.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_8.setNull(10,
										java.sql.Types.DATE);
							}

							if (vm_interface_configuration.delete_date != null) {
								pstmt_tJDBCOutput_8
										.setTimestamp(
												11,
												new java.sql.Timestamp(
														vm_interface_configuration.delete_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_8.setNull(11,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_8 = insertedCount_tJDBCOutput_8
										+ pstmt_tJDBCOutput_8.executeUpdate();
								nb_line_tJDBCOutput_8++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_8 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_8++;

							/**
							 * [tJDBCOutput_8 main ] stop
							 */

						} // End of branch "vm_interface_configuration"

					} // G_TM_M_280 close main tMap filter for table 'row8'

					/**
					 * [tJDBCInput_8 end ] start
					 */

					currentComponent = "tJDBCInput_8";

				}
				rs_tJDBCInput_8.close();
				stmt_tJDBCInput_8.close();

				globalMap.put("tJDBCInput_8_NB_LINE", nb_line_tJDBCInput_8);

				ok_Hash.put("tJDBCInput_8", true);
				end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				/**
				 * [tJDBCInput_8 end ] stop
				 */

				/**
				 * [tMap_8 end ] start
				 */

				currentComponent = "tMap_8";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row40 != null) {
					tHash_Lookup_row40.endGet();
				}
				globalMap.remove("tHash_Lookup_row40");

				// ###############################

				ok_Hash.put("tMap_8", true);
				end_Hash.put("tMap_8", System.currentTimeMillis());

				/**
				 * [tMap_8 end ] stop
				 */

				/**
				 * [tJDBCOutput_8 end ] start
				 */

				currentComponent = "tJDBCOutput_8";

				if (pstmt_tJDBCOutput_8 != null) {

					pstmt_tJDBCOutput_8.close();

				}

				nb_line_deleted_tJDBCOutput_8 = nb_line_deleted_tJDBCOutput_8
						+ deletedCount_tJDBCOutput_8;
				nb_line_update_tJDBCOutput_8 = nb_line_update_tJDBCOutput_8
						+ updatedCount_tJDBCOutput_8;
				nb_line_inserted_tJDBCOutput_8 = nb_line_inserted_tJDBCOutput_8
						+ insertedCount_tJDBCOutput_8;
				nb_line_rejected_tJDBCOutput_8 = nb_line_rejected_tJDBCOutput_8
						+ rejectedCount_tJDBCOutput_8;

				globalMap.put("tJDBCOutput_8_NB_LINE", nb_line_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_8);

				ok_Hash.put("tJDBCOutput_8", true);
				end_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_8 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_8:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_30Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_8"
			globalMap.remove("tHash_Lookup_row40");

		}

		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 1);
	}

	public static class delete_vm_interfaceStruct implements
			routines.system.IPersistableRow<delete_vm_interfaceStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vm_interfaceStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row29Struct implements
			routines.system.IPersistableRow<row29Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_join_id = readString(dis);

					this.vm_interface_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_join_id, dos);

				// String

				writeString(this.vm_interface_name, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row29Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_30Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_30Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String network_name;

		public String getNetwork_name() {
			return this.network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_join_id = readString(dis);

					this.vm_interface_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_join_id, dos);

				// String

				writeString(this.vm_interface_name, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",network_name=" + network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_30Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_30Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_30_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_29Process(globalMap);

				row29Struct row29 = new row29Struct();
				delete_vm_interfaceStruct delete_vm_interface = new delete_vm_interfaceStruct();

				/**
				 * [tJDBCOutput_21 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_21", false);
				start_Hash.put("tJDBCOutput_21", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_21";

				int tos_count_tJDBCOutput_21 = 0;

				int nb_line_tJDBCOutput_21 = 0;
				int nb_line_update_tJDBCOutput_21 = 0;
				int nb_line_inserted_tJDBCOutput_21 = 0;
				int nb_line_deleted_tJDBCOutput_21 = 0;
				int nb_line_rejected_tJDBCOutput_21 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_21 = 0;

				int deletedCount_tJDBCOutput_21 = 0;
				int updatedCount_tJDBCOutput_21 = 0;
				int insertedCount_tJDBCOutput_21 = 0;
				int rejectedCount_tJDBCOutput_21 = 0;

				boolean whetherReject_tJDBCOutput_21 = false;

				java.sql.Connection connection_tJDBCOutput_21 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_21) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_21 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_21 = dataSources_tJDBCOutput_21.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_21 = 10000;
				int batchSizeCounter_tJDBCOutput_21 = 0;

				String insert_tJDBCOutput_21 = "INSERT INTO "
						+ "vm_interface_configuration"
						+ " (vm_interface_id,vm_interface_name,vm_interface_type,vm_interface_speed_bps,mac_address,network_name,vm_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_21 = connection_tJDBCOutput_21
						.prepareStatement(insert_tJDBCOutput_21);

				/**
				 * [tJDBCOutput_21 begin ] stop
				 */

				/**
				 * [tMap_21 begin ] start
				 */

				ok_Hash.put("tMap_21", false);
				start_Hash.put("tMap_21", System.currentTimeMillis());
				currentComponent = "tMap_21";

				int tos_count_tMap_21 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row28Struct> tHash_Lookup_row28 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row28Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row28Struct>) globalMap
						.get("tHash_Lookup_row28"));

				row28Struct row28HashKey = new row28Struct();
				row28Struct row28Default = new row28Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_21__Struct {
				}
				Var__tMap_21__Struct Var__tMap_21 = new Var__tMap_21__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_vm_interfaceStruct delete_vm_interface_tmp = new delete_vm_interfaceStruct();
				// ###############################

				/**
				 * [tMap_21 begin ] stop
				 */

				/**
				 * [tJDBCInput_30 begin ] start
				 */

				ok_Hash.put("tJDBCInput_30", false);
				start_Hash.put("tJDBCInput_30", System.currentTimeMillis());
				currentComponent = "tJDBCInput_30";

				int tos_count_tJDBCInput_30 = 0;

				int nb_line_tJDBCInput_30 = 0;
				java.sql.Connection conn_tJDBCInput_30 = null;
				conn_tJDBCInput_30 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == conn_tJDBCInput_30) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_30 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_30 = dataSources_tJDBCInput_30.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_2",
					// conn_tJDBCInput_30);
				}

				java.sql.Statement stmt_tJDBCInput_30 = conn_tJDBCInput_30
						.createStatement();

				String dbquery_tJDBCInput_30 = "SELECT     history_id,     vm_interface_id,     upper(cast(vm_interface_id as char(36))) as vm_interface_join_id,    vm_interface_name,     vm_interface_type,     vm_interface_speed_bps,     mac_address,     network_name,     vm_configuration_version,     create_date,     update_date  FROM v3_3_latest_configuration_vms_interfaces";

				globalMap.put("tJDBCInput_30_QUERY", dbquery_tJDBCInput_30);

				java.sql.ResultSet rs_tJDBCInput_30 = stmt_tJDBCInput_30
						.executeQuery(dbquery_tJDBCInput_30);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_30 = rs_tJDBCInput_30
						.getMetaData();
				int colQtyInRs_tJDBCInput_30 = rsmd_tJDBCInput_30
						.getColumnCount();

				String tmpContent_tJDBCInput_30 = null;
				int column_index_tJDBCInput_30 = 1;
				while (rs_tJDBCInput_30.next()) {
					nb_line_tJDBCInput_30++;

					column_index_tJDBCInput_30 = 1;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.history_id = null;
					} else {

						if (rs_tJDBCInput_30
								.getObject(column_index_tJDBCInput_30) != null) {
							row29.history_id = rs_tJDBCInput_30
									.getInt(column_index_tJDBCInput_30);
						} else {
							row29.history_id = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.history_id = null;
						}
					}
					column_index_tJDBCInput_30 = 2;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.vm_interface_id = null;
					} else {

						if (rs_tJDBCInput_30
								.getObject(column_index_tJDBCInput_30) != null) {
							row29.vm_interface_id = rs_tJDBCInput_30
									.getObject(column_index_tJDBCInput_30);
						} else {
							row29.vm_interface_id = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.vm_interface_id = null;
						}
					}
					column_index_tJDBCInput_30 = 3;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.vm_interface_join_id = null;
					} else {

						tmpContent_tJDBCInput_30 = rs_tJDBCInput_30
								.getString(column_index_tJDBCInput_30);
						if (tmpContent_tJDBCInput_30 != null) {
							row29.vm_interface_join_id = tmpContent_tJDBCInput_30;
						} else {
							row29.vm_interface_join_id = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.vm_interface_join_id = null;
						}
					}
					column_index_tJDBCInput_30 = 4;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.vm_interface_name = null;
					} else {

						tmpContent_tJDBCInput_30 = rs_tJDBCInput_30
								.getString(column_index_tJDBCInput_30);
						if (tmpContent_tJDBCInput_30 != null) {
							row29.vm_interface_name = tmpContent_tJDBCInput_30;
						} else {
							row29.vm_interface_name = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.vm_interface_name = null;
						}
					}
					column_index_tJDBCInput_30 = 5;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.vm_interface_type = null;
					} else {

						if (rs_tJDBCInput_30
								.getObject(column_index_tJDBCInput_30) != null) {
							row29.vm_interface_type = rs_tJDBCInput_30
									.getShort(column_index_tJDBCInput_30);
						} else {
							row29.vm_interface_type = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.vm_interface_type = null;
						}
					}
					column_index_tJDBCInput_30 = 6;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.vm_interface_speed_bps = null;
					} else {

						if (rs_tJDBCInput_30
								.getObject(column_index_tJDBCInput_30) != null) {
							row29.vm_interface_speed_bps = rs_tJDBCInput_30
									.getInt(column_index_tJDBCInput_30);
						} else {
							row29.vm_interface_speed_bps = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.vm_interface_speed_bps = null;
						}
					}
					column_index_tJDBCInput_30 = 7;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.mac_address = null;
					} else {

						tmpContent_tJDBCInput_30 = rs_tJDBCInput_30
								.getString(column_index_tJDBCInput_30);
						if (tmpContent_tJDBCInput_30 != null) {
							row29.mac_address = tmpContent_tJDBCInput_30;
						} else {
							row29.mac_address = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.mac_address = null;
						}
					}
					column_index_tJDBCInput_30 = 8;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.network_name = null;
					} else {

						tmpContent_tJDBCInput_30 = rs_tJDBCInput_30
								.getString(column_index_tJDBCInput_30);
						if (tmpContent_tJDBCInput_30 != null) {
							row29.network_name = tmpContent_tJDBCInput_30;
						} else {
							row29.network_name = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.network_name = null;
						}
					}
					column_index_tJDBCInput_30 = 9;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.vm_configuration_version = null;
					} else {

						if (rs_tJDBCInput_30
								.getObject(column_index_tJDBCInput_30) != null) {
							row29.vm_configuration_version = rs_tJDBCInput_30
									.getInt(column_index_tJDBCInput_30);
						} else {
							row29.vm_configuration_version = null;
						}

						if (rs_tJDBCInput_30.wasNull()) {
							row29.vm_configuration_version = null;
						}
					}
					column_index_tJDBCInput_30 = 10;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_30 = null;
						try {
							date_tJDBCInput_30 = rs_tJDBCInput_30
									.getTimestamp(column_index_tJDBCInput_30);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_30 = rs_tJDBCInput_30
									.getDate(column_index_tJDBCInput_30);
						}
						row29.create_date = date_tJDBCInput_30;

						if (rs_tJDBCInput_30.wasNull()) {
							row29.create_date = null;
						}
					}
					column_index_tJDBCInput_30 = 11;

					if (colQtyInRs_tJDBCInput_30 < column_index_tJDBCInput_30) {
						row29.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_30 = null;
						try {
							date_tJDBCInput_30 = rs_tJDBCInput_30
									.getTimestamp(column_index_tJDBCInput_30);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_30 = rs_tJDBCInput_30
									.getDate(column_index_tJDBCInput_30);
						}
						row29.update_date = date_tJDBCInput_30;

						if (rs_tJDBCInput_30.wasNull()) {
							row29.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_30 begin ] stop
					 */
					/**
					 * [tJDBCInput_30 main ] start
					 */

					currentComponent = "tJDBCInput_30";

					tos_count_tJDBCInput_30++;

					/**
					 * [tJDBCInput_30 main ] stop
					 */

					/**
					 * [tMap_21 main ] start
					 */

					currentComponent = "tMap_21";

					boolean hasCasePrimitiveKeyWithNull_tMap_21 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_21 = false;
					boolean mainRowRejected_tMap_21 = false;

					// /////////////////////////////////////////////
					// Starting Lookup Table "row28"
					// /////////////////////////////////////////////

					boolean forceLooprow28 = false;

					row28Struct row28ObjectFromLookup = null;

					if (!rejectedInnerJoin_tMap_21) { // G_TM_M_020

						hasCasePrimitiveKeyWithNull_tMap_21 = false;

						row28HashKey.vm_interface_join_id = row29.vm_interface_join_id;

						row28HashKey.hashCodeDirty = true;

						tHash_Lookup_row28.lookup(row28HashKey);

						if (!tHash_Lookup_row28.hasNext()) { // G_TM_M_090

							rejectedInnerJoin_tMap_21 = true;

						} // G_TM_M_090

					} // G_TM_M_020

					if (tHash_Lookup_row28 != null
							&& tHash_Lookup_row28.getCount(row28HashKey) > 1) { // G
																				// 071

						// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row28' and it contains more one result from keys :  row28.vm_interface_join_id = '"
						// + row28HashKey.vm_interface_join_id + "'");
					} // G 071

					row28Struct row28 = null;

					row28Struct fromLookup_row28 = null;
					row28 = row28Default;

					if (tHash_Lookup_row28 != null
							&& tHash_Lookup_row28.hasNext()) { // G 099

						fromLookup_row28 = tHash_Lookup_row28.next();

					} // G 099

					if (fromLookup_row28 != null) {
						row28 = fromLookup_row28;
					}

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_21__Struct Var = Var__tMap_21;// ###############################
						// ###############################
						// # Output tables

						delete_vm_interface = null;

						if (!rejectedInnerJoin_tMap_21) {
						} // closing inner join bracket (1)
							// ###### START REJECTS #####

						// # Output reject table : 'delete_vm_interface'
						// # Filter conditions
						if (rejectedInnerJoin_tMap_21) {
							delete_vm_interface_tmp.vm_interface_id = row29.vm_interface_id;
							delete_vm_interface_tmp.vm_interface_name = row29.vm_interface_name;
							delete_vm_interface_tmp.vm_interface_type = row29.vm_interface_type;
							delete_vm_interface_tmp.vm_interface_speed_bps = row29.vm_interface_speed_bps;
							delete_vm_interface_tmp.mac_address = row29.mac_address;
							delete_vm_interface_tmp.network_name = row29.network_name;
							delete_vm_interface_tmp.vm_configuration_version = row29.vm_configuration_version;
							delete_vm_interface_tmp.create_date = row29.create_date;
							delete_vm_interface_tmp.update_date = context.runTime;
							delete_vm_interface_tmp.delete_date = context.runTime;
							delete_vm_interface = delete_vm_interface_tmp;
						} // closing filter/reject
							// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_21 = false;

					tos_count_tMap_21++;

					/**
					 * [tMap_21 main ] stop
					 */
					// Start of branch "delete_vm_interface"
					if (delete_vm_interface != null) {

						/**
						 * [tJDBCOutput_21 main ] start
						 */

						currentComponent = "tJDBCOutput_21";

						whetherReject_tJDBCOutput_21 = false;
						if (delete_vm_interface.vm_interface_id == null) {
							pstmt_tJDBCOutput_21.setNull(1,
									java.sql.Types.OTHER);
						} else {
							pstmt_tJDBCOutput_21.setObject(1,
									delete_vm_interface.vm_interface_id);
						}

						if (delete_vm_interface.vm_interface_name == null) {
							pstmt_tJDBCOutput_21.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_21.setString(2,
									delete_vm_interface.vm_interface_name);
						}

						if (delete_vm_interface.vm_interface_type == null) {
							pstmt_tJDBCOutput_21.setNull(3,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_21.setShort(3,
									delete_vm_interface.vm_interface_type);
						}

						if (delete_vm_interface.vm_interface_speed_bps == null) {
							pstmt_tJDBCOutput_21.setNull(4,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_21.setInt(4,
									delete_vm_interface.vm_interface_speed_bps);
						}

						if (delete_vm_interface.mac_address == null) {
							pstmt_tJDBCOutput_21.setNull(5,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_21.setString(5,
									delete_vm_interface.mac_address);
						}

						if (delete_vm_interface.network_name == null) {
							pstmt_tJDBCOutput_21.setNull(6,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_21.setString(6,
									delete_vm_interface.network_name);
						}

						if (delete_vm_interface.vm_configuration_version == null) {
							pstmt_tJDBCOutput_21.setNull(7,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_21
									.setInt(7,
											delete_vm_interface.vm_configuration_version);
						}

						if (delete_vm_interface.create_date != null) {
							pstmt_tJDBCOutput_21.setTimestamp(
									8,
									new java.sql.Timestamp(
											delete_vm_interface.create_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_21
									.setNull(8, java.sql.Types.DATE);
						}

						if (delete_vm_interface.update_date != null) {
							pstmt_tJDBCOutput_21.setTimestamp(
									9,
									new java.sql.Timestamp(
											delete_vm_interface.update_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_21
									.setNull(9, java.sql.Types.DATE);
						}

						if (delete_vm_interface.delete_date != null) {
							pstmt_tJDBCOutput_21.setTimestamp(
									10,
									new java.sql.Timestamp(
											delete_vm_interface.delete_date
													.getTime()));
						} else {
							pstmt_tJDBCOutput_21.setNull(10,
									java.sql.Types.DATE);
						}

						try {
							insertedCount_tJDBCOutput_21 = insertedCount_tJDBCOutput_21
									+ pstmt_tJDBCOutput_21.executeUpdate();
							nb_line_tJDBCOutput_21++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_21 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_21++;

						/**
						 * [tJDBCOutput_21 main ] stop
						 */

					} // End of branch "delete_vm_interface"

					/**
					 * [tJDBCInput_30 end ] start
					 */

					currentComponent = "tJDBCInput_30";

				}
				rs_tJDBCInput_30.close();
				stmt_tJDBCInput_30.close();

				globalMap.put("tJDBCInput_30_NB_LINE", nb_line_tJDBCInput_30);

				ok_Hash.put("tJDBCInput_30", true);
				end_Hash.put("tJDBCInput_30", System.currentTimeMillis());

				/**
				 * [tJDBCInput_30 end ] stop
				 */

				/**
				 * [tMap_21 end ] start
				 */

				currentComponent = "tMap_21";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row28 != null) {
					tHash_Lookup_row28.endGet();
				}
				globalMap.remove("tHash_Lookup_row28");

				// ###############################

				ok_Hash.put("tMap_21", true);
				end_Hash.put("tMap_21", System.currentTimeMillis());

				/**
				 * [tMap_21 end ] stop
				 */

				/**
				 * [tJDBCOutput_21 end ] start
				 */

				currentComponent = "tJDBCOutput_21";

				if (pstmt_tJDBCOutput_21 != null) {

					pstmt_tJDBCOutput_21.close();

				}

				nb_line_deleted_tJDBCOutput_21 = nb_line_deleted_tJDBCOutput_21
						+ deletedCount_tJDBCOutput_21;
				nb_line_update_tJDBCOutput_21 = nb_line_update_tJDBCOutput_21
						+ updatedCount_tJDBCOutput_21;
				nb_line_inserted_tJDBCOutput_21 = nb_line_inserted_tJDBCOutput_21
						+ insertedCount_tJDBCOutput_21;
				nb_line_rejected_tJDBCOutput_21 = nb_line_rejected_tJDBCOutput_21
						+ rejectedCount_tJDBCOutput_21;

				globalMap.put("tJDBCOutput_21_NB_LINE", nb_line_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_21);

				ok_Hash.put("tJDBCOutput_21", true);
				end_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_21 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_30:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_53Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_21"
			globalMap.remove("tHash_Lookup_row28");

		}

		globalMap.put("tJDBCInput_30_SUBPROCESS_STATE", 1);
	}

	public static class insert_new_vm_device_connectionStruct
			implements
			routines.system.IPersistableRow<insert_new_vm_device_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public boolean is_managed;

		public boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public boolean is_readonly;

		public boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.device_id = (Object) dis.readObject();

					this.type = readString(dis);

					this.address = readString(dis);

					this.is_managed = dis.readBoolean();

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					this.is_readonly = dis.readBoolean();

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// boolean

				dos.writeBoolean(this.is_managed);

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// boolean

				dos.writeBoolean(this.is_readonly);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(insert_new_vm_device_connectionStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row45Struct implements
			routines.system.IPersistableRow<row45Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row45Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_53Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_53Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_53Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_53Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_53_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_54Process(globalMap);
				tJDBCInput_65Process(globalMap);
				tJDBCInput_66Process(globalMap);

				row45Struct row45 = new row45Struct();
				insert_new_vm_device_connectionStruct insert_new_vm_device_connection = new insert_new_vm_device_connectionStruct();

				/**
				 * [tJDBCOutput_31 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_31", false);
				start_Hash.put("tJDBCOutput_31", System.currentTimeMillis());
				currentComponent = "tJDBCOutput_31";

				int tos_count_tJDBCOutput_31 = 0;

				int nb_line_tJDBCOutput_31 = 0;
				int nb_line_update_tJDBCOutput_31 = 0;
				int nb_line_inserted_tJDBCOutput_31 = 0;
				int nb_line_deleted_tJDBCOutput_31 = 0;
				int nb_line_rejected_tJDBCOutput_31 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_31 = 0;

				int deletedCount_tJDBCOutput_31 = 0;
				int updatedCount_tJDBCOutput_31 = 0;
				int insertedCount_tJDBCOutput_31 = 0;
				int rejectedCount_tJDBCOutput_31 = 0;

				boolean whetherReject_tJDBCOutput_31 = false;

				java.sql.Connection connection_tJDBCOutput_31 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (null == connection_tJDBCOutput_31) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCOutput_31 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					connection_tJDBCOutput_31 = dataSources_tJDBCOutput_31.get(
							"").getConnection();
				}

				int batchSize_tJDBCOutput_31 = 10000;
				int batchSizeCounter_tJDBCOutput_31 = 0;

				String insert_tJDBCOutput_31 = "INSERT INTO "
						+ "vm_device_history"
						+ " (vm_id,device_id,type,address,is_managed,is_plugged,is_readonly,vm_configuration_version,device_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_31 = connection_tJDBCOutput_31
						.prepareStatement(insert_tJDBCOutput_31);

				/**
				 * [tJDBCOutput_31 begin ] stop
				 */

				/**
				 * [tMap_31 begin ] start
				 */

				ok_Hash.put("tMap_31", false);
				start_Hash.put("tMap_31", System.currentTimeMillis());
				currentComponent = "tMap_31";

				int tos_count_tMap_31 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row46Struct> tHash_Lookup_row46 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row46Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row46Struct>) globalMap
						.get("tHash_Lookup_row46"));

				row46Struct row46HashKey = new row46Struct();
				row46Struct row46Default = new row46Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row53Struct> tHash_Lookup_row53 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row53Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row53Struct>) globalMap
						.get("tHash_Lookup_row53"));

				row53Struct row53HashKey = new row53Struct();
				row53Struct row53Default = new row53Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row54Struct> tHash_Lookup_row54 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row54Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row54Struct>) globalMap
						.get("tHash_Lookup_row54"));

				row54Struct row54HashKey = new row54Struct();
				row54Struct row54Default = new row54Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_31__Struct {
				}
				Var__tMap_31__Struct Var__tMap_31 = new Var__tMap_31__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				insert_new_vm_device_connectionStruct insert_new_vm_device_connection_tmp = new insert_new_vm_device_connectionStruct();
				// ###############################

				/**
				 * [tMap_31 begin ] stop
				 */

				/**
				 * [tJDBCInput_53 begin ] start
				 */

				ok_Hash.put("tJDBCInput_53", false);
				start_Hash.put("tJDBCInput_53", System.currentTimeMillis());
				currentComponent = "tJDBCInput_53";

				int tos_count_tJDBCInput_53 = 0;

				int nb_line_tJDBCInput_53 = 0;
				java.sql.Connection conn_tJDBCInput_53 = null;
				conn_tJDBCInput_53 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (null == conn_tJDBCInput_53) {
					java.util.Map<String, routines.system.TalendDataSource> dataSources_tJDBCInput_53 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					conn_tJDBCInput_53 = dataSources_tJDBCInput_53.get("")
							.getConnection();
					// globalMap.put("conn_tJDBCConnection_1",
					// conn_tJDBCInput_53);
				}

				java.sql.Statement stmt_tJDBCInput_53 = conn_tJDBCInput_53
						.createStatement();

				String dbquery_tJDBCInput_53 = "SELECT    device_id,   upper(cast(device_id as char(36))) as device_join_id,   vm_id,   upper(cast(vm_id as char(36))) as vm_join_id,   type,    address,    is_managed,    is_plugged,    is_readonly,   create_date,   update_date FROM dwh_vm_device_history_view";

				globalMap.put("tJDBCInput_53_QUERY", dbquery_tJDBCInput_53);

				java.sql.ResultSet rs_tJDBCInput_53 = stmt_tJDBCInput_53
						.executeQuery(dbquery_tJDBCInput_53);
				java.sql.ResultSetMetaData rsmd_tJDBCInput_53 = rs_tJDBCInput_53
						.getMetaData();
				int colQtyInRs_tJDBCInput_53 = rsmd_tJDBCInput_53
						.getColumnCount();

				String tmpContent_tJDBCInput_53 = null;
				int column_index_tJDBCInput_53 = 1;
				while (rs_tJDBCInput_53.next()) {
					nb_line_tJDBCInput_53++;

					column_index_tJDBCInput_53 = 1;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.device_id = null;
					} else {

						if (rs_tJDBCInput_53
								.getObject(column_index_tJDBCInput_53) != null) {
							row45.device_id = rs_tJDBCInput_53
									.getObject(column_index_tJDBCInput_53);
						} else {
							row45.device_id = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.device_id = null;
						}
					}
					column_index_tJDBCInput_53 = 2;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.device_join_id = null;
					} else {

						tmpContent_tJDBCInput_53 = rs_tJDBCInput_53
								.getString(column_index_tJDBCInput_53);
						if (tmpContent_tJDBCInput_53 != null) {
							row45.device_join_id = tmpContent_tJDBCInput_53;
						} else {
							row45.device_join_id = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.device_join_id = null;
						}
					}
					column_index_tJDBCInput_53 = 3;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.vm_id = null;
					} else {

						if (rs_tJDBCInput_53
								.getObject(column_index_tJDBCInput_53) != null) {
							row45.vm_id = rs_tJDBCInput_53
									.getObject(column_index_tJDBCInput_53);
						} else {
							row45.vm_id = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.vm_id = null;
						}
					}
					column_index_tJDBCInput_53 = 4;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.vm_join_id = null;
					} else {

						tmpContent_tJDBCInput_53 = rs_tJDBCInput_53
								.getString(column_index_tJDBCInput_53);
						if (tmpContent_tJDBCInput_53 != null) {
							row45.vm_join_id = tmpContent_tJDBCInput_53;
						} else {
							row45.vm_join_id = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.vm_join_id = null;
						}
					}
					column_index_tJDBCInput_53 = 5;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.type = null;
					} else {

						tmpContent_tJDBCInput_53 = rs_tJDBCInput_53
								.getString(column_index_tJDBCInput_53);
						if (tmpContent_tJDBCInput_53 != null) {
							row45.type = tmpContent_tJDBCInput_53;
						} else {
							row45.type = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.type = null;
						}
					}
					column_index_tJDBCInput_53 = 6;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.address = null;
					} else {

						tmpContent_tJDBCInput_53 = rs_tJDBCInput_53
								.getString(column_index_tJDBCInput_53);
						if (tmpContent_tJDBCInput_53 != null) {
							row45.address = tmpContent_tJDBCInput_53;
						} else {
							row45.address = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.address = null;
						}
					}
					column_index_tJDBCInput_53 = 7;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.is_managed = null;
					} else {

						if (rs_tJDBCInput_53
								.getObject(column_index_tJDBCInput_53) != null) {
							row45.is_managed = rs_tJDBCInput_53
									.getBoolean(column_index_tJDBCInput_53);
						} else {
							row45.is_managed = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.is_managed = null;
						}
					}
					column_index_tJDBCInput_53 = 8;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.is_plugged = null;
					} else {

						if (rs_tJDBCInput_53
								.getObject(column_index_tJDBCInput_53) != null) {
							row45.is_plugged = rs_tJDBCInput_53
									.getBoolean(column_index_tJDBCInput_53);
						} else {
							row45.is_plugged = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.is_plugged = null;
						}
					}
					column_index_tJDBCInput_53 = 9;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.is_readonly = null;
					} else {

						if (rs_tJDBCInput_53
								.getObject(column_index_tJDBCInput_53) != null) {
							row45.is_readonly = rs_tJDBCInput_53
									.getBoolean(column_index_tJDBCInput_53);
						} else {
							row45.is_readonly = null;
						}

						if (rs_tJDBCInput_53.wasNull()) {
							row45.is_readonly = null;
						}
					}
					column_index_tJDBCInput_53 = 10;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.create_date = null;
					} else {

						java.util.Date date_tJDBCInput_53 = null;
						try {
							date_tJDBCInput_53 = rs_tJDBCInput_53
									.getTimestamp(column_index_tJDBCInput_53);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_53 = rs_tJDBCInput_53
									.getDate(column_index_tJDBCInput_53);
						}
						row45.create_date = date_tJDBCInput_53;

						if (rs_tJDBCInput_53.wasNull()) {
							row45.create_date = null;
						}
					}
					column_index_tJDBCInput_53 = 11;

					if (colQtyInRs_tJDBCInput_53 < column_index_tJDBCInput_53) {
						row45.update_date = null;
					} else {

						java.util.Date date_tJDBCInput_53 = null;
						try {
							date_tJDBCInput_53 = rs_tJDBCInput_53
									.getTimestamp(column_index_tJDBCInput_53);
						} catch (java.lang.Exception e) {
							date_tJDBCInput_53 = rs_tJDBCInput_53
									.getDate(column_index_tJDBCInput_53);
						}
						row45.update_date = date_tJDBCInput_53;

						if (rs_tJDBCInput_53.wasNull()) {
							row45.update_date = null;
						}
					}

					/**
					 * [tJDBCInput_53 begin ] stop
					 */
					/**
					 * [tJDBCInput_53 main ] start
					 */

					currentComponent = "tJDBCInput_53";

					tos_count_tJDBCInput_53++;

					/**
					 * [tJDBCInput_53 main ] stop
					 */

					/**
					 * [tMap_31 main ] start
					 */

					currentComponent = "tMap_31";

					boolean hasCasePrimitiveKeyWithNull_tMap_31 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_31 = false;
					boolean mainRowRejected_tMap_31 = false;

					if (

					(

					row45.update_date == null ? TalendDate.compareDate(
							row45.create_date, context.runTime) <= 0
							: TalendDate.compareDate(row45.update_date,
									context.runTime) <= 0

					)

					) { // G_TM_M_280

						// CALL close main tMap filter for table 'row45'

						// /////////////////////////////////////////////
						// Starting Lookup Table "row46"
						// /////////////////////////////////////////////

						boolean forceLooprow46 = false;

						row46Struct row46ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_31) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_31 = false;

							row46HashKey.vm_join_id = row45.vm_join_id;

							row46HashKey.hashCodeDirty = true;

							tHash_Lookup_row46.lookup(row46HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row46 != null
								&& tHash_Lookup_row46.getCount(row46HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row46' and it contains more one result from keys :  row46.vm_join_id = '"
							// + row46HashKey.vm_join_id + "'");
						} // G 071

						row46Struct row46 = null;

						row46Struct fromLookup_row46 = null;
						row46 = row46Default;

						if (tHash_Lookup_row46 != null
								&& tHash_Lookup_row46.hasNext()) { // G 099

							fromLookup_row46 = tHash_Lookup_row46.next();

						} // G 099

						if (fromLookup_row46 != null) {
							row46 = fromLookup_row46;
						}

						// /////////////////////////////////////////////
						// Starting Lookup Table "row53"
						// /////////////////////////////////////////////

						boolean forceLooprow53 = false;

						row53Struct row53ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_31) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_31 = false;

							row53HashKey.vm_interface_join_id = row45.device_join_id;

							row53HashKey.hashCodeDirty = true;

							tHash_Lookup_row53.lookup(row53HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row53 != null
								&& tHash_Lookup_row53.getCount(row53HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row53' and it contains more one result from keys :  row53.vm_interface_join_id = '"
							// + row53HashKey.vm_interface_join_id + "'");
						} // G 071

						row53Struct row53 = null;

						row53Struct fromLookup_row53 = null;
						row53 = row53Default;

						if (tHash_Lookup_row53 != null
								&& tHash_Lookup_row53.hasNext()) { // G 099

							fromLookup_row53 = tHash_Lookup_row53.next();

						} // G 099

						if (fromLookup_row53 != null) {
							row53 = fromLookup_row53;
						}

						// /////////////////////////////////////////////
						// Starting Lookup Table "row54"
						// /////////////////////////////////////////////

						boolean forceLooprow54 = false;

						row54Struct row54ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_31) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_31 = false;

							row54HashKey.vm_disk_join_id = row45.device_join_id;

							row54HashKey.hashCodeDirty = true;

							tHash_Lookup_row54.lookup(row54HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row54 != null
								&& tHash_Lookup_row54.getCount(row54HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row54' and it contains more one result from keys :  row54.vm_disk_join_id = '"
							// + row54HashKey.vm_disk_join_id + "'");
						} // G 071

						row54Struct row54 = null;

						row54Struct fromLookup_row54 = null;
						row54 = row54Default;

						if (tHash_Lookup_row54 != null
								&& tHash_Lookup_row54.hasNext()) { // G 099

							fromLookup_row54 = tHash_Lookup_row54.next();

						} // G 099

						if (fromLookup_row54 != null) {
							row54 = fromLookup_row54;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_31__Struct Var = Var__tMap_31;// ###############################
							// ###############################
							// # Output tables

							insert_new_vm_device_connection = null;

							// # Output table :
							// 'insert_new_vm_device_connection'
							insert_new_vm_device_connection_tmp.vm_id = row45.vm_id;
							insert_new_vm_device_connection_tmp.device_id = row45.device_id;
							insert_new_vm_device_connection_tmp.type = row45.type;
							insert_new_vm_device_connection_tmp.address = row45.address;
							insert_new_vm_device_connection_tmp.is_managed = row45.is_managed;
							insert_new_vm_device_connection_tmp.is_plugged = row45.is_plugged;
							insert_new_vm_device_connection_tmp.is_readonly = row45.is_readonly;
							insert_new_vm_device_connection_tmp.vm_configuration_version = row46.history_id;
							insert_new_vm_device_connection_tmp.device_configuration_version = row53.history_id != null ? row53.history_id
									: row54.history_id;
							insert_new_vm_device_connection_tmp.create_date = row45.create_date;
							insert_new_vm_device_connection_tmp.update_date = row45.update_date;
							insert_new_vm_device_connection_tmp.delete_date = null;
							insert_new_vm_device_connection = insert_new_vm_device_connection_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_31 = false;

						tos_count_tMap_31++;

						/**
						 * [tMap_31 main ] stop
						 */
						// Start of branch "insert_new_vm_device_connection"
						if (insert_new_vm_device_connection != null) {

							/**
							 * [tJDBCOutput_31 main ] start
							 */

							currentComponent = "tJDBCOutput_31";

							whetherReject_tJDBCOutput_31 = false;
							if (insert_new_vm_device_connection.vm_id == null) {
								pstmt_tJDBCOutput_31.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_31.setObject(1,
										insert_new_vm_device_connection.vm_id);
							}

							if (insert_new_vm_device_connection.device_id == null) {
								pstmt_tJDBCOutput_31.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_31
										.setObject(
												2,
												insert_new_vm_device_connection.device_id);
							}

							if (insert_new_vm_device_connection.type == null) {
								pstmt_tJDBCOutput_31.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_31.setString(3,
										insert_new_vm_device_connection.type);
							}

							if (insert_new_vm_device_connection.address == null) {
								pstmt_tJDBCOutput_31.setNull(4,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_31
										.setString(
												4,
												insert_new_vm_device_connection.address);
							}

							pstmt_tJDBCOutput_31.setBoolean(5,
									insert_new_vm_device_connection.is_managed);

							if (insert_new_vm_device_connection.is_plugged == null) {
								pstmt_tJDBCOutput_31.setNull(6,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_31
										.setBoolean(
												6,
												insert_new_vm_device_connection.is_plugged);
							}

							pstmt_tJDBCOutput_31
									.setBoolean(
											7,
											insert_new_vm_device_connection.is_readonly);

							if (insert_new_vm_device_connection.vm_configuration_version == null) {
								pstmt_tJDBCOutput_31.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_31
										.setInt(8,
												insert_new_vm_device_connection.vm_configuration_version);
							}

							if (insert_new_vm_device_connection.device_configuration_version == null) {
								pstmt_tJDBCOutput_31.setNull(9,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_31
										.setInt(9,
												insert_new_vm_device_connection.device_configuration_version);
							}

							if (insert_new_vm_device_connection.create_date != null) {
								pstmt_tJDBCOutput_31
										.setTimestamp(
												10,
												new java.sql.Timestamp(
														insert_new_vm_device_connection.create_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_31.setNull(10,
										java.sql.Types.DATE);
							}

							if (insert_new_vm_device_connection.update_date != null) {
								pstmt_tJDBCOutput_31
										.setTimestamp(
												11,
												new java.sql.Timestamp(
														insert_new_vm_device_connection.update_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_31.setNull(11,
										java.sql.Types.DATE);
							}

							if (insert_new_vm_device_connection.delete_date != null) {
								pstmt_tJDBCOutput_31
										.setTimestamp(
												12,
												new java.sql.Timestamp(
														insert_new_vm_device_connection.delete_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_31.setNull(12,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_31 = insertedCount_tJDBCOutput_31
										+ pstmt_tJDBCOutput_31.executeUpdate();
								nb_line_tJDBCOutput_31++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_31 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_31++;

							/**
							 * [tJDBCOutput_31 main ] stop
							 */

						} // End of branch "insert_new_vm_device_connection"

					} // G_TM_M_280 close main tMap filter for table 'row45'

					/**
					 * [tJDBCInput_53 end ] start
					 */

					currentComponent = "tJDBCInput_53";

				}
				rs_tJDBCInput_53.close();
				stmt_tJDBCInput_53.close();

				globalMap.put("tJDBCInput_53_NB_LINE", nb_line_tJDBCInput_53);

				ok_Hash.put("tJDBCInput_53", true);
				end_Hash.put("tJDBCInput_53", System.currentTimeMillis());

				/**
				 * [tJDBCInput_53 end ] stop
				 */

				/**
				 * [tMap_31 end ] start
				 */

				currentComponent = "tMap_31";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row46 != null) {
					tHash_Lookup_row46.endGet();
				}
				globalMap.remove("tHash_Lookup_row46");

				if (tHash_Lookup_row53 != null) {
					tHash_Lookup_row53.endGet();
				}
				globalMap.remove("tHash_Lookup_row53");

				if (tHash_Lookup_row54 != null) {
					tHash_Lookup_row54.endGet();
				}
				globalMap.remove("tHash_Lookup_row54");

				// ###############################

				ok_Hash.put("tMap_31", true);
				end_Hash.put("tMap_31", System.currentTimeMillis());

				/**
				 * [tMap_31 end ] stop
				 */

				/**
				 * [tJDBCOutput_31 end ] start
				 */

				currentComponent = "tJDBCOutput_31";

				if (pstmt_tJDBCOutput_31 != null) {

					pstmt_tJDBCOutput_31.close();

				}

				nb_line_deleted_tJDBCOutput_31 = nb_line_deleted_tJDBCOutput_31
						+ deletedCount_tJDBCOutput_31;
				nb_line_update_tJDBCOutput_31 = nb_line_update_tJDBCOutput_31
						+ updatedCount_tJDBCOutput_31;
				nb_line_inserted_tJDBCOutput_31 = nb_line_inserted_tJDBCOutput_31
						+ insertedCount_tJDBCOutput_31;
				nb_line_rejected_tJDBCOutput_31 = nb_line_rejected_tJDBCOutput_31
						+ rejectedCount_tJDBCOutput_31;

				globalMap.put("tJDBCOutput_31_NB_LINE", nb_line_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_31);

				ok_Hash.put("tJDBCOutput_31", true);
				end_Hash.put("tJDBCOutput_31", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_31 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_53:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_56Process(globalMap);

		} catch (java.lang.Exception e) {

			throw new TalendException(e, currentComponent, globalMap);

		} catch (java.lang.Error error) {

			throw new java.lang.Error(error);

		} finally {
			// free memory for "tMap_31"
			globalMap.remove("tHash_Lookup_row46");

			// free memory for "tMap_31"
			globalMap.remove("tHash_Lookup_row53");

			// free memory for "tMap_31"
			globalMap.remove("tHash_Lookup_row54");

		}

		globalMap.put("tJDBCInput_53_SUBPROCESS_STATE", 1);
	}

	public static class delete_vm_device_connectionStruct implements
			routines.system.IPersistableRow<delete_vm_device_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public boolean is_managed;

		public boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public boolean is_readonly;

		public boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result
						+ ((this.vm_id == null) ? 0 : this.vm_id.hashCode());

				result = prime
						* result
						+ ((this.device_id == null) ? 0 : this.device_id
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final delete_vm_device_connectionStruct other = (delete_vm_device_connectionStruct) obj;

			if (this.vm_id == null) {
				if (other.vm_id != null)
					return false;
			} else if (!this.vm_id.equals(other.vm_id))
				return false;

			if (this.device_id == null) {
				if (other.device_id != null)
					return false;
			} else if (!this.device_id.equals(other.device_id))
				return false;

			return true;
		}

		public void copyDataTo(delete_vm_device_connectionStruct other) {

			other.vm_id = this.vm_id;
			other.device_id = this.device_id;
			other.type = this.type;
			other.address = this.address;
			other.is_managed = this.is_managed;
			other.is_plugged = this.is_plugged;
			other.is_readonly = this.is_readonly;
			other.vm_configuration_version = this.vm_configuration_version;
			other.device_configuration_version = this.device_configuration_version;
			other.create_date = this.create_date;
			other.update_date = this.update_date;
			other.delete_date = this.delete_date;

		}

		public void copyKeysDataTo(delete_vm_device_connectionStruct other) {

			other.vm_id = this.vm_id;
			other.device_id = this.device_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.device_id = (Object) dis.readObject();

					this.type = readString(dis);

					this.address = readString(dis);

					this.is_managed = dis.readBoolean();

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					this.is_readonly = dis.readBoolean();

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// boolean

				dos.writeBoolean(this.is_managed);

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// boolean

				dos.writeBoolean(this.is_readonly);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vm_device_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.vm_id, other.vm_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.device_id, other.device_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row48Struct implements
			routines.system.IPersistableRow<row48Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row48Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_56Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_56Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte