# Settings
%global product_name Data warehouse package for oVirt Virtualization Suite
%global product_description oVirt virtualization manager data warehouse
%global install_poms 1

%global dwh_name ovirt-engine-dwh
%global dwh_java %{_javadir}/%{dwh_name}
%global engine_group ovirt
%global engine_user ovirt

%global make_common_opts \\\
        -j1 \\\
        PACKAGE_NAME=%{name} \\\
        RPM_VERSION=%{version} \\\
        RPM_RELEASE=%{release} \\\
        OVIRT_DWH_NAME=%{dwh_name} \\\
        PREFIX=%{_prefix} \\\
        SYSCONF_DIR=%{_sysconfdir} \\\
        BIN_DIR=%{_bindir} \\\
        DATAROOT_DIR=%{_datadir} \\\
        PYTHON=%{__python} \\\
        PYTHON_DIR=%{python_sitelib} \\\
        JAVA_DIR=%{_javadir} \\\
        MAVENPOM_DIR=%{_mavenpomdir} \\\
        PKG_JAVA_DIR=%{dwh_java} \\\
        %{?BUILD_FLAGS:BUILD_FLAGS="%{BUILD_FLAGS}"} \\\
        %{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name: ovirt-engine-dwh
Version: 3.3.2
Release: 1%{?release_suffix}%{dist}
License: GPLv2
Summary: %{product_name}
Group: Virtualization/Management
URL: http://www.ovirt.org
BuildArch: noarch
Source: ovirt-engine-dwh-3.3.2.tar.gz

BuildRequires: jpackage-utils
BuildRequires: make
BuildRequires: maven
BuildRequires: maven-dependency-plugin
BuildRequires: maven-antrun-plugin
BuildRequires: maven-compiler-plugin
BuildRequires: apache-commons-collections
BuildRequires: log4j
BuildRequires: postgresql-jdbc
Requires: python
Requires: java-1.7.0-openjdk
Requires: jpackage-utils
Requires: apache-commons-collections >= 3.2
Requires: log4j
Requires: dom4j >= 1.6.1
Requires: postgresql-jdbc
Requires: postgresql-server >= 8.4.7
Requires: postgresql-contrib >= 8.4.7
Requires: logrotate
Requires: ovirt-engine

%description
The %{product_description} package provides
the ETL process and DB scripts to create a historic database API.
Enables SQL BI reports creation for management and monitoring.

%prep
%setup -c -q

%build

make %{make_common_opts}

%install
rm -fr "%{buildroot}"

make %{make_common_opts} install DESTDIR=%{buildroot}

install -d %{buildroot}%{_initddir}
install -p -m 755 data-warehouse/history_etl/history_service/%{dwh_name}d %{buildroot}%{_initddir}

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{dwh_name}"
ln -s "%{dwh_name}" "%{buildroot}%{dwh_java}/../%{name}"
%endif

# Register poms
%if !%{install_poms}
rm -fr "%{buildroot}%{_mavenpomdir}"
%else
for pom in %{buildroot}%{_mavenpomdir}/*.pom
do
  pomdir=`dirname "${pom}"`
  pom=`basename "${pom}"`
  jpppom="JPP.${pom}"
  mv "${pomdir}/${pom}" "${pomdir}/${jpppom}"
  artifact_id=`echo "${pom}" | sed -e 's/^%{name}-//' -e 's/\.pom//'`
  if [ -f "%{buildroot}%{dwh_java}/${artifact_id}.jar" ]
  then
    %add_maven_depmap "${jpppom}" "%{name}/${artifact_id}.jar"
  else
    %add_maven_depmap "${jpppom}"
  fi
done
%endif

%post
/sbin/chkconfig --add %{dwh_name}d > /dev/null 2>&1
/sbin/chkconfig %{dwh_name}d off > /dev/null 2>&1
/sbin/service %{dwh_name}d stop > /dev/null 2>&1
/usr/sbin/logrotate /etc/logrotate.conf > /dev/null || /bin/true

%preun
if [ "$1" -eq 0 ]
then
    /sbin/service %{dwh_name}d stop > /dev/null 2>&1
    /sbin/chkconfig --list %{dwh_name}d > /dev/null 2>&1
    if [ $? -eq 0 ]
    then
        /sbin/chkconfig --del %{dwh_name}d > /dev/null 2>&1
    fi
fi

%files
%{dwh_java}
%{_datadir}/%{dwh_name}
%if "%{name}" != "%{dwh_name}"
%{_javadir}/%{name}
%endif
%if %{install_poms}
%{_mavendepmapfragdir}/%{name}
%{_mavenpomdir}/JPP.%{name}-*
%endif

%dir %attr(-, %{engine_user}, %{engine_group}) %{_sysconfdir}/%{dwh_name}/engine-dwh.conf.d
%config(noreplace) %{_sysconfdir}/%{dwh_name}/engine-dwh.conf.d/10-setup-database-dwh.conf

%dir %{_sysconfdir}/ovirt-engine/%{dwh_name}
%{_initddir}/%{dwh_name}d
%config(noreplace) %{_sysconfdir}/logrotate.d/%{dwh_name}d
%{_bindir}/%{dwh_name}-setup
%{_sysconfdir}/cron.hourly/ovirt_engine_dwh_watchdog.cron
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{_sysconfdir}/ovirt-engine/%{dwh_name}/Default.properties

%changelog
* Thu Apr 19 2012 Yaniv Dary <ydary@redhat.com> - 3.0.0-1.fc16
- Added packaging to dwh
