# Enable/disable features according to the type of distribution:
%if 0%{?fedora}
%global install_systemd 1
%global install_systemv 0
%global install_poms 1
%global require_maven 1
%endif

%if 0%{?rhel}
%global install_systemd 0
%global install_systemv 1
%global install_poms 0
%global require_maven 0
%endif

# Settings
%global product_name oVirt Engine
%global product_name_short oVirt Engine
%global user_description oVirt Manager

# Short names for engine directories:
%global engine_name ovirt-engine
%global engine_etc %{_sysconfdir}/%{engine_name}
%global engine_data %{_datadir}/%{engine_name}
%global engine_ear %{engine_data}/engine.ear
%global engine_java %{_javadir}/%{engine_name}
%global engine_pki %{_sysconfdir}/pki/%{engine_name}
%global engine_jboss_modules %{engine_data}/modules

%global engine_state %{_localstatedir}/lib/%{engine_name}
%global engine_log %{_localstatedir}/log/%{engine_name}
%global engine_run %{_localstatedir}/run/%{engine_name}
%global engine_lock %{_localstatedir}/lock/%{engine_name}
%global engine_cache %{_localstatedir}/cache/%{engine_name}
%global engine_tmp %{_localstatedir}/tmp/%{engine_name}

%global restapi_war %{engine_ear}/restapi.war
%global root_war %{engine_ear}/root.war

# The name and ids of the engine user and group:
%global engine_user ovirt
%global engine_group ovirt
%global engine_gid 108
%global engine_uid 108

# The name and ids of the VDSM user and group:
%global vdsm_description Node Virtualization Manager
%global vdsm_user vdsm
%global vdsm_group kvm
%global vdsm_uid 36
%global vdsm_gid 36

# Macro to create an user:
#
# %1 user name
# %2 user id
# %3 primary group name
# %4 primary group id
# %5 description
# %6 home directory
#
%global create_user() \
getent group %3 >/dev/null || groupadd -r -g %4 %3; \
getent passwd %1 >/dev/null || useradd -r -u %2 -g %3 -c %5 -s /sbin/nologin -d %6 %1

# Macro to create the engine user and group:
%global create_engine_user \
%create_user %{engine_user} %{engine_uid} %{engine_group} %{engine_gid} "%{user_description}" %{engine_state}

# Macro to create the VDSM user and group:
%global create_vdsm_user \
%create_user %{vdsm_user} %{vdsm_uid} %{vdsm_group} %{vdsm_gid} "%{vdsm_description}" /var/lib/vdsm

%global make_common_opts \\\
	-j1 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE=%{release} \\\
	DISPLAY_VERSION=%{version}-%{release} \\\
	ENGINE_NAME=%{engine_name} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	ENGINE_STATE=%{engine_state} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	BIN_DIR=%{_bindir} \\\
	PID_DIR=%{_localstatedir}/run \\\
	DATAROOT_DIR=%{_datadir} \\\
	MAN_DIR=%{_mandir} \\\
	PYTHON=%{__python} \\\
	PYTHON_DIR=%{python_sitelib} \\\
	JAVA_DIR=%{_javadir} \\\
	MAVENPOM_DIR=%{_mavenpomdir} \\\
	PKG_SYSCONF_DIR=%{engine_etc} \\\
	PKG_EAR_DIR=%{engine_ear} \\\
	PKG_PKI_DIR=%{engine_pki} \\\
	PKG_JBOSS_MODULES=%{engine_jboss_modules} \\\
	PKG_CACHE_DIR=%{engine_cache} \\\
	PKG_LOCK_DIR=%{engine_lock} \\\
	PKG_LOG_DIR=%{engine_log} \\\
	PKG_TMP_DIR=%{engine_tmp} \\\
	%{?BUILD_FLAGS:BUILD_FLAGS="%{BUILD_FLAGS}"} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name: ovirt-engine
Version: 3.2.2
Release: 1.1%{?release_suffix}%{?dist}
Summary: Management server for Open Virtualization
Group: Virtualization/Management
License: ASL 2.0
URL: http://www.ovirt.org
Source0: http://ovirt.org/releases/stable/src/ovirt-engine-3.2.2.tar.gz

BuildArch: noarch

# Build time requirements:
BuildRequires: dos2unix
BuildRequires: java-devel
BuildRequires: jpackage-utils
BuildRequires: make
%if %{require_maven}
BuildRequires: maven
%endif
BuildRequires: unzip

# Run time requirements (most of these requirements should be
# moved to the subpackages):
Requires: bind-utils
Requires: cracklib-python
Requires: httpd
Requires: java-1.7.0-openjdk >= 1:1.7.0.9-2.3.3.2
Requires: java
Requires: jpackage-utils
Requires: mod_ssl
Requires: ntp
Requires: openssl
Requires: policycoreutils-python
Requires: python-configobj
Requires: python-cheetah
Requires: ovirt-host-deploy-java
Requires: yum-plugin-versionlock
Requires: ovirt-engine-cli

# For local database:
Requires: postgresql-server >= 8.4.7

# Require JBoss AS 7:
Requires: jboss-as >= 7.1.1-9.3

# We can't require exactly the same version and release of the
# setup package because it needs to be updated independely as part
# of the update process implemented in the engine-upgrade script:
Requires: %{name}-setup >= %{version}-%{release}

# Require the subpackages so that everything is installed when the
# main package is installed:
Requires: %{name}-backend = %{version}-%{release}
Requires: %{name}-restapi = %{version}-%{release}
Requires: %{name}-tools = %{version}-%{release}
Requires: %{name}-genericapi = %{version}-%{release}
Requires: %{name}-userportal = %{version}-%{release}
Requires: %{name}-dbscripts = %{version}-%{release}
Requires: %{name}-webadmin-portal = %{version}-%{release}

# Require other tool packages:
Requires: ovirt-iso-uploader
Requires: ovirt-image-uploader
Requires: ovirt-log-collector

# Make sure that obsolete subpackages are removed:
Obsoletes: %{name}-notification-service
Obsoletes: %{name}-tools-common
Obsoletes: %{name}-config

%description
%{product_name} is a feature-rich server virtualization management
system that provides advanced capabilities for managing the Open
virtualization infrastructure for Servers and Desktops.


%package backend
Summary: Engine core of %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}
Requires: java
Requires: openssh
Requires: openssl


%description backend
The backend engine of %{product_name_short}


%package restapi
Summary: RESTful API for %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description restapi
The RESTful API for %{product_name_short}


%package genericapi
Summary: Generic API for %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description genericapi
The generic API for %{product_name_short}


%package setup
Summary: Setup and upgrade scripts for %{product_name_short}
Group: Virtualization/Management
Requires: %{name}
Requires: yum
Requires: lsof
Requires: nfs-utils
Requires: python-cheetah

%description setup
Setup and upgrade scripts for %{product_name_short}


%package dbscripts
Summary: Database scripts for %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description dbscripts
Database scripts for %{product_name_short}


%package userportal
Summary: User Portal of %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description userportal
The user portal interface to %{product_name_short}


%package webadmin-portal
Summary: Web Admin Portal of %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description webadmin-portal
The web administration interface to %{product_name_short}


%package tools
Summary: Common libraries for  %{product_name_short} Tools
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description tools
The common libraries used by %{product_name_short} Tools


%package setup-plugin-allinone
Summary: All-in-one plugin for %{product_name_short}'s setup
Group: Virtualization/Management
Requires: %{name}-setup
Requires: %{name}-sdk
Requires: vdsm
Requires: ovirt-host-deploy-offline
Requires: openssh-server

%description setup-plugin-allinone
All-in-one plugin for %{product_name_short}'s setup


%prep

%setup -c -q

%build

make %{make_common_opts}

%install

rm -fr "%{buildroot}"

# Use the makefile to do the normal installation, after that we
# will need to replace jar files with links to their actual
# locations:
make %{make_common_opts} install DESTDIR=%{buildroot}

install -dm 755 %{buildroot}/%{engine_state}/deployments
install -dm 755 %{buildroot}/%{engine_state}/content
install -dm 755 %{buildroot}/%{engine_log}/{host-deploy,notifier,engine-manage-domains}
install -dm 755 %{buildroot}/%{engine_run}/notifier
install -dm 755 %{buildroot}/%{engine_lock}

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{engine_name}"
ln -s "%{engine_name}" "%{buildroot}%{engine_java}/../%{name}"
%endif

#
# Force TLS/SSL for selected applications.
#
for war in restapi userportal webadmin; do
    sed -i \
        's#<transport-guarantee>NONE</transport-guarantee>#<transport-guarantee>CONFIDENTIAL</transport-guarantee>#' \
        "%{buildroot}%{engine_ear}/${war}.war/WEB-INF/web.xml"
done

# Move the jar files to the right directory and replace them with links:
install -dm 755 %{buildroot}%{engine_java}
while read lib_path
do
  java_path=%{engine_java}/`basename ${lib_path}`
  mv %{buildroot}/${lib_path} %{buildroot}/${java_path}
  ln -s ${java_path} %{buildroot}${lib_path}
done <<'.'
%{engine_ear}/bll.jar
%{engine_ear}/genericapi.jar
%{engine_ear}/lib/vdsbroker.jar
%{engine_ear}/scheduler.jar
%{engine_jboss_modules}/org/ovirt/engine/core/common/main/common.jar
%{engine_jboss_modules}/org/ovirt/engine/core/compat/main/compat.jar
%{engine_jboss_modules}/org/ovirt/engine/core/dal/main/dal.jar
%{engine_jboss_modules}/org/ovirt/engine/core/searchbackend/main/searchbackend.jar
%{engine_jboss_modules}/org/ovirt/engine/core/tools/main/tools.jar
%{engine_jboss_modules}/org/ovirt/engine/core/utils/main/utils.jar
%{restapi_war}/WEB-INF/lib/interface-common-jaxrs.jar
%{restapi_war}/WEB-INF/lib/restapi-definition.jar
%{restapi_war}/WEB-INF/lib/restapi-jaxrs.jar
%{restapi_war}/WEB-INF/lib/restapi-types.jar
.

# Register poms
%if !%{install_poms}
rm -fr "%{buildroot}%{_mavenpomdir}"
%else
for pom in %{buildroot}%{_mavenpomdir}/*.pom
do
  pomdir=`dirname "${pom}"`
  pom=`basename "${pom}"`
  jpppom="JPP.${pom}"
  mv "${pomdir}/${pom}" "${pomdir}/${jpppom}"
  artifact_id=`echo "${pom}" | sed -e 's/^%{name}-//' -e 's/\.pom//'`
  if [ -f "%{buildroot}%{engine_java}/${artifact_id}.jar" ]
  then
    %add_maven_depmap "${jpppom}" "%{name}/${artifact_id}.jar"
  else
    %add_maven_depmap "${jpppom}"
  fi
done
%endif

# Install the systemd files:
%if %{install_systemd}
install -dm 755 %{buildroot}%{_unitdir}
install -m 644 packaging/fedora/engine-service.systemd %{buildroot}%{_unitdir}/%{engine_name}.service
install -dm 755 %{buildroot}%{_sysconfdir}/tmpfiles.d
install -m 644 packaging/resources/ovirt-tmpfilesd %{buildroot}%{_sysconfdir}/tmpfiles.d/ovirt-engine.conf
%endif

# Install System V init scripts:
%if %{install_systemv}
install -dm 755 %{buildroot}%{_sysconfdir}/rc.d/init.d
ln -s %{engine_data}/service/engine-service.py %{buildroot}%{_sysconfdir}/rc.d/init.d/ovirt-engine
%endif


%preun
if [ "$1" -eq 0 ]
then
    if [ -d "%{engine_pki}" ]; then
        #backup whole 'rhevm' dir into the backup dir with current date
        dest="%{engine_pki}/../%{engine_name}-backups/%{engine_name}-$(date +"%%Y_%%m_%%d_%%H_%%M_%%S")"
        mkdir -p "${dest}"
        cp -pR "%{engine_pki}" "${dest}"
    fi
fi


%postun
if [ "$1" -eq 0 ]
then
    rm -rf "%{engine_cache}"
    rm -rf "%{engine_pki}"

    if [[ -f %{_sysconfdir}/yum/pluginconf.d/versionlock.list ]]
    then
        sed -i '/%{name}/d' %{_sysconfdir}/yum/pluginconf.d/versionlock.list
    fi
fi


%pre
%create_engine_user


%pre backend
%create_engine_user


%pre setup
%create_vdsm_user


%pre tools
%create_engine_user


%files

# The main package owns most of the directories:
%dir %{engine_data}
%dir %{engine_data}/ovirt-isos
%dir %{engine_data}/db-backups
%dir %{engine_data}/scripts
%dir %{engine_run}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_lock}

# Log rotation script:
%{engine_data}/scripts/ovirtlogrot.sh
%{_sysconfdir}/cron.daily/ovirt-cron

# Misc configuration files:
%{engine_data}/conf
%if %{install_systemd}
%{_sysconfdir}/tmpfiles.d/ovirt-engine.conf
%endif

# Engine configuration files:
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_etc}
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_etc}/engine.conf

# Files needed by the service:
%config(noreplace) %{_sysconfdir}/security/limits.d/10-ovirt-engine.conf
%config(noreplace) %{_sysconfdir}/sysconfig/%{engine_name}
%dir %{_sysconfdir}/sysconfig/%{engine_name}.d
%{engine_data}/service
%{_bindir}/engine-service
%if %{install_systemd}
%{_unitdir}/%{engine_name}.service
%endif
%if %{install_systemv}
%{_initddir}/ovirt-engine
%endif

# Jar files used by all the components:
%dir %{engine_java}
%{engine_java}/common.jar
%{engine_java}/compat.jar
%{engine_java}/utils.jar

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{engine_name}"
%{_javadir}/%{name}
%endif

# POM files:
%if %{install_poms}
%{_mavendepmapfragdir}/%{name}
%{_mavenpomdir}/JPP.%{name}-root.pom
%{_mavenpomdir}/JPP.%{name}-common.pom
%{_mavenpomdir}/JPP.%{name}-compat.pom
%{_mavenpomdir}/JPP.%{name}-utils.pom
%endif

# Documentation:
%doc LICENSE


%files backend

# Directory for binaries and scripts:
%dir %{engine_data}/bin

# Jar files:
%{engine_java}/bll.jar
%{engine_java}/dal.jar
%{engine_java}/scheduler.jar
%{engine_java}/searchbackend.jar
%{engine_java}/vdsbroker.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-backend.pom
%{_mavenpomdir}/JPP.%{name}-manager.pom
%{_mavenpomdir}/JPP.%{name}-manager-modules.pom
%{_mavenpomdir}/JPP.%{name}-tools.pom
%{_mavenpomdir}/JPP.%{name}-bll.pom
%{_mavenpomdir}/JPP.%{name}-dal.pom
%{_mavenpomdir}/JPP.%{name}-scheduler.pom
%{_mavenpomdir}/JPP.%{name}-searchbackend.pom
%{_mavenpomdir}/JPP.%{name}-vdsbroker.pom
%endif

# The state directory is owned by the backend, but not recursively, as
# some of its subdirectories are owned by other packages (backups, for
# example, has to be owned by the setup package):
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_state}

# Directories for the deployments and content files need to be owned by
# the engine user because the application server needs to write to them:
%attr(-, %{engine_user}, %{engine_group}) %{engine_state}/content
%attr(-, %{engine_user}, %{engine_group}) %{engine_state}/deployments

# Host deploy logs
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/host-deploy

# The backend owns the directory of the ear and most of its contents,
# but not all, as most of the web applications are owned by other
# subpackages:
%dir %{engine_ear}
%{engine_ear}/META-INF
%{engine_ear}/lib
%{engine_ear}/bll.jar
%{engine_ear}/scheduler.jar
%{engine_ear}/ovirtengineweb.war

# Root web application:
%{root_war}

# Sysprep files:
%config(noreplace) %{engine_etc}/sysprep

# PKI directories are owned by the engine user because it needs to
# create files inside:
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/certs
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/keys
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/private
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/requests

# PKI scripts:
%{engine_pki}/*.sh

# PKI configuration files:
%config(noreplace) %{engine_pki}/openssl.conf
%config(noreplace) %{engine_pki}/cacert.template
%config(noreplace) %{engine_pki}/cert.template

# The certificate database files:
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/database.txt
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/serial.txt

# Modules:
%{engine_jboss_modules}

%files setup

# Links to the main programs:
%{_bindir}/engine-setup
%{_bindir}/engine-upgrade
%{_bindir}/engine-check-update
%{_bindir}/engine-cleanup

# Python scripts:
%{engine_data}/scripts/basedefs.py*
%{engine_data}/scripts/engine_validators.py*
%{engine_data}/scripts/engine_firewalld.py*
%{engine_data}/scripts/setup_params.py*
%{engine_data}/scripts/setup_sequences.py*
%{engine_data}/scripts/setup_controller.py*
%{engine_data}/scripts/common_utils.py*
%{engine_data}/scripts/miniyum.py*
%{engine_data}/scripts/output_messages.py*
%{engine_data}/scripts/nfsutils.py*
%{engine_data}/scripts/engine-setup.py*
%{engine_data}/scripts/engine-cleanup.py*
%{engine_data}/scripts/engine-upgrade.py*
%{engine_data}/scripts/post_upgrade.py*
%{engine_data}/scripts/add_fn_db_get_async_tasks_function.sql

# Firewalld configuration
%config(noreplace) %{_sysconfdir}/firewalld/services/ovirt.xml

# Man pages
%{_mandir}/man8/engine-setup.*
%{_mandir}/man8/engine-upgrade.*

# Plugins directory:
%dir %{engine_data}/scripts/plugins
%{engine_data}/scripts/plugins/example_plugin_000.py*

# Backups directory
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_state}/backups

%files setup-plugin-allinone
%{engine_data}/scripts/plugins/all_in_one_100.py*


%files dbscripts
%{engine_data}/dbscripts


%files restapi

# Jar files:
%{engine_java}/interface-common-jaxrs.jar
%{engine_java}/restapi-definition.jar
%{engine_java}/restapi-jaxrs.jar
%{engine_java}/restapi-types.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-interface-common-jaxrs.pom
%{_mavenpomdir}/JPP.%{name}-restapi-definition.pom
%{_mavenpomdir}/JPP.%{name}-restapi-jaxrs.pom
%{_mavenpomdir}/JPP.%{name}-restapi-parent.pom
%{_mavenpomdir}/JPP.%{name}-restapi-types.pom
%endif

# Everything inside of the web application is owned by this
# subpackage:
%{restapi_war}


%files genericapi

# Jar files:
%{engine_java}/genericapi.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-genericapi.pom
%endif

# Link to the jar file inside the ear:
%{engine_ear}/genericapi.jar


%files userportal
%config(noreplace) %{engine_etc}/usbfilter.txt
%{engine_ear}/userportal.war


%files webadmin-portal
%{engine_ear}/webadmin.war


%files tools

# Scripts:
%{engine_data}/bin/engine-config.sh
%{engine_data}/bin/engine-encrypt-passwd.sh
%{engine_data}/bin/engine-manage-domains.sh
%{engine_data}/bin/engine-notifier.sh
%{engine_data}/bin/engine-prolog.sh
%{_initddir}/engine-notifierd

# Links to the scripts:
%{_bindir}/engine-config
%{_bindir}/engine-manage-domains

# Configuration files for the configuration tool:
%dir %{engine_etc}/engine-config
%config(noreplace) %{engine_etc}/engine-config/engine-config.conf
%{engine_etc}/engine-config/engine-config.*properties
%{engine_etc}/engine-config/log4j.xml

# Configuration files for the domain management tool:
%dir %{engine_etc}/engine-manage-domains
%config(noreplace) %{engine_etc}/engine-manage-domains/engine-manage-domains.conf
%{engine_etc}/engine-manage-domains/log4j.xml

# Configuration files for the notifier:
%dir %{engine_etc}/notifier
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_etc}/notifier/notifier.conf
%{engine_etc}/notifier/log4j.xml

# Jar files:
%{engine_java}/tools.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-tools.pom
%endif

# Log and state directories must be owned by ovirt because the notifier service
# runs with that user and needs to write them:
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}/notifier
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_run}/notifier


%changelog
* Fri Nov 02 2012 Juan Hernandez <juan.hernandez@redhat.com> - 3.2.0-1
- Bump version to 3.2.0

* Mon May 07 2012 Keith Robertson <kroberts@redhat.com> - 3.1.0-3
- Removed image uploader, iso uploader, and log collector from this
  git repo.  The are now in their own respective ovirt.org git
  repos. BZ#803240.

* Wed Apr 04 2012 Stephen Gordon <sgordon@redhat.com> - 3.1.0-2
- The ovirt-engine spec file did not previously contain a BuildRequires
  statement for the maven package. As a result in mock environments the
  build failed with an error when attempting to call the 'mvn' binary -
  BZ#807761.

* Wed Jan 04 2012 Ronen Angluste <ranglust@redhat.com> - 3.1.0-1
- Adjust code for Jboss AS 7.1

* Sun Dec 11 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Moved all hard coded paths to macros

* Wed Oct 26 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Initial build
- Cloned from RHEVM spec file
