/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class NamingBindingAdd
extends AbstractAddStepHandler {
    static final NamingBindingAdd INSTANCE = new NamingBindingAdd();

    private NamingBindingAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        this.installRuntimeServices(context, name, model, verificationHandler, newControllers);
    }

    void installRuntimeServices(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String type = model.require("binding-type").asString();
        if (type.equals("simple")) {
            this.installSimpleBinding(context, name, model, verificationHandler, newControllers);
        } else if (type.equals("object-factory")) {
            this.installObjectFactory(context, name, model, verificationHandler, newControllers);
        } else if (type.equals("lookup")) {
            this.installLookup(context, name, model, verificationHandler, newControllers);
        } else {
            throw new OperationFailedException(new ModelNode().set("Unknown binding type " + type));
        }
    }

    void installSimpleBinding(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String value = NamingBindingResourceDefinition.VALUE.resolveModelAttribute(context, model).asString();
        String type = model.hasDefined("type") ? NamingBindingResourceDefinition.TYPE.resolveModelAttribute(context, model).asString() : null;
        Object bindValue = this.coerceToType(value, type);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name, bindValue);
        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value<?>)new ImmediateValue(bindValue)));
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    void installObjectFactory(OperationContext context, final String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ObjectFactory objectFactoryClassInstance;
        Module module;
        ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)NamingBindingResourceDefinition.MODULE.resolveModelAttribute(context, model).asString());
        String className = NamingBindingResourceDefinition.CLASS.resolveModelAttribute(context, model).asString();
        try {
            module = Module.getBootModuleLoader().loadModule(moduleID);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Could not load module " + moduleID));
        }
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)module.getClassLoader());
            Class clazz = module.getClassLoader().loadClass(className);
            objectFactoryClassInstance = (ObjectFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Could not load class " + className + " from module " + moduleID));
        }
        catch (InstantiationException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Could not instantiate instance of class " + className + " from module " + moduleID));
        }
        catch (IllegalAccessException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Could not instantiate instance of class " + className + " from module " + moduleID));
        }
        catch (ClassCastException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Class " + className + " from module " + moduleID + " was not an instance of ObjectFactory"));
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name, objectFactoryClassInstance);
        binderService.getManagedObjectInjector().inject((Object)new ManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = objectFactoryClassInstance.getObjectInstance(name, null, null, null);
                    return new ValueManagedReference((Value<Object>)new ImmediateValue(value));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    void installLookup(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final String lookup = NamingBindingResourceDefinition.LOOKUP.resolveModelAttribute(context, model).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name);
        binderService.getManagedObjectInjector().inject((Object)new ManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = new InitialContext().lookup(lookup);
                    return new ValueManagedReference((Value<Object>)new ImmediateValue(value));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    private Object coerceToType(String value, String type) throws OperationFailedException {
        if (type == null || type.isEmpty() || type.equals(String.class.getName())) {
            return value;
        }
        if (type.equals("char") || type.equals("java.lang.Character")) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals("byte") || type.equals("java.lang.Byte")) {
            return Byte.parseByte(value);
        }
        if (type.equals("short") || type.equals("java.lang.Short")) {
            return Short.parseShort(value);
        }
        if (type.equals("int") || type.equals("java.lang.Integer")) {
            return Integer.parseInt(value);
        }
        if (type.equals("long") || type.equals("java.lang.Long")) {
            return Long.parseLong(value);
        }
        if (type.equals("float") || type.equals("java.lang.Float")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals("double") || type.equals("java.lang.Double")) {
            return Double.parseDouble(value);
        }
        if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            return Boolean.parseBoolean(value);
        }
        throw new OperationFailedException(new ModelNode().set("Unknown primitive type " + type));
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String type = operation.require("binding-type").asString();
        model.get("binding-type").set(type);
        if (type.equals("simple")) {
            model.get("value").set(operation.require("value").asString());
            if (operation.hasDefined("type")) {
                model.get("type").set(operation.require("type").asString());
            }
        } else if (type.equals("object-factory")) {
            model.get("module").set(operation.require("module").asString());
            model.get("class").set(operation.require("class").asString());
        } else if (type.equals("lookup")) {
            model.get("lookup").set(operation.require("lookup").asString());
        } else {
            throw new OperationFailedException(new ModelNode().set("Unknown binding type " + type));
        }
    }
}

