/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModifierOrderCheck
extends Check {
    private static final String[] JLS_ORDER = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp"};

    public int[] getDefaultTokens() {
        return new int[]{5};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST error;
        ArrayList<AST> mods = new ArrayList<AST>();
        for (AST modifier = aAST.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            mods.add(modifier);
        }
        if (!mods.isEmpty() && (error = this.checkOrderSuggestedByJLS(mods)) != null) {
            if (error.getType() == 159) {
                this.log(error.getLineNo(), error.getColumnNo(), "annotation.order", (Object)(error.getFirstChild().getText() + error.getFirstChild().getNextSibling().getText()));
            } else {
                this.log(error.getLineNo(), error.getColumnNo(), "mod.order", (Object)error.getText());
            }
        }
    }

    DetailAST checkOrderSuggestedByJLS(List aModifiers) {
        DetailAST modifier;
        int i = 0;
        Iterator it = aModifiers.iterator();
        if (!it.hasNext()) {
            return null;
        }
        do {
            modifier = (DetailAST)it.next();
        } while (it.hasNext() && modifier.getType() == 159);
        if (modifier.getType() == 159) {
            return null;
        }
        while (i < JLS_ORDER.length) {
            if (modifier.getType() == 159) {
                return modifier;
            }
            while (i < JLS_ORDER.length && !JLS_ORDER[i].equals(modifier.getText())) {
                ++i;
            }
            if (i == JLS_ORDER.length) {
                return modifier;
            }
            if (!it.hasNext()) {
                return null;
            }
            modifier = (DetailAST)it.next();
        }
        return modifier;
    }
}

