# Copyright (C) 2015 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%if 0%{?rhel} && 0%{?rhel} <= 6
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%global         package_version 1.0.1

Summary:        oVirt setup common library
Name:           ovirt-setup-lib
Version:        1.0.1
Release:        1%{?release_suffix}%{?dist}
Source0:        http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{package_version}.tar.gz
License:        ASL 2.0
Group:          Development/Libraries
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires:       python

Requires:       otopi

BuildRequires:  gettext
BuildRequires:  python2-devel

%description
oVirt setup common library

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_pkgdocdir}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{python2_sitelib}/ovirt_setup_lib/
%{_pkgdocdir}/*
%doc README.md
%if 0%{?rhel} && 0%{?rhel} <= 6
%doc COPYING
%else
%license COPYING
%endif


%changelog
* Tue Dec 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.1-1
- 1.0.1-1

* Tue Sep 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-1
- 1.0.0-1

* Wed Jul 15 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.0.master
- initial packaging
- doc: https://fedoraproject.org/wiki/Changes/UnversionedDocdirs
- python: https://fedoraproject.org/wiki/Packaging:Python#Macros

