#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2014-2019 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 4.4.2_rc5
%global	package_name ovirt-release44
%global	package_short_version 4.4.2
%global	ovirt_version 4.4
%global	ovirt_yum_repo https://resources.ovirt.org
%global	ovirt_repo_path_normal /pub/yum-repo/mirrorlist-ovirt-4.4-snapshot-
%global	ovirt_repo_path_static /pub/yum-repo/mirrorlist-ovirt-4.4-snapshot-static-
%global	repo_url_key mirrorlist
%define is_x86 %(test %{_arch} = x86_64 && echo 1 || echo 0)

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_node 1
%else
%global with_node 0
%endif


Name:		%{package_name}
Version:	4.4.2
Release:	0.5.rc5%{?release_suffix}%{?dist}
Summary:	The oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		https://www.ovirt.org
Source0:	https://resources.ovirt.org/pub/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	https://resources.ovirt.org/pub/keys/RPM-GPG-ovirt-v2

BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:	system-release
Requires:	tar
%if 0%{?fedora} >= 30 || 0%{?rhel} >= 8
Requires:	python3
%endif

%description
This package contains the yum configuration for oVirt repositories


%if %{with_node}
# node supported targets
%global	host_node_release_file ovirt-release-host-node
%package -n ovirt-release-host-node
Summary:	The oVirt Node release file
Version:	4.4.2
Release:	0.5.rc5%{?release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		https://www.ovirt.org
BuildArch:	noarch

BuildRequires:	systemd

Requires(post):	systemd
Requires(post):	firewalld
Requires(postun):	systemd
Requires(postun):	firewalld

Requires:	ovirt-node-ng-nodectl
Requires:	firewalld
Requires:	gluster-ansible-roles
Requires:	imgbased
Requires:	ovirt-host
Requires:	vdsm-gluster

%if 0%{?fedora} >= 30 || 0%{?rhel} >= 8
Requires:	python3-ovirt-engine-sdk4
%else
Requires:	python-ovirt-engine-sdk4
%endif

# Additional packages for EFI support
# https://www.brianlane.com/creating-live-isos-with-livemedia-creator.html
# http://lorax.readthedocs.org/en/latest/livemedia-creator.html#kickstarts
# Architecture dependent dependencies
%if 0%{?is_x86}
Requires:	efibootmgr

%if 0%{?fedora}
Requires:	grub2-efi
%else
Requires:	grub2-efi-x64
%endif

Requires:	memtest86+
Requires:	shim
Requires:	syslinux
Requires:	iotop
%endif

%description -n ovirt-release-host-node
oVirt Node distribution dependencies, presets and required settings.

%package -n ovirt-node-ng-image-update-placeholder
Summary:	The oVirt Node Image Update Placeholder
Version:	4.4.2
Release:	0.5.rc5%{?release_suffix}%{?placeholder_release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		https://www.ovirt.org
BuildArch:	noarch

%description -n ovirt-node-ng-image-update-placeholder
A sub-package to be included into oVirt Node Next squashfs
image to allow upgrading itself
%endif # node supported targets

%package pre
Summary:	oVirt pre-release repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description pre
This package contains the yum configuration for oVirt pre-release repositories

%package tested
Summary:	oVirt tested repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description tested
This package contains the yum configuration for oVirt tested repositories

%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure \
	--with-ovirt-yum-repo=%{ovirt_yum_repo} \
	--with-repo-url-key=%{repo_url_key} \
	--with-repo-path-normal=%{ovirt_repo_path_normal} \
	--with-repo-path-static=%{ovirt_repo_path_static}
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-tested.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-pre"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-tested"

%if %{with_node}
install -d 755 "%{buildroot}/data/images/rhev"
%else
rm -f "%{buildroot}/usr/lib/systemd/system-preset/98-ovirt-host-node.preset"
rm -rf "%{buildroot}/usr/share/ovirt-release-host-node"
%endif

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el8" ]] ; then
	if [ -f /etc/dnf/vars/stream ] ; then
		install -m 644 "%{_datadir}/%{package_name}/ovirt-el8-stream-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
	else
		install -m 644 "%{_datadir}/%{package_name}/ovirt-el8-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
	fi
	if [ -f /etc/yum.repos.d/CentOS-PowerTools.repo ] ; then
		sed -i "s:enabled=0:enabled=1:" /etc/yum.repos.d/CentOS-PowerTools.repo
	fi
elif [[ "${DISTVER}" == "fc31" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f31-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc30" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f30-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

%post tested

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el8" ]] ; then
	if [ -f /etc/dnf/vars/stream ] ; then
		install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-el8-stream-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
	else
		install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-el8-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
	fi
	if [ -f /etc/yum.repos.d/CentOS-PowerTools.repo ] ; then
		sed -i "s:enabled=0:enabled=1:" /etc/yum.repos.d/CentOS-PowerTools.repo
	fi
elif [[ "${DISTVER}" == "fc31" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-f31-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc30" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-f30-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-tested/ovirt-tested.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-tested.repo"

%post pre

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el8" ]] ; then
	if [ -f /etc/dnf/vars/stream ] ; then
		install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el8-stream-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
	else
		install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el8-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
	fi
	if [ -f /etc/yum.repos.d/CentOS-PowerTools.repo ] ; then
		sed -i "s:enabled=0:enabled=1:" /etc/yum.repos.d/CentOS-PowerTools.repo
	fi
elif [[ "${DISTVER}" == "fc31" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f31-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc30" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f30-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-pre/ovirt-pre.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"


%files
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo

%files pre
%{_datadir}/%{package_name}-pre/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files tested
%{_datadir}/%{package_name}-tested/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-tested.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%if %{with_node}
%post -n ovirt-release-host-node
%define __default_units_wanted cockpit.socket sshd.service NetworkManager.service imgbase-setup.service rsyslog.service auditd.service
# Make the defualt services default requirements of the target
for UNIT in %{__default_units_wanted} ; do
  ln -fs ../$UNIT %{_unitdir}/multi-user.target.wants/$UNIT
done

#
# Create the common os-release file

# Import os-release to get some fields
# NAME, VERSION, ID, VERSION_ID, CPE_NAME
. /etc/os-release || :

install -d /usr/lib/os.release.d/
cat << EOF >> /usr/lib/os.release.d/%{host_node_release_file}
NAME="$NAME"
VERSION="$VERSION"
ID="$ID"
ID_LIKE="$ID_LIKE"
VERSION_ID="$VERSION_ID"
VARIANT="oVirt Node %{package_version}"
VARIANT_ID="ovirt-node"
PRETTY_NAME="oVirt Node %{package_short_version}"
ANSI_COLOR="$ANSI_COLOR"
CPE_NAME="$CPE_NAME"
HOME_URL="https://www.ovirt.org/"
BUG_REPORT_URL="https://bugzilla.redhat.com/"
EOF

if [[ -n $PLATFORM_ID ]]; then
    echo "PLATFORM_ID=\"$PLATFORM_ID\"" >> /usr/lib/os.release.d/%{host_node_release_file}
fi

# Only on installation
if [ $1 = 1 ]; then
	cp -p /etc/os-release /usr/lib/os.release.d/.host-node-previous-os-release
	ln -sf os.release.d/%{host_node_release_file} /usr/lib/os-release
	ln -sf ../usr/lib/os-release /etc/os-release
	source /etc/os-release
	ln -sf %{_prefix}/share/ovirt-release-host-node/branding %{_prefix}/share/cockpit/branding/$ID-ovirt-node
fi

# Firewalld - add all services required for host
firewall-offline-cmd --add-service=cockpit >/dev/null 2>&1
firewall-offline-cmd --add-service=vdsm >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt-tls >/dev/null 2>&1
firewall-offline-cmd --add-service=ssh >/dev/null 2>&1
firewall-offline-cmd --add-service=glusterfs >/dev/null 2>&1
systemctl restart firewalld.service >/dev/null 2>&1

# Restarting cockpit to load the new branding data
systemctl restart cockpit.service >/dev/null 2>&1

# Only whitelist ovirt-node-ng-image-update and ovirt-engine-appliance
# set-enabled is needed to keep the repo enabled when post-processing
# the image
# The loop is required because sed -i does not work with multiple files
PYTHON=$(command -v python3 || command -v python)

for REPO in %{_sysconfdir}/yum.repos.d/ovirt-*.repo;
do
    $PYTHON << EOF
try:
    from ConfigParser import ConfigParser
except ImportError:
    from configparser import ConfigParser
cp = ConfigParser()
cp.optionxform = str
cp.read("$REPO")
for s in cp.sections():
    cp.remove_option(s, "includepkgs")
    cp.set(s, "includepkgs", "ovirt-node-ng-image-update ovirt-node-ng-image ovirt-engine-appliance")
with open("$REPO", "w") as f:
    f.write("# imgbased: set-enabled\n")
    cp.write(f)
EOF
done

#
# NGN TEMPORARY HACKS
# For each hack there must be a bug, and they must be removed at
# some point in time
# ===================

# =======================
# NGN TEMPORARY HACKS END
#

%postun -n ovirt-release-host-node
for UNIT in %{__default_units_wanted} ; do
  rm -f %{_unitdir}/multi-user.target.wants/$UNIT
done

# In case of uninstall the host-node pkg, return the previous os-release
if [ $1 = 0 ]; then
	rm -f %{_prefix}/share/cockpit/branding/*-ovirt-node
	rm -f /usr/lib/os-release /etc/os-release
	cp -pf /usr/lib/os.release.d/.host-node-previous-os-release /usr/lib/os-release
	ln -sf /usr/lib/os-release /etc/os-release
	rm -f /usr/lib/os.release.d/.host-node-previous-os-release
	firewall-offline-cmd --remove-service=cockpit >/dev/null 2>&1
	firewall-offline-cmd --remove-service=vdsm >/dev/null 2>&1
	firewall-offline-cmd --remove-service=libvirt >/dev/null 2>&1
	firewall-offline-cmd --remove-service=ssh >/dev/null 2>&1
	systemctl restart firewalld.service >/dev/null 2>&1
fi
# Restarting cockpit to reload the branding data
systemctl restart cockpit.service >/dev/null 2>&1

%files -n ovirt-node-ng-image-update-placeholder

%files -n ovirt-release-host-node
%ghost %attr(0644, root, root) %{_prefix}/lib/os.release.d/%{host_node_release_file}
%dir %{_prefix}/share/ovirt-release-host-node
%dir %{_prefix}/share/ovirt-release-host-node/branding
%{_presetdir}/98-ovirt-host-node.preset
%{_prefix}/share/ovirt-release-host-node/branding/*

# Add a folder for local datastores
%dir %attr(0755, vdsm, kvm) /data/images/rhev
%endif

%changelog
* Tue Aug 25 2020 Lev Veyde <lveyde@redhat.com> - 4.4.2-0.5.rc5
- 4.4.2 RC5

* Tue Aug 18 2020 Lev Veyde <lveyde@redhat.com> - 4.4.2-0.4.rc4
- 4.4.2 RC4

* Wed Aug 12 2020 Lev Veyde <lveyde@redhat.com> - 4.4.2-0.3.rc3
- 4.4.2 RC3

* Tue Aug 04 2020 Lev Veyde <lveyde@redhat.com> - 4.4.2-0.2.rc2
- 4.4.2 RC2

* Tue Jul 28 2020 Lev Veyde <lveyde@redhat.com> - 4.4.2-0.1.rc1
- 4.4.2 RC1

* Wed Jul 22 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1.4-1
- 4.4.1.4 GA

* Wed Jul 22 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1.3-1
- 4.4.1.3 GA

* Mon Jul 20 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1.2-1
- 4.4.1.2 GA

* Mon Jul 13 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1.1-1
- 4.4.1.1 GA

* Tue Jul 07 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1-1
- 4.4.1 GA

* Tue Jun 30 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.1-0.8.rc6
- RC6 build

* Fri Jun 19 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.1-0.7.rc5
- RC5 re-build

* Fri Jun 19 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.1-0.6.rc5
- RC5 build

* Mon Jun 08 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.1-0.5.rc4
- RC4 build

* Tue Jun 02 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1-0.4.rc3
- RC3 build

* Tue May 26 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1-0.3.rc2
- RC2 build

* Fri May 22 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1-0.2.rc1
- RC1 build re-spin

* Wed May 20 2020 Lev Veyde <lveyde@redhat.com> - 4.4.1-0.1.rc1
- RC1 build

* Wed May 20 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-2
- 4.4.0 GA re-spin

* Mon May 18 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-1
- 4.4.0 GA

* Tue May 12 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-rc2
- RC2 build

* Tue May 05 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-rc1
- RC1 build

* Fri Apr 17 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-beta4
- Beta4 build

* Wed Apr 08 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-beta3
- Beta3 build

* Tue Mar 31 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-beta2
- Beta2 build

* Tue Mar 24 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-beta1
- Beta1 build

* Wed Mar 11 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-0.7.alpha
- Alpha refresh

* Fri Feb 28 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-0.6.alpha
- Alpha refresh

* Wed Feb 26 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-0.5.alpha
- Alpha refresh

* Wed Feb 12 2020 Lev Veyde <lveyde@redhat.com> - 4.4.0-0.4.alpha
- Alpha refresh

* Tue Jan 21 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-0.3.alpha
- Alpha refresh

* Mon Jan 13 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-0.2.alpha
- Alpha refresh

* Wed Dec 11 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-0.1.alpha
- Alpha build

* Thu Nov 21 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.4.0-0.0.alpha
- Alpha build
