# Hack to require python2-* packages on Fedora, and python-* on RHEL.
%if 0%{?rhel}
%global python python
%else
%global python python2
%endif

%global     package_name    ovirt-imageio-proxy
%global     package_version 1.6.2

%global     proxy_confdir   %{_sysconfdir}/%{package_name}
%global     proxy_logdir    %{_localstatedir}/log/%{package_name}
%global     engine_name     ovirt-engine
%global     engine_data     %{_datadir}/%{engine_name}

Name:       %{package_name}
Version:    %{package_version}
Release:    0%{?release_suffix}%{?dist}
Summary:    oVirt imageio proxy

Group:      Applications/System
License:    GPLv2+
URL:        https://gerrit.ovirt.org/ovirt-imageio
Source0:    http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{version}.tar.gz
BuildArch:  noarch

# NOTE: keep in sync with automation/check.packages
Requires:   m2crypto
Requires:   ovirt-imageio-common = %{version}
Requires:   %{python}
Requires:   %{python}-requests
Requires:   %{python}-webob

%if 0%{?rhel}
Requires:   systemd-python
%else
Requires:   python2-systemd
%endif

Requires:   %{name}-setup >= %{version}

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires:  %{python}-devel
BuildRequires:  systemd


%description
Proxy for image upload data transfer for oVirt project.


%prep
%setup -q


%build
make %{?_smp_mflags}


%install
make %{?_smp_mflags} install DESTDIR=%{buildroot}

install -dDm 0750 %{buildroot}%{proxy_confdir}
install -dDm 0700 %{buildroot}%{proxy_logdir}
install -Dm 0640 data/ovirt-imageio-proxy.conf.sample %{buildroot}%{proxy_confdir}
install -Dm 0640 data/logger.conf %{buildroot}%{proxy_confdir}
install -Dm 0644 data/ovirt-imageio-proxy.service %{buildroot}%{_unitdir}/ovirt-imageio-proxy.service

install -Dm 0644 setup/data/ovirt-imageio-proxy.xml.in %{buildroot}%{engine_data}/firewalld/ovirt-imageio-proxy/ovirt-imageio-proxy.xml.in
find setup/plugins setup/ovirt_engine_setup -name '*.py' -exec install -Dm 0644 {} %{buildroot}%{engine_data}/{} \;


%clean
make clean


%files
%license COPYING

%dir %{proxy_confdir}
%config(noreplace) %{proxy_confdir}/*
%{_unitdir}/ovirt-imageio-proxy.service
%{_bindir}/ovirt-imageio-proxy
%dir %{proxy_logdir}
%{python2_sitelib}/*


# For more information about the systemd macros, see:
# https://fedoraproject.org/wiki/Packaging:Scriptlets#New_Packages

%post
# After installation, synchronize service state with preset files.
%systemd_post ovirt-imageio-proxy.service


%preun
# Before uninstalling, this stops and disables the service.
%systemd_preun ovirt-imageio-proxy.service


%postun
# After upgrading, this restarts the service.
%systemd_postun_with_restart ovirt-imageio-proxy.service


%package setup
Summary:    Setup plugin for oVirt imageio proxy
Requires:   %{engine_name}-setup-plugin-ovirt-engine-common >= 4.3.0
Requires:   %{python}-six
License:    ASL 2.0

%description setup
Setup plugin for oVirt imageio proxy

%files setup
%license setup/COPYING
%{engine_data}/firewalld/ovirt-imageio-proxy/
%{engine_data}/setup/ovirt_engine_setup/ovirt_imageio_proxy/
%{engine_data}/setup/plugins/*/ovirt_imageio_proxy/
