/*
Copyright (c) 2016 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.api.v3.adapters;

import static org.ovirt.engine.api.v3.adapters.V3OutAdapters.adaptOut;

import org.ovirt.engine.api.model.CloudInit;
import org.ovirt.engine.api.v3.V3Adapter;
import org.ovirt.engine.api.v3.types.V3AuthorizedKeys;
import org.ovirt.engine.api.v3.types.V3CloudInit;
import org.ovirt.engine.api.v3.types.V3Files;
import org.ovirt.engine.api.v3.types.V3Users;

public class V3CloudInitOutAdapter implements V3Adapter<CloudInit, V3CloudInit> {
    @Override
    public V3CloudInit adapt(CloudInit from) {
        V3CloudInit to = new V3CloudInit();
        if (from.isSetAuthorizedKeys()) {
            to.setAuthorizedKeys(new V3AuthorizedKeys());
            to.getAuthorizedKeys().getAuthorizedKeys().addAll(adaptOut(from.getAuthorizedKeys().getAuthorizedKeys()));
        }
        if (from.isSetFiles()) {
            to.setFiles(new V3Files());
            to.getFiles().getFiles().addAll(adaptOut(from.getFiles().getFiles()));
        }
        if (from.isSetHost()) {
            to.setHost(adaptOut(from.getHost()));
        }
        if (from.isSetNetworkConfiguration()) {
            to.setNetworkConfiguration(adaptOut(from.getNetworkConfiguration()));
        }
        if (from.isSetRegenerateSshKeys()) {
            to.setRegenerateSshKeys(from.isRegenerateSshKeys());
        }
        if (from.isSetTimezone()) {
            to.setTimezone(from.getTimezone());
        }
        if (from.isSetUsers()) {
            to.setUsers(new V3Users());
            to.getUsers().getUsers().addAll(adaptOut(from.getUsers().getUsers()));
        }
        return to;
    }
}
