package org.ovirt.engine.core.utils.osinfo;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class OsinfoPropertiesParser {

    /**
     * Parse the properties file using the class auto-generated by javacc from the osinfo.jj file.
     * Parsing the file throws an exception in case the file structure doesn't follow the grammar.
     *
     * @param path
     */
    public static void parse(String path) {

        try (FileInputStream inputStream = new FileInputStream(path)) {
            OsInfoParser parser = new OsInfoParser(inputStream);
            parser.parse();
        } catch (FileNotFoundException e) {
            throw new RuntimeException(
                    String.format("osinfo properties file cannot be found: %s", path),
                    e
            );
        } catch (IOException e) {
            throw new RuntimeException(
                    String.format("error while reading osinfo properties file: %s", path),
                    e
            );
        } catch (ParseException e) {
            throw new RuntimeException(
                String.format(
                    "osinfo properties syntax error: %s: %d, %d: error: %s",
                    path,
                    e.currentToken.beginLine,
                    e.currentToken.beginColumn,
                    e.getMessage()
                ),
                e
            );
        }
    }
}
