/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.ovirt.engine.sdk.entities.KeyValuePair;

public class HttpHeaderBuilder {
    private List<HttpHeaderParameter> params;

    public HttpHeaderBuilder() {
        this.params = new ArrayList<HttpHeaderParameter>();
    }

    public HttpHeaderBuilder(List<HttpHeaderParameter> headers) {
        this.params = headers;
    }

    public HttpHeaderBuilder add(String key, Object value) {
        this.params.add(new HttpHeaderParameter(key, value != null ? String.valueOf(value) : null));
        return this;
    }

    public HttpHeaderBuilder add(String key) {
        this.params.add(new HttpHeaderParameter(key, null));
        return this;
    }

    public List<Header> build() {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (HttpHeaderParameter param : this.params) {
            headers.add((Header)new BasicHeader(param.getKey(), param.getValue()));
        }
        return headers;
    }

    private static class HttpHeaderParameter
    extends KeyValuePair {
        public HttpHeaderParameter(String key, String value) {
            this.setKey(key);
            this.setValue(value);
        }
    }
}

