/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VM;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMs
extends CollectionDecorator<org.ovirt.engine.sdk.entities.VM, org.ovirt.engine.sdk.entities.VMs, VM> {
    public VMs(HttpProxyBroker proxy) {
        super(proxy, "vms");
    }

    @Override
    public List<VM> list() throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        return this.list(url, org.ovirt.engine.sdk.entities.VMs.class, VM.class);
    }

    @Override
    public VM get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.VM.class, VM.class);
    }

    @Override
    public VM getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.VM.class, VM.class);
    }

    public VM add(org.ovirt.engine.sdk.entities.VM vm) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, org.ovirt.engine.sdk.entities.VM.class, VM.class, headers);
    }

    public VM add(org.ovirt.engine.sdk.entities.VM vm, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, org.ovirt.engine.sdk.entities.VM.class, VM.class, headers);
    }

    public VM add(org.ovirt.engine.sdk.entities.VM vm, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, org.ovirt.engine.sdk.entities.VM.class, VM.class, headers);
    }

    public List<VM> list(String query) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.VMs.class, VM.class, headers);
    }

    public List<VM> list(String query, Boolean caseSensitive) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.VMs.class, VM.class, headers);
    }

    public List<VM> list(String query, Boolean caseSensitive, Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.VMs.class, VM.class, headers);
    }

    public List<VM> list(String query, Boolean caseSensitive, Integer max, String allContent) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (allContent != null) {
            headersBuilder.add("All-Content", allContent);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.VMs.class, VM.class, headers);
    }
}

