/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.OpenStackNetworkProvider;
import org.ovirt.engine.sdk.decorators.OpenStackNetworkProviderCertificate;
import org.ovirt.engine.sdk.entities.Certificate;
import org.ovirt.engine.sdk.entities.Certificates;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class OpenStackNetworkProviderCertificates
extends CollectionDecorator<Certificate, Certificates, OpenStackNetworkProviderCertificate> {
    private OpenStackNetworkProvider parent;

    public OpenStackNetworkProviderCertificates(HttpProxyBroker proxy, OpenStackNetworkProvider parent) {
        super(proxy, "certificates");
        this.parent = parent;
    }

    @Override
    public List<OpenStackNetworkProviderCertificate> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Certificates.class, OpenStackNetworkProviderCertificate.class);
    }

    @Override
    public OpenStackNetworkProviderCertificate get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Certificate.class, OpenStackNetworkProviderCertificate.class);
    }

    @Override
    public OpenStackNetworkProviderCertificate getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Certificate.class, OpenStackNetworkProviderCertificate.class);
    }

    public List<OpenStackNetworkProviderCertificate> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Certificates.class, OpenStackNetworkProviderCertificate.class, headers);
    }
}

