%global rolename shutdown_env
%global roleprefix ovirt.
%global legacy_roleprefix oVirt.
%global legacy_rolename shutdown-env
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-shutdown-env
Summary: Ansible role to perform a clean shutdown of all the entities (vms, hosts) in an oVirt environment
Version: 1.0.2
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-shutdown-env/ovirt-ansible-shutdown-env-1.0.2.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.7

%description
This Ansible role provide funtionality to perform a clean and ordered shutdown of all the entities (vms, hosts)
in an oVirt environment using oVirt engine API.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
rolename_legacy_noprefix = "%{_datadir}/%{ansible_roles_dir}/ovirt-%{legacy_rolename}"
rolename_legacy_dash = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{legacy_rolename}"
rolename_legacy_uppercase="%{_datadir}/%{ansible_roles_dir}/%{legacy_roleprefix}%{legacy_rolename}"

st1 = posix.stat(rolename_legacy_noprefix)
if st1 and st1.type == "directory" then
  os.execute('rm -rf "'..rolename_legacy_noprefix..'"')
end

st2 = posix.stat(rolename_legacy_dash)
if st2 and st2.type == "directory" then
  os.execute('rm -rf "'..rolename_legacy_dash..'"')
end

st3 = posix.stat(rolename_legacy_uppercase)
if st3 and st3.type == "directory" then
  os.execute('rm -rf "'..rolename_legacy_uppercase..'"')
end


%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Thu Jun 10 2019 Simone Tiraboschi <stirabos@redhat.com> - 1.0.2-1
- Renaming to ovirt.shutdown_env to satisfy galaxy 3.0 naming recommendations

* Wed Jul 25 2018 Simone Tiraboschi <stirabos@redhat.com> - 1.0.0-1
- Initial release
