/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VmPoolBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmPoolServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlVmPoolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmPoolWriter;
import org.ovirt.engine.sdk4.services.VmPoolService;
import org.ovirt.engine.sdk4.services.VmPoolsService;
import org.ovirt.engine.sdk4.types.VmPool;

public class VmPoolsServiceImpl
extends ServiceImpl
implements VmPoolsService {
    public VmPoolsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmPoolsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmPoolsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmPoolService poolService(String id) {
        return new VmPoolServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.poolService(path);
        }
        return this.poolService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmPoolsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmPoolsService.ListResponse {
        private List<VmPool> pools;

        private ListResponseImpl() {
        }

        public void pools(List<VmPool> pools) {
            this.pools = pools;
        }

        @Override
        public List<VmPool> pools() {
            return this.pools;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmPoolsService.ListRequest, VmPoolsService.ListResponse>
    implements VmPoolsService.ListRequest {
        private Boolean caseSensitive;
        private Boolean filter;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public VmPoolsService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public VmPoolsService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmPoolsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmPoolsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmPoolsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmPoolsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmPoolsService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public VmPoolsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmPoolsServiceImpl.this.getConnection().getUrl() + VmPoolsServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmPoolsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.pools(XmlVmPoolReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmPoolsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmPoolsService.AddResponse {
        private VmPool pool;

        private AddResponseImpl() {
        }

        public void pool(VmPool pool) {
            this.pool = pool;
        }

        @Override
        public VmPool pool() {
            return this.pool;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmPoolsService.AddRequest, VmPoolsService.AddResponse>
    implements VmPoolsService.AddRequest {
        private VmPool pool;

        private AddRequestImpl() {
        }

        @Override
        public VmPoolsService.AddRequest pool(VmPool pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public VmPoolsService.AddRequest pool(VmPoolBuilder pool) {
            this.pool = pool.build();
            return this;
        }

        @Override
        public VmPoolsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmPoolsServiceImpl.this.getConnection().getUrl() + VmPoolsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmPoolWriter.writeOne(this.pool, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmPoolsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.pool(XmlVmPoolReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmPoolsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

