/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.TagBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedTagServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlTagReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTagWriter;
import org.ovirt.engine.sdk4.services.AssignedTagService;
import org.ovirt.engine.sdk4.services.AssignedTagsService;
import org.ovirt.engine.sdk4.types.Tag;

public class AssignedTagsServiceImpl
extends ServiceImpl
implements AssignedTagsService {
    public AssignedTagsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AssignedTagsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AssignedTagsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AssignedTagService tagService(String id) {
        return new AssignedTagServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.tagService(path);
        }
        return this.tagService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AssignedTagsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AssignedTagsService.ListResponse {
        private List<Tag> tags;

        private ListResponseImpl() {
        }

        public void tags(List<Tag> tags) {
            this.tags = tags;
        }

        @Override
        public List<Tag> tags() {
            return this.tags;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AssignedTagsService.ListRequest, AssignedTagsService.ListResponse>
    implements AssignedTagsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AssignedTagsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AssignedTagsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AssignedTagsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AssignedTagsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AssignedTagsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedTagsServiceImpl.this.getConnection().getUrl() + AssignedTagsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedTagsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.tags(XmlTagReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedTagsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AssignedTagsService.AddResponse {
        private Tag tag;

        private AddResponseImpl() {
        }

        public void tag(Tag tag) {
            this.tag = tag;
        }

        @Override
        public Tag tag() {
            return this.tag;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AssignedTagsService.AddRequest, AssignedTagsService.AddResponse>
    implements AssignedTagsService.AddRequest {
        private Tag tag;

        private AddRequestImpl() {
        }

        @Override
        public AssignedTagsService.AddRequest tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public AssignedTagsService.AddRequest tag(TagBuilder tag) {
            this.tag = tag.build();
            return this;
        }

        @Override
        public AssignedTagsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedTagsServiceImpl.this.getConnection().getUrl() + AssignedTagsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlTagWriter.writeOne(this.tag, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedTagsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.tag(XmlTagReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedTagsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

