/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.LogicalUnitBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.builders.VolumeGroupBuilder;
import org.ovirt.engine.sdk4.internal.containers.HostStorageContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.HostStorage;
import org.ovirt.engine.sdk4.types.LogicalUnit;
import org.ovirt.engine.sdk4.types.NfsVersion;
import org.ovirt.engine.sdk4.types.Property;
import org.ovirt.engine.sdk4.types.StorageType;
import org.ovirt.engine.sdk4.types.VolumeGroup;

public class HostStorageBuilder {
    private String address;
    private String comment;
    private String description;
    private List<Property> driverOptions;
    private List<Property> driverSensitiveOptions;
    private Host host;
    private String href;
    private String id;
    private List<LogicalUnit> logicalUnits;
    private String mountOptions;
    private String name;
    private BigInteger nfsRetrans;
    private BigInteger nfsTimeo;
    private NfsVersion nfsVersion;
    private Boolean overrideLuns;
    private String password;
    private String path;
    private BigInteger port;
    private String portal;
    private String target;
    private StorageType type;
    private String username;
    private String vfsType;
    private VolumeGroup volumeGroup;

    public HostStorageBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public HostStorageBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public HostStorageBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public HostStorageBuilder driverOptions(List<Property> newDriverOptions) {
        if (newDriverOptions != null) {
            if (this.driverOptions == null) {
                this.driverOptions = new ArrayList<Property>(newDriverOptions);
            } else {
                this.driverOptions.addAll(newDriverOptions);
            }
        }
        return this;
    }

    public HostStorageBuilder driverOptions(Property ... newDriverOptions) {
        if (newDriverOptions != null) {
            if (this.driverOptions == null) {
                this.driverOptions = new ArrayList<Property>(newDriverOptions.length);
            }
            Collections.addAll(this.driverOptions, newDriverOptions);
        }
        return this;
    }

    public HostStorageBuilder driverOptions(PropertyBuilder ... newDriverOptions) {
        if (newDriverOptions != null) {
            if (this.driverOptions == null) {
                this.driverOptions = new ArrayList<Property>(newDriverOptions.length);
            }
            for (PropertyBuilder builder : newDriverOptions) {
                this.driverOptions.add(builder.build());
            }
        }
        return this;
    }

    public HostStorageBuilder driverSensitiveOptions(List<Property> newDriverSensitiveOptions) {
        if (newDriverSensitiveOptions != null) {
            if (this.driverSensitiveOptions == null) {
                this.driverSensitiveOptions = new ArrayList<Property>(newDriverSensitiveOptions);
            } else {
                this.driverSensitiveOptions.addAll(newDriverSensitiveOptions);
            }
        }
        return this;
    }

    public HostStorageBuilder driverSensitiveOptions(Property ... newDriverSensitiveOptions) {
        if (newDriverSensitiveOptions != null) {
            if (this.driverSensitiveOptions == null) {
                this.driverSensitiveOptions = new ArrayList<Property>(newDriverSensitiveOptions.length);
            }
            Collections.addAll(this.driverSensitiveOptions, newDriverSensitiveOptions);
        }
        return this;
    }

    public HostStorageBuilder driverSensitiveOptions(PropertyBuilder ... newDriverSensitiveOptions) {
        if (newDriverSensitiveOptions != null) {
            if (this.driverSensitiveOptions == null) {
                this.driverSensitiveOptions = new ArrayList<Property>(newDriverSensitiveOptions.length);
            }
            for (PropertyBuilder builder : newDriverSensitiveOptions) {
                this.driverSensitiveOptions.add(builder.build());
            }
        }
        return this;
    }

    public HostStorageBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public HostStorageBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public HostStorageBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public HostStorageBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public HostStorageBuilder logicalUnits(List<LogicalUnit> newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (this.logicalUnits == null) {
                this.logicalUnits = new ArrayList<LogicalUnit>(newLogicalUnits);
            } else {
                this.logicalUnits.addAll(newLogicalUnits);
            }
        }
        return this;
    }

    public HostStorageBuilder logicalUnits(LogicalUnit ... newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (this.logicalUnits == null) {
                this.logicalUnits = new ArrayList<LogicalUnit>(newLogicalUnits.length);
            }
            Collections.addAll(this.logicalUnits, newLogicalUnits);
        }
        return this;
    }

    public HostStorageBuilder logicalUnits(LogicalUnitBuilder ... newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (this.logicalUnits == null) {
                this.logicalUnits = new ArrayList<LogicalUnit>(newLogicalUnits.length);
            }
            for (LogicalUnitBuilder builder : newLogicalUnits) {
                this.logicalUnits.add(builder.build());
            }
        }
        return this;
    }

    public HostStorageBuilder mountOptions(String newMountOptions) {
        this.mountOptions = newMountOptions;
        return this;
    }

    public HostStorageBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public HostStorageBuilder nfsRetrans(int newNfsRetrans) {
        this.nfsRetrans = BigInteger.valueOf(newNfsRetrans);
        return this;
    }

    public HostStorageBuilder nfsRetrans(Integer newNfsRetrans) {
        this.nfsRetrans = newNfsRetrans == null ? null : BigInteger.valueOf(newNfsRetrans.longValue());
        return this;
    }

    public HostStorageBuilder nfsRetrans(long newNfsRetrans) {
        this.nfsRetrans = BigInteger.valueOf(newNfsRetrans);
        return this;
    }

    public HostStorageBuilder nfsRetrans(Long newNfsRetrans) {
        this.nfsRetrans = newNfsRetrans == null ? null : BigInteger.valueOf(newNfsRetrans);
        return this;
    }

    public HostStorageBuilder nfsRetrans(BigInteger newNfsRetrans) {
        this.nfsRetrans = newNfsRetrans;
        return this;
    }

    public HostStorageBuilder nfsTimeo(int newNfsTimeo) {
        this.nfsTimeo = BigInteger.valueOf(newNfsTimeo);
        return this;
    }

    public HostStorageBuilder nfsTimeo(Integer newNfsTimeo) {
        this.nfsTimeo = newNfsTimeo == null ? null : BigInteger.valueOf(newNfsTimeo.longValue());
        return this;
    }

    public HostStorageBuilder nfsTimeo(long newNfsTimeo) {
        this.nfsTimeo = BigInteger.valueOf(newNfsTimeo);
        return this;
    }

    public HostStorageBuilder nfsTimeo(Long newNfsTimeo) {
        this.nfsTimeo = newNfsTimeo == null ? null : BigInteger.valueOf(newNfsTimeo);
        return this;
    }

    public HostStorageBuilder nfsTimeo(BigInteger newNfsTimeo) {
        this.nfsTimeo = newNfsTimeo;
        return this;
    }

    public HostStorageBuilder nfsVersion(NfsVersion newNfsVersion) {
        this.nfsVersion = newNfsVersion;
        return this;
    }

    public HostStorageBuilder overrideLuns(boolean newOverrideLuns) {
        this.overrideLuns = newOverrideLuns;
        return this;
    }

    public HostStorageBuilder overrideLuns(Boolean newOverrideLuns) {
        this.overrideLuns = newOverrideLuns;
        return this;
    }

    public HostStorageBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public HostStorageBuilder path(String newPath) {
        this.path = newPath;
        return this;
    }

    public HostStorageBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public HostStorageBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public HostStorageBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public HostStorageBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public HostStorageBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public HostStorageBuilder portal(String newPortal) {
        this.portal = newPortal;
        return this;
    }

    public HostStorageBuilder target(String newTarget) {
        this.target = newTarget;
        return this;
    }

    public HostStorageBuilder type(StorageType newType) {
        this.type = newType;
        return this;
    }

    public HostStorageBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public HostStorageBuilder vfsType(String newVfsType) {
        this.vfsType = newVfsType;
        return this;
    }

    public HostStorageBuilder volumeGroup(VolumeGroup newVolumeGroup) {
        this.volumeGroup = newVolumeGroup;
        return this;
    }

    public HostStorageBuilder volumeGroup(VolumeGroupBuilder newVolumeGroup) {
        this.volumeGroup = newVolumeGroup == null ? null : newVolumeGroup.build();
        return this;
    }

    public HostStorage build() {
        HostStorageContainer container = new HostStorageContainer();
        container.address(this.address);
        container.comment(this.comment);
        container.description(this.description);
        container.driverOptions(this.driverOptions);
        container.driverSensitiveOptions(this.driverSensitiveOptions);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.logicalUnits(this.logicalUnits);
        container.mountOptions(this.mountOptions);
        container.name(this.name);
        container.nfsRetrans(this.nfsRetrans);
        container.nfsTimeo(this.nfsTimeo);
        container.nfsVersion(this.nfsVersion);
        container.overrideLuns(this.overrideLuns);
        container.password(this.password);
        container.path(this.path);
        container.port(this.port);
        container.portal(this.portal);
        container.target(this.target);
        container.type(this.type);
        container.username(this.username);
        container.vfsType(this.vfsType);
        container.volumeGroup(this.volumeGroup);
        return container;
    }
}

