/*
Copyright (c) 2015 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package types;

import org.ovirt.api.metamodel.annotations.Type;

@Type
public interface Ssh extends Identified {
    Integer port();

    /**
     * Fingerprint of SSH public key for a host. This field is deprecated since 4.4.5 and will be removed in the future.
     *
     * Please use publicKey instead.
     *
     * @deprecated 4.4.5
     */
    @Deprecated
    String fingerprint();

    /**
     * SSH public key of the host using SSH public key format as defined in RFC4253.
     * https://tools.ietf.org/html/rfc4253
     *
     * @author Artur Socha <asocha@redhat.com>
     * @date 29 Jan 21
     * @status requires_text
     * @since 4.4.5
     */
    String publicKey();

    SshAuthenticationMethod authenticationMethod();
    User user();
}
