/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.MDevType;

public class MDevTypeContainer extends Container implements MDevType {
    private BigInteger availableInstances;
    private String description;
    private String name;
    
    public BigInteger availableInstances() {
        return availableInstances;
    }
    
    public Byte availableInstancesAsByte() {
        return asByte("MDevType", "availableInstances", availableInstances);
    }
    
    public Short availableInstancesAsShort() {
        return asShort("MDevType", "availableInstances", availableInstances);
    }
    
    public Integer availableInstancesAsInteger() {
        return asInteger("MDevType", "availableInstances", availableInstances);
    }
    
    public Long availableInstancesAsLong() {
        return asLong("MDevType", "availableInstances", availableInstances);
    }
    
    public void availableInstances(BigInteger newAvailableInstances) {
        availableInstances = newAvailableInstances;
    }
    
    public boolean availableInstancesPresent() {
        return availableInstances != null;
    }
    
    public String description() {
        return description;
    }
    
    public void description(String newDescription) {
        description = newDescription;
    }
    
    public boolean descriptionPresent() {
        return description != null;
    }
    
    public String name() {
        return name;
    }
    
    public void name(String newName) {
        name = newName;
    }
    
    public boolean namePresent() {
        return name != null;
    }
    
}
