/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.RangeBuilder;
import org.ovirt.engine.sdk4.internal.containers.MacPoolContainer;
import org.ovirt.engine.sdk4.types.MacPool;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Range;

public class MacPoolBuilder {
    private Boolean allowDuplicates;
    private String comment;
    private Boolean defaultPool;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<Permission> permissions;
    private List<Range> ranges;

    public MacPoolBuilder allowDuplicates(boolean newAllowDuplicates) {
        this.allowDuplicates = newAllowDuplicates;
        return this;
    }

    public MacPoolBuilder allowDuplicates(Boolean newAllowDuplicates) {
        this.allowDuplicates = newAllowDuplicates;
        return this;
    }

    public MacPoolBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public MacPoolBuilder defaultPool(boolean newDefaultPool) {
        this.defaultPool = newDefaultPool;
        return this;
    }

    public MacPoolBuilder defaultPool(Boolean newDefaultPool) {
        this.defaultPool = newDefaultPool;
        return this;
    }

    public MacPoolBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public MacPoolBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public MacPoolBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public MacPoolBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public MacPoolBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public MacPoolBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public MacPoolBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public MacPoolBuilder ranges(List<Range> newRanges) {
        if (newRanges != null) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>(newRanges);
            } else {
                this.ranges.addAll(newRanges);
            }
        }
        return this;
    }

    public MacPoolBuilder ranges(Range ... newRanges) {
        if (newRanges != null) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>(newRanges.length);
            }
            Collections.addAll(this.ranges, newRanges);
        }
        return this;
    }

    public MacPoolBuilder ranges(RangeBuilder ... newRanges) {
        if (newRanges != null) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>(newRanges.length);
            }
            for (RangeBuilder builder : newRanges) {
                this.ranges.add(builder.build());
            }
        }
        return this;
    }

    public MacPool build() {
        MacPoolContainer container = new MacPoolContainer();
        container.allowDuplicates(this.allowDuplicates);
        container.comment(this.comment);
        container.defaultPool(this.defaultPool);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.permissions(this.permissions);
        container.ranges(this.ranges);
        return container;
    }
}

