/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.AgentConfigurationContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlMessageBrokerTypeReader;
import org.ovirt.engine.sdk4.types.AgentConfiguration;

public class XmlAgentConfigurationReader {
    public static AgentConfiguration readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        AgentConfigurationContainer object = new AgentConfigurationContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block18: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block18;
                }
                case "broker_type": {
                    object.brokerType(XmlMessageBrokerTypeReader.readOne(reader));
                    continue block18;
                }
                case "network_mappings": {
                    object.networkMappings(reader.readString());
                    continue block18;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block18;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block18;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block18;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block18;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlAgentConfigurationReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<AgentConfiguration> iterateMany(final XmlReader reader) {
        return new Iterator<AgentConfiguration>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public AgentConfiguration next() {
                AgentConfiguration next = XmlAgentConfigurationReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<AgentConfiguration> readMany(XmlReader reader) {
        ArrayList<AgentConfiguration> list = new ArrayList<AgentConfiguration>();
        Iterator<AgentConfiguration> iterator = XmlAgentConfigurationReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(AgentConfigurationContainer object, String[] link) {
    }
}

