/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.OpenstackSubnetsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackNetworkReader;
import org.ovirt.engine.sdk4.services.OpenstackNetworkService;
import org.ovirt.engine.sdk4.services.OpenstackSubnetsService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.OpenStackNetwork;

public class OpenstackNetworkServiceImpl
extends ServiceImpl
implements OpenstackNetworkService {
    public OpenstackNetworkServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackNetworkService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public OpenstackNetworkService.ImportRequest import_() {
        return new ImportRequestImpl();
    }

    @Override
    public OpenstackSubnetsService subnetsService() {
        return new OpenstackSubnetsServiceImpl(this.getConnection(), this.getPath() + "/subnets");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("subnets")) {
            return this.subnetsService();
        }
        if (path.startsWith("subnets/")) {
            return this.subnetsService().service(path.substring(8));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "OpenstackNetworkService:" + this.getPath();
    }

    private class ImportResponseImpl
    implements OpenstackNetworkService.ImportResponse {
        private ImportResponseImpl() {
        }
    }

    private class ImportRequestImpl
    extends BaseRequest<OpenstackNetworkService.ImportRequest, OpenstackNetworkService.ImportResponse>
    implements OpenstackNetworkService.ImportRequest {
        private Boolean async;
        private DataCenter dataCenter;

        private ImportRequestImpl() {
        }

        @Override
        public OpenstackNetworkService.ImportRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackNetworkService.ImportRequest dataCenter(DataCenter dataCenter) {
            this.dataCenter = dataCenter;
            return this;
        }

        @Override
        public OpenstackNetworkService.ImportRequest dataCenter(DataCenterBuilder dataCenter) {
            this.dataCenter = dataCenter.build();
            return this;
        }

        @Override
        public OpenstackNetworkService.ImportResponse send() {
            HttpPost request = new HttpPost(OpenstackNetworkServiceImpl.this.getConnection().getUrl() + OpenstackNetworkServiceImpl.this.getPath() + "/import");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.dataCenter(this.dataCenter);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = OpenstackNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = OpenstackNetworkServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ImportResponseImpl();
        }
    }

    private class GetResponseImpl
    implements OpenstackNetworkService.GetResponse {
        private OpenStackNetwork network;

        private GetResponseImpl() {
        }

        public void network(OpenStackNetwork network) {
            this.network = network;
        }

        @Override
        public OpenStackNetwork network() {
            return this.network;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<OpenstackNetworkService.GetRequest, OpenstackNetworkService.GetResponse>
    implements OpenstackNetworkService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public OpenstackNetworkService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackNetworkService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackNetworkServiceImpl.this.getConnection().getUrl() + OpenstackNetworkServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.network(XmlOpenStackNetworkReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackNetworkServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

