/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.Container;
import org.ovirt.engine.sdk4.types.AuthorizedKey;
import org.ovirt.engine.sdk4.types.CloudInit;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.NetworkConfiguration;
import org.ovirt.engine.sdk4.types.User;

public class CloudInitContainer
extends Container
implements CloudInit {
    private List<AuthorizedKey> authorizedKeys;
    private List<File> files;
    private Host host;
    private NetworkConfiguration networkConfiguration;
    private Boolean regenerateSshKeys;
    private String timezone;
    private List<User> users;

    @Override
    public List<AuthorizedKey> authorizedKeys() {
        return CloudInitContainer.makeUnmodifiableList(this.authorizedKeys);
    }

    public void authorizedKeys(List<AuthorizedKey> newAuthorizedKeys) {
        this.authorizedKeys = CloudInitContainer.makeArrayList(newAuthorizedKeys);
    }

    @Override
    public boolean authorizedKeysPresent() {
        return this.authorizedKeys != null && !this.authorizedKeys.isEmpty();
    }

    @Override
    public List<File> files() {
        return CloudInitContainer.makeUnmodifiableList(this.files);
    }

    public void files(List<File> newFiles) {
        this.files = CloudInitContainer.makeArrayList(newFiles);
    }

    @Override
    public boolean filesPresent() {
        return this.files != null && !this.files.isEmpty();
    }

    @Override
    public Host host() {
        return this.host;
    }

    public void host(Host newHost) {
        this.host = newHost;
    }

    @Override
    public boolean hostPresent() {
        return this.host != null;
    }

    @Override
    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public void networkConfiguration(NetworkConfiguration newNetworkConfiguration) {
        this.networkConfiguration = newNetworkConfiguration;
    }

    @Override
    public boolean networkConfigurationPresent() {
        return this.networkConfiguration != null;
    }

    @Override
    public boolean regenerateSshKeys() {
        return this.regenerateSshKeys;
    }

    public void regenerateSshKeys(boolean newRegenerateSshKeys) {
        this.regenerateSshKeys = newRegenerateSshKeys;
    }

    public void regenerateSshKeys(Boolean newRegenerateSshKeys) {
        this.regenerateSshKeys = newRegenerateSshKeys;
    }

    @Override
    public boolean regenerateSshKeysPresent() {
        return this.regenerateSshKeys != null;
    }

    @Override
    public String timezone() {
        return this.timezone;
    }

    public void timezone(String newTimezone) {
        this.timezone = newTimezone;
    }

    @Override
    public boolean timezonePresent() {
        return this.timezone != null;
    }

    @Override
    public List<User> users() {
        return CloudInitContainer.makeUnmodifiableList(this.users);
    }

    public void users(List<User> newUsers) {
        this.users = CloudInitContainer.makeArrayList(newUsers);
    }

    @Override
    public boolean usersPresent() {
        return this.users != null && !this.users.isEmpty();
    }
}

