/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CpuBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.internal.containers.NumaNodeContainer;
import org.ovirt.engine.sdk4.types.Cpu;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.NumaNode;
import org.ovirt.engine.sdk4.types.Statistic;

public class NumaNodeBuilder {
    private String comment;
    private Cpu cpu;
    private String description;
    private Host host;
    private String href;
    private String id;
    private BigInteger index;
    private BigInteger memory;
    private String name;
    private String nodeDistance;
    private List<Statistic> statistics;

    public NumaNodeBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public NumaNodeBuilder cpu(Cpu newCpu) {
        this.cpu = newCpu;
        return this;
    }

    public NumaNodeBuilder cpu(CpuBuilder newCpu) {
        this.cpu = newCpu == null ? null : newCpu.build();
        return this;
    }

    public NumaNodeBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public NumaNodeBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public NumaNodeBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public NumaNodeBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public NumaNodeBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public NumaNodeBuilder index(int newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public NumaNodeBuilder index(Integer newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex.longValue());
        return this;
    }

    public NumaNodeBuilder index(long newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public NumaNodeBuilder index(Long newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex);
        return this;
    }

    public NumaNodeBuilder index(BigInteger newIndex) {
        this.index = newIndex;
        return this;
    }

    public NumaNodeBuilder memory(int newMemory) {
        this.memory = BigInteger.valueOf(newMemory);
        return this;
    }

    public NumaNodeBuilder memory(Integer newMemory) {
        this.memory = newMemory == null ? null : BigInteger.valueOf(newMemory.longValue());
        return this;
    }

    public NumaNodeBuilder memory(long newMemory) {
        this.memory = BigInteger.valueOf(newMemory);
        return this;
    }

    public NumaNodeBuilder memory(Long newMemory) {
        this.memory = newMemory == null ? null : BigInteger.valueOf(newMemory);
        return this;
    }

    public NumaNodeBuilder memory(BigInteger newMemory) {
        this.memory = newMemory;
        return this;
    }

    public NumaNodeBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public NumaNodeBuilder nodeDistance(String newNodeDistance) {
        this.nodeDistance = newNodeDistance;
        return this;
    }

    public NumaNodeBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public NumaNodeBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public NumaNodeBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public NumaNode build() {
        NumaNodeContainer container = new NumaNodeContainer();
        container.comment(this.comment);
        container.cpu(this.cpu);
        container.description(this.description);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.index(this.index);
        container.memory(this.memory);
        container.name(this.name);
        container.nodeDistance(this.nodeDistance);
        container.statistics(this.statistics);
        return container;
    }
}

