/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NfsVersion {
    AUTO("auto"),
    V3("v3"),
    V4("v4"),
    V4_0("v4_0"),
    V4_1("v4_1"),
    V4_2("v4_2");

    private static final Logger log;
    private String image;

    private NfsVersion(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static NfsVersion fromValue(String value) {
        try {
            return NfsVersion.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'NfsVersion' enumerated type. Valid values are 'auto', 'v3', 'v4', 'v4_0', 'v4_1' and 'v4_2'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(NfsVersion.class);
    }
}

