/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.BrickProfileDetail;
import org.ovirt.engine.sdk4.types.GlusterVolumeProfileDetails;
import org.ovirt.engine.sdk4.types.NfsProfileDetail;

public class GlusterVolumeProfileDetailsContainer extends IdentifiedContainer implements GlusterVolumeProfileDetails {
    private List<BrickProfileDetail> brickProfileDetails;
    private List<NfsProfileDetail> nfsProfileDetails;
    
    public List<BrickProfileDetail> brickProfileDetails() {
        return makeUnmodifiableList(brickProfileDetails);
    }
    
    public void brickProfileDetails(List<BrickProfileDetail> newBrickProfileDetails) {
        brickProfileDetails = makeArrayList(newBrickProfileDetails);
    }
    
    public boolean brickProfileDetailsPresent() {
        return brickProfileDetails != null && !brickProfileDetails.isEmpty();
    }
    
    public List<NfsProfileDetail> nfsProfileDetails() {
        return makeUnmodifiableList(nfsProfileDetails);
    }
    
    public void nfsProfileDetails(List<NfsProfileDetail> newNfsProfileDetails) {
        nfsProfileDetails = makeArrayList(newNfsProfileDetails);
    }
    
    public boolean nfsProfileDetailsPresent() {
        return nfsProfileDetails != null && !nfsProfileDetails.isEmpty();
    }
    
}
