/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenStackVolumeProviderBuilder;
import org.ovirt.engine.sdk4.types.OpenStackVolumeProvider;

public interface OpenstackVolumeProviderService extends Service {
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        OpenStackVolumeProvider provider();
    }
    
    GetRequest get();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
        /**
         * Indicates if the operation should succeed, and the provider removed from the database,
         * even if something fails during the operation.
         * 
         * This parameter is optional, and the default value is `false`.
         */
        RemoveRequest force(Boolean force);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    /**
     * Update the specified OpenStack volume provider in the system.
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest provider(OpenStackVolumeProvider provider);
        UpdateRequest provider(OpenStackVolumeProviderBuilder provider);
    }
    
    /**
     * Update the specified OpenStack volume provider in the system.
     */
    public interface UpdateResponse extends Response {
        OpenStackVolumeProvider provider();
    }
    
    /**
     * Update the specified OpenStack volume provider in the system.
     */
    UpdateRequest update();
    
    OpenstackVolumeAuthenticationKeysService authenticationKeysService();
    OpenstackVolumeTypesService volumeTypesService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

