/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StorageType {
    CINDER("cinder"),
    FCP("fcp"),
    GLANCE("glance"),
    GLUSTERFS("glusterfs"),
    ISCSI("iscsi"),
    LOCALFS("localfs"),
    NFS("nfs"),
    POSIXFS("posixfs");

    private static final Logger log;
    private String image;

    private StorageType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StorageType fromValue(String value) {
        try {
            return StorageType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StorageType' enumerated type. Valid values are 'cinder', 'fcp', 'glance', 'glusterfs', 'iscsi', 'localfs', 'nfs' and 'posixfs'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StorageType.class);
    }
}

