/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.AgentBuilder;
import org.ovirt.engine.sdk4.builders.OptionBuilder;
import org.ovirt.engine.sdk4.builders.PmProxyBuilder;
import org.ovirt.engine.sdk4.internal.containers.PowerManagementContainer;
import org.ovirt.engine.sdk4.types.Agent;
import org.ovirt.engine.sdk4.types.Option;
import org.ovirt.engine.sdk4.types.PmProxy;
import org.ovirt.engine.sdk4.types.PowerManagement;
import org.ovirt.engine.sdk4.types.PowerManagementStatus;

public class PowerManagementBuilder {
    private String address;
    private List<Agent> agents;
    private Boolean automaticPmEnabled;
    private Boolean enabled;
    private Boolean kdumpDetection;
    private List<Option> options;
    private String password;
    private List<PmProxy> pmProxies;
    private PowerManagementStatus status;
    private String type;
    private String username;

    public PowerManagementBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public PowerManagementBuilder agents(List<Agent> newAgents) {
        if (newAgents != null) {
            if (this.agents == null) {
                this.agents = new ArrayList<Agent>(newAgents);
            } else {
                this.agents.addAll(newAgents);
            }
        }
        return this;
    }

    public PowerManagementBuilder agents(Agent ... newAgents) {
        if (newAgents != null) {
            if (this.agents == null) {
                this.agents = new ArrayList<Agent>(newAgents.length);
            }
            Collections.addAll(this.agents, newAgents);
        }
        return this;
    }

    public PowerManagementBuilder agents(AgentBuilder ... newAgents) {
        if (newAgents != null) {
            if (this.agents == null) {
                this.agents = new ArrayList<Agent>(newAgents.length);
            }
            for (AgentBuilder builder : newAgents) {
                this.agents.add(builder.build());
            }
        }
        return this;
    }

    public PowerManagementBuilder automaticPmEnabled(boolean newAutomaticPmEnabled) {
        this.automaticPmEnabled = newAutomaticPmEnabled;
        return this;
    }

    public PowerManagementBuilder automaticPmEnabled(Boolean newAutomaticPmEnabled) {
        this.automaticPmEnabled = newAutomaticPmEnabled;
        return this;
    }

    public PowerManagementBuilder enabled(boolean newEnabled) {
        this.enabled = newEnabled;
        return this;
    }

    public PowerManagementBuilder enabled(Boolean newEnabled) {
        this.enabled = newEnabled;
        return this;
    }

    public PowerManagementBuilder kdumpDetection(boolean newKdumpDetection) {
        this.kdumpDetection = newKdumpDetection;
        return this;
    }

    public PowerManagementBuilder kdumpDetection(Boolean newKdumpDetection) {
        this.kdumpDetection = newKdumpDetection;
        return this;
    }

    public PowerManagementBuilder options(List<Option> newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions);
            } else {
                this.options.addAll(newOptions);
            }
        }
        return this;
    }

    public PowerManagementBuilder options(Option ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            Collections.addAll(this.options, newOptions);
        }
        return this;
    }

    public PowerManagementBuilder options(OptionBuilder ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            for (OptionBuilder builder : newOptions) {
                this.options.add(builder.build());
            }
        }
        return this;
    }

    public PowerManagementBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public PowerManagementBuilder pmProxies(List<PmProxy> newPmProxies) {
        if (newPmProxies != null) {
            if (this.pmProxies == null) {
                this.pmProxies = new ArrayList<PmProxy>(newPmProxies);
            } else {
                this.pmProxies.addAll(newPmProxies);
            }
        }
        return this;
    }

    public PowerManagementBuilder pmProxies(PmProxy ... newPmProxies) {
        if (newPmProxies != null) {
            if (this.pmProxies == null) {
                this.pmProxies = new ArrayList<PmProxy>(newPmProxies.length);
            }
            Collections.addAll(this.pmProxies, newPmProxies);
        }
        return this;
    }

    public PowerManagementBuilder pmProxies(PmProxyBuilder ... newPmProxies) {
        if (newPmProxies != null) {
            if (this.pmProxies == null) {
                this.pmProxies = new ArrayList<PmProxy>(newPmProxies.length);
            }
            for (PmProxyBuilder builder : newPmProxies) {
                this.pmProxies.add(builder.build());
            }
        }
        return this;
    }

    public PowerManagementBuilder status(PowerManagementStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public PowerManagementBuilder type(String newType) {
        this.type = newType;
        return this;
    }

    public PowerManagementBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public PowerManagement build() {
        PowerManagementContainer container = new PowerManagementContainer();
        container.address(this.address);
        container.agents(this.agents);
        container.automaticPmEnabled(this.automaticPmEnabled);
        container.enabled(this.enabled);
        container.kdumpDetection(this.kdumpDetection);
        container.options(this.options);
        container.password(this.password);
        container.pmProxies(this.pmProxies);
        container.status(this.status);
        container.type(this.type);
        container.username(this.username);
        return container;
    }
}

