/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;

/**
 * Information describing the operating system. Used for virtual machines and hosts.
 */
public interface OperatingSystem {
    Boot boot();
    
    boolean bootPresent();
    
    String cmdline();
    
    boolean cmdlinePresent();
    
    String customKernelCmdline();
    
    boolean customKernelCmdlinePresent();
    
    String initrd();
    
    boolean initrdPresent();
    
    String kernel();
    
    boolean kernelPresent();
    
    String reportedKernelCmdline();
    
    boolean reportedKernelCmdlinePresent();
    
    String type();
    
    boolean typePresent();
    
    Version version();
    
    boolean versionPresent();
    
}
