# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%define use_vdsm %( test -z  && echo 1 || echo 0)
%global _plugindir %{_datarootdir}/cockpit/
%global _ovirtenginedir %{_datarootdir}/ovirt-engine
%global _uipluginsdir %{_ovirtenginedir}/ui-plugins
%global product oVirt
%global use_rhev %( test -z // && echo 1 || echo 0)
%define debug_package %{nil}

# git ls-remote http://gerrit.ovirt.org/cockpit-ovirt.git | grep $tag"
%global commit 588cde76f8e2ffefe59f8101b49c56b68678edfe
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global source_basename cockpit-ovirt-0.10.7-0.0.22

Name:           cockpit-ovirt
Version:        0.10.7
Release:        0.0.22%{?release_suffix}%{?checkout}%{?dist}
Summary:        Dashboard for Cockpit based on %{product}
License:        ASL 2.0
URL:            https://gerrit.ovirt.org/gitweb?p=cockpit-ovirt.git;a=summary
Source0:        http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{source_basename}.tar.gz


%if 0%{?rhel}
ExclusiveArch:  x86_64
%else
BuildRequires: nodejs-packaging
ExclusiveArch: %{nodejs_arches} noarch
%endif

#This is a hack for copr, but why is it needed?
BuildRequires: python
BuildRequires: ovirt-engine-nodejs
BuildRequires: ovirt-engine-nodejs-modules
BuildRequires: ovirt-engine-yarn

%package dashboard
Summary:        Dashboard for Cockpit based on %{product}
BuildArch:      noarch

%if 0%{?rhel}
#FIXME: don't pull in base cockpit until rhbz#1349375 is fixed
Requires:       cockpit-bridge
Requires:       cockpit-ws
Requires:       cockpit-shell
Requires:       cockpit-storaged
%else
Requires:       cockpit
%endif

Requires:       ovirt-hosted-engine-setup
Requires:       otopi >= 1.5.2-1
%if 0%{?use_vdsm}
Requires: vdsm >= 4.17.999-610
%endif

%description
This package provides a Cockpit dashboard for use with %{product}.

%description dashboard
This package provides a Cockpit dashboard for use with %{product}.

%prep
%setup -q -n"%{source_basename}"

# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
for d in dashboard vdsm; do
  pushd .
  cd ${d}
  %{_datadir}/ovirt-engine-nodejs-modules/setup-env.sh
  popd
done

# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./dashboard/node_modules
%if 0%{?use_vdsm}
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./vdsm/node_modules
%endif


%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%if 0%{?use_vdsm}
%if 0%{?use_rhev}
%configure --with-vdsm --with-rhev
%else
%configure --with-vdsm
%endif #END RHEV
%else
%if 0%{?use_rhev}
%configure --with-rhev
%else
%configure
%endif  #END RHEV
%endif  #END VDSM

export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}
%if 0%{?use_vdsm}
chmod a+x %{buildroot}/%{_plugindir}/ovirt-dashboard/vdsm/vdsm/vdsm
chmod a+x %{buildroot}/%{_plugindir}/ovirt-dashboard/vdsm/vdsm/vdsmJsonRPCCli.py
%endif

%files dashboard
%if 0%{?use_vdsm}
%doc vdsm/README.md 
%endif
%license LICENSE
%{_plugindir}/ovirt-dashboard

%package uiplugin
Summary: UI Plugin embedding Cockpit in oVirt's Administration Portal
%if 0%{?use_rhev}
Requires: rhev-engine-webadmin-portal
%else
Requires: ovirt-engine-webadmin-portal
%endif
BuildArch: noarch

%description uiplugin
Optional UI plugin embedding Cockpit in oVirt's Administration Portal
for low-level host management.

%files uiplugin
%doc ovirt-uiplugin/README.cockpit
%license LICENSE
%{_uipluginsdir}/cockpit.json
%{_uipluginsdir}/cockpit-resources

%changelog
* Mon Jul 21 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.22
- Gdeploy fixes

* Wed Jul 05 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.21
- hosted-engine: make the page optional by checking for the hosted-engine
  binary before enabling anything
- gdeploy: re-calculate thinpoolMetadata size dynamically
* Thu Jun 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.20
- vdsm: fix d3 import
- gdeploy: add qemu user to gluster group
- gdeploy: move multipath-disable before brick creation

* Wed Jun 07 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.19
- gdeploy: use chrony instead of ntpd
- gdeploy: disable repos when deploying

* Thu May 04 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.10.7-0.0.18
- gdeploy: calculate arbiter brick size
- gdeploy: restart glusterd instead of start.
- gdeploy: calculate thinpoolMetadata size dynamically.
- gdeploy: Add option disable repos while generating gdeploy config file
- gdeploy: Remove text message when mount point is empty
- gdeploy: include gdeploy multipath disable script
* Fri Apr 14 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.17
- Unset confirm_otopi after passing
* Thu Mar 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.15
- Add hostnames to brick_dir in gluster config
* Wed Mar 08 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.10.7-0.0.14
- Various gdeploy fixes
* Thu Mar 02 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.13
- Fix a misnamed variable
* Wed Mar 01 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.12
- Various gdeploy fixes
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.11
- Various gdeploy fixes
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.10
- Add a prompt for GPG keys for hosted engine setup
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.9
- Use yarn to build
* Thu Feb 09 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.8
- Pull in missed patches
* Wed Jan 25 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.7
- gdeploy fixes
- Don't prompt for a password in Firefox during HE setup
- Block HE setup if the host is already registered
* Wed Jan 25 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.6
- gdeploy fixes
* Mon Jan 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.5
- Disable uiplugin again
* Mon Jan 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.4
- Disable node dashboard on non-node systems
- Some vdsm fixes
* Wed Jan 04 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.3
- Fix syntax in dashboard helper
* Tue Jan 03 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.2
- gdeploy bug fixes
* Wed Dec 21 2016 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.1
- gdeploy bug fixes
* Wed Dec 21 2016 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.0
- Add gdeploy to hosted engine
* Tue Dec 20 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.3
- Keep all of the hosted-engine output
* Fri Nov 4 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.2
- Fix a regression with the last patch where the password was
  shown in plaintext
* Mon Oct 24 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.1
- Be smarter about the password check in hosted-engine setup
* Wed Aug 10 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.6
- Don't include the cockpit metapackage on RHEL
* Wed Jul 27 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.2
- UX improvements
* Fri Jul 1 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6
- Run hosted-engine setup as a superuser if sudo is available
- Rename the dashboard so branding isn't needed
- UX improvements
* Thu Jun 16 2016 Marek Libra <mlibra@redhat.com> - 0.10.5
- UI improvements
* Wed Jun 08 2016 Marek Libra <mlibra@redhat.com> - 0.10.4
- UI bugfixes and minor usability improvements
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10.3
- Update the otopi parser
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10
- Add a hosted engine status pae
- Add cancellation buttons for hosted engine
- Catch abnormal exits
* Wed May 18 2016 Ryan Barry <rbarry@redhat.com> - 0.9
- Add links to other parts of cockpit on the dashboard
- Add the ability to show the host SSH key to the dashboard
- Terminate hosted engine setup when the page is exited
- Mask some fields in hosted engine setup
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Thu Apr 28 2016 Marek Libra <mlibra@redhat.com> - 0.7
- Add Webadmin Cockpit UI Plugin
* Mon Apr 25 2016 Marek Libra <mlibra@redhat.com> - 0.6
- Add vdsm VM Management
* Fri Apr 08 2016 Ryan Barry <rbarry@redhat.com> - 0.5
- Add node-dashboard
* Tue Mar 22 2016 Ryan Barry <rbarry@redhat.com> - 0.4
- Add node-dashboard
* Fri Mar 18 2016 Marek Libra <rbarry@redhat.com> - 0.3
- Update packaging to match upstream standards
- Convert to autotools
* Fri Mar 11 2016 Marek Libra <mlibra@redhat.com> - 0.2
* Thu Mar 03 2016 Marek Libra <mlibra@redhat.com> - 0.1
- Initial packaging

