/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderCertificatesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.services.ExternalProviderCertificatesService;
import org.ovirt.engine.sdk4.services.ExternalProviderService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Certificate;

public class ExternalProviderServiceImpl
extends ServiceImpl
implements ExternalProviderService {
    public ExternalProviderServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalProviderService.ImportCertificatesRequest importCertificates() {
        return new ImportCertificatesRequestImpl();
    }

    @Override
    public ExternalProviderService.TestConnectivityRequest testConnectivity() {
        return new TestConnectivityRequestImpl();
    }

    @Override
    public ExternalProviderCertificatesService certificatesService() {
        return new ExternalProviderCertificatesServiceImpl(this.getConnection(), this.getPath() + "/certificates");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("certificates")) {
            return this.certificatesService();
        }
        if (path.startsWith("certificates/")) {
            return this.certificatesService().service(path.substring(13));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ExternalProviderService:" + this.getPath();
    }

    private class TestConnectivityResponseImpl
    implements ExternalProviderService.TestConnectivityResponse {
        private TestConnectivityResponseImpl() {
        }
    }

    private class TestConnectivityRequestImpl
    extends BaseRequest<ExternalProviderService.TestConnectivityRequest, ExternalProviderService.TestConnectivityResponse>
    implements ExternalProviderService.TestConnectivityRequest {
        private Boolean async;

        private TestConnectivityRequestImpl() {
        }

        @Override
        public ExternalProviderService.TestConnectivityRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ExternalProviderService.TestConnectivityResponse send() {
            HttpPost request = new HttpPost(ExternalProviderServiceImpl.this.getConnection().getUrl() + ExternalProviderServiceImpl.this.getPath() + "/testconnectivity");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ExternalProviderServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ExternalProviderServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new TestConnectivityResponseImpl();
        }
    }

    private class ImportCertificatesResponseImpl
    implements ExternalProviderService.ImportCertificatesResponse {
        private ImportCertificatesResponseImpl() {
        }
    }

    private class ImportCertificatesRequestImpl
    extends BaseRequest<ExternalProviderService.ImportCertificatesRequest, ExternalProviderService.ImportCertificatesResponse>
    implements ExternalProviderService.ImportCertificatesRequest {
        private List<Certificate> certificates;

        private ImportCertificatesRequestImpl() {
        }

        @Override
        public ExternalProviderService.ImportCertificatesRequest certificates(List<Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        @Override
        public ExternalProviderService.ImportCertificatesRequest certificates(Certificate ... certificates) {
            this.certificates = Arrays.asList(certificates);
            return this;
        }

        @Override
        public ExternalProviderService.ImportCertificatesRequest certificates(CertificateBuilder ... certificates) {
            this.certificates = new ArrayList<Certificate>(certificates.length);
            for (CertificateBuilder element : certificates) {
                this.certificates.add(element.build());
            }
            return this;
        }

        @Override
        public ExternalProviderService.ImportCertificatesResponse send() {
            HttpPost request = new HttpPost(ExternalProviderServiceImpl.this.getConnection().getUrl() + ExternalProviderServiceImpl.this.getPath() + "/importcertificates");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.certificates(this.certificates);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ExternalProviderServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ExternalProviderServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ImportCertificatesResponseImpl();
        }
    }
}

