/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.GlusterHookServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterHookReader;
import org.ovirt.engine.sdk4.services.GlusterHookService;
import org.ovirt.engine.sdk4.services.GlusterHooksService;
import org.ovirt.engine.sdk4.types.GlusterHook;

public class GlusterHooksServiceImpl
extends ServiceImpl
implements GlusterHooksService {
    public GlusterHooksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public GlusterHooksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public GlusterHookService hookService(String id) {
        return new GlusterHookServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.hookService(path);
        }
        return this.hookService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "GlusterHooksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements GlusterHooksService.ListResponse {
        private List<GlusterHook> hooks;

        private ListResponseImpl() {
        }

        public void hooks(List<GlusterHook> hooks) {
            this.hooks = hooks;
        }

        @Override
        public List<GlusterHook> hooks() {
            return this.hooks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<GlusterHooksService.ListRequest, GlusterHooksService.ListResponse>
    implements GlusterHooksService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public GlusterHooksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public GlusterHooksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public GlusterHooksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public GlusterHooksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public GlusterHooksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterHooksServiceImpl.this.getConnection().getUrl() + GlusterHooksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterHooksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.hooks(XmlGlusterHookReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GlusterHooksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

