/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.HostHookServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlHookReader;
import org.ovirt.engine.sdk4.services.HostHookService;
import org.ovirt.engine.sdk4.services.HostHooksService;
import org.ovirt.engine.sdk4.types.Hook;

public class HostHooksServiceImpl
extends ServiceImpl
implements HostHooksService {
    public HostHooksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public HostHooksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public HostHookService hookService(String id) {
        return new HostHookServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.hookService(path);
        }
        return this.hookService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "HostHooksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements HostHooksService.ListResponse {
        private List<Hook> hooks;

        private ListResponseImpl() {
        }

        public void hooks(List<Hook> hooks) {
            this.hooks = hooks;
        }

        @Override
        public List<Hook> hooks() {
            return this.hooks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<HostHooksService.ListRequest, HostHooksService.ListResponse>
    implements HostHooksService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public HostHooksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public HostHooksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public HostHooksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public HostHooksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public HostHooksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostHooksServiceImpl.this.getConnection().getUrl() + HostHooksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostHooksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.hooks(XmlHookReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostHooksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

