/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.BookmarkBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.BookmarkServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlBookmarkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlBookmarkWriter;
import org.ovirt.engine.sdk4.services.BookmarkService;
import org.ovirt.engine.sdk4.services.BookmarksService;
import org.ovirt.engine.sdk4.types.Bookmark;

public class BookmarksServiceImpl
extends ServiceImpl
implements BookmarksService {
    public BookmarksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public BookmarksService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public BookmarksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public BookmarkService bookmarkService(String id) {
        return new BookmarkServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.bookmarkService(path);
        }
        return this.bookmarkService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "BookmarksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements BookmarksService.ListResponse {
        private List<Bookmark> bookmarks;

        private ListResponseImpl() {
        }

        public void bookmarks(List<Bookmark> bookmarks) {
            this.bookmarks = bookmarks;
        }

        @Override
        public List<Bookmark> bookmarks() {
            return this.bookmarks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<BookmarksService.ListRequest, BookmarksService.ListResponse>
    implements BookmarksService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public BookmarksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public BookmarksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public BookmarksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public BookmarksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public BookmarksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BookmarksServiceImpl.this.getConnection().getUrl() + BookmarksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BookmarksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.bookmarks(XmlBookmarkReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            BookmarksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements BookmarksService.AddResponse {
        private Bookmark bookmark;

        private AddResponseImpl() {
        }

        public void bookmark(Bookmark bookmark) {
            this.bookmark = bookmark;
        }

        @Override
        public Bookmark bookmark() {
            return this.bookmark;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<BookmarksService.AddRequest, BookmarksService.AddResponse>
    implements BookmarksService.AddRequest {
        private Bookmark bookmark;

        private AddRequestImpl() {
        }

        @Override
        public BookmarksService.AddRequest bookmark(Bookmark bookmark) {
            this.bookmark = bookmark;
            return this;
        }

        @Override
        public BookmarksService.AddRequest bookmark(BookmarkBuilder bookmark) {
            this.bookmark = bookmark.build();
            return this;
        }

        @Override
        public BookmarksService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BookmarksServiceImpl.this.getConnection().getUrl() + BookmarksServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlBookmarkWriter.writeOne(this.bookmark, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BookmarksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.bookmark(XmlBookmarkReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            BookmarksServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

